/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.diff;

import javax.swing.text.Segment;

public class DiffSegment
extends Segment {
    private boolean _ignoreWhitespace;
    private boolean _ignoreCase;

    public DiffSegment(boolean bl, boolean bl2) {
        this._ignoreWhitespace = bl;
        this._ignoreCase = bl2;
    }

    public boolean equals(Object object) {
        if (object instanceof Segment) {
            Segment segment = (Segment)object;
            if (!this._ignoreWhitespace && segment.length() != this.length()) {
                return false;
            }
            char c = this.first();
            char c2 = segment.first();
            while (c != '\uffff' && c2 != '\uffff') {
                if (this._ignoreWhitespace && Character.isWhitespace(c)) {
                    c = this.next();
                    continue;
                }
                while (c2 != '\uffff' && this._ignoreWhitespace && Character.isWhitespace(c2)) {
                    c2 = segment.next();
                }
                if (this._ignoreCase) {
                    c = Character.toUpperCase(c);
                    c2 = Character.toUpperCase(c2);
                }
                if (c != c2) {
                    return false;
                }
                c = this.next();
                c2 = segment.next();
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 1;
        char c = this.first();
        while (c != '\uffff') {
            if (!this._ignoreWhitespace || !Character.isWhitespace(c)) {
                if (this._ignoreCase) {
                    c = Character.toUpperCase(c);
                }
                n = 31 * n + c;
            }
            c = this.next();
        }
        return n;
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        DiffSegment diffSegment = new DiffSegment(this._ignoreWhitespace, this._ignoreCase);
        diffSegment.array = this.array;
        diffSegment.offset = this.offset + n;
        diffSegment.count = n2 - n;
        return diffSegment;
    }
}

