/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.diff;

import com.jidesoft.diff.BasicDiffPane;
import com.jidesoft.diff.CodeEditorDiffMarkerArea;
import com.jidesoft.diff.Diff;
import com.jidesoft.diff.DiffDivider;
import com.jidesoft.diff.DiffRowNumberMargin;
import com.jidesoft.diff.DiffSegment;
import com.jidesoft.diff.DiffSpan;
import com.jidesoft.diff.DiffTokens;
import com.jidesoft.diff.Difference;
import com.jidesoft.diff.LineHighlightPainter;
import com.jidesoft.diff.SeparatorHighlightPainter;
import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.CodeEditorMarkerSupport;
import com.jidesoft.editor.CodeEditorRowMarginSupport;
import com.jidesoft.editor.SyntaxDocument;
import com.jidesoft.editor.caret.CaretEvent;
import com.jidesoft.editor.caret.CaretListener;
import com.jidesoft.editor.highlight.DefaultHighlighter;
import com.jidesoft.margin.RowMarginSupport;
import com.jidesoft.marker.MarkerSupport;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Segment;

public class CodeEditorDiffPane
extends BasicDiffPane<CharSequence> {
    protected CodeEditor _fromEditor;
    protected CodeEditor _toEditor;
    private boolean _suppressDocumentEvent = false;
    private boolean _ignoreWhitespaces = true;
    private boolean _caseSensitive = false;
    private int _fromLinesDifferenceOffset = 0;
    private int _toLinesDifferenceOffset = 0;
    private Timer _timer;
    protected static char[] separators = new char[]{'.', ',', ';', ':', '=', '<', '>', '(', ')', '/', '+', '-', '[', ']'};
    private boolean _ignoreFromScrollEvent = false;
    private boolean _ignoreToScrollEvent = false;
    private AdjustmentListener _fromAdjustmentListener;
    private AdjustmentListener _fromAdjustmentHorizontalListener;
    private AdjustmentListener _toAdjustmentListener;
    private AdjustmentListener _toAdjustmentHorizontalListener;
    private CaretListener _fromCaretListener;
    private CaretListener _toCaretListener;

    public CodeEditorDiffPane() {
        super("", "");
    }

    public CodeEditorDiffPane(CharSequence charSequence, CharSequence charSequence2) {
        super(charSequence, charSequence2);
    }

    @Override
    void superFlip() {
        SyntaxDocument syntaxDocument = this._fromEditor.getDocument();
        SyntaxDocument syntaxDocument2 = this._toEditor.getDocument();
        this._fromEditor.setDocument(syntaxDocument2);
        this._toEditor.setDocument(syntaxDocument);
    }

    @Override
    public JComponent createComponent(Object object, int n) {
        CodeEditor codeEditor = this.createEditor(n);
        codeEditor.setText(object == null ? null : object.toString());
        return codeEditor;
    }

    @Override
    public JComponent createPane(Object object, int n) {
        if (n == 0) {
            this._fromComponent = this.createComponent(object, n);
            if (this._fromComponent instanceof CodeEditor) {
                this._fromEditor = (CodeEditor)this._fromComponent;
            } else {
                JideSwingUtilities.setRecursively(this._fromComponent, new JideSwingUtilities.Handler(){

                    @Override
                    public boolean condition(Component component) {
                        return component instanceof CodeEditor;
                    }

                    @Override
                    public void action(Component component) {
                        CodeEditorDiffPane.this._fromEditor = (CodeEditor)component;
                    }

                    @Override
                    public void postAction(Component component) {
                    }
                });
            }
            if (this._fromEditor == null) {
                throw new IllegalArgumentException("The from component created by createComponent() does not contain a CodeEditor.");
            }
            this._fromEditor.setEditable(false);
            this._fromRowMarginSupport = this.createRowMarginSupport(this._fromEditor, null);
            this._fromDiffMargin = this.createDiffMargin(this._fromRowMarginSupport, true);
            this._fromDiffLineNumberMargin = new DiffRowNumberMargin(this._fromRowMarginSupport);
            this._fromMarkerArea = new CodeEditorDiffMarkerArea(this._fromEditor);
            ((CodeEditorDiffMarkerArea)this._fromMarkerArea).setChangedColor(this.getChangedColor());
            ((CodeEditorDiffMarkerArea)this._fromMarkerArea).setInsertedColor(this.getInsertedColor());
            ((CodeEditorDiffMarkerArea)this._fromMarkerArea).setDeletedColor(this.getDeletedColor());
            this._fromEditor.setMarkerArea(this._fromMarkerArea);
            this._fromEditor.getMarginArea().removeAll();
            this._fromEditor.getMarginArea().addMarginComponent(this._fromDiffMargin);
            this._fromEditor.getMarginArea().addMarginComponent(this._fromDiffLineNumberMargin);
            this._fromEditor.swap();
            JPanel jPanel = new JPanel(new BorderLayout(1, 1));
            jPanel.add(this._fromComponent);
            jPanel.add((Component)this._fromMarkerArea, "Before");
            JPanel jPanel2 = new JPanel(new BorderLayout(2, 2));
            jPanel2.add(jPanel);
            this._fromTitle = this.createFromTitle();
            jPanel2.add((Component)this._fromTitle, "First");
            return jPanel2;
        }
        this._toComponent = this.createComponent(object, n);
        if (this._toComponent instanceof CodeEditor) {
            this._toEditor = (CodeEditor)this._toComponent;
        } else {
            JideSwingUtilities.setRecursively(this._toComponent, new JideSwingUtilities.Handler(){

                @Override
                public boolean condition(Component component) {
                    return component instanceof CodeEditor;
                }

                @Override
                public void action(Component component) {
                    CodeEditorDiffPane.this._toEditor = (CodeEditor)component;
                }

                @Override
                public void postAction(Component component) {
                }
            });
        }
        if (this._toEditor == null) {
            throw new IllegalArgumentException("The to component created by createComponent() does not contain a CodeEditor.");
        }
        this._toRowMarginSupport = this.createRowMarginSupport(this._toEditor, null);
        this._toDiffMargin = this.createDiffMargin(this._toRowMarginSupport, false);
        this._toDiffLineNumberMargin = new DiffRowNumberMargin(this._toRowMarginSupport);
        this._toMarkerArea = new CodeEditorDiffMarkerArea(this._toEditor);
        ((CodeEditorDiffMarkerArea)this._toMarkerArea).setChangedColor(this.getChangedColor());
        ((CodeEditorDiffMarkerArea)this._toMarkerArea).setInsertedColor(this.getInsertedColor());
        ((CodeEditorDiffMarkerArea)this._toMarkerArea).setDeletedColor(this.getDeletedColor());
        this._toEditor.setMarkerArea(this._toMarkerArea);
        this._toEditor.getMarginArea().removeAll();
        this._toEditor.getMarginArea().addMarginComponent(this._toDiffLineNumberMargin);
        this._toEditor.getMarginArea().addMarginComponent(this._toDiffMargin);
        JPanel jPanel = new JPanel(new BorderLayout(1, 1));
        jPanel.add(this._toComponent);
        jPanel.add((Component)this._toMarkerArea, "After");
        JPanel jPanel3 = new JPanel(new BorderLayout(2, 2));
        jPanel3.add(jPanel);
        this._toTitle = this.createToTitle();
        jPanel3.add((Component)this._toTitle, "First");
        return jPanel3;
    }

    @Override
    protected void customizePane(JComponent jComponent, int n) {
        CodeEditor codeEditor;
        super.customizePane(jComponent, n);
        CodeEditor codeEditor2 = codeEditor = n == 0 ? this._fromEditor : this._toEditor;
        if (codeEditor != null) {
            codeEditor.setLineHighlight(false);
            codeEditor.getMarkerArea().getMarkerEye().setVisible(false);
        }
        this.customizeEditor(codeEditor, n);
    }

    @Override
    protected MarkerSupport createMarkerSupport(JComponent jComponent) {
        return new CodeEditorMarkerSupport((CodeEditor)jComponent);
    }

    @Override
    protected RowMarginSupport createRowMarginSupport(JComponent jComponent, JScrollPane jScrollPane) {
        return new CodeEditorRowMarginSupport((CodeEditor)jComponent);
    }

    @Override
    protected void adjustDividerOffset(DiffDivider diffDivider, int n) {
        FontMetrics fontMetrics = this._fromEditor.getPainter().getFontMetrics();
        int n2 = fontMetrics.getLeading() + fontMetrics.getMaxDescent();
        diffDivider.adjustFirstVerticalOffset(n2 - 2, 2 + this._fromTitle.getPreferredSize().height);
        fontMetrics = this._toEditor.getPainter().getFontMetrics();
        n2 = fontMetrics.getLeading() + fontMetrics.getMaxDescent();
        diffDivider.adjustSecondVerticalOffset(n2 - 2, 2 + this._toTitle.getPreferredSize().height);
    }

    protected CodeEditor createEditor(int n) {
        return this.createEditor();
    }

    protected CodeEditor createEditor() {
        return new CodeEditor();
    }

    protected void customizeEditor(CodeEditor codeEditor, int n) {
    }

    public CharSequence[] getFromItems() {
        CharSequence[] charSequenceArray = new CharSequence[this._fromEditor.getLineCount()];
        for (int i = 0; i < charSequenceArray.length; ++i) {
            charSequenceArray[i] = this.getLineCharSequence(this._fromEditor, i);
        }
        return charSequenceArray;
    }

    public CharSequence[] getToItems() {
        CharSequence[] charSequenceArray = new CharSequence[this._toEditor.getLineCount()];
        for (int i = 0; i < charSequenceArray.length; ++i) {
            charSequenceArray[i] = this.getLineCharSequence(this._toEditor, i);
        }
        return charSequenceArray;
    }

    protected CharSequence getLineCharSequence(CodeEditor codeEditor, int n) {
        return this.getSegment(codeEditor, n, n);
    }

    protected Segment getFromSegment(int n, int n2) {
        return this.getSegment(this._fromEditor, n, n2);
    }

    protected Segment getToSegment(int n, int n2) {
        return this.getSegment(this._toEditor, n, n2);
    }

    protected Segment getSegment(CodeEditor codeEditor, int n, int n2) {
        DiffSegment diffSegment = new DiffSegment(this.isIgnoreWhitespaces(), this.is_caseSensitive());
        int n3 = codeEditor.getDocument().getLineStartOffset(n);
        int n4 = codeEditor.getDocument().getLineEndOffset(n2);
        try {
            codeEditor.getDocument().getText(n3, n4 + 1 - n3, diffSegment);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return diffSegment;
    }

    public boolean isIgnoreWhitespaces() {
        return this._ignoreWhitespaces;
    }

    public void setIgnoreWhitespaces(boolean bl) {
        this._ignoreWhitespaces = bl;
    }

    public boolean is_caseSensitive() {
        return this._caseSensitive;
    }

    public void set_caseSensitive(boolean bl) {
        this._caseSensitive = bl;
    }

    public void setFromText(String string) {
        try {
            this._suppressDocumentEvent = true;
            this._fromEditor.setText(string);
        }
        finally {
            this._suppressDocumentEvent = false;
        }
    }

    public String getFromText() {
        return this._fromEditor.getText();
    }

    @Override
    public Diff<?> createLinesDiff(int n, int n2, int n3, int n4) {
        this._fromLinesDifferenceOffset = 0;
        this._toLinesDifferenceOffset = 0;
        Segment segment = this.getFromSegment(n, n2);
        Segment segment2 = this.getToSegment(n3, n4);
        return new Diff<Segment>(this.getDiffTokens(segment).getTokenValues(), this.getDiffTokens(segment2).getTokenValues());
    }

    protected Character[] getFromText(int n, int n2) {
        Object object;
        int n3;
        int n4;
        if (n > n2) {
            n4 = n2;
            n2 = n;
            n = n4;
        }
        n = Math.max(0, n);
        n2 = Math.max(0, n2);
        n4 = this._fromEditor.getLineStartOffset(n);
        Object object2 = this._fromEditor.getText(n4, (n3 = n2 >= this._fromEditor.getLineCount() ? this._fromEditor.getDocumentLength() : this._fromEditor.getLineEndOffset(n2)) - n4 + 1);
        if (object2 == null) {
            return new Character[0];
        }
        if (this.isIgnoreLeadingTrailingSpaces()) {
            object = ((String)object2).trim();
            this._fromLinesDifferenceOffset = ((String)object2).indexOf((String)object);
            object2 = object;
        }
        object = ((String)object2).toCharArray();
        Character[] characterArray = new Character[((Object)object).length];
        for (int i = 0; i < ((Object)object).length; ++i) {
            characterArray[i] = Character.valueOf((char)object[i]);
        }
        return characterArray;
    }

    protected Character[] getToText(int n, int n2) {
        Object object;
        int n3;
        int n4;
        if (n > n2) {
            n4 = n2;
            n2 = n;
            n = n4;
        }
        n = Math.max(0, n);
        n2 = Math.max(0, n2);
        n4 = this._toEditor.getLineStartOffset(n);
        Object object2 = this._toEditor.getText(n4, (n3 = n2 >= this._toEditor.getLineCount() ? this._toEditor.getDocumentLength() : this._toEditor.getLineEndOffset(n2)) - n4 + 1);
        if (object2 == null) {
            return new Character[0];
        }
        if (this.isIgnoreLeadingTrailingSpaces()) {
            object = ((String)object2).trim();
            this._toLinesDifferenceOffset = ((String)object2).indexOf((String)object);
            object2 = object;
        }
        object = ((String)object2).toCharArray();
        Character[] characterArray = new Character[((Object)object).length];
        for (int i = 0; i < ((Object)object).length; ++i) {
            characterArray[i] = Character.valueOf((char)object[i]);
        }
        return characterArray;
    }

    public void setToText(String string) {
        try {
            this._suppressDocumentEvent = true;
            this._toEditor.setText(string);
        }
        finally {
            this._suppressDocumentEvent = false;
        }
    }

    public String getToText() {
        return this._toEditor.getText();
    }

    protected void synchronizeViewport(DiffDivider diffDivider, boolean bl) {
        if (bl) {
            int n = this._fromEditor.getFirstLine();
            int n2 = diffDivider.getSecondMatchLine(Math.min(this._fromEditor.getVisualLineCount(), this._fromEditor.getVisibleLines()), n);
            if (n2 < this._toEditor.getVisualLineCount()) {
                this._toEditor.setFirstLine(n2);
            }
        } else {
            int n = this._toEditor.getFirstLine();
            int n3 = diffDivider.getFirstMatchLine(Math.min(this._toEditor.getVisualLineCount(), this._toEditor.getVisibleLines()), n);
            if (n3 < this._fromEditor.getVisualLineCount()) {
                this._fromEditor.setFirstLine(n3);
            }
        }
    }

    protected void synchronizeViewportHorizontally(boolean bl) {
        if (bl) {
            int n = this._fromEditor.getHorizontalOffset();
            this._toEditor.setHorizontalOffset(n);
        } else {
            int n = this._toEditor.getHorizontalOffset();
            this._fromEditor.setHorizontalOffset(n);
        }
    }

    @Override
    protected int getSelectedIndex(int n) {
        CodeEditor codeEditor = n == 0 ? this._fromEditor : this._toEditor;
        int n2 = codeEditor.getCaretPosition();
        return codeEditor.getLineNumber(n2);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (this._fromAdjustmentListener != null) {
            this._fromEditor.getVerticalScrollBar().removeAdjustmentListener(this._fromAdjustmentListener);
        }
        if (this._fromAdjustmentHorizontalListener != null) {
            this._fromEditor.getHorizontalScrollBar().removeAdjustmentListener(this._fromAdjustmentHorizontalListener);
        }
        this._fromAdjustmentListener = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (CodeEditorDiffPane.this._ignoreFromScrollEvent) {
                    return;
                }
                CodeEditorDiffPane.this._ignoreToScrollEvent = true;
                try {
                    CodeEditorDiffPane.this.synchronizeViewport(CodeEditorDiffPane.this._fromToDivider, true);
                    CodeEditorDiffPane.this._fromToDivider.repaint();
                }
                finally {
                    CodeEditorDiffPane.this._ignoreToScrollEvent = false;
                }
            }
        };
        this._fromAdjustmentHorizontalListener = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (CodeEditorDiffPane.this._ignoreFromScrollEvent) {
                    return;
                }
                CodeEditorDiffPane.this._ignoreToScrollEvent = true;
                try {
                    CodeEditorDiffPane.this.synchronizeViewportHorizontally(true);
                    CodeEditorDiffPane.this._fromToDivider.repaint();
                }
                finally {
                    CodeEditorDiffPane.this._ignoreToScrollEvent = false;
                }
            }
        };
        this._fromEditor.getVerticalScrollBar().addAdjustmentListener(this._fromAdjustmentListener);
        this._fromEditor.getHorizontalScrollBar().addAdjustmentListener(this._fromAdjustmentHorizontalListener);
        if (this._toAdjustmentListener != null) {
            this._toEditor.getVerticalScrollBar().removeAdjustmentListener(this._toAdjustmentListener);
        }
        if (this._toAdjustmentHorizontalListener != null) {
            this._toEditor.getHorizontalScrollBar().removeAdjustmentListener(this._toAdjustmentHorizontalListener);
        }
        this._toAdjustmentListener = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (CodeEditorDiffPane.this._ignoreToScrollEvent) {
                    return;
                }
                CodeEditorDiffPane.this._ignoreFromScrollEvent = true;
                try {
                    CodeEditorDiffPane.this.synchronizeViewport(CodeEditorDiffPane.this._fromToDivider, false);
                    CodeEditorDiffPane.this._fromToDivider.repaint();
                }
                finally {
                    CodeEditorDiffPane.this._ignoreFromScrollEvent = false;
                }
            }
        };
        this._toAdjustmentHorizontalListener = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (CodeEditorDiffPane.this._ignoreToScrollEvent) {
                    return;
                }
                CodeEditorDiffPane.this._ignoreFromScrollEvent = true;
                try {
                    CodeEditorDiffPane.this.synchronizeViewportHorizontally(false);
                    CodeEditorDiffPane.this._fromToDivider.repaint();
                }
                finally {
                    CodeEditorDiffPane.this._ignoreFromScrollEvent = false;
                }
            }
        };
        this._toEditor.getVerticalScrollBar().addAdjustmentListener(this._toAdjustmentListener);
        this._toEditor.getHorizontalScrollBar().addAdjustmentListener(this._toAdjustmentHorizontalListener);
        if (this._fromCaretListener != null) {
            this._fromEditor.getCaretModel().removeCaretListener(this._fromCaretListener);
        }
        this._fromCaretListener = new CaretListener(){

            @Override
            public void caretUpdated(CaretEvent caretEvent) {
                CodeEditorDiffPane.this.updateSelectedDifference(0);
            }
        };
        this._fromEditor.getCaretModel().addCaretListener(this._fromCaretListener);
        if (this._toCaretListener != null) {
            this._toEditor.getCaretModel().removeCaretListener(this._toCaretListener);
        }
        this._toCaretListener = new CaretListener(){

            @Override
            public void caretUpdated(CaretEvent caretEvent) {
                CodeEditorDiffPane.this.updateSelectedDifference(1);
            }
        };
        this._toEditor.getCaretModel().addCaretListener(this._toCaretListener);
        this._timer = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CodeEditorDiffPane.this._diffed) {
                    CodeEditorDiffPane.this.runDiff();
                }
            }
        });
        DiffPaneDocumentListener diffPaneDocumentListener = new DiffPaneDocumentListener();
        this._toEditor.getDocument().addDocumentListener(diffPaneDocumentListener);
        this._fromEditor.getDocument().addDocumentListener(diffPaneDocumentListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this._fromAdjustmentListener != null && this._fromEditor != null) {
            this._fromEditor.getVerticalScrollBar().removeAdjustmentListener(this._fromAdjustmentListener);
        }
        if (this._toAdjustmentListener != null && this._toEditor != null) {
            this._toEditor.getVerticalScrollBar().removeAdjustmentListener(this._toAdjustmentListener);
        }
        if (this._fromCaretListener != null && this._fromEditor != null) {
            this._fromEditor.getCaretModel().removeCaretListener(this._fromCaretListener);
        }
        if (this._toCaretListener != null && this._toEditor != null) {
            this._toEditor.getCaretModel().removeCaretListener(this._toCaretListener);
        }
        if (this._fromEditor != null) {
            for (DocumentListener documentListener : this._fromEditor.getDocument().getDocumentListeners()) {
                if (!(documentListener instanceof DiffPaneDocumentListener)) continue;
                this._fromEditor.getDocument().removeDocumentListener(documentListener);
            }
        }
        if (this._toEditor != null) {
            for (DocumentListener documentListener : this._toEditor.getDocument().getDocumentListeners()) {
                if (!(documentListener instanceof DiffPaneDocumentListener)) continue;
                this._toEditor.getDocument().removeDocumentListener(documentListener);
            }
        }
        this._fromAdjustmentListener = null;
        this._toAdjustmentListener = null;
        this._fromCaretListener = null;
        this._toCaretListener = null;
    }

    @Deprecated
    protected String[] splitString(String string, String string2) {
        if (string.length() == 0) {
            return new String[0];
        }
        String[] stringArray = string.split(string2);
        if (this.isIgnoreLeadingTrailingSpaces()) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
            }
        }
        return stringArray;
    }

    private Character[] toCharArray(String string) {
        Character[] characterArray = new Character[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            characterArray[i] = Character.valueOf(string.charAt(i));
        }
        return characterArray;
    }

    @Override
    public void setReadOnly(boolean bl) {
        super.setReadOnly(bl);
        this._toEditor.setEditable(!bl);
    }

    @Override
    public void clearHighlights() {
        this._fromEditor.getFixedHighlighter().removeAllHighlights();
        this._toEditor.getFixedHighlighter().removeAllHighlights();
        this._fromEditor.getMarkerModel().clearMarkers();
        this._toEditor.getMarkerModel().clearMarkers();
    }

    @Override
    public void startHighlights() {
        this._fromEditor.getMarkerModel().setAdjusting(true);
        this._toEditor.getMarkerModel().setAdjusting(true);
    }

    @Override
    public void endHighlights() {
        this._fromEditor.getMarkerModel().setAdjusting(false);
        this._toEditor.getMarkerModel().setAdjusting(false);
    }

    @Override
    public void highlightChangedExactly(List<Difference> list, int n, int n2, int n3, int n4, Color color, Color color2, String string) {
        int n5 = this._fromEditor.getLineStartOffset(n);
        int n6 = n2 >= 0 ? this._fromEditor.getLineEndOffset(n2) + 1 : 0;
        int n7 = this._toEditor.getLineStartOffset(n3);
        int n8 = n4 >= 0 ? this._toEditor.getLineEndOffset(n4) + 1 : 0;
        Segment segment = this.getFromSegment(n, n2);
        List<DiffSpan> list2 = this.getDiffTokens(segment).getTokenSpans();
        Segment segment2 = this.getToSegment(n3, n4);
        List<DiffSpan> list3 = this.getDiffTokens(segment2).getTokenSpans();
        try {
            CodeEditorDiffPane.addSeparatorHighlightPainter(this._fromEditor, n5, n6, color2);
            CodeEditorDiffPane.addSeparatorHighlightPainter(this._toEditor, n7, n8, color2);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        for (Difference difference : list) {
            DiffSpan diffSpan;
            int n9;
            Color color3;
            int n10 = difference.getDeletedStart();
            int n11 = difference.getDeletedEnd();
            int n12 = difference.getAddedStart();
            int n13 = difference.getAddedEnd();
            if (n11 == -1) {
                color3 = this._fromToDivider.getInsertedColor();
                for (n9 = n12; n9 < n13 + 1; ++n9) {
                    diffSpan = list3.get(n9);
                    try {
                        this._toEditor.getFixedHighlighter().addHighlight(n7 + diffSpan.getStartIndex(), n7 + diffSpan.getStopIndex(), new DefaultHighlighter.DefaultHighlightPainter(color3));
                        continue;
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                continue;
            }
            if (n13 == -1) {
                color3 = this._fromToDivider.getDeletedColor();
                for (n9 = n10; n9 < n11 + 1; ++n9) {
                    diffSpan = list2.get(n9);
                    try {
                        this._fromEditor.getFixedHighlighter().addHighlight(n5 + diffSpan.getStartIndex(), n5 + diffSpan.getStopIndex(), new DefaultHighlighter.DefaultHighlightPainter(color3));
                        continue;
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                continue;
            }
            color3 = this._fromToDivider.getChangedColor();
            for (n9 = n12; n9 < n13 + 1; ++n9) {
                diffSpan = list3.get(n9);
                try {
                    this._toEditor.getFixedHighlighter().addHighlight(n7 + diffSpan.getStartIndex(), n7 + diffSpan.getStopIndex(), new DefaultHighlighter.DefaultHighlightPainter(color3));
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            for (n9 = n10; n9 < n11 + 1; ++n9) {
                diffSpan = list2.get(n9);
                try {
                    this._fromEditor.getFixedHighlighter().addHighlight(n5 + diffSpan.getStartIndex(), n5 + diffSpan.getStopIndex(), new DefaultHighlighter.DefaultHighlightPainter(color3));
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        this._fromEditor.getMarkerModel().addMarker(n5, n6 + 1, 124, "");
        this._toEditor.getMarkerModel().addMarker(n7, n8, 124, string);
    }

    private boolean isSeparator(char c) {
        return Arrays.binarySearch(separators, c) >= 0;
    }

    protected DiffTokens getDiffTokens(Segment segment) {
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        ArrayList<DiffSpan> arrayList2 = new ArrayList<DiffSpan>();
        boolean bl = false;
        char c = segment.first();
        int n = 0;
        int n2 = 0;
        while (c != '\uffff') {
            if (n2 - n != 0) {
                if (this.isSeparator(segment.charAt(n2 - 1))) {
                    bl = true;
                } else if (Character.isWhitespace(segment.charAt(n2 - 1))) {
                    if (!Character.isWhitespace(c)) {
                        bl = true;
                    }
                } else if (Character.isWhitespace(c)) {
                    bl = true;
                } else if (this.isSeparator(c)) {
                    bl = true;
                }
            }
            if (bl) {
                if (!this.isIgnoreWhitespaces() || !Character.isWhitespace(segment.charAt(n2 - 1))) {
                    arrayList.add((Segment)segment.subSequence(n, n2));
                    arrayList2.add(new DiffSpan(n, n2));
                }
                n = n2;
                bl = false;
            }
            c = segment.next();
            ++n2;
        }
        if (!(n == segment.length() - 1 || this.isIgnoreWhitespaces() && Character.isWhitespace(segment.charAt(n)))) {
            arrayList.add((Segment)segment.subSequence(n, segment.length() - 1));
            arrayList2.add(new DiffSpan(n, segment.length() - 1));
        }
        return new DiffTokens(arrayList, arrayList2);
    }

    @Override
    public void highlightChanged(int n, int n2, int n3, int n4, Color color, Color color2, String string) {
        try {
            Difference difference = this.getMatchingDifference(0, n);
            n = this._fromEditor.getLineStartOffset(n);
            n2 = n2 >= 0 ? this._fromEditor.getLineEndOffset(n2) + 1 : 0;
            n3 = this._toEditor.getLineStartOffset(n3);
            n4 = n4 >= 0 ? this._toEditor.getLineEndOffset(n4) + 1 : 0;
            CodeEditorDiffPane.addSeparatorHighlightPainter(this._fromEditor, n, n2, color2);
            this._fromEditor.getFixedHighlighter().addHighlight(n, n2, new LineHighlightPainter(color, this._fromToDivider, difference));
            this._fromEditor.getMarkerModel().addMarker(n, n2 + 1, 124, "");
            CodeEditorDiffPane.addSeparatorHighlightPainter(this._toEditor, n3, n4, color2);
            this._toEditor.getFixedHighlighter().addHighlight(n3, n4, new LineHighlightPainter(color, this._fromToDivider, difference));
            this._toEditor.getMarkerModel().addMarker(n3, n4, 124, string);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    static void addSeparatorHighlightPainter(CodeEditor codeEditor, int n, int n2, Color color) throws BadLocationException {
        SeparatorHighlightPainter separatorHighlightPainter = new SeparatorHighlightPainter(color);
        if (n != n2) {
            separatorHighlightPainter.setHighlightStartOffset(n);
        } else if (n >= codeEditor.getDocumentLength()) {
            n = codeEditor.getLineStartOffset(codeEditor.getLineCount() - 1);
            n2 = codeEditor.getLineEndOffset(codeEditor.getLineCount() - 1);
        } else {
            n2 = codeEditor.getLineEndOffset(codeEditor.getLineNumber(n));
        }
        separatorHighlightPainter.setHighlightEndOffset(n2);
        codeEditor.getFixedHighlighter().addHighlight(n, n2, separatorHighlightPainter);
    }

    @Override
    public void highlightInserted(int n, int n2, int n3, Color color, Color color2, String string) {
        try {
            Difference difference = this.getMatchingDifference(0, n);
            int n4 = this._fromEditor.getLineStartOffset(n);
            int n5 = this._toEditor.getLineStartOffset(n2);
            int n6 = n3 >= 0 ? this._toEditor.getLineEndOffset(n3) + 1 : 0;
            CodeEditorDiffPane.addSeparatorHighlightPainter(this._toEditor, n5, n6, color2);
            this._toEditor.getFixedHighlighter().addHighlight(n5, n6, new LineHighlightPainter(color, this._fromToDivider, difference));
            this._toEditor.getMarkerModel().addMarker(n5, n6, 125, string);
            CodeEditorDiffPane.addSeparatorHighlightPainter(this._fromEditor, n4, n4, color2);
            this._fromEditor.getMarkerModel().addMarker(n4, n4, 126, "");
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void highlightDeleted(int n, int n2, int n3, Color color, Color color2, String string) {
        try {
            Difference difference = this.getMatchingDifference(0, n);
            int n4 = this._fromEditor.getLineStartOffset(n);
            int n5 = n2 >= 0 ? this._fromEditor.getLineEndOffset(n2) + 1 : 0;
            int n6 = this._toEditor.getLineStartOffset(n3);
            CodeEditorDiffPane.addSeparatorHighlightPainter(this._fromEditor, n4, n5, color2);
            this._fromEditor.getFixedHighlighter().addHighlight(n4, n5, new LineHighlightPainter(color, this._fromToDivider, difference));
            this._fromEditor.getMarkerModel().addMarker(n4, n5, 125, "");
            CodeEditorDiffPane.addSeparatorHighlightPainter(this._toEditor, n6, n6, color2);
            this._toEditor.getMarkerModel().addMarker(n6, n6 + 1, 126, string);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    protected List<Difference> acceptDifference(List<Difference> list, Difference difference) {
        boolean bl = false;
        int n = 0;
        ArrayList<Difference> arrayList = new ArrayList<Difference>();
        for (Difference difference2 : list) {
            if (difference2.getDeletedStart() == difference.getDeletedStart() && difference2.getDeletedEnd() == difference.getDeletedEnd()) {
                bl = true;
                if (difference.getAddedEnd() == -1) {
                    n = -(difference.getDeletedEnd() - difference.getDeletedStart() + 1);
                    continue;
                }
                if (difference.getDeletedEnd() == -1) {
                    n = difference.getAddedEnd() - difference.getAddedStart() + 1;
                    continue;
                }
                n = difference.getAddedEnd() - difference.getAddedStart() + 1 - (difference.getDeletedEnd() - difference.getDeletedStart() + 1);
                continue;
            }
            if (bl && n != 0) {
                difference2.adjustAdded(-n);
            }
            arrayList.add(difference2);
        }
        return arrayList;
    }

    private void updateMessage() {
        if (this._differences == null || this._differences.size() == 0) {
            this.setMessage(this.getResourceString("DiffPane.noChange"));
        } else if (this._differences.size() == 1) {
            this.setMessage(this.getResourceString("DiffPane.oneChange"));
        } else {
            this.setMessage(MessageFormat.format(this.getResourceString("DiffPane.hasChanges"), this._differences.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(int n, int n2, boolean bl) {
        if (n2 == -1) {
            return false;
        }
        int n3 = this._toEditor.getLineStartOffset(n);
        int n4 = this._toEditor.getLineStartOffset(n + n2);
        this._suppressDocumentEvent = true;
        try {
            if (n4 > this._toEditor.getDocumentLength()) {
                if (n > 0) {
                    n3 = this._toEditor.getLineEndOffset(n - 1);
                }
                n4 = this._toEditor.getDocumentLength();
            }
            this._toEditor.getDocument().remove(n3, n4 - n3);
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            this._suppressDocumentEvent = false;
        }
        if (bl && this._diffed) {
            this.runDiff();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean insert(int n, int n2, int n3, boolean bl) {
        int n4 = this._toEditor.getLineStartOffset(n);
        int n5 = this._fromEditor.getLineStartOffset(n2);
        int n6 = this._fromEditor.getLineStartOffset(n2 + n3);
        String string = this._fromEditor.getText(n5, n6 - n5);
        this._suppressDocumentEvent = true;
        try {
            this._toEditor.getDocument().insertString(n4, string, null);
            this._toEditor.select(n4);
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            this._suppressDocumentEvent = false;
        }
        if (bl && this._diffed) {
            this.runDiff();
        }
        return true;
    }

    @Deprecated
    public boolean isIgnoreLeadingTrailingSpaces() {
        return this.isIgnoreWhitespaces();
    }

    @Deprecated
    public void setIgnoreLeadingTrailingSpaces(boolean bl) {
        this.setIgnoreWhitespaces(bl);
    }

    static {
        Arrays.sort(separators);
    }

    private class DiffPaneDocumentListener
    implements DocumentListener {
        private DiffPaneDocumentListener() {
        }

        private void startTimer() {
            if (CodeEditorDiffPane.this._timer == null) {
                return;
            }
            if (CodeEditorDiffPane.this._timer.isRunning()) {
                CodeEditorDiffPane.this._timer.restart();
            } else {
                CodeEditorDiffPane.this._timer.setRepeats(false);
                CodeEditorDiffPane.this._timer.start();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (!CodeEditorDiffPane.this._suppressDocumentEvent) {
                this.startTimer();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (!CodeEditorDiffPane.this._suppressDocumentEvent) {
                this.startTimer();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            if (!CodeEditorDiffPane.this._suppressDocumentEvent) {
                this.startTimer();
            }
        }
    }
}

