/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.diff;

import com.jidesoft.editor.CodeEditor;

public class CodeEditorCharSequence
implements CharSequence {
    private final CodeEditor _editor;
    private final int _lineNumber;
    private final boolean _ignoreLeadingTrailingSpaces;

    public CodeEditorCharSequence(CodeEditor codeEditor, int n, boolean bl) {
        this._editor = codeEditor;
        this._lineNumber = n;
        this._ignoreLeadingTrailingSpaces = bl;
    }

    @Override
    public int length() {
        String string = this._editor.getLineText(this._lineNumber);
        if (string.endsWith("\r\n")) {
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("\r") || string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        if (this.isIgnoreLeadingTrailingSpaces()) {
            string = string.trim();
        }
        return string.length();
    }

    @Override
    public char charAt(int n) {
        String string = this._editor.getLineText(this._lineNumber);
        if (string.endsWith("\r\n")) {
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("\r") || string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        if (this.isIgnoreLeadingTrailingSpaces()) {
            string = string.trim();
        }
        return n < 0 || n >= string.length() ? (char)'\u0000' : string.charAt(n);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        String string = this._editor.getLineText(this._lineNumber);
        if (string.endsWith("\r\n")) {
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("\r") || string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        if (this.isIgnoreLeadingTrailingSpaces()) {
            string = string.trim();
        }
        return string.subSequence(n, n2);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String toString() {
        return this.subSequence(0, this.length()).toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof CodeEditorCharSequence)) {
            return false;
        }
        if (((CodeEditorCharSequence)object).length() != this.length()) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    private boolean isIgnoreLeadingTrailingSpaces() {
        return this._ignoreLeadingTrailingSpaces;
    }
}

