/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.database;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.CurrencyConverter;
import com.jidesoft.converter.NumberConverter;
import com.jidesoft.database.ResultSetTableModel;
import com.jidesoft.filter.AndFilter;
import com.jidesoft.filter.BetweenFilter;
import com.jidesoft.filter.EqualFilter;
import com.jidesoft.filter.Filter;
import com.jidesoft.filter.InFilter;
import com.jidesoft.filter.LikeFilter;
import com.jidesoft.filter.NotFilter;
import com.jidesoft.filter.OrFilter;
import com.jidesoft.filter.SqlFilterSupport;
import com.jidesoft.filter.WildcardFilter;
import com.jidesoft.grid.AutoFilterTableHeaderAdapter;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.DynamicTableFilter;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.FilterItemSupport;
import com.jidesoft.grid.FilterableTableModelEvent;
import com.jidesoft.grid.FilterableTableModelListener;
import com.jidesoft.grid.GridIconsFactory;
import com.jidesoft.grid.IFilterableTableModel;
import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.MultipleValuesFilter;
import com.jidesoft.grid.SingleValueFilter;
import com.jidesoft.grid.SortEvent;
import com.jidesoft.grid.SortItemSupport;
import com.jidesoft.grid.SortListener;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.StringConverter;
import com.jidesoft.utils.TypeUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import javax.swing.table.AbstractTableModel;

public class DatabaseTableModel
extends AbstractTableModel
implements ISortableTableModel,
IFilterableTableModel,
ContextSensitiveTableModel {
    protected ResultSetTableModel _resultSetTableModel;
    protected Connection _connection;
    protected Statement _statement;
    protected String _fromStatement;
    protected String _selectStatement;
    protected String _preStatement;
    private boolean _updatable = false;
    private Map<String, String> _columnMapping = new HashMap<String, String>();
    private static final Logger LOGGER = Logger.getLogger(DatabaseTableModel.class.getName());
    protected ConverterContext[] _converterContexts;
    private boolean _considerCurrencyField = false;
    private static final long serialVersionUID = -5764565305416398488L;
    protected SortItemSupport _sortItemSupport;
    private boolean[] _columnsSortable;
    protected FilterItemSupport _filterItemSupport;
    private boolean _isAdjusting = false;
    private static final Logger LOGGER_FILTERABLE_TABLE_MODEL_EVENT = Logger.getLogger(FilterableTableModelEvent.class.getName());

    public DatabaseTableModel(Connection connection, String string) throws SQLException {
        this(connection, "*", string);
    }

    public DatabaseTableModel(Connection connection, String string, String string2) throws SQLException {
        this(connection, string, string2, false);
    }

    public DatabaseTableModel(Connection connection, String string, String string2, String string3) throws SQLException {
        this(connection, string, string2, string3, false);
    }

    public DatabaseTableModel(Connection connection, String string, String string2, boolean bl) throws SQLException {
        this(connection, null, string, string2, bl);
    }

    public DatabaseTableModel(Connection connection, String string, String string2, String string3, boolean bl) throws SQLException {
        this._connection = connection;
        this._preStatement = string;
        this._selectStatement = string2;
        this._fromStatement = string3;
        this._sortItemSupport = new SortItemSupport();
        this._filterItemSupport = new FilterItemSupport();
        this._filterItemSupport.setFiltersApplied(true);
        this._updatable = bl;
        this.initDatabase();
    }

    protected void initDatabase() throws SQLException {
        if (this._selectStatement == null) {
            this._selectStatement = "*";
        }
        this._statement = null;
        this.refreshData(this._sortItemSupport, this._filterItemSupport);
    }

    public void setColumnMapping(Map<String, String> map) {
        this._columnMapping = map;
    }

    public Map<String, String> getColumnMapping() {
        return this._columnMapping;
    }

    @Override
    public int getColumnCount() {
        return this._resultSetTableModel == null ? 0 : this._resultSetTableModel.getColumnCount();
    }

    private String getColumnNameInDatabase(int n) {
        return this._resultSetTableModel == null ? "" : this._resultSetTableModel.getColumnName(n);
    }

    @Override
    public String getColumnName(int n) {
        String string = this.getColumnNameInDatabase(n);
        Map<String, String> map = this.getColumnMapping();
        if (map != null && map.containsKey(string.toUpperCase())) {
            return map.get(string.toUpperCase());
        }
        return string;
    }

    @Override
    public ConverterContext getConverterContextAt(int n, int n2) {
        if (this._converterContexts != null && n2 < this._converterContexts.length) {
            return this._converterContexts[n2];
        }
        return null;
    }

    @Override
    public EditorContext getEditorContextAt(int n, int n2) {
        return null;
    }

    @Override
    public Class<?> getCellClassAt(int n, int n2) {
        return this.getColumnClass(n2);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this._resultSetTableModel == null ? null : this._resultSetTableModel.getColumnClass(n);
    }

    @Override
    public int getRowCount() {
        return this._resultSetTableModel == null ? 0 : this._resultSetTableModel.getRowCount();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this._resultSetTableModel == null ? null : this._resultSetTableModel.getValueAt(n, n2);
    }

    @Override
    public int getSortedRowAt(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getActualRowAt(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sortColumn(int n) {
        if (this._sortItemSupport.sortColumn(n)) {
            this.resort();
        }
    }

    @Override
    public void sortColumn(int n, boolean bl) {
        if (this._sortItemSupport.sortColumn(n, bl)) {
            this.resort();
        }
    }

    @Override
    public void unsortColumn(int n) {
        if (this._sortItemSupport.unsortColumn(n)) {
            this.resort();
        }
    }

    @Override
    public void reverseColumnSortOrder(int n) {
        if (this._sortItemSupport.reverseColumnSortOrder(n)) {
            this.resort();
        }
    }

    @Override
    public void sortColumn(int n, boolean bl, boolean bl2) {
        if (this._sortItemSupport.sortColumn(n, bl, bl2)) {
            this.resort();
        }
    }

    @Override
    public boolean isColumnSorted(int n) {
        return this._sortItemSupport.isColumnSorted(n);
    }

    @Override
    public boolean isColumnAscending(int n) {
        return this._sortItemSupport.isColumnAscending(n);
    }

    @Override
    public void reset() {
        if (this._sortItemSupport.reset()) {
            this.resort();
        }
    }

    @Override
    public void toggleSortOrder(int n, boolean bl) {
        this._sortItemSupport.toggleSortOrder(n, bl);
        this.resort();
    }

    @Override
    public List<ISortableTableModel.SortItem> getSortingColumns() {
        return this._sortItemSupport.getSortingColumns();
    }

    @Override
    public void setSortingColumns(List<ISortableTableModel.SortItem> list) {
        this._sortItemSupport.setSortingColumns(list);
        this.resort();
    }

    @Override
    public int getColumnSortRank(int n) {
        return this._sortItemSupport.getColumnSortRank(n);
    }

    @Override
    public void setMasterSortColumns(int[] nArray) {
        this._sortItemSupport.setMasterSortColumns(nArray);
    }

    @Override
    public int[] getMasterSortColumns() {
        return this._sortItemSupport.getMasterSortColumns();
    }

    @Override
    public boolean isMultiColumnSortable() {
        return this._sortItemSupport.isMultiColumnSortable();
    }

    @Override
    public void setMultiColumnSortable(boolean bl) {
        this._sortItemSupport.setMultiColumnSortable(bl);
        this.resort();
    }

    @Override
    public boolean isSortable() {
        return this._sortItemSupport.isSortable();
    }

    @Override
    public void setSortable(boolean bl) {
        this._sortItemSupport.setSortable(bl);
    }

    @Override
    public void resort() {
        this.fireSortingEvent();
        this.sort();
        this.fireTableDataChanged();
        this.fireSortEvent();
    }

    @Override
    public int getSortPriority() {
        return this._sortItemSupport.getSortPriority();
    }

    @Override
    public void setSortPriority(int n) {
        this._sortItemSupport.setSortPriority(n);
    }

    @Override
    public int getMaximumSortColumns() {
        return this._sortItemSupport.getMaximumSortColumns();
    }

    @Override
    public void setMaximumSortColumns(int n) {
        this._sortItemSupport.setMaximumSortColumns(n);
    }

    @Override
    public void addSortListener(SortListener sortListener) {
        if (!JideSwingUtilities.isListenerRegistered(this.listenerList, SortListener.class, (EventListener)sortListener)) {
            this.listenerList.add(SortListener.class, sortListener);
        }
    }

    @Override
    public void removeSortListener(SortListener sortListener) {
        this.listenerList.remove(SortListener.class, sortListener);
    }

    @Override
    public SortListener[] getSortListeners() {
        return (SortListener[])this.listenerList.getListeners(SortListener.class);
    }

    public void fireSortEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        SortEvent sortEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SortListener.class) continue;
            if (sortEvent == null) {
                sortEvent = new SortEvent(this);
            }
            ((SortListener)objectArray[i + 1]).sortChanged(sortEvent);
        }
    }

    public void fireSortingEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        SortEvent sortEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SortListener.class) continue;
            if (sortEvent == null) {
                sortEvent = new SortEvent(this);
            }
            ((SortListener)objectArray[i + 1]).sortChanging(sortEvent);
        }
    }

    @Override
    public boolean isColumnSortable(int n) {
        if (this.getColumnCount() == 0) {
            return false;
        }
        if (!this.isSortable()) {
            return false;
        }
        if (n >= 0 && n < this.getColumnCount()) {
            this.initColumnsSortable();
            return this._columnsSortable[n];
        }
        return false;
    }

    @Override
    public void setColumnSortable(int n, boolean bl) {
        if (n >= 0 && n < this.getColumnCount()) {
            this.initColumnsSortable();
            this._columnsSortable[n] = bl;
        }
    }

    private void initColumnsSortable() {
        if (this._columnsSortable == null) {
            this._columnsSortable = new boolean[this.getColumnCount()];
            Arrays.fill(this._columnsSortable, true);
        }
    }

    protected void sort() {
        try {
            this.refreshData(this._sortItemSupport, this._filterItemSupport);
        }
        catch (SQLException sQLException) {
            LOGGER.severe(sQLException.getLocalizedMessage());
        }
    }

    protected String createOrderStatement(SortItemSupport sortItemSupport) {
        List<ISortableTableModel.SortItem> list;
        List<ISortableTableModel.SortItem> list2 = list = sortItemSupport == null ? null : sortItemSupport.getSortingColumns();
        if (list != null && list.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer("ORDER BY ");
            for (int i = 0; i < list.size(); ++i) {
                ISortableTableModel.SortItem sortItem = list.get(i);
                String string = this.getColumnNameInDatabase(sortItem.column);
                stringBuffer.append(string).append(sortItem.ascending ? " ASC" : " DESC");
                if (i == list.size() - 1) continue;
                stringBuffer.append(",");
            }
            return stringBuffer.toString();
        }
        return null;
    }

    protected StringBuffer prepareWhereStatement(IFilterableTableModel.FilterItem filterItem) {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendFilter(filterItem.filter, filterItem.column, stringBuffer);
        return stringBuffer;
    }

    private void appendFilter(Filter filter, int n, StringBuffer stringBuffer) {
        Filter filter2;
        int n2;
        Object object;
        if (filter instanceof OrFilter) {
            object = ((OrFilter)filter).getFilters();
            for (n2 = 0; n2 < object.size(); ++n2) {
                filter2 = (Filter)object.get(n2);
                stringBuffer.append("(");
                this.appendFilter(filter2, n, stringBuffer);
                stringBuffer.append(")");
                if (n2 == object.size() - 1) continue;
                stringBuffer.append(" OR ");
            }
        } else if (filter instanceof AndFilter) {
            object = ((AndFilter)filter).getFilters();
            for (n2 = 0; n2 < object.size(); ++n2) {
                filter2 = (Filter)object.get(n2);
                stringBuffer.append("(");
                this.appendFilter(filter2, n, stringBuffer);
                stringBuffer.append(")");
                if (n2 == object.size() - 1) continue;
                stringBuffer.append(" AND ");
            }
        } else if (filter instanceof NotFilter) {
            object = ((NotFilter)filter).getFilter();
            stringBuffer.append(" NOT (");
            this.appendFilter((Filter)object, n, stringBuffer);
            stringBuffer.append(")");
        }
        if (n == -2) {
            stringBuffer.append("(");
            boolean bl = true;
            for (n2 = 0; n2 < this.getColumnCount(); ++n2) {
                if (!(filter instanceof SqlFilterSupport)) continue;
                if (!bl) {
                    stringBuffer.append(" OR ");
                }
                this.appendFilter(filter, n, stringBuffer, n2);
                bl = false;
            }
            if (bl) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            } else {
                stringBuffer.append(")");
            }
        } else if (n == -1) {
            stringBuffer.append("(");
            boolean bl = true;
            for (n2 = 0; n2 < this.getColumnCount(); ++n2) {
                if (!(filter instanceof SqlFilterSupport)) continue;
                if (!bl) {
                    stringBuffer.append(" AND ");
                }
                this.appendFilter(filter, n, stringBuffer, n2);
                bl = false;
            }
            if (bl) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            } else {
                stringBuffer.append(")");
            }
        } else {
            this.appendFilter(filter, n, stringBuffer, n);
        }
    }

    private void appendFilter(Filter filter, int n, StringBuffer stringBuffer, int n2) {
        if (filter instanceof LikeFilter) {
            this.appendLikeFilter((LikeFilter)filter, n2, stringBuffer);
        } else if (filter instanceof EqualFilter) {
            this.appendEqualFilter((EqualFilter)filter, n2, stringBuffer);
        } else if (filter instanceof BetweenFilter) {
            this.appendBetweenFilter((BetweenFilter)filter, n2, stringBuffer);
        } else if (filter instanceof InFilter) {
            this.appendInFilter((InFilter)filter, n2, stringBuffer);
        } else if (filter instanceof SingleValueFilter) {
            this.appendSingleValueFilter((SingleValueFilter)filter, n2, stringBuffer);
        } else if (filter instanceof MultipleValuesFilter) {
            this.appendInFilter((MultipleValuesFilter)filter, n2, stringBuffer);
        } else if (filter instanceof WildcardFilter) {
            this.appendWildcardFilter((WildcardFilter)filter, n, stringBuffer);
        }
    }

    private void appendWildcardFilter(WildcardFilter wildcardFilter, int n, StringBuffer stringBuffer) {
        stringBuffer.append(this.getColumnNameInDatabase(n)).append(" LIKE ");
        if (wildcardFilter.isBeginWith() && wildcardFilter.isEndWith()) {
            stringBuffer.append("'").append("%").append(wildcardFilter.getPattern()).append("%").append("'");
        } else if (wildcardFilter.isBeginWith()) {
            stringBuffer.append("'").append(wildcardFilter.getPattern()).append("%").append("'");
        } else if (wildcardFilter.isEndWith()) {
            stringBuffer.append("'").append("%").append(wildcardFilter.getPattern()).append("'");
        }
    }

    protected String convertElementToString(Filter filter, Object object) {
        if (object == null) {
            return "NULL";
        }
        if (object instanceof String || object instanceof Date) {
            return "'" + object + "'";
        }
        return object.toString();
    }

    private void appendInFilter(InFilter inFilter, int n, StringBuffer stringBuffer) {
        stringBuffer.append(this.getColumnNameInDatabase(n)).append(inFilter.getOperator()).append("(");
        T[] TArray = inFilter.getValues();
        for (int i = 0; i < TArray.length; ++i) {
            Object t = TArray[i];
            stringBuffer.append(this.convertElementToString(inFilter, t));
            if (i == TArray.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
    }

    private void appendInFilter(MultipleValuesFilter multipleValuesFilter, int n, StringBuffer stringBuffer) {
        stringBuffer.append(this.getColumnNameInDatabase(n)).append(multipleValuesFilter.getOperator()).append("(");
        T[] TArray = multipleValuesFilter.getValues();
        for (int i = 0; i < TArray.length; ++i) {
            Object t = TArray[i];
            stringBuffer.append(this.convertElementToString(multipleValuesFilter, t));
            if (i == TArray.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
    }

    private void appendBetweenFilter(BetweenFilter betweenFilter, int n, StringBuffer stringBuffer) {
        stringBuffer.append(this.getColumnNameInDatabase(n)).append(betweenFilter.getOperator());
        Object t = betweenFilter.getValue1();
        stringBuffer.append(this.convertElementToString(betweenFilter, t));
        stringBuffer.append(" AND ");
        Object t2 = betweenFilter.getValue2();
        stringBuffer.append(this.convertElementToString(betweenFilter, t2));
    }

    private void appendEqualFilter(EqualFilter equalFilter, int n, StringBuffer stringBuffer) {
        stringBuffer.append(this.getColumnNameInDatabase(n)).append(equalFilter.getOperator());
        Object t = equalFilter.getValue();
        stringBuffer.append(this.convertElementToString(equalFilter, t));
    }

    private void appendSingleValueFilter(SingleValueFilter singleValueFilter, int n, StringBuffer stringBuffer) {
        stringBuffer.append(this.getColumnNameInDatabase(n)).append(singleValueFilter.getOperator());
        Object t = singleValueFilter.getValue();
        stringBuffer.append(this.convertElementToString(singleValueFilter, t));
    }

    private void appendLikeFilter(LikeFilter likeFilter, int n, StringBuffer stringBuffer) {
        String string = likeFilter.getPattern();
        if (string == null) {
            return;
        }
        if (!likeFilter.isCaseSensitive()) {
            stringBuffer.append("lower(").append(this.getColumnNameInDatabase(n)).append(")");
        } else {
            stringBuffer.append(this.getColumnNameInDatabase(n));
        }
        if (!likeFilter.isCaseSensitive()) {
            string = string.toLowerCase();
        }
        stringBuffer.append(likeFilter.getOperator()).append("'").append(string).append("'");
    }

    @Override
    public void refresh() {
        try {
            this.refreshData(this._sortItemSupport, this._filterItemSupport);
        }
        catch (SQLException sQLException) {
            StringWriter stringWriter = new StringWriter();
            sQLException.printStackTrace(new PrintWriter(stringWriter));
            LOGGER.severe(stringWriter.toString());
        }
    }

    protected String createWhereStatement(FilterItemSupport filterItemSupport) {
        List<IFilterableTableModel.FilterItem> list;
        List<IFilterableTableModel.FilterItem> list2 = list = filterItemSupport == null ? null : filterItemSupport.getFilterItems();
        if (list != null && list.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer("");
            for (int i = 0; i < list.size(); ++i) {
                IFilterableTableModel.FilterItem filterItem = list.get(i);
                StringBuffer stringBuffer2 = this.prepareWhereStatement(filterItem);
                if (stringBuffer2.length() > 0) {
                    stringBuffer.append("(").append(stringBuffer2).append(")");
                }
                if (i == list.size() - 1) continue;
                stringBuffer.append(filterItemSupport.isAndMode() ? " AND " : " OR ");
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.insert(0, "WHERE ");
                return stringBuffer.toString();
            }
        }
        return null;
    }

    @Override
    public boolean isColumnFilterable(int n) {
        return true;
    }

    @Override
    public boolean isColumnVisible(int n) {
        return true;
    }

    @Override
    public boolean isColumnAutoFilterable(int n) {
        return true;
    }

    @Override
    public boolean isValuePredetermined(int n) {
        return true;
    }

    @Override
    public void addFilter(int n, Filter filter) {
        this._filterItemSupport.addFilter(n, filter);
    }

    @Override
    public void addFilter(Filter filter) {
        this._filterItemSupport.addFilter(filter);
    }

    @Override
    public void addFilter(IFilterableTableModel.FilterItem filterItem) {
        this._filterItemSupport.addFilter(filterItem);
    }

    @Override
    public void removeFilter(int n, Filter filter) {
        this._filterItemSupport.removeFilter(n, filter);
    }

    @Override
    public void removeFilter(Filter filter) {
        this._filterItemSupport.removeFilter(filter);
    }

    @Override
    public void removeFilter(IFilterableTableModel.FilterItem filterItem) {
        this._filterItemSupport.removeFilter(filterItem);
    }

    @Override
    public void removeAllFilters(int n) {
        this._filterItemSupport.removeAllFilters(n);
    }

    @Override
    public void removeAllFilters() {
        this._filterItemSupport.removeAllFilters();
    }

    @Override
    public void clearFilters() {
        this._filterItemSupport.clearFilters();
    }

    @Override
    public Filter[] getFilters(int n) {
        return this._filterItemSupport.getFilters(n);
    }

    @Override
    public List<IFilterableTableModel.FilterItem> getFilterItems() {
        return this._filterItemSupport.getFilterItems();
    }

    @Override
    public void setFiltersApplied(boolean bl) {
        this._filterItemSupport.setFiltersApplied(bl);
        this.refresh();
    }

    @Override
    public boolean isFiltersApplied() {
        return this._filterItemSupport.isFiltersApplied();
    }

    @Override
    public boolean hasFilter() {
        return this._filterItemSupport.hasFilter();
    }

    @Override
    public boolean hasFilter(int n) {
        return this._filterItemSupport.hasFilter(n);
    }

    @Override
    public boolean isAndMode() {
        return this._filterItemSupport.isAndMode();
    }

    @Override
    public void setAndMode(boolean bl) {
        this._filterItemSupport.setAndMode(bl);
    }

    @Override
    public boolean isAdjusting() {
        return this._isAdjusting;
    }

    @Override
    public void setAdjusting(boolean bl) {
        if (this._isAdjusting != bl) {
            this._isAdjusting = bl;
            if (!this._isAdjusting) {
                // empty if block
            }
        }
    }

    @Override
    public Object[] getPossibleValues(int n, Comparator comparator) {
        try {
            String string = this.createPossibleValuesStatement(n);
            if (this._statement == null) {
                this._statement = this.createStatement();
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Statement statement = this.prepareStatement(string);
            ResultSet resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                arrayList.add(resultSet.getObject(1));
            }
            Object[] objectArray = arrayList.toArray(new Object[arrayList.size()]);
            Arrays.sort(objectArray, comparator);
            return objectArray;
        }
        catch (SQLException sQLException) {
            return new Object[0];
        }
    }

    @Override
    public Object[] getPossibleValuesAndConverters(int n, Comparator comparator) {
        return this.getPossibleValues(n, comparator);
    }

    @Override
    public boolean isSameConverterAt(int n) {
        return true;
    }

    @Override
    public boolean isSplitArrayOrCollection() {
        return false;
    }

    @Override
    public void setSplitArrayOrCollection(boolean bl) {
    }

    protected String createPossibleValuesStatement(int n) {
        return this.createSqlStatement(this._preStatement, "distinct " + this.getColumnNameInDatabase(n), this._fromStatement, null, null).toString();
    }

    @Override
    public void setFilteringPaused(boolean bl) {
    }

    @Override
    public boolean isFilteringPaused() {
        return false;
    }

    @Override
    public void addFilterableTableModelListener(FilterableTableModelListener filterableTableModelListener) {
        this.listenerList.add(FilterableTableModelListener.class, filterableTableModelListener);
    }

    @Override
    public void removeFilterableTableModelListener(FilterableTableModelListener filterableTableModelListener) {
        this.listenerList.remove(FilterableTableModelListener.class, filterableTableModelListener);
    }

    @Override
    public FilterableTableModelListener[] getFilterableTableModelListeners() {
        return (FilterableTableModelListener[])this.listenerList.getListeners(FilterableTableModelListener.class);
    }

    public void fireFilterChanged(FilterableTableModelEvent filterableTableModelEvent) {
        if (LOGGER_FILTERABLE_TABLE_MODEL_EVENT.isLoggable(Level.FINE)) {
            switch (filterableTableModelEvent.getID()) {
                case 7099: {
                    LOGGER_FILTERABLE_TABLE_MODEL_EVENT.fine("FilterableTableModel: \"" + filterableTableModelEvent.getFilter() + "\" is added at column index " + filterableTableModelEvent.getColumn());
                    break;
                }
                case 7100: {
                    if (filterableTableModelEvent.getFilter() == null) {
                        LOGGER_FILTERABLE_TABLE_MODEL_EVENT.fine("FilterableTableModel: all filters are cleared at column index " + filterableTableModelEvent.getColumn());
                        break;
                    }
                    LOGGER_FILTERABLE_TABLE_MODEL_EVENT.fine("FilterableTableModel: \"" + filterableTableModelEvent.getFilter() + "\" is removed at column index " + filterableTableModelEvent.getColumn());
                }
            }
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != FilterableTableModelListener.class) continue;
            ((FilterableTableModelListener)objectArray[i + 1]).filterableTableModelChanged(filterableTableModelEvent);
        }
    }

    public void fireFilterAdded(int n, Filter filter) {
        this.fireFilterChanged(new FilterableTableModelEvent(this, 7099, n, filter));
    }

    public void fireFilterRemoved(int n, Filter filter) {
        this.fireFilterChanged(new FilterableTableModelEvent(this, 7100, n, filter));
    }

    @Override
    public Icon getFilterIcon(int n) {
        return GridIconsFactory.getImageIcon("icons/filter.png");
    }

    protected Statement createStatement() throws SQLException {
        Statement statement;
        int n = this.isUpdatable() ? 1008 : 1007;
        try {
            statement = this._connection.createStatement(1005, n);
        }
        catch (SQLException sQLException) {
            try {
                statement = this._connection.createStatement(1004, n);
            }
            catch (SQLException sQLException2) {
                statement = this._connection.createStatement(1003, n);
            }
        }
        return statement;
    }

    protected Statement createReadonlyStatement() throws SQLException {
        Statement statement;
        try {
            statement = this._connection.createStatement(1004, 1007);
        }
        catch (SQLException sQLException) {
            statement = this._connection.createStatement(1003, 1007);
        }
        return statement;
    }

    protected Statement adjustStatement(Statement statement, String string) throws SQLException {
        return statement.getResultSetConcurrency() != 1008 || string.startsWith("select count(*) ") ? this.createReadonlyStatement() : null;
    }

    public void refreshData(SortItemSupport sortItemSupport, FilterItemSupport filterItemSupport) throws SQLException {
        String string = this.createCountStatement(filterItemSupport);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("SQL statement: " + string);
        }
        if (this._statement == null) {
            this._statement = this.createStatement();
        }
        Statement statement = this.prepareStatement(string);
        ResultSet resultSet = statement.executeQuery(string);
        resultSet.next();
        int n = resultSet.getInt(1);
        StringBuffer stringBuffer = this.createSqlStatement(this._preStatement, this._selectStatement, this._fromStatement, sortItemSupport, filterItemSupport);
        String string2 = stringBuffer.toString();
        statement = this.prepareStatement(string2);
        ResultSet resultSet2 = statement.executeQuery(string2);
        if (this._resultSetTableModel != null) {
            this._resultSetTableModel.close();
        }
        this._resultSetTableModel = this.createResultSetTableModel(resultSet2, n);
        this.configureConverterContexts();
        this.fireTableDataChanged();
    }

    private Statement prepareStatement(String string) throws SQLException {
        Statement statement = this.adjustStatement(this._statement, string);
        if (statement == null) {
            statement = this._statement;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("SQL statement: " + string);
        }
        return statement;
    }

    protected ResultSetTableModel createResultSetTableModel(ResultSet resultSet, int n) throws SQLException {
        return new ResultSetTableModel(resultSet, n);
    }

    protected void configureConverterContexts() throws SQLException {
        int n = this.getColumnCount();
        this._converterContexts = new ConverterContext[n];
        if (this._resultSetTableModel == null) {
            return;
        }
        ResultSetMetaData resultSetMetaData = this._resultSetTableModel.getResultSet().getMetaData();
        for (int i = 0; i < n; ++i) {
            int n2 = i + 1;
            if (this.isConsiderCurrencyField() && resultSetMetaData.isCurrency(n2)) {
                this._converterContexts[i] = CurrencyConverter.CONTEXT;
                continue;
            }
            if (TypeUtils.isNumericType(this.getColumnClass(i))) {
                int n3 = resultSetMetaData.getScale(n2);
                this._converterContexts[i] = NumberConverter.CONTEXT_FRACTION_NUMBER;
                NumberFormat numberFormat = NumberFormat.getInstance();
                numberFormat.setMinimumFractionDigits(n3);
                numberFormat.setMaximumFractionDigits(n3);
                numberFormat.setMaximumIntegerDigits(resultSetMetaData.getPrecision(n2));
                this._converterContexts[i].setUserObject(numberFormat);
                continue;
            }
            this._converterContexts[i] = null;
        }
    }

    protected String createCountStatement(FilterItemSupport filterItemSupport) {
        Pattern[] patternArray = new Pattern[]{Pattern.compile(" order +by "), Pattern.compile(" group +by ")};
        String string = this._fromStatement;
        for (int i = 0; i < patternArray.length; ++i) {
            Matcher matcher = patternArray[i].matcher(string.toLowerCase());
            if (!matcher.find()) continue;
            string = string.substring(0, matcher.start());
        }
        return this.createSqlStatement(this._preStatement, "count(*)", string, null, filterItemSupport).toString();
    }

    protected StringBuffer createSqlStatement(String string, String string2, String string3, SortItemSupport sortItemSupport, FilterItemSupport filterItemSupport) {
        String string4;
        StringBuffer stringBuffer = string != null && string.trim().length() > 0 ? new StringBuffer(string).append(" select ") : new StringBuffer("select ");
        stringBuffer.append(string2).append(" from ").append(string3);
        String string5 = this.createWhereStatement(filterItemSupport);
        if (string5 != null) {
            stringBuffer.append(" ").append(string5);
        }
        if ((string4 = this.createOrderStatement(sortItemSupport)) != null) {
            stringBuffer.append(" ").append(string4);
        }
        return stringBuffer;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this._resultSetTableModel != null) {
            this._resultSetTableModel.setValueAt(object, n, n2);
            try {
                this.commit();
            }
            catch (SQLException sQLException) {
                LOGGER.severe(sQLException.getLocalizedMessage());
            }
        }
    }

    public void invalidateCache(int n) {
        this._resultSetTableModel.invalidateCache(n);
    }

    public void invalidateCache() {
        this._resultSetTableModel.invalidateCache();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        boolean bl;
        boolean bl2 = bl = this._resultSetTableModel != null && this._resultSetTableModel.isCellEditable(n, n2);
        if (bl) {
            try {
                return !this._resultSetTableModel.getResultSet().getMetaData().isReadOnly(n2 + 1);
            }
            catch (SQLException sQLException) {
                return false;
            }
        }
        return false;
    }

    public void setUpdatable(boolean bl) {
        boolean bl2 = this._updatable;
        if (bl2 != bl) {
            this._updatable = bl;
            this._statement = null;
            try {
                this.initDatabase();
            }
            catch (SQLException sQLException) {
                this._updatable = false;
            }
        }
        if (this._resultSetTableModel != null) {
            this._resultSetTableModel.setUpdatable(this._updatable);
        }
    }

    public boolean isUpdatable() {
        return this._updatable;
    }

    public void commit() throws SQLException {
        if (!this._connection.getAutoCommit()) {
            this._connection.commit();
        }
    }

    public void close() throws SQLException {
        if (this._resultSetTableModel != null) {
            this._resultSetTableModel.close();
        }
        this._connection.close();
    }

    public boolean validate(int n, Object object) {
        try {
            if (!this.validateNullable(n, object)) {
                return false;
            }
            if (!this.validateSigned(n, object)) {
                return false;
            }
            if (!this.validatePrecision(n, object)) {
                return false;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return true;
    }

    public boolean validateNullable(int n, Object object) throws SQLException {
        return object != null || this._resultSetTableModel.getResultSet().getMetaData().isNullable(n + 1) != 0;
    }

    public boolean validateSigned(int n, Object object) throws SQLException {
        return !TypeUtils.isNumericType(this.getColumnClass(n)) || !(((Number)object).doubleValue() < 0.0) || this._resultSetTableModel.getResultSet().getMetaData().isSigned(n + 1);
    }

    public boolean validatePrecision(int n, Object object) throws SQLException {
        int n2 = this._resultSetTableModel.getResultSet().getMetaData().getPrecision(n + 1);
        if (n2 == 0) {
            return true;
        }
        return !(TypeUtils.isNumericType(this.getColumnClass(n)) ? Math.pow(10.0, n2) < ((Number)object).doubleValue() : object.toString().length() > n2);
    }

    public boolean isConsiderCurrencyField() {
        return this._considerCurrencyField;
    }

    public void setConsiderCurrencyField(boolean bl) {
        this._considerCurrencyField = bl;
    }

    @Override
    public DynamicTableFilter[] getDynamicTableFilters(int n) {
        return new DynamicTableFilter[0];
    }

    @Override
    public boolean isAllowMultipleValues(int n) {
        return true;
    }

    @Override
    public StringConverter getTitleConverter(int n) {
        return null;
    }

    @Override
    public AutoFilterTableHeaderAdapter.FilterTitleFormatter getFilterTitleFormatter(int n) {
        return null;
    }

    @Override
    public ListCellRenderer getListCellRenderer(int n) {
        return null;
    }

    @Override
    public boolean isUseTableCellRenderer(int n) {
        return false;
    }

    @Override
    public boolean isAllowCustomFilter(int n) {
        return true;
    }

    @Override
    public SingleValueFilter createSingleValueFilter(Object object) {
        return new SingleValueFilter<Object>(object);
    }

    @Override
    public MultipleValuesFilter createMultipleValuesFilter(Object[] objectArray) {
        return new MultipleValuesFilter<Object>(objectArray);
    }
}

