/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.database;

import com.jidesoft.database.CrudTableModel;
import com.jidesoft.database.DatabaseTableModel;
import com.jidesoft.database.DefaultRecord;
import com.jidesoft.database.Record;
import com.jidesoft.database.ResultSetTableModel;
import com.jidesoft.database.ResultSetTableModelCrudSupport;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CrudDatabaseTableModel
extends DatabaseTableModel
implements CrudTableModel {
    private static final long serialVersionUID = 8367704501434745273L;
    protected ResultSetTableModelCrudSupport _crudSupport;
    protected Record insertRow;
    protected volatile boolean isInInsertRow = false;

    public CrudDatabaseTableModel(Connection connection, String string) throws SQLException {
        this(connection, "*", string, true);
    }

    public CrudDatabaseTableModel(Connection connection, String string, String string2) throws SQLException {
        this(connection, string, string2, true);
    }

    public CrudDatabaseTableModel(Connection connection, String string, String string2, boolean bl) throws SQLException {
        super(connection, string, string2, bl);
    }

    @Override
    public int getRowCount() {
        return super.getRowCount() + (this.isInInsertRow ? 1 : 0);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.isInsertRow(n)) {
            return this.insertRow.getValue(this.getColumnName(n2));
        }
        return super.getValueAt(n, n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this.isInsertRow(n)) {
            this.insertRow.setValue(this.getColumnName(n2), object);
            try {
                this.insertRow(this.insertRow);
                this.isInInsertRow = false;
                this.insertRow = this.createRowRecord();
            }
            catch (Exception exception) {}
        } else {
            super.setValueAt(object, n, n2);
        }
    }

    private boolean isInsertRow(int n) {
        return this.isInInsertRow && n == this.getRowCount() - 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void insertRow(Record record) throws Exception {
        boolean bl;
        boolean bl2 = bl = record == null || Record.EMPTY == record;
        if (bl) {
            if (this.isInInsertRow) throw new IllegalStateException("No se puede insertar un registro nuevo hasta completar o borrar el anterior");
            this.insertRow = this.createRowRecord();
            this.isInInsertRow = true;
        } else {
            this._crudSupport.insertRow(record);
            this.commit();
            this.isInInsertRow = false;
        }
        this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
    }

    protected Record createRowRecord() {
        return new DefaultRecord();
    }

    @Override
    public Record readRow(int n) throws Exception {
        if (this.isInsertRow(n)) {
            return this.insertRow;
        }
        return this._crudSupport.readRow(n);
    }

    @Override
    public void updateRow(int n, Record record) throws Exception {
        if (this.isInsertRow(n)) {
            this.insertRow = record;
        } else {
            this._crudSupport.updateRow(n, record);
            this.commit();
        }
        this.fireTableRowsUpdated(n, n);
    }

    @Override
    public void deleteRow(int n) throws Exception {
        if (this.isInInsertRow && n == this.getRowCount() - 1) {
            this.isInInsertRow = false;
            this.insertRow = this.createRowRecord();
        } else {
            this._crudSupport.deleteRow(n);
            this.commit();
        }
        this.fireTableRowsDeleted(n, n);
    }

    @Override
    protected ResultSetTableModel createResultSetTableModel(ResultSet resultSet, int n) throws SQLException {
        ResultSetTableModel resultSetTableModel = super.createResultSetTableModel(resultSet, n);
        if (this._crudSupport == null) {
            this._crudSupport = new ResultSetTableModelCrudSupport(resultSetTableModel);
        } else {
            this._crudSupport.setResultSetTableModel(resultSetTableModel);
        }
        return resultSetTableModel;
    }
}

