/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dashboard;

import com.jidesoft.dashboard.Dashboard;
import com.jidesoft.dashboard.DashboardHolder;
import com.jidesoft.dashboard.Gadget;
import com.jidesoft.dashboard.GadgetComponent;
import com.jidesoft.dashboard.GadgetContainer;
import com.jidesoft.dashboard.GadgetEvent;
import com.jidesoft.dashboard.GadgetManager;
import com.jidesoft.dashboard.PlaceHolder;
import com.jidesoft.dashboard.PredefinedLayoutAdapter;
import com.jidesoft.dashboard.ResizableGadgetContainer;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideSplitPaneLayout;
import com.jidesoft.swing.PersistenceUtils;
import com.jidesoft.utils.PersistenceUtilsCallback;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DashboardPersistenceUtils {
    private static final String NODE_DASHBOARD_HOLDER = "DashboardHolder";
    private static final String NODE_DASHBOARD = "Dashboard";
    private static final String NODE_DASHBOARD_SETTINGS = "Settings";
    private static final String NODE_GADGET_CONTAINER = "GadgetContainer";
    private static final String NODE_GADGET_CONTAINER_SETTINGS = "Settings";
    private static final String NODE_GADGET = "Gadget";
    private static final String NODE_DUMMY_GADGET = "DummyGadget";
    private static final String NODE_MAXIMIZED_GADGET = "MaximizedGadget";
    private static final String ATTRIBUTE_COLUMN_RESIZABLE = "columnResizable";
    private static final String ATTRIBUTE_ROW_RESIZABLE = "rowResizable";
    private static final String ATTRIBUTE_COUNT = "count";
    private static final String ATTRIBUTE_WIDTH = "width";
    private static final String ATTRIBUTE_LAYOUT = "layout";
    private static final String ATTRIBUTE_HGAP = "hgap";
    private static final String ATTRIBUTE_VGAP = "vgap";
    private static final String ATTRIBUTE_BOX_AXIS = "boxAxis";
    private static final String ATTRIBUTE_FLOW_ALIGNMENT = "flowAlign";
    private static final String ATTRIBUTE_GRID_COLUMN = "gridColumn";
    private static final String ATTRIBUTE_GRID_ROW = "gridRow";
    private static final String ATTRIBUTE_KEY = "key";
    private static final String ATTRIBUTE_TITLE = "title";
    private static final String ATTRIBUTE_HEIGHT = "height";
    private static final String ATTRIBUTE_MAXIMIZED_COLUMN = "column";
    private static final String ATTRIBUTE_MAXIMIZED_ROW = "row";
    private static final String ATTRIBUTE_MAXIMIZED_INDEX = "index";
    private static final String ATTRIBUTE_CONSTRAINTS = "constraints";
    private static final String ATTRIBUTE_ACTIVE_DASHBOARD = "activeDashboard";

    public static void save(DashboardHolder dashboardHolder, String string) throws ParserConfigurationException, IOException {
        DashboardPersistenceUtils.save(dashboardHolder, string, PersistenceUtils.getDefaultXmlEncoding());
    }

    public static void save(DashboardHolder dashboardHolder, String string, String string2) throws ParserConfigurationException, IOException {
        DashboardPersistenceUtils.save(dashboardHolder, string, string2, null);
    }

    public static void save(DashboardHolder dashboardHolder, String string, String string2, PersistenceUtilsCallback.Save save) throws ParserConfigurationException, IOException {
        Document document = DashboardPersistenceUtils.save(dashboardHolder, save);
        PersistenceUtils.saveXMLDocumentToFile(document, string, string2);
    }

    public static void save(DashboardHolder dashboardHolder, OutputStream outputStream) throws ParserConfigurationException, IOException {
        DashboardPersistenceUtils.save(dashboardHolder, outputStream, PersistenceUtils.getDefaultXmlEncoding());
    }

    public static void save(DashboardHolder dashboardHolder, OutputStream outputStream, String string) throws ParserConfigurationException, IOException {
        DashboardPersistenceUtils.save(dashboardHolder, outputStream, string, null);
    }

    public static void save(DashboardHolder dashboardHolder, OutputStream outputStream, String string, PersistenceUtilsCallback.Save save) throws ParserConfigurationException, IOException {
        Document document = DashboardPersistenceUtils.save(dashboardHolder, save);
        PersistenceUtils.saveXMLDocumentToStream(document, outputStream, string);
    }

    public static Document save(DashboardHolder dashboardHolder, PersistenceUtilsCallback.Save save) throws ParserConfigurationException {
        String[] stringArray;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("component");
        if (dashboardHolder.getGadgetManager().getVersion() != null) {
            element.setAttribute("version", dashboardHolder.getGadgetManager().getVersion());
        }
        document.appendChild(element);
        Element element2 = document.createElement(NODE_DASHBOARD_HOLDER);
        element.appendChild(element2);
        for (String string : stringArray = dashboardHolder.getGadgetManager().getDashboards()) {
            Element element3 = document.createElement(NODE_DASHBOARD);
            element2.appendChild(element3);
            Dashboard dashboard = dashboardHolder.getGadgetManager().getDashboard(string);
            DashboardPersistenceUtils.writeElement(document, element3, dashboard, save);
        }
        element2.setAttribute(ATTRIBUTE_ACTIVE_DASHBOARD, dashboardHolder.getGadgetManager().getActiveDashboardKey());
        return document;
    }

    public static void saveDashboard(DashboardHolder dashboardHolder, Dashboard dashboard, String string) throws ParserConfigurationException, IOException {
        DashboardPersistenceUtils.saveDashboard(dashboardHolder, dashboard, string, PersistenceUtils.getDefaultXmlEncoding());
    }

    public static void saveDashboard(DashboardHolder dashboardHolder, Dashboard dashboard, OutputStream outputStream) throws ParserConfigurationException, IOException {
        DashboardPersistenceUtils.saveDashboard(dashboardHolder, dashboard, outputStream, PersistenceUtils.getDefaultXmlEncoding());
    }

    public static void saveDashboard(DashboardHolder dashboardHolder, Dashboard dashboard, String string, String string2) throws ParserConfigurationException, IOException {
        DashboardPersistenceUtils.saveDashboard(dashboardHolder, dashboard, string, string2, null);
    }

    public static void saveDashboard(DashboardHolder dashboardHolder, Dashboard dashboard, String string, String string2, PersistenceUtilsCallback.Save save) throws ParserConfigurationException, IOException {
        Document document = DashboardPersistenceUtils.saveDashboard(dashboardHolder, dashboard, save);
        PersistenceUtils.saveXMLDocumentToFile(document, string, string2);
    }

    public static void saveDashboard(DashboardHolder dashboardHolder, Dashboard dashboard, OutputStream outputStream, String string) throws ParserConfigurationException, IOException {
        DashboardPersistenceUtils.saveDashboard(dashboardHolder, dashboard, outputStream, string, null);
    }

    public static void saveDashboard(DashboardHolder dashboardHolder, Dashboard dashboard, OutputStream outputStream, String string, PersistenceUtilsCallback.Save save) throws ParserConfigurationException, IOException {
        Document document = DashboardPersistenceUtils.saveDashboard(dashboardHolder, dashboard, save);
        PersistenceUtils.saveXMLDocumentToStream(document, outputStream, string);
    }

    public static Document saveActiveDashboard(DashboardHolder dashboardHolder) throws ParserConfigurationException {
        return DashboardPersistenceUtils.saveActiveDashboard(dashboardHolder, null);
    }

    public static Document saveActiveDashboard(DashboardHolder dashboardHolder, PersistenceUtilsCallback.Save save) throws ParserConfigurationException {
        return DashboardPersistenceUtils.saveDashboard(dashboardHolder, dashboardHolder.getActiveDashboard(), save);
    }

    public static Document saveDashboard(DashboardHolder dashboardHolder, Dashboard dashboard, PersistenceUtilsCallback.Save save) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("component");
        if (dashboardHolder.getGadgetManager().getVersion() != null) {
            element.setAttribute("version", dashboardHolder.getGadgetManager().getVersion());
        }
        document.appendChild(element);
        Element element2 = document.createElement(NODE_DASHBOARD_HOLDER);
        element.appendChild(element2);
        Element element3 = document.createElement(NODE_DASHBOARD);
        element2.appendChild(element3);
        DashboardPersistenceUtils.writeElement(document, element3, dashboard, save);
        return document;
    }

    private static void writeElement(Document document, Element element, Dashboard dashboard, PersistenceUtilsCallback.Save save) {
        Object object;
        Object object2;
        Object object3;
        element.setAttribute(ATTRIBUTE_KEY, dashboard.getKey());
        element.setAttribute(ATTRIBUTE_TITLE, dashboard.getTitle());
        element.setAttribute(ATTRIBUTE_COLUMN_RESIZABLE, dashboard.isColumnResizable() ? "1" : "0");
        element.setAttribute(ATTRIBUTE_ROW_RESIZABLE, dashboard.isRowResizable() ? "1" : "0");
        PredefinedLayoutAdapter predefinedLayoutAdapter = dashboard.getLayoutAdapter();
        if (dashboard.isPredefinedLayoutSet()) {
            object3 = dashboard.getPredefinedLayout();
            if (predefinedLayoutAdapter != null) {
                element.setAttribute(ATTRIBUTE_LAYOUT, predefinedLayoutAdapter.layoutToString((LayoutManager)object3));
            }
        }
        object3 = document.createElement("Settings");
        Map<String, String> map2 = dashboard.getSettings();
        if (map2 != null) {
            Set<String> set = map2.keySet();
            for (String map3 : set) {
                object2 = document.createElement(map3);
                object2.appendChild(document.createTextNode(map2.get(map3)));
                object3.appendChild((Node)object2);
            }
        }
        element.appendChild((Node)object3);
        for (int i = 0; i < dashboard.getNormalGadgetContainer().getComponentCount(); ++i) {
            object = dashboard.getNormalGadgetContainer().getComponent(i);
            if (GadgetManager.isGadgetContainer((Component)object)) {
                Element element2 = document.createElement(NODE_GADGET_CONTAINER);
                element.appendChild(element2);
                DashboardPersistenceUtils.writeGadgetContainer(document, element2, (Container)object, save);
                continue;
            }
            if (object instanceof GadgetComponent) {
                Element element3 = document.createElement(NODE_GADGET);
                element.appendChild(element3);
                DashboardPersistenceUtils.writeGadgetComponent(document, element3, (GadgetComponent)object, save);
                if (!dashboard.isPredefinedLayoutSet()) continue;
                element3.setAttribute(ATTRIBUTE_CONSTRAINTS, predefinedLayoutAdapter == null ? "null" : predefinedLayoutAdapter.constraintsToString(dashboard.getPredefinedLayout(), dashboard.getComponentConstraints(i)));
                continue;
            }
            if (!dashboard.isPredefinedLayoutSet()) continue;
            Element element4 = document.createElement(NODE_DUMMY_GADGET);
            element.appendChild(element4);
            if (!dashboard.isPredefinedLayoutSet()) continue;
            element4.setAttribute(ATTRIBUTE_CONSTRAINTS, predefinedLayoutAdapter == null ? "null" : predefinedLayoutAdapter.constraintsToString(dashboard.getPredefinedLayout(), dashboard.getComponentConstraints(i)));
            element4.setAttribute(ATTRIBUTE_WIDTH, "" + ((Component)object).getWidth());
            element4.setAttribute(ATTRIBUTE_HEIGHT, "" + ((Component)object).getHeight());
        }
        if (dashboard.getMaximizedComponent() != null && dashboard.getMaximizedComponent() instanceof GadgetComponent) {
            Element element2 = document.createElement(NODE_MAXIMIZED_GADGET);
            if (dashboard.isPredefinedLayoutSet()) {
                element2.setAttribute(ATTRIBUTE_MAXIMIZED_INDEX, "" + dashboard.getMaximizedIndex());
                element2.setAttribute(ATTRIBUTE_CONSTRAINTS, predefinedLayoutAdapter == null ? "null" : predefinedLayoutAdapter.constraintsToString(dashboard.getPredefinedLayout(), dashboard.getMaximizedConstraints()));
            } else {
                element2.setAttribute(ATTRIBUTE_MAXIMIZED_COLUMN, "" + dashboard.getMaximizedColumn());
                element2.setAttribute(ATTRIBUTE_MAXIMIZED_ROW, "" + dashboard.getMaximizedRow());
            }
            object = (GadgetComponent)((Object)dashboard.getMaximizedComponent());
            element2.setAttribute(ATTRIBUTE_KEY, "" + object.getGadget().getKey());
            element2.setAttribute(ATTRIBUTE_WIDTH, "" + ((Component)object).getPreferredSize().width);
            element2.setAttribute(ATTRIBUTE_HEIGHT, "" + ((Component)object).getPreferredSize().height);
            Map<String, String> map = object.getSettings();
            if (map != null) {
                object2 = map.keySet();
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    Element element5 = document.createElement(string);
                    element5.appendChild(document.createTextNode(map.get(string)));
                    element2.appendChild(element5);
                }
            }
            element.appendChild(element2);
        }
        if (save != null) {
            save.save(document, element, dashboard);
        }
    }

    private static void writeGadgetContainer(Document document, Element element, Container container, PersistenceUtilsCallback.Save save) {
        Object object;
        Object object2;
        int n = 0;
        for (int i = 0; i < container.getComponentCount(); ++i) {
            object2 = container.getComponent(i);
            if (!(object2 instanceof GadgetComponent)) continue;
            object = document.createElement(NODE_GADGET);
            element.appendChild((Node)object);
            DashboardPersistenceUtils.writeGadgetComponent(document, (Element)object, (GadgetComponent)object2, save);
            ++n;
        }
        element.setAttribute(ATTRIBUTE_COUNT, "" + n);
        element.setAttribute(ATTRIBUTE_WIDTH, "" + container.getWidth());
        element.setAttribute(ATTRIBUTE_HEIGHT, "" + container.getHeight());
        if (container.getLayout() instanceof JideBoxLayout) {
            element.setAttribute(ATTRIBUTE_LAYOUT, "JideBoxLayout");
            element.setAttribute(ATTRIBUTE_BOX_AXIS, "" + ((JideBoxLayout)container.getLayout()).getAxis());
            element.setAttribute(ATTRIBUTE_VGAP, "" + ((JideBoxLayout)container.getLayout()).getGap());
        } else if (container.getLayout() instanceof FlowLayout) {
            element.setAttribute(ATTRIBUTE_LAYOUT, "FlowLayout");
            element.setAttribute(ATTRIBUTE_FLOW_ALIGNMENT, "" + ((FlowLayout)container.getLayout()).getAlignment());
            element.setAttribute(ATTRIBUTE_VGAP, "" + ((FlowLayout)container.getLayout()).getVgap());
            element.setAttribute(ATTRIBUTE_HGAP, "" + ((FlowLayout)container.getLayout()).getHgap());
        } else if (container.getLayout() instanceof GridLayout) {
            element.setAttribute(ATTRIBUTE_LAYOUT, "GridLayout");
            element.setAttribute(ATTRIBUTE_VGAP, "" + ((GridLayout)container.getLayout()).getVgap());
            element.setAttribute(ATTRIBUTE_HGAP, "" + ((GridLayout)container.getLayout()).getHgap());
            element.setAttribute(ATTRIBUTE_GRID_ROW, "" + ((GridLayout)container.getLayout()).getRows());
            element.setAttribute(ATTRIBUTE_GRID_COLUMN, "" + ((GridLayout)container.getLayout()).getColumns());
        }
        Element element2 = document.createElement("Settings");
        object2 = null;
        if (container instanceof GadgetContainer) {
            object2 = ((GadgetContainer)container).getSettings();
        } else if (container instanceof ResizableGadgetContainer) {
            object2 = ((ResizableGadgetContainer)container).getSettings();
        }
        if (object2 != null) {
            object = object2.keySet();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Element element3 = document.createElement(string);
                element3.appendChild(document.createTextNode(object2.get(string)));
                element2.appendChild(element3);
            }
        }
        element.appendChild(element2);
        if (save != null) {
            save.save(document, element, container);
        }
    }

    private static void writeGadgetComponent(Document document, Element element, GadgetComponent gadgetComponent, PersistenceUtilsCallback.Save save) {
        element.setAttribute(ATTRIBUTE_KEY, gadgetComponent.getGadget().getKey());
        element.setAttribute(ATTRIBUTE_WIDTH, "" + ((Component)((Object)gadgetComponent)).getWidth());
        element.setAttribute(ATTRIBUTE_HEIGHT, "" + ((Component)((Object)gadgetComponent)).getHeight());
        Map<String, String> map = gadgetComponent.getSettings();
        if (map != null) {
            Set<String> set = map.keySet();
            for (String string : set) {
                Element element2 = document.createElement(string);
                element2.appendChild(document.createTextNode(map.get(string)));
                element.appendChild(element2);
            }
        }
        if (save != null) {
            save.save(document, element, gadgetComponent);
        }
    }

    public static void load(DashboardHolder dashboardHolder, InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        DashboardPersistenceUtils.load(dashboardHolder, PersistenceUtils.getDocument(inputStream), true);
    }

    public static void load(DashboardHolder dashboardHolder, InputStream inputStream, boolean bl) throws ParserConfigurationException, SAXException, IOException {
        DashboardPersistenceUtils.load(dashboardHolder, PersistenceUtils.getDocument(inputStream), bl);
    }

    public static void load(DashboardHolder dashboardHolder, String string) throws ParserConfigurationException, SAXException, IOException {
        DashboardPersistenceUtils.load(dashboardHolder, PersistenceUtils.getDocument(string), true);
    }

    public static void load(DashboardHolder dashboardHolder, String string, boolean bl) throws ParserConfigurationException, SAXException, IOException {
        DashboardPersistenceUtils.load(dashboardHolder, string, bl, null);
    }

    public static void load(DashboardHolder dashboardHolder, String string, boolean bl, PersistenceUtilsCallback.Load load) throws ParserConfigurationException, SAXException, IOException {
        DashboardPersistenceUtils.load(dashboardHolder, PersistenceUtils.getDocument(string), bl);
    }

    public static void load(DashboardHolder dashboardHolder, Document document) {
        DashboardPersistenceUtils.load(dashboardHolder, document, true);
    }

    public static void load(DashboardHolder dashboardHolder, Document document, boolean bl) {
        DashboardPersistenceUtils.load(dashboardHolder, document, bl, null);
    }

    public static void load(final DashboardHolder dashboardHolder, final Document document, final boolean bl, final PersistenceUtilsCallback.Load load) {
        if (SwingUtilities.isEventDispatchThread()) {
            DashboardPersistenceUtils.internalLoad(dashboardHolder, document, bl, load);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DashboardPersistenceUtils.internalLoad(dashboardHolder, document, bl, load);
                }
            });
        }
    }

    public static void internalLoad(DashboardHolder dashboardHolder, Document document, boolean bl, PersistenceUtilsCallback.Load load) {
        Node node = document.getElementsByTagName("component").item(0);
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (!"version".equals(node2.getNodeName())) continue;
            string = node2.getNodeValue();
            break;
        }
        if (string != null) {
            dashboardHolder.getGadgetManager().setVersion(string);
        }
        if (bl) {
            dashboardHolder.getGadgetManager().removeAllDashboards();
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            if (!NODE_DASHBOARD_HOLDER.equals(node3.getNodeName())) continue;
            String string2 = null;
            NamedNodeMap namedNodeMap2 = node3.getAttributes();
            for (int j = 0; j < namedNodeMap2.getLength(); ++j) {
                Node node4 = namedNodeMap2.item(j);
                if (!ATTRIBUTE_ACTIVE_DASHBOARD.equals(node4.getNodeName())) continue;
                string2 = node4.getNodeValue();
            }
            NodeList nodeList2 = node3.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node5 = nodeList2.item(j);
                if (!NODE_DASHBOARD.equals(node5.getNodeName())) continue;
                DashboardPersistenceUtils.readDashboard(dashboardHolder, document, node5, load);
            }
            if (string2 == null) continue;
            dashboardHolder.getGadgetManager().setActiveDashboardKey(string2);
        }
    }

    private static void readDashboard(DashboardHolder dashboardHolder, Document document, Node node, PersistenceUtilsCallback.Load load) {
        LayoutManager layoutManager;
        Node node2;
        int n;
        Object object;
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            object = namedNodeMap.item(i);
            if (ATTRIBUTE_KEY.equals(object.getNodeName())) {
                string = object.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_TITLE.equals(object.getNodeName())) {
                string2 = object.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_COLUMN_RESIZABLE.equals(object.getNodeName())) {
                string3 = object.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_ROW_RESIZABLE.equals(object.getNodeName())) {
                string4 = object.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_LAYOUT.equals(object.getNodeName())) continue;
            string5 = object.getNodeValue();
        }
        Dashboard dashboard = dashboardHolder.createDashboard(string);
        dashboard.setTitle(string2);
        dashboardHolder.getGadgetManager().addDashboard(dashboard);
        dashboard.setColumnCount(0);
        dashboard.setColumnResizable(string3 == null || "1".equals(string3));
        dashboard.setRowResizable(string4 != null && "1".equals(string4));
        object = dashboard.getLayoutAdapter();
        if (string5 != null && object != null) {
            dashboard.setPredefinedLayout(object.stringToLayout(string5));
        }
        NodeList nodeList = node.getChildNodes();
        int n2 = 0;
        for (n = 0; n < nodeList.getLength(); ++n) {
            node2 = nodeList.item(n);
            if (NODE_GADGET_CONTAINER.equals(node2.getNodeName())) {
                ++n2;
                continue;
            }
            if (!"Settings".equals(node2.getNodeName())) continue;
            dashboard.setSettings(DashboardPersistenceUtils.convertNodeToMap(node2));
        }
        dashboard.setColumnCount(n2);
        n2 = 0;
        for (n = 0; n < nodeList.getLength(); ++n) {
            node2 = nodeList.item(n);
            if (NODE_GADGET_CONTAINER.equals(node2.getNodeName())) {
                DashboardPersistenceUtils.readGadgetContainer(dashboardHolder, dashboard, document, dashboard.getGadgetContainer(n2), node2, load);
                ++n2;
                continue;
            }
            if (NODE_MAXIMIZED_GADGET.equals(node2.getNodeName()) && dashboard.getMaximizedGadgetContainer() != null) {
                DashboardPersistenceUtils.readMaximizedGadget(dashboardHolder, dashboard, document, node2, load);
                continue;
            }
            if (NODE_GADGET.equals(node2.getNodeName())) {
                DashboardPersistenceUtils.readGadget(dashboardHolder, dashboard, null, document, node2, load);
                continue;
            }
            if (!NODE_DUMMY_GADGET.equals(node2.getNodeName())) continue;
            DashboardPersistenceUtils.readDummyGadget(dashboardHolder, dashboard, document, node2, load);
        }
        if (dashboard.getNormalGadgetContainer() != null && (layoutManager = dashboard.getNormalGadgetContainer().getLayout()) instanceof JideSplitPaneLayout) {
            boolean bl = ((JideSplitPaneLayout)layoutManager).isResetWhenInvalidate();
            ((JideSplitPaneLayout)layoutManager).setResetWhenInvalidate(true);
            ((JideSplitPaneLayout)layoutManager).invalidateLayout(dashboard.getNormalGadgetContainer());
            ((JideSplitPaneLayout)layoutManager).setResetWhenInvalidate(bl);
        }
        if (dashboard.getMaximizedGadgetContainer() != null && dashboard.getMaximizedGadgetContainer().getComponentCount() > 0) {
            dashboard.showMaximizedGadgetContainer();
        }
        if (load != null) {
            load.load(document, (Element)node, dashboard);
        }
    }

    private static void readMaximizedGadget(DashboardHolder dashboardHolder, Dashboard dashboard, Document document, Node node, PersistenceUtilsCallback.Load load) {
        Object object;
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            object = namedNodeMap.item(i);
            if (ATTRIBUTE_KEY.equals(object.getNodeName())) {
                string3 = object.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_WIDTH.equals(object.getNodeName())) {
                string = object.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_HEIGHT.equals(object.getNodeName())) {
                string2 = object.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_MAXIMIZED_COLUMN.equals(object.getNodeName())) {
                string5 = object.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_MAXIMIZED_ROW.equals(object.getNodeName())) {
                string4 = object.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_CONSTRAINTS.equals(object.getNodeName())) {
                string6 = object.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_MAXIMIZED_INDEX.equals(object.getNodeName())) continue;
            string7 = object.getNodeValue();
        }
        if (!(string6 != null && string7 != null || string3 != null && string4 != null && string5 != null && Integer.valueOf(string5) >= 0 && Integer.valueOf(string4) >= 0)) {
            return;
        }
        Gadget gadget = dashboardHolder.getGadgetManager().getGadget(string3);
        if (gadget != null && (object = gadget.createGadgetComponent()) != null) {
            ((Component)object).setVisible(true);
            dashboardHolder.getGadgetManager().installListeners((Component)object);
            object.setSettings(DashboardPersistenceUtils.convertNodeToMap(node));
            dashboardHolder.getGadgetManager().fireGadgetEvent(new GadgetEvent(gadget, 13203, (GadgetComponent)object));
            dashboard.getMaximizedGadgetContainer().add((Component)object);
            dashboardHolder.getGadgetManager().fireGadgetEvent(new GadgetEvent(gadget, 13201, (GadgetComponent)object));
            dashboardHolder.getGadgetManager().fireGadgetEvent(new GadgetEvent(gadget, 13205, (GadgetComponent)object));
            if (string != null && string2 != null && Integer.valueOf(string) > 0 && Integer.valueOf(string2) > 0) {
                ((Component)object).setPreferredSize(new Dimension(Integer.valueOf(string), Integer.valueOf(string2)));
            }
            if (string6 != null) {
                dashboard.setMaximizedIndex(Integer.valueOf(string7));
                dashboard.setMaximizedConstraints(dashboard.getLayoutAdapter().stringToConstraints(dashboard.getNormalGadgetContainer().getLayout(), "" + string6));
            } else {
                dashboard.setMaximizedColumn(Integer.valueOf(string5));
                dashboard.setMaximizedRow(Integer.valueOf(string4));
            }
            dashboard.setMaximizedComponent((Component)object);
        }
        if (load != null) {
            load.load(document, (Element)node, dashboard);
        }
    }

    private static void readGadgetContainer(DashboardHolder dashboardHolder, Dashboard dashboard, Document document, Container container, Node node, PersistenceUtilsCallback.Load load) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (ATTRIBUTE_WIDTH.equals(node2.getNodeName())) {
                string = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_HEIGHT.equals(node2.getNodeName())) {
                string2 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_LAYOUT.equals(node2.getNodeName())) {
                string3 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_HGAP.equals(node2.getNodeName())) {
                string4 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_VGAP.equals(node2.getNodeName())) {
                string5 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_GRID_ROW.equals(node2.getNodeName())) {
                string6 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_GRID_COLUMN.equals(node2.getNodeName())) {
                string7 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_FLOW_ALIGNMENT.equals(node2.getNodeName())) {
                string8 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_BOX_AXIS.equals(node2.getNodeName())) {
                string9 = node2.getNodeValue();
                continue;
            }
            if (!"Settings".equals(node2.getNodeName())) continue;
            if (container instanceof GadgetContainer) {
                ((GadgetContainer)container).setSettings(DashboardPersistenceUtils.convertNodeToMap(node2));
                continue;
            }
            if (!(container instanceof ResizableGadgetContainer)) continue;
            ((ResizableGadgetContainer)container).setSettings(DashboardPersistenceUtils.convertNodeToMap(node2));
        }
        if (string != null && string2 != null && Integer.valueOf(string) > 0 && Integer.valueOf(string2) > 0) {
            container.setPreferredSize(new Dimension(Integer.valueOf(string), Integer.valueOf(string2)));
        }
        NodeList nodeList = node.getChildNodes();
        container.removeAll();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            if (!NODE_GADGET.equals(node3.getNodeName())) continue;
            DashboardPersistenceUtils.readGadget(dashboardHolder, dashboard, container, document, node3, load);
        }
        if (string3 != null && !dashboard.isRowResizable()) {
            if ("JideBoxLayout".equals(string3)) {
                if (string9 != null && string5 != null) {
                    container.setLayout(new JideBoxLayout(container, Integer.valueOf(string9), Integer.valueOf(string5)));
                }
            } else if ("FlowLayout".equals(string3)) {
                if (string8 != null && string4 != null && string5 != null) {
                    container.setLayout(new FlowLayout(Integer.valueOf(string8), Integer.valueOf(string4), Integer.valueOf(string5)));
                }
            } else if ("GridLayout".equals(string3) && string6 != null && string7 != null && string4 != null && string5 != null) {
                container.setLayout(new GridLayout(Integer.valueOf(string6), Integer.valueOf(string7), Integer.valueOf(string4), Integer.valueOf(string5)));
            }
        }
        if (container.getLayout() instanceof JideBoxLayout) {
            container.add(Box.createGlue(), "vary");
        }
        if (load != null) {
            load.load(document, (Element)node, dashboard);
        }
    }

    private static Map<String, String> convertNodeToMap(Node node) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getFirstChild() == null) continue;
            hashMap.put(node2.getNodeName(), node2.getFirstChild().getNodeValue());
        }
        return hashMap;
    }

    private static void readGadget(DashboardHolder dashboardHolder, Dashboard dashboard, Container container, Document document, Node node, PersistenceUtilsCallback.Load load) {
        Object object;
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            object = namedNodeMap.item(i);
            if (ATTRIBUTE_KEY.equals(object.getNodeName())) {
                string = object.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_WIDTH.equals(object.getNodeName())) {
                string2 = object.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_HEIGHT.equals(object.getNodeName())) {
                string3 = object.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_CONSTRAINTS.equals(object.getNodeName())) continue;
            string4 = object.getNodeValue();
        }
        Gadget gadget = dashboardHolder.getGadgetManager().getGadget(string);
        if (gadget != null && (object = gadget.createGadgetComponent()) instanceof Component) {
            ((Component)object).setVisible(true);
            dashboardHolder.getGadgetManager().installListeners((Component)object);
            object.setSettings(DashboardPersistenceUtils.convertNodeToMap(node));
            dashboardHolder.getGadgetManager().fireGadgetEvent(new GadgetEvent(gadget, 13203, (GadgetComponent)object));
            if (string2 != null && string3 != null && Integer.valueOf(string2) > 0 && Integer.valueOf(string3) > 0) {
                ((Component)object).setPreferredSize(new Dimension(Integer.valueOf(string2), Integer.valueOf(string3)));
            }
            if (container != null) {
                container.add((Component)object);
                dashboardHolder.getGadgetManager().fireGadgetEvent(new GadgetEvent(gadget, 13201, (GadgetComponent)object));
                dashboardHolder.getGadgetManager().fireGadgetEvent(new GadgetEvent(gadget, 13206, (GadgetComponent)object));
            } else if (dashboard.getLayoutAdapter() != null) {
                Object object2 = dashboard.getLayoutAdapter().stringToConstraints(dashboard.getNormalGadgetContainer().getLayout(), "" + string4);
                dashboard.getNormalGadgetContainer().add((Component)object, object2);
                dashboardHolder.getGadgetManager().fireGadgetEvent(new GadgetEvent(gadget, 13201, (GadgetComponent)object));
                dashboardHolder.getGadgetManager().fireGadgetEvent(new GadgetEvent(gadget, 13206, (GadgetComponent)object));
            }
        }
        if (load != null) {
            load.load(document, (Element)node, dashboard);
        }
    }

    private static void readDummyGadget(DashboardHolder dashboardHolder, Dashboard dashboard, Document document, Node node, PersistenceUtilsCallback.Load load) {
        Object object;
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = null;
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            object = namedNodeMap.item(i);
            if (ATTRIBUTE_CONSTRAINTS.equals(object.getNodeName())) {
                string = object.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_WIDTH.equals(object.getNodeName())) {
                string2 = object.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_HEIGHT.equals(object.getNodeName())) continue;
            string3 = object.getNodeValue();
        }
        PlaceHolder placeHolder = dashboard.createDefaultPlaceHolder();
        if (placeHolder instanceof Component && dashboard.getLayoutAdapter() != null) {
            ((Component)((Object)placeHolder)).setVisible(true);
            object = dashboard.getLayoutAdapter().stringToConstraints(dashboard.getNormalGadgetContainer().getLayout(), "" + string);
            dashboard.getNormalGadgetContainer().add((Component)((Object)placeHolder), object);
            if (string2 != null && string3 != null && Integer.valueOf(string2) > 0 && Integer.valueOf(string3) > 0) {
                ((Component)((Object)placeHolder)).setPreferredSize(new Dimension(Integer.valueOf(string2), Integer.valueOf(string3)));
            }
        }
        if (load != null) {
            load.load(document, (Element)node, dashboard);
        }
    }

    public static String getVersion(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        return DashboardPersistenceUtils.getVersion(PersistenceUtils.getDocument(inputStream));
    }

    public static String getVersion(String string) throws ParserConfigurationException, SAXException, IOException {
        return DashboardPersistenceUtils.getVersion(PersistenceUtils.getDocument(string));
    }

    public static String getVersion(Document document) {
        return PersistenceUtils.getVersion(document);
    }
}

