/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.AbstractComboBox;
import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.combobox.TableChooserPanel;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableModel;

public class TableComboBox
extends AbstractComboBox {
    protected int _maximumRowCount = 8;
    private TableModel _tableModel;
    private int _valueColumnIndex = 0;

    public TableComboBox() {
        this(null, String.class);
    }

    public TableComboBox(TableModel tableModel) {
        this(tableModel, String.class);
    }

    public TableComboBox(TableModel tableModel, Class<?> clazz) {
        this(tableModel, clazz, 0);
    }

    public TableComboBox(TableModel tableModel, int n) {
        this(tableModel, String.class, n);
    }

    public TableComboBox(TableModel tableModel, Class<?> clazz, int n) {
        super(n);
        this.setType(clazz);
        this._tableModel = tableModel;
        this.initComponent(new DefaultComboBoxModel(){
            private static final long serialVersionUID = 3765916115399137049L;

            @Override
            public int getSize() {
                return TableComboBox.this._tableModel.getRowCount();
            }

            @Override
            public Object getElementAt(int n) {
                return TableComboBox.this._tableModel.getValueAt(n, TableComboBox.this.getValueColumnIndex());
            }
        });
    }

    @Override
    public AbstractComboBox.EditorComponent createEditorComponent() {
        if (this.isEditable()) {
            return new TableEditorComponent(this.getType());
        }
        return new TableRendererComponent(this.getType());
    }

    @Override
    public PopupPanel createPopupComponent() {
        TableChooserPanel tableChooserPanel = this.createTableChooserPanel(this._tableModel, this.getType());
        tableChooserPanel.setResizable(true);
        tableChooserPanel.setResizableCorners(16);
        tableChooserPanel.setMaximumRowCount(this.getMaximumRowCount());
        tableChooserPanel.setValueColumnIndex(this.getValueColumnIndex());
        tableChooserPanel.setAutoSelectionEnabled(this.getPopupType() != 1);
        return tableChooserPanel;
    }

    @Override
    public void setPopupType(int n) {
        super.setPopupType(n);
        if (this.getPopupPanel() instanceof TableChooserPanel) {
            ((TableChooserPanel)this.getPopupPanel()).setAutoSelectionEnabled(this.getPopupType() != 1);
        }
    }

    @Override
    protected List<KeyStroke> getDelegateKeyStrokes() {
        List<KeyStroke> list = super.getDelegateKeyStrokes();
        list.remove(KeyStroke.getKeyStroke(37, 0));
        list.remove(KeyStroke.getKeyStroke(39, 0));
        return list;
    }

    protected JTable createTable(TableModel tableModel) {
        return null;
    }

    protected void setupTable(JTable jTable) {
        Font font = this.getFont();
        if (font != null && !(font instanceof UIResource)) {
            jTable.setFont(font);
        }
    }

    protected TableChooserPanel createTableChooserPanel(TableModel tableModel, Class<?> clazz) {
        return new TableChooserPanel(tableModel, clazz){

            @Override
            protected JTable createTable(TableModel tableModel) {
                JTable jTable = TableComboBox.this.createTable(tableModel);
                if (jTable == null) {
                    return super.createTable(tableModel);
                }
                return jTable;
            }

            @Override
            protected void setupTable(final JTable jTable) {
                super.setupTable(jTable);
                jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        int n;
                        if (!listSelectionEvent.getValueIsAdjusting() && !Boolean.TRUE.equals(jTable.getClientProperty("PopupPanel.selectedByMouseRollover")) && (n = jTable.getSelectedRow()) != -1) {
                            Object object = jTable.getModel().getValueAt(n, this.getValueColumnIndex());
                            if (TableComboBox.this.getEditor().getItem() != object) {
                                this.setSelectedObject(object, false);
                                TableComboBox.this.getEditor().setItem(object);
                                TableComboBox.this.getEditor().selectAll();
                            }
                        }
                    }
                });
                TableComboBox.this.setupTable(jTable);
            }
        };
    }

    private boolean compareNull(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    private void toggleValue(AbstractComboBox.EditorComponent editorComponent, int n) {
        block19: {
            boolean bl;
            block20: {
                if (this.dataModel.getSize() == 0) {
                    return;
                }
                boolean bl2 = bl = this.getClientProperty("AbstractComboBox.isTableCellEditor") != null;
                if (n != 40) break block20;
                if (editorComponent.getItem() == null) {
                    if (bl) {
                        editorComponent.setItem(this.dataModel.getElementAt(0));
                    } else {
                        this.setSelectedItem(this.dataModel.getElementAt(0));
                    }
                }
                for (int i = 0; i < this.dataModel.getSize(); ++i) {
                    Object e = this.dataModel.getElementAt(i);
                    if (!this.compareNull(e, editorComponent.getItem())) continue;
                    if (i < this.dataModel.getSize() - 1) {
                        if (bl) {
                            editorComponent.setItem(this.dataModel.getElementAt(i + 1));
                        } else {
                            this.setSelectedItem(this.dataModel.getElementAt(i + 1));
                        }
                    } else if (bl) {
                        editorComponent.setItem(this.dataModel.getElementAt(0));
                    } else {
                        this.setSelectedItem(this.dataModel.getElementAt(0));
                    }
                    break block19;
                }
                break block19;
            }
            if (n != 38) break block19;
            if (editorComponent.getItem() == null) {
                editorComponent.setItem(this.dataModel.getElementAt(this.dataModel.getSize() - 1));
            }
            for (int i = 0; i < this.dataModel.getSize(); ++i) {
                Object e = this.dataModel.getElementAt(i);
                if (!this.compareNull(e, editorComponent.getItem())) continue;
                if (i > 0) {
                    if (bl) {
                        editorComponent.setItem(this.dataModel.getElementAt(i - 1));
                    } else {
                        this.setSelectedItem(this.dataModel.getElementAt(i - 1));
                    }
                } else if (bl) {
                    editorComponent.setItem(this.dataModel.getElementAt(this.dataModel.getSize() - 1));
                } else {
                    this.setSelectedItem(this.dataModel.getElementAt(this.dataModel.getSize() - 1));
                }
                break;
            }
        }
    }

    public void setMaximumRowCount(int n) {
        int n2 = this._maximumRowCount;
        if (n2 != n) {
            this._maximumRowCount = n;
            this.firePropertyChange("maximumRowCount", n2, this._maximumRowCount);
        }
    }

    public int getMaximumRowCount() {
        return this._maximumRowCount;
    }

    public void setSelectedIndex(int n) {
        int n2 = this.dataModel.getSize();
        if (n == -1) {
            this.setSelectedItem(null);
        } else {
            if (n < -1 || n >= n2) {
                throw new IllegalArgumentException("setSelectedIndex: " + n + " out of bounds");
            }
            this.setSelectedItem(this.dataModel.getElementAt(n));
        }
    }

    public int getSelectedIndex() {
        Object object = this.dataModel.getSelectedItem();
        int n = this.dataModel.getSize();
        for (int i = 0; i < n; ++i) {
            Object e = this.dataModel.getElementAt(i);
            if (!JideSwingUtilities.equals(e, object)) continue;
            return i;
        }
        return -1;
    }

    public JTable getTable() {
        if (this.getPopupPanel() == null && !this.isPopupVisible() && this.isShowing()) {
            if (this.getPopupType() == 0) {
                this.showPopupPanelAsPopup(false);
            } else {
                this.showPopup();
            }
        }
        if (this.getPopupPanel() != null && this.getPopupPanel() instanceof TableChooserPanel) {
            return ((TableChooserPanel)this.getPopupPanel()).getTable();
        }
        return null;
    }

    @Override
    protected JComponent getDelegateTarget() {
        if (this.getPopupPanel() != null && this.getPopupPanel() instanceof TableChooserPanel) {
            return ((TableChooserPanel)this.getPopupPanel()).getTable();
        }
        return null;
    }

    public void addItem(Object object) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).addElement(object);
    }

    public void insertItemAt(Object object, int n) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).insertElementAt(object, n);
    }

    public void removeItem(Object object) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).removeElement(object);
    }

    public void removeItemAt(int n) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).removeElementAt(n);
    }

    public void removeAllItems() {
        this.checkMutableComboBoxModel();
        MutableComboBoxModel mutableComboBoxModel = (MutableComboBoxModel)this.dataModel;
        int n = mutableComboBoxModel.getSize();
        if (mutableComboBoxModel instanceof DefaultComboBoxModel) {
            ((DefaultComboBoxModel)mutableComboBoxModel).removeAllElements();
        } else {
            for (int i = 0; i < n; ++i) {
                Object e = mutableComboBoxModel.getElementAt(0);
                mutableComboBoxModel.removeElement(e);
            }
        }
        this.selectedItemReminder = null;
        this.getEditor().setItem(null);
    }

    void checkMutableComboBoxModel() {
        if (!(this.dataModel instanceof MutableComboBoxModel)) {
            throw new RuntimeException("Cannot use this method with a non-Mutable data model.");
        }
    }

    public void setValueColumnIndex(int n) {
        int n2 = this._valueColumnIndex;
        if (n2 != n) {
            this._valueColumnIndex = n;
            this.firePropertyChange("valueColumnIndex", n2, this._valueColumnIndex);
        }
    }

    public int getValueColumnIndex() {
        return this._valueColumnIndex;
    }

    public TableModel getTableModel() {
        return this._tableModel;
    }

    public void setTableModel(TableModel tableModel) {
        JTable jTable;
        this._tableModel = tableModel;
        if (this.getPopupPanel() != null && this.getPopupPanel() instanceof TableChooserPanel && (jTable = ((TableChooserPanel)this.getPopupPanel()).getTable()) != null) {
            jTable.setModel(this.getTableModel());
        }
    }

    class TableRendererComponent
    extends AbstractComboBox.DefaultRendererComponent {
        public TableRendererComponent(Class<?> clazz) {
            super(clazz);
        }

        @Override
        protected void registerKeys(JComponent jComponent) {
            super.registerKeys(jComponent);
            AbstractAction abstractAction = new AbstractAction(){
                private static final long serialVersionUID = 8365865243650140794L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableComboBox.this.toggleValue(TableRendererComponent.this, 38);
                }
            };
            TableComboBox.this.registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(38, 0), 0);
            TableComboBox.this.registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(224, 0), 0);
            AbstractAction abstractAction2 = new AbstractAction(){
                private static final long serialVersionUID = 1984904069969983459L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableComboBox.this.toggleValue(TableRendererComponent.this, 40);
                }
            };
            TableComboBox.this.registerKeyboardAction(abstractAction2, KeyStroke.getKeyStroke(40, 0), 0);
            TableComboBox.this.registerKeyboardAction(abstractAction2, KeyStroke.getKeyStroke(225, 0), 0);
        }
    }

    class TableEditorComponent
    extends AbstractComboBox.DefaultTextFieldEditorComponent {
        public TableEditorComponent(Class<?> clazz) {
            super(clazz);
            this._textField.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (TableEditorComponent.this.isEnabled() && TableComboBox.this.isButtonVisible() && mouseEvent.getClickCount() == 2 && TableComboBox.this.isToggleValueOnDoubleClick()) {
                        TableComboBox.this.toggleValue(TableEditorComponent.this, 40);
                    }
                }
            });
        }

        @Override
        protected void registerKeys(JComponent jComponent) {
            super.registerKeys(jComponent);
            AbstractAction abstractAction = new AbstractAction(){
                private static final long serialVersionUID = -7569782152559501290L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (TableEditorComponent.this.isEditable() && !TableComboBox.this.isPopupVisible()) {
                        TableComboBox.this.showPopup();
                    } else {
                        TableComboBox.this.toggleValue(TableEditorComponent.this, 38);
                    }
                }
            };
            jComponent.registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(38, 0), 0);
            jComponent.registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(224, 0), 0);
            AbstractAction abstractAction2 = new AbstractAction(){
                private static final long serialVersionUID = 7795924952174008707L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (TableEditorComponent.this.isEditable() && !TableComboBox.this.isPopupVisible()) {
                        TableComboBox.this.showPopup();
                    } else {
                        TableComboBox.this.toggleValue(TableEditorComponent.this, 40);
                    }
                }
            };
            jComponent.registerKeyboardAction(abstractAction2, KeyStroke.getKeyStroke(40, 0), 0);
            jComponent.registerKeyboardAction(abstractAction2, KeyStroke.getKeyStroke(225, 0), 0);
        }
    }
}

