/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.CalendarViewer;
import com.jidesoft.combobox.DateModel;
import com.jidesoft.combobox.DateModelEvent;
import com.jidesoft.combobox.DateModelListener;
import com.jidesoft.combobox.DateResource;
import com.jidesoft.combobox.DateSelectionEvent;
import com.jidesoft.combobox.DateSelectionModel;
import com.jidesoft.combobox.DefaultDateModel;
import com.jidesoft.combobox.DefaultDateSelectionModel;
import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.combobox.RetargetMouseListener;
import com.jidesoft.combobox.RetargetMouseMotionListener;
import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.icons.JideIconsFactory;
import com.jidesoft.icons.MaskFilter;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.spinner.DateSpinner;
import com.jidesoft.spinner.SpinnerWheelSupport;
import com.jidesoft.swing.DelegateAction;
import com.jidesoft.swing.JideBorderLayout;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.NullJideButton;
import com.jidesoft.swing.NullLabel;
import com.jidesoft.swing.NullPanel;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.JTextComponent;

public class DateChooserPanel
extends PopupPanel
implements ActionListener,
ComponentListener,
MouseListener,
MouseWheelListener,
DateModelListener {
    private Border _border = BorderFactory.createEmptyBorder(6, 6, 6, 6);
    private Color _monthyearBackground = UIDefaultsLookup.getColor("InternalFrame.activeTitleBackground");
    private Color _monthyearForeground = UIDefaultsLookup.getColor("InternalFrame.activeTitleForeground");
    private Border _monthyearBorder = BorderFactory.createEmptyBorder(4, 4, 4, 4);
    private Border _dayHeaderBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, UIDefaultsLookup.getColor("TextField.foreground"));
    private Border _buttonsBorder = BorderFactory.createEmptyBorder(4, 4, 4, 4);
    private Color _inactiveDateColor;
    private Color _selectedDateForeground;
    private Color _selectedDateBackground;
    private int _horizontalGap = 5;
    protected int _verticalGap = 1;
    protected int _cellWidth = 28;
    protected int _cellHeight = 16;
    protected int _cellWeekOfYearWidth = 28;
    protected int _cellWeekOfYearHeight = 16;
    protected Border _cellBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    protected Border _todayBorder = BorderFactory.createLineBorder(Color.RED, 1);
    protected int _labelAlignment = 0;
    private boolean _spinnerVisible = false;
    private SimpleDateFormat _monthFormatter;
    private SimpleDateFormat _yearFormatter;
    private SimpleDateFormat _weekFormatter;
    private SimpleDateFormat _weekOfYearFormatter;
    private int _todayYear;
    private int _todayMonth;
    private int _todayDay;
    private int _selectedYear;
    private int _selectedMonth;
    private int _selectedDay;
    private int _selectedHour;
    private int _selectedMinute;
    private int _selectedSecond;
    private int _selectedMillisecond;
    protected Map<Component, Date> _dayMap = new HashMap<Component, Date>();
    private Map<Date, Boolean> _toggleSelectionMap;
    private Calendar _displayedCalendar;
    private Calendar _todayCalendar;
    private Calendar _selectedCalendar;
    private AbstractButton _nextButton;
    private AbstractButton _prevButton;
    private AbstractButton _nextYearButton;
    private AbstractButton _prevYearButton;
    private AbstractButton _todayButton;
    private AbstractButton _noneButton;
    private AbstractButton _okButton;
    private boolean _showYearButtons = true;
    private JComponent _monthLabel;
    private JComponent _weekOfYearPanel;
    private JComponent _yearLabel;
    private JComponent _yearSpinner;
    private JPopupMenu _monthMenu;
    public static final String VIEWONLY_PROPERTY = "viewonly";
    public static final String PROPERTY_VIEWONLY = "viewonly";
    private JComponent[] _dayLabels = new JComponent[42];
    private JComponent[] _weekLabel = new JComponent[7];
    private boolean shortenLabels = false;
    private JComponent[] _weekOfYearLabel = new JComponent[6];
    private JPanel _titlePanel;
    private JPanel _monthyearPanel;
    private SpinnerModel _yearModel;
    private boolean _timeDisplayed = false;
    private boolean _showWeekNumbers = true;
    private boolean _showTodayButton = true;
    private boolean _showShortWeekLabels = true;
    private boolean _alwaysShowShortWeekLabels = false;
    private boolean _showNoneButton = true;
    private boolean _showOKButton = false;
    private boolean _showOKButtonSet = false;
    private boolean _showPreviousButton = true;
    private boolean _showNextButton = true;
    private boolean _showPreviousMonthDays = true;
    private boolean _showNextMonthDays = true;
    private boolean _showPreviousYearButton = true;
    private boolean _showNextYearButton = true;
    private boolean _showYearSpinner = true;
    private boolean _showMonthMenu = true;
    private boolean _viewOnly;
    protected ButtonPanel _buttonPanel;
    private int _firstDayOfWeek = -1;
    private DateModel _dateModel;
    public static int NAVIGATION_BUTTON_HEIGHT = 18;
    public static int NAVIGATION_BUTTON_WIDTH = 20;
    public ItemListener _itemListener;
    private MouseListener _yearLabelListener;
    private boolean _inited = false;
    private DateSpinner _timeSpinner;
    private boolean _todayHighlighted = true;
    private boolean _lastRowEmpty;
    private boolean _vetoSendSpinnerEvent;
    public static final String PROPERTY_DISPLAY_MONTH = "displayMonth";
    public static final String PROPERTY_SHOW_NONE_BUTTON = "showNoneButton";
    public static final String PROPERTY_SHOW_OK_BUTTON = "showOKButton";
    public static final String PROPERTY_SHOW_TODAY_BUTTON = "showTodayButton";
    public static final String PROPERTY_SHOW_WEEK_NUMBERS = "showWeekNumbers";
    public static final String PROPERTY_SHOW_PREVIOUS_BUTTON = "showPreviousButton";
    public static final String PROPERTY_SHOW_NEXT_BUTTON = "showNextButton";
    public static final String PROPERTY_SHOW_PREVIOUS_YEAR_BUTTON = "showPreviousYearButton";
    public static final String PROPERTY_SHOW_NEXT_YEAR_BUTTON = "showNextYearButton";
    public static final String PROPERTY_SHOW_YEAR_BUTTONS = "showYearButtons";
    public static final String PROPERTY_SHOW_PREVIOUS_MONTH_DAYS = "showPreviousMonthDays";
    public static final String PROPERTY_SHOW_NEXT_MONTH_DAYS = "showNextMonthDays";
    public static final String PROPERTY_TODAY_HIGHLIGHTED = "todayHighlighted";
    protected RetargetMouseMotionListener _retargetMouseMotionListener;
    protected RetargetMouseListener _retargetMouseListener;
    private Component _buttonContainerPanel;
    private boolean _toggleMode;
    private boolean _selectDateOnSameMonth = true;
    private boolean _selectAllDatesOnToggleMode = true;
    private Date _anchorDate;
    private Date _leadDate;
    private DateSelectionModel _selectionModel;
    private int _displayIndex;
    private CalendarViewer _calendarViewer;

    public DateChooserPanel() {
        this(new DefaultDateModel());
    }

    public DateChooserPanel(boolean bl) {
        this(new DefaultDateModel(), bl, true, true);
    }

    public DateChooserPanel(boolean bl, boolean bl2) {
        this(new DefaultDateModel(), bl, bl2, true);
    }

    public DateChooserPanel(boolean bl, boolean bl2, boolean bl3) {
        this(new DefaultDateModel(), bl, bl2, bl3);
    }

    public DateChooserPanel(DateModel dateModel) {
        this(dateModel, true, true, true);
    }

    public DateChooserPanel(DateModel dateModel, Locale locale) {
        this(dateModel, true, true, true, locale);
    }

    public DateChooserPanel(DateModel dateModel, boolean bl) {
        this(dateModel, bl, true, true);
    }

    public DateChooserPanel(DateModel dateModel, boolean bl, boolean bl2) {
        this(dateModel, bl, bl2, true);
    }

    public DateChooserPanel(DateModel dateModel, boolean bl, boolean bl2, boolean bl3) {
        this(dateModel, bl, bl2, bl3, Locale.getDefault());
    }

    public DateChooserPanel(DateModel dateModel, boolean bl, boolean bl2, boolean bl3, Locale locale) {
        this(dateModel, bl, bl2, bl3, null, locale);
    }

    public DateChooserPanel(DateModel dateModel, boolean bl, boolean bl2, boolean bl3, String string, Locale locale) {
        Color color = UIDefaultsLookup.getColor("TextField.inactiveForeground");
        Color color2 = UIDefaultsLookup.getColor("TextField.selectionForeground");
        Color color3 = UIDefaultsLookup.getColor("TextField.selectionBackground");
        this._inactiveDateColor = new Color(color != null ? color.getRGB() : Color.gray.getRGB());
        this._selectedDateForeground = new Color(color2 != null ? color2.getRGB() : Color.white.getRGB());
        this._selectedDateBackground = new Color(color3 != null ? color3.getRGB() : Color.blue.getRGB());
        this.setDateModel(dateModel);
        this._showTodayButton = bl;
        this._showWeekNumbers = bl3;
        this._showNoneButton = bl2;
        if (string != null) {
            dateModel.setTimeFormat(string);
            this._timeDisplayed = true;
        } else {
            this._timeDisplayed = false;
        }
        this._retargetMouseMotionListener = new RetargetMouseMotionListener(this);
        this._retargetMouseListener = new RetargetMouseListener(this);
        this.setSelectionModel(new DefaultDateSelectionModel());
        this.setLocale(locale);
        this.initDateFormat(locale);
        this.initComponents();
        this.initCalendar();
        this._itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    Object object = DateChooserPanel.this.getSelectedObject();
                    if (object instanceof Calendar) {
                        DateChooserPanel.this._selectedCalendar = (Calendar)object;
                        DateChooserPanel.this.changeSelectedCalendar();
                        DateChooserPanel.this.setDisplayedMonth(DateChooserPanel.this.getSelectedYear(), DateChooserPanel.this.getSelectedMonth());
                    } else if (object instanceof Date) {
                        DateChooserPanel.this._selectedCalendar = DateChooserPanel.this.createCalendarInstance();
                        DateChooserPanel.this._selectedCalendar.setTime((Date)object);
                        DateChooserPanel.this.changeSelectedCalendar();
                        DateChooserPanel.this.setDisplayedMonth(DateChooserPanel.this.getSelectedYear(), DateChooserPanel.this.getSelectedMonth());
                    } else {
                        DateChooserPanel.this._selectedCalendar = null;
                    }
                    DateChooserPanel.this.updateCalendar();
                }
            }
        };
        this.addItemListener(this._itemListener);
        this.addComponentListener(this);
        this.addMouseWheelListener(this);
        MouseInputListener mouseInputListener = new MouseInputListener(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (!DateChooserPanel.this.isViewOnly() && DateChooserPanel.this._anchorDate != null && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    Serializable serializable;
                    Cloneable cloneable;
                    Component component = DateChooserPanel.this.findComponentAt(mouseEvent.getX(), mouseEvent.getY());
                    DateChooserPanel dateChooserPanel = null;
                    if (DateChooserPanel.this._dayMap.containsKey(component)) {
                        dateChooserPanel = DateChooserPanel.this;
                    }
                    if (component == null && DateChooserPanel.this.getCalendarViewer() != null && mouseEvent.getSource() instanceof Component) {
                        cloneable = mouseEvent.getPoint();
                        SwingUtilities.convertPointToScreen((Point)cloneable, (Component)mouseEvent.getSource());
                        SwingUtilities.convertPointFromScreen((Point)cloneable, DateChooserPanel.this.getCalendarViewer());
                        component = DateChooserPanel.this.getCalendarViewer().findComponentAt((Point)cloneable);
                        if (component != null && (serializable = SwingUtilities.getAncestorOfClass(DateChooserPanel.class, component)) instanceof DateChooserPanel) {
                            dateChooserPanel = (DateChooserPanel)serializable;
                            if (!dateChooserPanel._dayMap.containsKey(component)) {
                                dateChooserPanel = null;
                            }
                        }
                    }
                    if (dateChooserPanel != null) {
                        cloneable = dateChooserPanel._dayMap.get(component);
                        serializable = DateChooserPanel.this.createCalendarInstance();
                        serializable.setTime((Date)cloneable);
                        if (DateChooserPanel.this.isValidDate(serializable)) {
                            if (!DateChooserPanel.this.shouldKeepCurrentSelection(mouseEvent)) {
                                dateChooserPanel.getSelectionModel().clearSelection();
                                if (DateChooserPanel.this.getCalendarViewer() != null) {
                                    for (DateChooserPanel dateChooserPanel2 : DateChooserPanel.this.getCalendarViewer().getDateChooserPanels()) {
                                        if (dateChooserPanel2 == dateChooserPanel) continue;
                                        dateChooserPanel2.getSelectionModel().clearSelection();
                                        dateChooserPanel2.updateCalendar();
                                    }
                                }
                            } else {
                                dateChooserPanel.getSelectionModel().removeSelectionInterval(DateChooserPanel.this.getAnchorDate(), DateChooserPanel.this.getLeadDate());
                                if (DateChooserPanel.this.getCalendarViewer() != null) {
                                    for (DateChooserPanel dateChooserPanel2 : DateChooserPanel.this.getCalendarViewer().getDateChooserPanels()) {
                                        if (dateChooserPanel2 == dateChooserPanel) continue;
                                        dateChooserPanel2.getSelectionModel().removeSelectionInterval(DateChooserPanel.this.getAnchorDate(), DateChooserPanel.this.getLeadDate());
                                        dateChooserPanel2.updateCalendar();
                                    }
                                }
                            }
                            dateChooserPanel.setLeadDate((Date)cloneable, true);
                            dateChooserPanel.getSelectionModel().addSelectionInterval(DateChooserPanel.this.getAnchorDate(), DateChooserPanel.this.getLeadDate());
                            if (DateChooserPanel.this.getCalendarViewer() != null) {
                                for (DateChooserPanel dateChooserPanel2 : DateChooserPanel.this.getCalendarViewer().getDateChooserPanels()) {
                                    if (dateChooserPanel2 == dateChooserPanel) continue;
                                    dateChooserPanel2.getSelectionModel().addSelectionInterval(DateChooserPanel.this.getAnchorDate(), DateChooserPanel.this.getLeadDate());
                                    dateChooserPanel2.updateCalendar();
                                }
                            }
                            dateChooserPanel.updateCalendar();
                        }
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    return;
                }
                Component component = DateChooserPanel.this.findComponentAt(mouseEvent.getX(), mouseEvent.getY());
                if (DateChooserPanel.this._dayMap.containsKey(component)) {
                    DateChooserPanel.this.setAnchorDate(DateChooserPanel.this._dayMap.get(component), true);
                    DateChooserPanel.this.setLeadDate(DateChooserPanel.this.getAnchorDate(), true);
                    Calendar calendar = DateChooserPanel.this.createCalendarInstance();
                    calendar.setTime(DateChooserPanel.this.getAnchorDate());
                    if (!DateChooserPanel.this.isValidDate(calendar)) {
                        DateChooserPanel.this.setAnchorDate(null, true);
                        DateChooserPanel.this.setLeadDate(null, true);
                        return;
                    }
                    DateChooserPanel.this.getSelectionModel().setValueIsAdjusting(true);
                    if (!DateChooserPanel.this.shouldKeepCurrentSelection(mouseEvent) && !DateChooserPanel.this.isToggleMode()) {
                        DateChooserPanel.this.getSelectionModel().clearSelection();
                    }
                    if (DateChooserPanel.this.isToggleMode()) {
                        DateChooserPanel.this.cacheCurrentSelection();
                        if (DateChooserPanel.this.getCalendarViewer() != null) {
                            for (DateChooserPanel dateChooserPanel : DateChooserPanel.this.getCalendarViewer().getDateChooserPanels()) {
                                if (dateChooserPanel == DateChooserPanel.this) continue;
                                dateChooserPanel.cacheCurrentSelection();
                            }
                        }
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                DateChooserPanel.this.getSelectionModel().setValueIsAdjusting(false);
                DateChooserPanel.this.setAnchorDate(null, true);
                DateChooserPanel.this.setLeadDate(null, true);
                DateChooserPanel.this.clearCurrentSelectionCache();
                if (DateChooserPanel.this.getCalendarViewer() != null) {
                    for (DateChooserPanel dateChooserPanel : DateChooserPanel.this.getCalendarViewer().getDateChooserPanels()) {
                        if (dateChooserPanel == DateChooserPanel.this) continue;
                        dateChooserPanel.clearCurrentSelectionCache();
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        };
        this.addMouseListener(mouseInputListener);
        this.addMouseMotionListener(mouseInputListener);
        this.updateCalendar();
        this._inited = true;
    }

    protected boolean shouldKeepCurrentSelection(MouseEvent mouseEvent) {
        return JideSwingUtilities.isMenuShortcutKeyDown(mouseEvent);
    }

    public DateModel getDateModel() {
        return this._dateModel;
    }

    public void setDateModel(DateModel dateModel) {
        if (this._dateModel != dateModel) {
            if (this._dateModel != null) {
                this.removeModeListener();
            }
            this._dateModel = dateModel;
            if (this._dateModel != null) {
                this.addModelListener();
            }
        }
    }

    protected void addModelListener() {
        this._dateModel.addDateModelListener(this);
    }

    protected void removeModeListener() {
        this._dateModel.removeDateModelListener(this);
    }

    @Override
    public void dateModelChanged(DateModelEvent dateModelEvent) {
        this.updateCalendar();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.isViewOnly()) {
            Object object = mouseEvent.getSource();
            if (object == this._yearLabel && this._yearLabel.isEnabled()) {
                this.showYearSpinner();
            } else {
                this.hideYearSpinner();
            }
            if (object == this._monthLabel && this._monthLabel.isEnabled()) {
                this.showPopup(mouseEvent);
            }
            if ((this.getSelectionModel().getSelectionMode() != 0 || mouseEvent.getClickCount() == 2) && this._dayMap.containsKey((Component)object) && SwingUtilities.isLeftMouseButton(mouseEvent) && ((JideButton)object).isEnabled()) {
                Date date = this._dayMap.get((Component)object);
                this.changeSelection(date, this.isToggleMode() || this.shouldKeepCurrentSelection(mouseEvent), !this.isToggleMode() && (1 & mouseEvent.getModifiers()) != 0);
                if (mouseEvent.getClickCount() == 2 && this.isDoubleClickToSelect() && !this.isSingleClickToSelect()) {
                    if (date == null) {
                        date = this.createCalendarInstance().getTime();
                    }
                    Calendar calendar = this.updateDisplayedTime(date);
                    this.setSelectedCalendar(calendar);
                }
                this.requestFocus();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Object object;
        if (!this.isViewOnly() && (object = mouseEvent.getSource()) != this._yearLabel && this._yearLabel.isEnabled()) {
            this.hideYearSpinner();
        }
    }

    protected void showYearSpinner() {
        if (!this._spinnerVisible && this.isShowYearSpinner()) {
            this._monthyearPanel.remove(this._yearLabel);
            try {
                ((JSpinner)this._yearSpinner).setValue(this._displayedCalendar.get(1));
                ((JSpinner)this._yearSpinner).addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        DateChooserPanel.this.commitYearSpinner();
                    }
                });
                ((JSpinner.DefaultEditor)((JSpinner)this._yearSpinner).getEditor()).getTextField().addFocusListener(new FocusListener(){

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        DateChooserPanel.this.hideYearSpinner();
                    }

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                    }
                });
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this._monthyearPanel.add(this._yearSpinner);
            Container container = this.getTopLevelAncestor();
            if (container != null) {
                if (container instanceof Window && container.getParent() instanceof JFrame) {
                    ((Window)container).setFocusableWindowState(true);
                }
                container.setFocusable(true);
            }
            this._yearSpinner.requestFocus();
            this._monthyearPanel.revalidate();
            this._monthyearPanel.repaint();
            this.repaint();
            this._spinnerVisible = true;
        }
    }

    protected int hideYearSpinner() {
        if (this._spinnerVisible) {
            try {
                ((JSpinner)this._yearSpinner).commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            Object object = ((JSpinner)this._yearSpinner).getValue();
            this._monthyearPanel.remove(this._yearSpinner);
            this._monthyearPanel.add(this._yearLabel);
            if (this._yearLabel instanceof AbstractButton) {
                ((AbstractButton)this._yearLabel).getModel().setRollover(false);
            }
            this._monthyearPanel.revalidate();
            this._monthyearPanel.repaint();
            this._spinnerVisible = false;
            if (object instanceof Integer) {
                int n = (Integer)object;
                this.setDisplayedMonth(n, this._displayedCalendar.get(2), true);
                return n;
            }
        }
        return -1;
    }

    private void commitYearSpinner() {
        if (this._spinnerVisible) {
            int n;
            boolean bl;
            try {
                ((JSpinner)this._yearSpinner).commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            Object object = ((JSpinner)this._yearSpinner).getValue();
            if (object instanceof Integer && !(bl = this.setDisplayedMonth(n = ((Integer)object).intValue(), this._displayedCalendar.get(2), true))) {
                ((JSpinner)this._yearSpinner).setValue(this._displayedCalendar.get(1));
                PortingUtils.notifyUser();
            }
        }
    }

    protected void showPopup(MouseEvent mouseEvent) {
        if (this._monthMenu == null) {
            return;
        }
        try {
            JideSwingUtilities.showPopupMenu(this._monthMenu, (Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.isViewOnly()) {
            Object object = mouseEvent.getSource();
            if (object == this._monthLabel && this._monthLabel.isEnabled()) {
                this.showPopup(mouseEvent);
            } else if (object == this._yearLabel && this._yearLabel.isEnabled()) {
                this.showYearSpinner();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.isShowYearButtons()) {
            this.hideYearSpinner();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isViewOnly()) {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                Container container = ((JMenuItem)object).getParent();
                for (int i = 0; i < container.getComponentCount(); ++i) {
                    Component component = container.getComponent(i);
                    if (component != object) continue;
                    this.setDisplayedMonth(this._displayedCalendar.get(1), i, true);
                    this.updateCalendar();
                    break;
                }
            } else if (object == this._prevButton) {
                this.prevDisplayMonth();
            } else if (object == this._nextButton) {
                this.nextDisplayMonth();
            } else if (object == this._prevYearButton) {
                this.prevDisplayYear();
            } else if (object == this._nextYearButton) {
                this.nextDisplayYear();
            } else if (object == this._todayButton) {
                this.hideYearSpinner();
                Calendar calendar = this.createCalendarInstance();
                Calendar calendar2 = this.isTimeDisplayed() ? calendar : DateChooserPanel.convertToMidnight(calendar);
                this.setSelectedCalendar(calendar2);
            } else if (object == this._noneButton) {
                this.hideYearSpinner();
                this.setSelectedDate(null);
            } else if (object == this._okButton) {
                this.commit();
            } else if (this._dayMap.containsKey((Component)object) && this.getSelectionModel().getSelectionMode() == 0) {
                Date date = this._dayMap.get((Component)object);
                Calendar calendar = this.createCalendarInstance();
                calendar.setTime(date);
                if (!this.isValidDate(calendar)) {
                    return;
                }
                if (object instanceof AbstractButton) {
                    ((AbstractButton)object).getModel().setRollover(false);
                }
                Date date2 = this._dayMap.get((Component)object);
                this.changeSelection(date2, JideSwingUtilities.isMenuShortcutKeyDown(actionEvent), (1 & actionEvent.getModifiers()) != 0);
                this.requestFocus();
            }
        }
    }

    private void commit() {
        this.hideYearSpinner();
        Date date = this.getSelectedDate();
        if (date != null) {
            Calendar calendar = this.updateDisplayedTime(date);
            this.setSelectedCalendar(calendar);
        } else {
            this.setSelectedCalendar(null);
        }
    }

    protected void setDisplayedTime(Calendar calendar) {
        if (this.isTimeDisplayed()) {
            this._selectedCalendar = calendar;
            if (this._selectedCalendar == null) {
                this.resetSelectedCalendar();
            }
            this._vetoSendSpinnerEvent = true;
            try {
                this._timeSpinner.setValue(this._selectedCalendar.getTime());
            }
            finally {
                this._vetoSendSpinnerEvent = false;
            }
        }
    }

    protected Calendar updateDisplayedTime(Date date) {
        Calendar calendar = this.createCalendarInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        if (this._timeSpinner != null && this.isTimeDisplayed()) {
            try {
                if (this._timeSpinner._format != null && this._timeSpinner._timeEditor != null && this._timeSpinner._timeEditor.getTextField() != null && !JideSwingUtilities.equals(this._timeSpinner._format.format(date), this._timeSpinner._timeEditor.getTextField().getText())) {
                    this._timeSpinner.commitEdit();
                }
                Date date2 = (Date)this._timeSpinner.getValue();
                Calendar calendar2 = this.createCalendarInstance();
                calendar2.setTime(date2);
                this.setSelectedHour(calendar2.get(11));
                this.setSelectedMinute(calendar2.get(12));
                this.setSelectedSecond(calendar2.get(13));
                this.setSelectedMillisecond(calendar2.get(14));
                calendar.set(11, this.getSelectedHour());
                calendar.set(12, this.getSelectedMinute());
                calendar.set(13, this.getSelectedSecond());
                calendar.set(14, this.getSelectedMillisecond());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return calendar;
    }

    protected void changeSelectedCalendar() {
        if (this._selectedCalendar == null) {
            this.getSelectionModel().clearSelection();
            this.setSelectedYear(0);
            this.setSelectedMonth(0);
            this.setSelectedDay(0);
            this.setSelectedHour(0);
            this.setSelectedMinute(0);
            this.setSelectedSecond(0);
            this.setSelectedMillisecond(0);
        } else {
            this._selectedCalendar.setTimeZone(this.getDateModel().getTimeZone());
            this.setSelectedYear(this._selectedCalendar.get(1));
            this.setSelectedMonth(this._selectedCalendar.get(2));
            this.setSelectedDay(this._selectedCalendar.get(5));
            this.setSelectedHour(this._selectedCalendar.get(11));
            this.setSelectedMinute(this._selectedCalendar.get(12));
            this.setSelectedSecond(this._selectedCalendar.get(13));
            this.setSelectedMillisecond(this._selectedCalendar.get(14));
            this.setDisplayedTime(this._selectedCalendar);
            this.getSelectionModel().setSelectedDate(this._selectedCalendar.getTime());
        }
    }

    private void resetSelectedCalendar() {
        this._selectedCalendar = this.getSelectedCalendar();
        if (this._selectedCalendar == null) {
            this._selectedCalendar = this.getMidnight();
        }
    }

    protected void nextMonth() {
        this.resetSelectedCalendar();
        this.hideYearSpinner();
        this._selectedCalendar.add(2, 1);
        if (this.isMonthOutOfRange(this._selectedCalendar)) {
            PortingUtils.notifyUser();
            this._selectedCalendar.add(2, -1);
            return;
        }
        this.changeSelectedCalendar();
        this.setDisplayedMonth(this.getSelectedYear(), this.getSelectedMonth());
    }

    protected void nextDisplayMonth() {
        Calendar calendar;
        this.hideYearSpinner();
        if (this.getCalendarViewer() != null) {
            calendar = this.getCalendarViewer().getMaxDisplayCalendar();
            calendar.add(2, 1);
            if (this.isMonthOutOfRange(calendar)) {
                return;
            }
        }
        calendar = DefaultDateSelectionModel.cloneCalendar(this._displayedCalendar);
        calendar.add(2, 1);
        if (this.isMonthOutOfRange(calendar)) {
            return;
        }
        this.setDisplayedMonth(calendar.get(1), calendar.get(2), true);
    }

    protected boolean isMonthOutOfRange(Calendar calendar) {
        if (this._dateModel.monthInRange(calendar)) {
            return false;
        }
        PortingUtils.notifyUser();
        return true;
    }

    protected boolean isDayOutOfRange(Calendar calendar) {
        if (this._dateModel.dayInRange(calendar)) {
            return false;
        }
        PortingUtils.notifyUser();
        return true;
    }

    protected boolean isSingleSelectionMode() {
        return this.getSelectionModel().getSelectionMode() == 0;
    }

    protected void prevDisplayMonth() {
        Calendar calendar;
        this.hideYearSpinner();
        if (this.getCalendarViewer() != null) {
            calendar = this.getCalendarViewer().getMinDisplayCalendar();
            calendar.add(2, -1);
            if (this.isMonthOutOfRange(calendar)) {
                return;
            }
        }
        calendar = DefaultDateSelectionModel.cloneCalendar(this._displayedCalendar);
        calendar.add(2, -1);
        if (this.isMonthOutOfRange(calendar)) {
            return;
        }
        this.setDisplayedMonth(calendar.get(1), calendar.get(2), true);
    }

    protected void prevMonth() {
        this.resetSelectedCalendar();
        this.hideYearSpinner();
        this._selectedCalendar.add(2, -1);
        if (this.isMonthOutOfRange(this._selectedCalendar)) {
            PortingUtils.notifyUser();
            this._selectedCalendar.add(2, 1);
            return;
        }
        this.changeSelectedCalendar();
        this.setDisplayedMonth(this.getSelectedYear(), this.getSelectedMonth());
    }

    protected void nextDisplayYear() {
        Calendar calendar;
        this.hideYearSpinner();
        if (this.getCalendarViewer() != null) {
            calendar = this.getCalendarViewer().getMaxDisplayCalendar();
            calendar.add(1, 1);
            if (this.isMonthOutOfRange(calendar)) {
                return;
            }
        }
        calendar = DefaultDateSelectionModel.cloneCalendar(this._displayedCalendar);
        calendar.add(1, 1);
        if (this.isMonthOutOfRange(calendar)) {
            return;
        }
        this.setDisplayedMonth(calendar.get(1), calendar.get(2), true);
    }

    protected void nextYear() {
        this.resetSelectedCalendar();
        this.hideYearSpinner();
        this._selectedCalendar.add(1, 1);
        if (this.isMonthOutOfRange(this._selectedCalendar)) {
            PortingUtils.notifyUser();
            this._selectedCalendar.add(1, -1);
            return;
        }
        this.changeSelectedCalendar();
        this.setDisplayedMonth(this.getSelectedYear(), this.getSelectedMonth());
    }

    protected void prevDisplayYear() {
        Calendar calendar;
        this.hideYearSpinner();
        if (this.getCalendarViewer() != null) {
            calendar = this.getCalendarViewer().getMinDisplayCalendar();
            calendar.add(1, -1);
            if (this.isMonthOutOfRange(calendar)) {
                return;
            }
        }
        calendar = DefaultDateSelectionModel.cloneCalendar(this._displayedCalendar);
        calendar.add(1, -1);
        if (this.isMonthOutOfRange(calendar)) {
            return;
        }
        this.setDisplayedMonth(calendar.get(1), calendar.get(2), true);
    }

    protected void prevYear() {
        this.resetSelectedCalendar();
        this.hideYearSpinner();
        this._selectedCalendar.add(1, -1);
        if (this.isMonthOutOfRange(this._selectedCalendar)) {
            PortingUtils.notifyUser();
            this._selectedCalendar.add(1, 1);
            return;
        }
        this.changeSelectedCalendar();
        this.setDisplayedMonth(this.getSelectedYear(), this.getSelectedMonth());
    }

    private void firstDayOfMonth() {
        this.resetSelectedCalendar();
        this.hideYearSpinner();
        int n = this._selectedCalendar.getActualMinimum(5);
        this._selectedCalendar.set(5, n);
        this._selectedCalendar.set(5, 1);
        if (this.isDayOutOfRange(this._selectedCalendar)) {
            this._selectedCalendar = this._dateModel.getMinDate();
        }
        this.changeSelectedCalendar();
        this.setDisplayedMonth(this.getSelectedYear(), this.getSelectedMonth());
    }

    private void lastDayOfMonth() {
        this.resetSelectedCalendar();
        this.hideYearSpinner();
        int n = this._selectedCalendar.getActualMaximum(5);
        this._selectedCalendar.set(5, n);
        if (this.isDayOutOfRange(this._selectedCalendar)) {
            this._selectedCalendar = this._dateModel.getMaxDate();
        }
        this.changeSelectedCalendar();
        this.setDisplayedMonth(this.getSelectedYear(), this.getSelectedMonth());
    }

    protected void nextDay() {
        this.resetSelectedCalendar();
        this.hideYearSpinner();
        do {
            this._selectedCalendar.add(6, 1);
            if (!this.isDayOutOfRange(this._selectedCalendar)) continue;
            this._selectedCalendar.add(6, -1);
            return;
        } while (!this._dateModel.isValidDate(this._selectedCalendar));
        this.changeSelectedCalendar();
        this.setDisplayedMonth(this.getSelectedYear(), this.getSelectedMonth());
    }

    protected void prevDay() {
        this.resetSelectedCalendar();
        this.hideYearSpinner();
        do {
            this._selectedCalendar.add(6, -1);
            if (!this.isDayOutOfRange(this._selectedCalendar)) continue;
            this._selectedCalendar.add(6, 1);
            return;
        } while (!this._dateModel.isValidDate(this._selectedCalendar));
        this.changeSelectedCalendar();
        this.setDisplayedMonth(this.getSelectedYear(), this.getSelectedMonth());
    }

    protected void nextWeek() {
        this.resetSelectedCalendar();
        this.hideYearSpinner();
        this._selectedCalendar.add(6, 7);
        if (this.isDayOutOfRange(this._selectedCalendar)) {
            this._selectedCalendar.add(6, -7);
            return;
        }
        this.changeSelectedCalendar();
        this.setDisplayedMonth(this.getSelectedYear(), this.getSelectedMonth());
    }

    protected void prevWeek() {
        this.resetSelectedCalendar();
        this.hideYearSpinner();
        this._selectedCalendar.add(6, -7);
        if (this.isDayOutOfRange(this._selectedCalendar)) {
            this._selectedCalendar.add(6, 7);
            return;
        }
        this.changeSelectedCalendar();
        this.setDisplayedMonth(this.getSelectedYear(), this.getSelectedMonth());
    }

    public Date getSelectedDate() {
        if (this.getSelectedCalendar() != null) {
            return this.getSelectedCalendar().getTime();
        }
        return null;
    }

    public Calendar getSelectedCalendar() {
        Date date = this.getSelectionModel().getSelectedDate();
        if (date != null) {
            return this.updateDisplayedTime(date);
        }
        return null;
    }

    public void setSelectedDate(Date date) {
        if (date == null) {
            this.setSelectedCalendar(null);
        } else {
            Calendar calendar = this.getMidnight();
            calendar.setTime(date);
            this.setSelectedCalendar(calendar);
        }
    }

    public void setSelectedCalendar(Calendar calendar) {
        if (this._dateModel.isValidDate(calendar)) {
            if (calendar != null) {
                this.getSelectionModel().setSelectedDate(calendar.getTime());
                this.setSelectedObject(calendar.clone());
                this.setDisplayedMonth(calendar.get(1), calendar.get(2));
            } else {
                this.getSelectionModel().setSelectedDate(null);
                this.setSelectedObject(null);
                this.getSelectionModel().clearSelection();
                this.setDisplayedTime(this._selectedCalendar);
            }
        }
    }

    public boolean setDisplayedMonth(int n, int n2) {
        return this.setDisplayedMonth(n, n2, false);
    }

    public boolean setDisplayedMonth(int n, int n2, boolean bl) {
        if (this.isTimeDisplayed()) {
            this._selectedCalendar = this.updateDisplayedTime(this._selectedCalendar == null ? this.createCalendarInstance().getTime() : this._selectedCalendar.getTime());
        }
        if (!bl && this.getCalendarViewer() != null) {
            if (this.getCalendarViewer().setDisplayedMonth(n, n2 - this.getDisplayIndex())) {
                this.updateCalendar();
                return true;
            }
            return false;
        }
        this.setDisplayedTime(this._selectedCalendar);
        Calendar calendar = this.getMidnight();
        calendar.setTimeZone(this.getDateModel().getTimeZone());
        calendar.set(5, 1);
        calendar.set(1, n);
        if (n2 >= calendar.getActualMinimum(2) && n2 <= calendar.getActualMaximum(2)) {
            calendar.set(2, n2);
        }
        if (this.getCalendarViewer() != null || this._dateModel.monthInRange(calendar)) {
            Calendar calendar2 = this._displayedCalendar;
            this._displayedCalendar = calendar;
            this.updateCalendar();
            this.firePropertyChange(PROPERTY_DISPLAY_MONTH, DefaultDateSelectionModel.cloneCalendar(calendar2), DefaultDateSelectionModel.cloneCalendar(this._displayedCalendar));
            return true;
        }
        return false;
    }

    public Calendar getDisplayedCalendar() {
        return DefaultDateSelectionModel.cloneCalendar(this._displayedCalendar);
    }

    Date getDisplayedDate() {
        return this._displayedCalendar.getTime();
    }

    protected Component createDayPanel() {
        JPanel jPanel = this.createPanel(new JideBorderLayout(2, 2));
        jPanel.add(this.createDayHeaderPanel(), "First");
        this._weekOfYearPanel = this.createWeekOfYearPanel();
        jPanel.add((Component)this._weekOfYearPanel, "Before");
        jPanel.add(this.createDatePanel(), "Center");
        this._weekOfYearPanel.setVisible(this.isShowWeekNumbers());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        return jPanel;
    }

    protected Component createDayHeaderPanel() {
        JPanel jPanel = this.createPanel(new GridLayout(1, 7, this._horizontalGap, this._verticalGap));
        for (int i = 0; i < this._weekLabel.length; ++i) {
            this._weekLabel[i] = this.createDayOfWeekLabel(i);
            jPanel.add(this._weekLabel[i]);
        }
        jPanel.setBorder(this._dayHeaderBorder);
        return jPanel;
    }

    protected JComponent createWeekOfYearPanel() {
        JPanel jPanel = this.createPanel(new GridLayout(6, 1, this._horizontalGap, this._verticalGap));
        for (int i = 0; i < this._weekOfYearLabel.length; ++i) {
            this._weekOfYearLabel[i] = this.createWeekOfYearLabel(i);
            jPanel.add(this._weekOfYearLabel[i]);
        }
        jPanel.addPropertyChangeListener("componentOrientation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ((JComponent)propertyChangeEvent.getSource()).setBorder(((JComponent)propertyChangeEvent.getSource()).getComponentOrientation().isLeftToRight() ? BorderFactory.createMatteBorder(0, 0, 0, 1, UIDefaultsLookup.getColor("TextField.foreground")) : BorderFactory.createMatteBorder(0, 1, 0, 0, UIDefaultsLookup.getColor("TextField.foreground")));
            }
        });
        return jPanel;
    }

    protected JComponent createDayOfWeekLabel(final int n) {
        NullLabel nullLabel = new NullLabel("WWW");
        nullLabel.setBorder(this._cellBorder);
        nullLabel.setHorizontalAlignment(this._labelAlignment);
        nullLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                DateSelectionModel dateSelectionModel = DateChooserPanel.this.getSelectionModel();
                if (dateSelectionModel.getSelectionMode() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    int n2;
                    Date date = null;
                    Date date2 = null;
                    if (DateChooserPanel.this.isSelectDateOnSameMonth()) {
                        Calendar calendar = DateChooserPanel.this.getDisplayedCalendar();
                        date = calendar.getTime();
                        calendar.add(2, 1);
                        calendar.add(5, -1);
                        date2 = calendar.getTime();
                    }
                    boolean bl = true;
                    if (DateChooserPanel.this.isSelectAllDatesOnToggleMode()) {
                        for (n2 = 0; n2 < 6; ++n2) {
                            Date date3 = DateChooserPanel.this._dayMap.get(DateChooserPanel.this._dayLabels[n2 * 7 + n]);
                            if (date3 == null || date != null && date3.before(date) || date2 != null && date3.after(date2) || dateSelectionModel.isSelectedDate(date3)) continue;
                            bl = false;
                            break;
                        }
                    }
                    n2 = 1;
                    for (int i = 0; i < 6; ++i) {
                        Date date4 = DateChooserPanel.this._dayMap.get(DateChooserPanel.this._dayLabels[i * 7 + n]);
                        if (date4 == null || date != null && date4.before(date) || date2 != null && date4.after(date2) || DateChooserPanel.this.isSelectAllDatesOnToggleMode() && !bl && dateSelectionModel.isSelectedDate(date4)) continue;
                        DateChooserPanel.this.changeSelection(date4, DateChooserPanel.this.isToggleMode() || n2 == 0 || JideSwingUtilities.isMenuShortcutKeyDown(mouseEvent), !DateChooserPanel.this.isToggleMode() && (1 & mouseEvent.getModifiers()) != 0);
                        n2 = 0;
                    }
                }
            }
        });
        return nullLabel;
    }

    protected JComponent createWeekOfYearLabel(final int n) {
        NullLabel nullLabel = new NullLabel("00"){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (dimension.width < DateChooserPanel.this._cellWeekOfYearWidth) {
                    dimension.width = DateChooserPanel.this._cellWeekOfYearWidth;
                }
                if (dimension.height < DateChooserPanel.this._cellWeekOfYearHeight) {
                    dimension.height = DateChooserPanel.this._cellWeekOfYearHeight;
                }
                return dimension;
            }
        };
        nullLabel.setBorder(this._cellBorder);
        nullLabel.setHorizontalAlignment(this._labelAlignment);
        nullLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                DateSelectionModel dateSelectionModel = DateChooserPanel.this.getSelectionModel();
                if (dateSelectionModel.getSelectionMode() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    int n2;
                    Date date = null;
                    Date date2 = null;
                    if (DateChooserPanel.this.isSelectDateOnSameMonth()) {
                        Calendar calendar = DateChooserPanel.this.getDisplayedCalendar();
                        date = calendar.getTime();
                        calendar.add(2, 1);
                        calendar.add(5, -1);
                        date2 = calendar.getTime();
                    }
                    boolean bl = true;
                    if (DateChooserPanel.this.isSelectAllDatesOnToggleMode()) {
                        for (n2 = 0; n2 < 7; ++n2) {
                            Date date3 = DateChooserPanel.this._dayMap.get(DateChooserPanel.this._dayLabels[n * 7 + n2]);
                            if (date3 == null || date != null && date3.before(date) || date2 != null && date3.after(date2) || dateSelectionModel.isSelectedDate(date3)) continue;
                            bl = false;
                            break;
                        }
                    }
                    n2 = 1;
                    for (int i = 0; i < 7; ++i) {
                        Date date4 = DateChooserPanel.this._dayMap.get(DateChooserPanel.this._dayLabels[n * 7 + i]);
                        if (date4 == null || date != null && date4.before(date) || date2 != null && date4.after(date2) || DateChooserPanel.this.isSelectAllDatesOnToggleMode() && !bl && dateSelectionModel.isSelectedDate(date4)) continue;
                        DateChooserPanel.this.changeSelection(date4, DateChooserPanel.this.isToggleMode() || n2 == 0 || JideSwingUtilities.isMenuShortcutKeyDown(mouseEvent), !DateChooserPanel.this.isToggleMode() && (1 & mouseEvent.getModifiers()) != 0);
                        n2 = 0;
                    }
                }
            }
        });
        return nullLabel;
    }

    protected Component createDatePanel() {
        JPanel jPanel = this.createPanel(new GridLayout(6, 7, this._horizontalGap, this._verticalGap));
        for (int i = 0; i < this._dayLabels.length; ++i) {
            this._dayLabels[i] = this.createDateLabel(i);
            jPanel.add(this._dayLabels[i]);
        }
        return jPanel;
    }

    private Dimension getPreferredCellSize(AbstractButton abstractButton) {
        Dimension dimension = BasicGraphicsUtils.getPreferredButtonSize(abstractButton, abstractButton.getIconTextGap());
        if (dimension.width < this._cellWidth) {
            dimension.width = this._cellWidth;
        }
        if (dimension.height < this._cellHeight) {
            dimension.height = this._cellHeight;
        }
        return dimension;
    }

    protected JComponent createDateLabel(int n) {
        JideButton jideButton = new JideButton(""){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getPreferredSize() {
                return DateChooserPanel.this.getPreferredCellSize(this);
            }

            @Override
            public void setFont(Font font) {
                if (font instanceof FontUIResource) {
                    return;
                }
                super.setFont(font);
            }
        };
        jideButton.setName("" + n);
        jideButton.setHorizontalAlignment(this._labelAlignment);
        jideButton.addMouseListener(this);
        jideButton.addActionListener(this);
        jideButton.addMouseMotionListener(this._retargetMouseMotionListener);
        jideButton.addMouseListener(this._retargetMouseListener);
        jideButton.setBorder(this._cellBorder);
        jideButton.setFont(null);
        PortingUtils.removeFocus(jideButton);
        return jideButton;
    }

    protected JTextField getTextField(JSpinner jSpinner) {
        JComponent jComponent = jSpinner.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor) {
            return ((JSpinner.DefaultEditor)jComponent).getTextField();
        }
        System.err.println("Unexpected editor type: " + jSpinner.getEditor().getClass() + " isn't a descendent of DefaultEditor");
        return null;
    }

    protected MouseListener createYearLabelListener() {
        return new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                DateChooserPanel.this.showYearSpinner();
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (!DateChooserPanel.this.isShowYearButtons()) {
                    DateChooserPanel.this.showYearSpinner();
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                DateChooserPanel.this.hideYearSpinner();
            }
        };
    }

    protected Component createMonthYearPanel() {
        this._yearLabel = this.createYearLabel();
        this._yearLabelListener = this.createYearLabelListener();
        this._yearLabel.addMouseListener(this._yearLabelListener);
        this._monthLabel = this.createMonthLabel();
        this._monthLabel.addMouseListener(this);
        this._yearModel = new SpinnerNumberModel(this.getMidnight().get(1), 1753, 9999, 1);
        this._yearSpinner = this.createYearSpinner(this._yearModel);
        SpinnerWheelSupport.installMouseWheelSupport((JSpinner)this._yearSpinner);
        ((JSpinner)this._yearSpinner).setEditor(new JSpinner.NumberEditor((JSpinner)this._yearSpinner, "#"));
        this._yearSpinner.setBorder(BorderFactory.createEmptyBorder());
        this._yearSpinner.setForeground(null);
        this._yearSpinner.setBackground(null);
        this._yearSpinner.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (!DateChooserPanel.this.isShowYearButtons()) {
                    DateChooserPanel.this.hideYearSpinner();
                }
            }
        });
        JTextField jTextField = this.getTextField((JSpinner)this._yearSpinner);
        if (jTextField != null) {
            jTextField.setBorder(BorderFactory.createEmptyBorder());
            jTextField.setColumns(3);
            jTextField.setHorizontalAlignment(4);
            jTextField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DateChooserPanel.this.hideYearSpinner();
                }
            });
        }
        this._monthyearPanel = this.createPanel(new FlowLayout());
        this._monthyearPanel.setOpaque(false);
        this._monthyearPanel.add(this._monthLabel);
        this._monthyearPanel.add(this._yearLabel);
        this._titlePanel = new JPanel(new BorderLayout());
        this._titlePanel.setFont(null);
        this._prevButton = new MonthNavigationButton(JideIconsFactory.getImageIcon("jide/direction_left.gif"));
        this._prevButton.setPreferredSize(new Dimension(NAVIGATION_BUTTON_WIDTH, NAVIGATION_BUTTON_HEIGHT));
        PortingUtils.removeFocus(this._prevButton);
        this._prevButton.addActionListener(this);
        this._prevYearButton = new MonthNavigationButton(IconsFactory.getCombinedIcon(this, JideIconsFactory.getImageIcon("jide/direction_left.gif"), JideIconsFactory.getImageIcon("jide/direction_left.gif"), 0, 0));
        this._prevYearButton.setPreferredSize(new Dimension(NAVIGATION_BUTTON_WIDTH, NAVIGATION_BUTTON_HEIGHT));
        PortingUtils.removeFocus(this._prevYearButton);
        this._prevYearButton.addActionListener(this);
        JPanel jPanel = JideSwingUtilities.createCenterPanel(this._prevYearButton);
        jPanel.add(this._prevButton);
        jPanel.setPreferredSize(new Dimension(NAVIGATION_BUTTON_WIDTH * 2, NAVIGATION_BUTTON_HEIGHT));
        this._titlePanel.add((Component)jPanel, "Before");
        this._nextButton = new MonthNavigationButton(JideIconsFactory.getImageIcon("jide/direction_right.gif"));
        this._nextButton.setPreferredSize(new Dimension(NAVIGATION_BUTTON_WIDTH, NAVIGATION_BUTTON_HEIGHT));
        PortingUtils.removeFocus(this._nextButton);
        this._nextButton.addActionListener(this);
        this._nextYearButton = new MonthNavigationButton(IconsFactory.getCombinedIcon(this, JideIconsFactory.getImageIcon("jide/direction_right.gif"), JideIconsFactory.getImageIcon("jide/direction_right.gif"), 0, 0));
        this._nextYearButton.setPreferredSize(new Dimension(NAVIGATION_BUTTON_WIDTH, NAVIGATION_BUTTON_HEIGHT));
        PortingUtils.removeFocus(this._nextYearButton);
        this._nextYearButton.addActionListener(this);
        jPanel = JideSwingUtilities.createCenterPanel(this._nextButton);
        jPanel.add(this._nextYearButton);
        jPanel.setPreferredSize(new Dimension(NAVIGATION_BUTTON_WIDTH * 2, NAVIGATION_BUTTON_HEIGHT));
        this._titlePanel.add((Component)jPanel, "After");
        this._titlePanel.add((Component)this._monthyearPanel, "Center");
        this._prevButton.setVisible(!this.isViewOnly());
        this._nextButton.setVisible(!this.isViewOnly());
        this._prevYearButton.setVisible(!this.isViewOnly() && this.isShowYearButtons());
        this._nextYearButton.setVisible(!this.isViewOnly() && this.isShowYearButtons());
        this._titlePanel.setBorder(this._monthyearBorder);
        LookAndFeel.installColors(this._titlePanel, "InternalFrame.activeTitleBackground", "InternalFrame.activeTitleForeground");
        this._titlePanel.putClientProperty("setOpaqueRecursively.excluded", Boolean.TRUE);
        return this._titlePanel;
    }

    protected JSpinner createYearSpinner(SpinnerModel spinnerModel) {
        return new JSpinner(spinnerModel){

            @Override
            public Font getFont() {
                return this.getParent() == null ? super.getFont() : this.getParent().getFont();
            }
        };
    }

    protected Component createButtonPanel() {
        this._buttonPanel = new ButtonPanel(){

            @Override
            public void updateUI() {
                super.updateUI();
                this.clearAttribute();
            }

            private void clearAttribute() {
                this.setFont(null);
                this.setBackground(null);
                this.setForeground(null);
            }
        };
        this._todayButton = this.createButton(this.isTimeDisplayed() ? this.getResourceString("Date.now", this.getLocale()) : this.getResourceString("Date.today", this.getLocale()), this.isTimeDisplayed() ? this.getResourceString("Date.now.mnemonic", this.getLocale()) : this.getResourceString("Date.today.mnemonic", this.getLocale()));
        if (this.isTimeDisplayed()) {
            this._todayButton.setName("Date.now");
        } else {
            this._todayButton.setName("Date.today");
        }
        this._todayButton.addActionListener(this);
        this._noneButton = this.createButton(this.getResourceString("Date.none", this.getLocale()), this.getResourceString("Date.none.mnemonic", this.getLocale()));
        this._noneButton.setName("Date.none");
        this._noneButton.addActionListener(this);
        this._okButton = this.createButton(this.getResourceString("Date.ok", this.getLocale()), null);
        this._okButton.setName("Date.ok");
        this._okButton.addActionListener(this);
        this.updateButtons(this._buttonPanel);
        JPanel jPanel = this.createPanel(new BorderLayout(6, 6));
        jPanel.add(JideSwingUtilities.createCenterPanel(this._buttonPanel));
        this._timeSpinner = this.createTimeSpinner();
        jPanel.add((Component)JideSwingUtilities.createCenterPanel(this._timeSpinner), "First");
        this._timeSpinner.setVisible(this.isTimeDisplayed());
        this._timeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!DateChooserPanel.this._vetoSendSpinnerEvent) {
                    ((DefaultDateSelectionModel)DateChooserPanel.this.getSelectionModel()).fireValueChanged(new DateSelectionEvent(DateChooserPanel.this.getSelectionModel()));
                }
            }
        });
        jPanel.setBorder(this._buttonsBorder);
        return jPanel;
    }

    protected AbstractButton createButton(String string, String string2) {
        JButton jButton = new JButton(string);
        if (string2 != null) {
            jButton.setMnemonic(string2.charAt(0));
        }
        return jButton;
    }

    protected DateSpinner createTimeSpinner() {
        String string = this.getTimeFormat();
        if (string == null) {
            string = ((SimpleDateFormat)SimpleDateFormat.getTimeInstance(2, this.getLocale())).toPattern();
        }
        DateSpinner dateSpinner = new DateSpinner(string){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Dimension getPreferredSize() {
                Object object;
                Dimension dimension = super.getPreferredSize();
                if (SystemInfo.isJdk15Above() && ((object = this.getValue()) instanceof Date || object instanceof Calendar)) {
                    Calendar calendar;
                    if (object instanceof Calendar) {
                        calendar = (Calendar)object;
                    } else {
                        calendar = Calendar.getInstance();
                        calendar.setTime((Date)object);
                    }
                    if (calendar.get(10) < 10) {
                        DateChooserPanel.this._vetoSendSpinnerEvent = true;
                        try {
                            calendar.set(10, 11);
                            if (object instanceof Calendar) {
                                this.setValue(calendar);
                            } else {
                                this.setValue(calendar.getTime());
                            }
                            try {
                                dimension = super.getPreferredSize();
                            }
                            finally {
                                this.setValue(object);
                            }
                        }
                        finally {
                            DateChooserPanel.this._vetoSendSpinnerEvent = false;
                        }
                    }
                }
                return dimension;
            }
        };
        dateSpinner.setTimeZone(this.getTimeZone());
        return dateSpinner;
    }

    protected void updateButtons(ButtonPanel buttonPanel) {
        boolean bl = false;
        if (!this.isViewOnly()) {
            if (this.isShowTodayButton()) {
                buttonPanel.addButton(this._todayButton);
                this._todayButton.setEnabled(this.isEnabled());
                bl = true;
            } else {
                buttonPanel.removeButton(this._todayButton);
            }
            if (this.isShowNoneButton()) {
                buttonPanel.addButton(this._noneButton);
                this._noneButton.setEnabled(this.isEnabled());
                bl = true;
            } else {
                buttonPanel.removeButton(this._noneButton);
            }
            if (this.isShowOKButton()) {
                buttonPanel.addButton(this._okButton);
                this._okButton.setEnabled(this.isEnabled());
                bl = true;
            } else {
                buttonPanel.removeButton(this._okButton);
            }
        }
        if (this.isTimeDisplayed()) {
            bl = true;
        }
        if (this._buttonContainerPanel != null) {
            this._buttonContainerPanel.setVisible(bl);
            this._buttonContainerPanel.invalidate();
            this._timeSpinner.setEnabled(!this.isViewOnly());
        }
        this.revalidate();
        this.doLayout();
    }

    @Override
    public void doLayout() {
        this._vetoSendSpinnerEvent = true;
        try {
            super.doLayout();
        }
        finally {
            this._vetoSendSpinnerEvent = false;
        }
    }

    protected void initCalendar() {
        this._todayCalendar = this.getMidnight();
        this._todayYear = this._todayCalendar.get(1);
        this._todayMonth = this._todayCalendar.get(2);
        this._todayDay = this._todayCalendar.get(5);
        this.setSelectedDate(null);
        this._selectedCalendar = this.getMidnight();
        this.changeSelectedCalendar();
        this.setDisplayedMonth(this.getSelectedYear(), this.getSelectedMonth());
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBorder(this._border);
        LookAndFeel.installColorsAndFont(this, "TextField.background", "TextField.foreground", "TextField.font");
        if (this._yearSpinner != null) {
            this._yearSpinner.updateUI();
        }
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBorder(this._border);
        LookAndFeel.installColorsAndFont(this, "TextField.background", "TextField.foreground", "TextField.font");
        this.add(this.createMonthPanel());
        this._buttonContainerPanel = this.createButtonPanel();
        this.add(this._buttonContainerPanel, "Last");
        this.setRequestFocusEnabled(true);
        this.setFocusable(true);
        this.registerKeyStrokes();
        this.applyComponentOrientation(this.getComponentOrientation());
    }

    protected Component createMonthPanel() {
        JPanel jPanel = this.createPanel(new GridLayout(1, 1, 6, 6));
        JPanel jPanel2 = this.createPanel(new BorderLayout());
        jPanel2.add(this.createMonthYearPanel(), "First");
        jPanel2.add(this.createDayPanel(), "Center");
        jPanel.add(jPanel2);
        return jPanel;
    }

    @Override
    public void setSelectedObject(Object object, boolean bl) {
        if (object == null && this.isVisible() && this.isShowing()) {
            this.getSelectionModel().clearSelection();
        }
        super.setSelectedObject(object, bl);
    }

    void clearCurrentSelectionCache() {
        this._toggleSelectionMap = null;
    }

    void cacheCurrentSelection() {
        if (this._dayMap == null) {
            return;
        }
        Collection<Date> collection = this._dayMap.values();
        this._toggleSelectionMap = new HashMap<Date, Boolean>();
        for (Date date : collection) {
            this._toggleSelectionMap.put(date, this.getSelectionModel().isSelectedDate(date));
        }
    }

    void toggleSelectionTo(Date date) {
        if (this.getAnchorDate() != null) {
            Object object;
            Object object2 = date;
            Date date2 = this.getAnchorDate();
            if (((Date)object2).before(date2)) {
                object = date2;
                date2 = object2;
                object2 = object;
            }
            object = this._dayMap.values();
            HashSet<Date> hashSet = new HashSet<Date>();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Date date3 = (Date)iterator.next();
                if ((date3.after(date2) || DefaultDateSelectionModel.isSameDay(date2, date3)) && (date3.before((Date)object2) || DefaultDateSelectionModel.isSameDay((Date)object2, date3))) {
                    if (this.getSelectionModel().isSelectedDate(date3) != this._toggleSelectionMap.get(date3).booleanValue()) continue;
                    hashSet.add(date3);
                    continue;
                }
                if (this.getSelectionModel().isSelectedDate(date3) == this._toggleSelectionMap.get(date3).booleanValue()) continue;
                hashSet.add(date3);
            }
            this.changeSelection(hashSet, true, false);
        }
    }

    public void updateCalendar() {
        int n;
        int n2;
        int n3;
        this._lastRowEmpty = false;
        if (this._displayedCalendar == null) {
            this._displayedCalendar = this.getMidnight();
        }
        if (this.getCalendarViewer() == null && !this.getDateModel().monthInRange(this._displayedCalendar)) {
            if (this.getDateModel().getMaxDate() != null && this._displayedCalendar.getTimeInMillis() > this.getDateModel().getMaxDate().getTimeInMillis()) {
                this._displayedCalendar = this.getDateModel().getMaxDate();
            } else if (this.getDateModel().getMinDate() != null && this._displayedCalendar.getTimeInMillis() < this.getDateModel().getMinDate().getTimeInMillis()) {
                this._displayedCalendar = this.getDateModel().getMinDate();
            }
        }
        Calendar calendar = (Calendar)this._displayedCalendar.clone();
        this.updateMonthLabel(this._monthLabel, calendar);
        this.updateYearLabel(this._yearLabel, calendar);
        this.updateMonthNavigationButtons(calendar);
        calendar.set(5, 1);
        Calendar calendar2 = (Calendar)calendar.clone();
        int n4 = calendar.get(7);
        int n5 = calendar.getActualMaximum(5);
        calendar.add(2, -1);
        int n6 = calendar.getActualMaximum(5);
        calendar.set(5, n6);
        Calendar calendar3 = this.getMidnight();
        calendar3.set(2003, 6, 27);
        calendar3.add(5, this.getFirstDayOfWeek() - 1);
        if (!this.isAlwaysShowShortWeekLabels() && this.isShowShortWeekLabels()) {
            this.checkShortenLabels();
        }
        for (JComponent jComponent : this._weekLabel) {
            this.updateDayOfWeekLabel(jComponent, calendar3);
            calendar3.add(7, 1);
        }
        if (this._monthMenu == null) {
            this._monthMenu = this.createMonthMenu();
        } else {
            this._monthMenu.removeAll();
        }
        calendar3.set(2003, 0, 1);
        for (n3 = 0; n3 < 12; ++n3) {
            JMenuItem jMenuItem = this.createMonthMenuItem(this.getMonthFormatter().format(calendar3.getTime()));
            jMenuItem.addActionListener(this);
            this._monthMenu.add(jMenuItem);
            calendar3.add(2, 1);
        }
        this._dayMap.clear();
        if ((n4 -= this.getFirstDayOfWeek() - 1) <= 0) {
            n4 += 7;
        }
        if (n4 > 1) {
            for (n3 = n4 - 2; n3 > -1; --n3) {
                if (this.isShowPreviousMonthDays()) {
                    this._dayMap.put(this._dayLabels[n3], calendar.getTime());
                    n2 = this.isDateSelected(calendar) ? 1 : 0;
                    n = this.isToday(calendar) ? 1 : 0;
                    this.updateDateLabel(this._dayLabels[n3], calendar, n2 != 0, n != 0, false);
                } else {
                    this.updateDateLabel(this._dayLabels[n3], null, false, false, false);
                }
                calendar.roll(5, -1);
            }
        }
        calendar.add(2, 1);
        calendar.set(5, 1);
        for (n3 = n4 - 1; n3 < n4 + n5 - 1; ++n3) {
            this._dayMap.put(this._dayLabels[n3], calendar.getTime());
            n2 = this.isDateSelected(calendar) ? 1 : 0;
            n2 = this.isDateSelected(calendar) ? 1 : 0;
            n = this.isToday(calendar);
            this.updateDateLabel(this._dayLabels[n3], calendar, n2 != 0, n != 0, true);
            calendar.roll(5, 1);
        }
        calendar.add(2, 1);
        calendar.set(5, 1);
        for (n3 = n4 + n5 - 1; n3 < this._dayLabels.length; ++n3) {
            if (this.isShowNextMonthDays()) {
                this._dayMap.put(this._dayLabels[n3], calendar.getTime());
                n2 = this.isDateSelected(calendar);
                n = this.isToday(calendar);
                this.updateDateLabel(this._dayLabels[n3], calendar, n2 != 0, n != 0, false);
            } else {
                this.updateDateLabel(this._dayLabels[n3], null, false, false, false);
            }
            calendar.roll(5, 1);
        }
        calendar.add(2, -1);
        calendar.set(5, 1);
        if (this.getFirstDayOfWeek() > 1 && calendar2.get(7) < this.getFirstDayOfWeek()) {
            calendar2.add(6, 1 - this.getFirstDayOfWeek());
        }
        for (n3 = 0; n3 < this._weekOfYearLabel.length; ++n3) {
            JComponent jComponent = this._weekOfYearLabel[n3];
            this.updateWeekOfYearLabel(jComponent, calendar2);
            if (n3 == this._weekOfYearLabel.length - 1) {
                if (!this.isShowNextMonthDays() && n4 + n5 <= 36) {
                    jComponent.setVisible(false);
                    this._lastRowEmpty = true;
                } else {
                    jComponent.setVisible(true);
                }
            }
            calendar2.add(3, 1);
        }
        this.repaint();
    }

    protected JPopupMenu createMonthMenu() {
        return new JPopupMenu();
    }

    protected JMenuItem createMonthMenuItem(String string) {
        return new JMenuItem(string);
    }

    protected void updateMonthNavigationButtons(Calendar calendar) {
        calendar.add(2, -1);
        this._prevButton.setEnabled(this._dateModel.monthInRange(calendar));
        calendar.add(2, 2);
        this._nextButton.setEnabled(this._dateModel.monthInRange(calendar));
        calendar.add(2, -1);
        calendar.add(1, -1);
        this._prevYearButton.setEnabled(this._dateModel.yearInRange(calendar));
        calendar.add(1, 2);
        this._nextYearButton.setEnabled(this._dateModel.yearInRange(calendar));
        calendar.add(1, -1);
    }

    private Calendar getMidnight() {
        Calendar calendar = this.createCalendarInstance();
        return DateChooserPanel.convertToMidnight(calendar);
    }

    public static Calendar convertToMidnight(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        calendar.set(10, 0);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    protected JPanel createPanel(LayoutManager layoutManager) {
        NullPanel nullPanel = new NullPanel(layoutManager);
        nullPanel.addMouseListener(this);
        return nullPanel;
    }

    public boolean isViewOnly() {
        return this._viewOnly;
    }

    public void setViewOnly(boolean bl) {
        boolean bl2 = this._viewOnly;
        if (bl2 != bl) {
            this._viewOnly = bl;
            this.firePropertyChange("viewonly", this._viewOnly, bl2);
            if (this._nextButton != null) {
                this._nextButton.setVisible(this.isShowNextButton() && !this.isViewOnly());
                this._nextButton.setEnabled(this.isEnabled());
            }
            if (this._prevButton != null) {
                this._prevButton.setVisible(this.isShowPreviousButton() && !this.isViewOnly());
                this._prevButton.setEnabled(this.isEnabled());
            }
            if (this._nextYearButton != null) {
                this._nextYearButton.setVisible(this.isShowNextYearButton() && !this.isViewOnly() && this.isShowYearButtons());
                this._nextYearButton.setEnabled(this.isEnabled());
            }
            if (this._prevYearButton != null) {
                this._prevYearButton.setVisible(this.isShowPreviousYearButton() && !this.isViewOnly() && this.isShowYearButtons());
                this._prevYearButton.setEnabled(this.isEnabled());
            }
            if (this._buttonPanel != null) {
                this.updateButtons(this._buttonPanel);
            }
            this.revalidate();
            this.updateCalendar();
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.updateCalendar();
        if (this._nextButton != null) {
            this._nextButton.setVisible(this.isShowNextButton() && !this.isViewOnly());
            this._nextButton.setEnabled(this.isEnabled());
        }
        if (this._prevButton != null) {
            this._prevButton.setVisible(this.isShowPreviousButton() && !this.isViewOnly());
            this._prevButton.setEnabled(this.isEnabled());
        }
        if (this._nextYearButton != null) {
            this._nextYearButton.setVisible(this.isShowNextYearButton() && !this.isViewOnly() && this.isShowYearButtons());
            this._nextYearButton.setEnabled(this.isEnabled());
        }
        if (this._prevYearButton != null) {
            this._prevYearButton.setVisible(this.isShowPreviousYearButton() && !this.isViewOnly() && this.isShowYearButtons());
            this._prevYearButton.setEnabled(this.isEnabled());
        }
        if (this._buttonPanel != null) {
            this.updateButtons(this._buttonPanel);
        }
        if (this._timeSpinner != null) {
            this._timeSpinner.setEnabled(bl);
        }
    }

    protected void checkShortenLabels() {
        Calendar calendar = this.getMidnight();
        calendar.set(2003, 6, 27);
        calendar.add(5, this.getFirstDayOfWeek() - 1);
        this.shortenLabels = false;
        for (JComponent jComponent : this._weekLabel) {
            Graphics graphics;
            String string = this.getWeekFormatter().format(calendar.getTime());
            Dimension dimension = jComponent.getSize();
            if (dimension.width != 0 && dimension.height != 0 && (graphics = jComponent.getGraphics()) != null) {
                Insets insets = jComponent.getInsets();
                Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(string, graphics);
                if (rectangle2D.getWidth() + (double)insets.left + (double)insets.right > (double)dimension.width) {
                    this.shortenLabels = true;
                    return;
                }
            }
            calendar.add(7, 1);
        }
    }

    protected void updateDayOfWeekLabel(JComponent jComponent, Calendar calendar) {
        String string = this.getWeekFormatter().format(calendar.getTime());
        if (this.isAlwaysShowShortWeekLabels() || this.isShowShortWeekLabels() && this.shortenLabels) {
            string = SystemInfo.isCJKLocale(this.getLocale()) ? "" + string.charAt(string.length() - 1) : "" + string.charAt(0);
        }
        if (jComponent instanceof JLabel) {
            ((JLabel)jComponent).setText(string);
        } else if (jComponent instanceof AbstractButton) {
            ((AbstractButton)jComponent).setText(string);
        } else if (jComponent instanceof JTextComponent) {
            ((JTextComponent)jComponent).setText(string);
        }
        jComponent.setEnabled(this.isEnabled());
    }

    protected void updateWeekOfYearLabel(JComponent jComponent, Calendar calendar) {
        String string = "" + calendar.get(3);
        if (jComponent instanceof JLabel) {
            ((JLabel)jComponent).setText(string);
        } else if (jComponent instanceof AbstractButton) {
            ((AbstractButton)jComponent).setText(string);
        } else if (jComponent instanceof JTextComponent) {
            ((JTextComponent)jComponent).setText(string);
        }
        jComponent.setEnabled(this.isEnabled());
    }

    protected void updateDateLabel(JComponent jComponent, Calendar calendar, boolean bl, boolean bl2, boolean bl3) {
        String string;
        String string2 = string = calendar == null ? "" : String.valueOf(calendar.get(5));
        if (jComponent instanceof JLabel) {
            ((JLabel)jComponent).setText(string);
        } else if (jComponent instanceof AbstractButton) {
            ((AbstractButton)jComponent).setText(string);
        } else if (jComponent instanceof JTextComponent) {
            ((JTextComponent)jComponent).setText(string);
        }
        jComponent.setName(string);
        if (!this.isValidDate(calendar)) {
            jComponent.setEnabled(false);
            jComponent.setBackground(new Color(230, 230, 230));
            if (jComponent instanceof AbstractButton) {
                ((AbstractButton)jComponent).setSelected(false);
            }
        } else {
            jComponent.setEnabled(this.isEnabled());
            if (bl) {
                if (jComponent instanceof AbstractButton) {
                    ((AbstractButton)jComponent).setSelected(true);
                    if (!bl3) {
                        jComponent.setBackground(this.getBackground());
                        jComponent.setForeground(this._inactiveDateColor);
                    } else {
                        jComponent.setBackground(this.getBackground());
                        jComponent.setForeground(this.getForeground());
                    }
                } else if (!bl3) {
                    jComponent.setBackground(this._selectedDateBackground);
                    jComponent.setForeground(this._inactiveDateColor);
                } else {
                    jComponent.setBackground(this._selectedDateBackground);
                    jComponent.setForeground(this._selectedDateForeground);
                }
            } else {
                if (jComponent instanceof AbstractButton) {
                    ((AbstractButton)jComponent).setSelected(false);
                } else {
                    jComponent.setForeground(this.getForeground());
                }
                if (!bl3) {
                    jComponent.setBackground(this.getBackground());
                    jComponent.setForeground(this._inactiveDateColor);
                } else {
                    jComponent.setBackground(this.getBackground());
                    jComponent.setForeground(this.getForeground());
                }
            }
        }
        if (bl2 && this.isTodayHighlighted()) {
            jComponent.setBorder(this._todayBorder);
        } else {
            jComponent.setBorder(this._cellBorder);
        }
    }

    private boolean isValidDate(Calendar calendar) {
        boolean bl = true;
        if (calendar == null) {
            bl = false;
        }
        if (bl && !this._dateModel.isValidDate(calendar)) {
            bl = false;
        }
        if (!bl && this._dateModel.isCompareTime()) {
            bl = this._dateModel.dayInRange(calendar);
        }
        return bl;
    }

    protected void updateMonthLabel(JComponent jComponent, Calendar calendar) {
        if (jComponent instanceof JLabel) {
            ((JLabel)jComponent).setText(this.getMonthFormatter().format(calendar.getTime()));
        } else if (jComponent instanceof AbstractButton) {
            ((AbstractButton)jComponent).setText(this.getMonthFormatter().format(calendar.getTime()));
        }
        jComponent.setEnabled(this.isEnabled());
    }

    protected void updateYearLabel(JComponent jComponent, Calendar calendar) {
        if (jComponent instanceof JLabel) {
            ((JLabel)jComponent).setText(this.getYearFormatter().format(calendar.getTime()));
        } else if (jComponent instanceof AbstractButton) {
            ((AbstractButton)jComponent).setText(this.getYearFormatter().format(calendar.getTime()));
        }
        jComponent.setEnabled(this.isEnabled());
    }

    protected JComponent createMonthLabel() {
        if (!this.isShowMonthMenu()) {
            return new NullLabel("");
        }
        NullJideButton nullJideButton = new NullJideButton("XXXXXXXXXXXX");
        nullJideButton.setMargin(new Insets(0, 0, 0, 0));
        nullJideButton.setBorder(BorderFactory.createEmptyBorder());
        nullJideButton.setButtonStyle(3);
        return nullJideButton;
    }

    protected JComponent createYearLabel() {
        if (this.isShowYearSpinner()) {
            NullJideButton nullJideButton = new NullJideButton("00000");
            nullJideButton.setMargin(new Insets(0, 0, 0, 0));
            nullJideButton.setBorder(BorderFactory.createEmptyBorder());
            nullJideButton.setButtonStyle(3);
            return nullJideButton;
        }
        return new NullLabel("");
    }

    public int getFirstDayOfWeek() {
        if (this._firstDayOfWeek == -1) {
            Calendar calendar = this.getMidnight();
            return calendar.getFirstDayOfWeek();
        }
        return this._firstDayOfWeek;
    }

    public void setFirstDayOfWeek(int n) {
        if (n < this.getMidnight().getActualMinimum(7) || n > this.getMidnight().getActualMaximum(7)) {
            throw new IllegalArgumentException("firstDayOfWeek must be between " + this.getMidnight().getActualMinimum(7) + " and " + this.getMidnight().getActualMaximum(7));
        }
        this._firstDayOfWeek = n;
    }

    public boolean isShowWeekNumbers() {
        return this._showWeekNumbers;
    }

    public void setShowWeekNumbers(boolean bl) {
        boolean bl2 = this._showWeekNumbers;
        if (bl2 != bl) {
            this._showWeekNumbers = bl;
            this._weekOfYearPanel.setVisible(this.isShowWeekNumbers());
            this.firePropertyChange(PROPERTY_SHOW_WEEK_NUMBERS, bl2, this._showWeekNumbers);
        }
    }

    public boolean isShowTodayButton() {
        return this._showTodayButton;
    }

    public void setShowTodayButton(boolean bl) {
        boolean bl2 = this._showTodayButton;
        if (bl2 != bl) {
            this._showTodayButton = bl;
            if (this._buttonPanel != null) {
                this.updateButtons(this._buttonPanel);
            }
            this.firePropertyChange(PROPERTY_SHOW_TODAY_BUTTON, bl2, this._showTodayButton);
        }
    }

    public boolean isShowNoneButton() {
        return this._showNoneButton;
    }

    public void setShowNoneButton(boolean bl) {
        boolean bl2 = this._showNoneButton;
        if (bl2 != bl) {
            this._showNoneButton = bl;
            if (this._buttonPanel != null) {
                this.updateButtons(this._buttonPanel);
            }
            this.firePropertyChange(PROPERTY_SHOW_NONE_BUTTON, bl2, this._showNoneButton);
        }
    }

    public boolean isShowOKButton() {
        return this.isTimeDisplayed() && !this._showOKButtonSet || this._showOKButton;
    }

    public void setShowOKButton(boolean bl) {
        boolean bl2 = this._showOKButton;
        this._showOKButtonSet = true;
        if (bl2 != bl) {
            this._showOKButton = bl;
            if (this._buttonPanel != null) {
                this.updateButtons(this._buttonPanel);
            }
            this.firePropertyChange(PROPERTY_SHOW_OK_BUTTON, bl2, this._showOKButton);
        }
    }

    public boolean isShowPreviousButton() {
        return this._showPreviousButton;
    }

    public void setShowPreviousButton(boolean bl) {
        boolean bl2 = this._showPreviousButton;
        if (this.isViewOnly()) {
            bl = false;
        }
        if (bl2 != bl) {
            this._showPreviousButton = bl;
            if (this._prevButton != null) {
                this._prevButton.setVisible(this.isShowPreviousButton());
            }
            this.firePropertyChange(PROPERTY_SHOW_PREVIOUS_BUTTON, bl2, this._showPreviousButton);
        }
    }

    public boolean isShowNextButton() {
        return this._showNextButton;
    }

    public void setShowNextButton(boolean bl) {
        boolean bl2 = this._showNextButton;
        if (this.isViewOnly()) {
            bl = false;
        }
        if (bl2 != bl) {
            this._showNextButton = bl;
            if (this._nextButton != null) {
                this._nextButton.setVisible(this.isShowNextButton());
            }
            this.firePropertyChange(PROPERTY_SHOW_NEXT_BUTTON, bl2, this._showNextButton);
        }
    }

    public boolean isShowPreviousYearButton() {
        return this._showPreviousYearButton;
    }

    public void setShowPreviousYearButton(boolean bl) {
        boolean bl2 = this._showPreviousYearButton;
        if (this.isViewOnly()) {
            bl = false;
        }
        if (bl2 != bl) {
            this._showPreviousYearButton = bl;
            if (this._prevYearButton != null) {
                this._prevYearButton.setVisible(this.isShowPreviousYearButton() && this.isShowYearButtons());
            }
            this.firePropertyChange(PROPERTY_SHOW_PREVIOUS_YEAR_BUTTON, bl2, this._showPreviousYearButton);
        }
    }

    public boolean isShowNextYearButton() {
        return this._showNextYearButton;
    }

    public void setShowNextYearButton(boolean bl) {
        boolean bl2 = this._showNextYearButton;
        if (this.isViewOnly()) {
            bl = false;
        }
        if (bl2 != bl) {
            this._showNextYearButton = bl;
            if (this._nextYearButton != null) {
                this._nextYearButton.setVisible(this.isShowNextYearButton() && this.isShowYearButtons());
            }
            this.firePropertyChange(PROPERTY_SHOW_NEXT_YEAR_BUTTON, bl2, this._showNextYearButton);
        }
    }

    public boolean isShowPreviousMonthDays() {
        return this._showPreviousMonthDays;
    }

    public void setShowPreviousMonthDays(boolean bl) {
        boolean bl2 = this._showPreviousMonthDays;
        if (bl2 != bl) {
            this._showPreviousMonthDays = bl;
            this.updateCalendar();
            this.firePropertyChange(PROPERTY_SHOW_PREVIOUS_MONTH_DAYS, bl2, this._showPreviousMonthDays);
        }
    }

    public boolean isShowNextMonthDays() {
        return this._showNextMonthDays;
    }

    public void setShowNextMonthDays(boolean bl) {
        boolean bl2 = this._showNextMonthDays;
        if (bl2 != bl) {
            this._showNextMonthDays = bl;
            this.updateCalendar();
            this.firePropertyChange(PROPERTY_SHOW_NEXT_MONTH_DAYS, bl2, this._showNextMonthDays);
        }
    }

    protected void registerKeyStrokes() {
        AbstractAction abstractAction = new AbstractAction(){
            private static final long serialVersionUID = 79628587978713129L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DateChooserPanel.this._selectedCalendar != null) {
                    Date date = DateChooserPanel.this._selectedCalendar.getTime();
                    DateChooserPanel.this.changeSelection(date, JideSwingUtilities.isMenuShortcutKeyDown(actionEvent), (1 & actionEvent.getModifiers()) != 0);
                }
            }
        };
        this.registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(32, 0), 1);
        this.registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(32, 2), 1);
        this.registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(32, 1), 1);
        this.registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(32, 3), 1);
        AbstractAction abstractAction2 = new AbstractAction(){
            private static final long serialVersionUID = -4766806573040425384L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateChooserPanel.this.prevDay();
            }
        };
        this.registerKeyboardAction(abstractAction2, KeyStroke.getKeyStroke(37, 0), 1);
        AbstractAction abstractAction3 = new AbstractAction(){
            private static final long serialVersionUID = -4654646314492211759L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateChooserPanel.this.nextDay();
            }
        };
        this.registerKeyboardAction(abstractAction3, KeyStroke.getKeyStroke(39, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = 3237543159306272523L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateChooserPanel.this.prevWeek();
            }
        }, KeyStroke.getKeyStroke(38, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = 743998151657619246L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateChooserPanel.this.nextWeek();
            }
        }, KeyStroke.getKeyStroke(40, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = 7077192901102522429L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateChooserPanel.this.prevMonth();
            }
        }, KeyStroke.getKeyStroke(33, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = -1709929784772129352L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateChooserPanel.this.nextMonth();
            }
        }, KeyStroke.getKeyStroke(34, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = -3158264898060349712L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateChooserPanel.this.prevYear();
            }
        }, KeyStroke.getKeyStroke(33, 128), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = 3786384379181045276L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateChooserPanel.this.nextYear();
            }
        }, KeyStroke.getKeyStroke(34, 128), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = -7164895810743192124L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateChooserPanel.this.firstDayOfMonth();
            }
        }, KeyStroke.getKeyStroke(36, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = -7005194727235200183L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateChooserPanel.this.lastDayOfMonth();
            }
        }, KeyStroke.getKeyStroke(35, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = 697712394243355450L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateChooserPanel.this.commit();
            }
        }, KeyStroke.getKeyStroke(10, 0), 1);
    }

    protected void initDateFormat(Locale locale) {
        this._monthFormatter = new SimpleDateFormat("MMMM", locale);
        this._yearFormatter = new SimpleDateFormat("yyyy", locale);
        this._weekFormatter = new SimpleDateFormat("E", locale);
        this._weekOfYearFormatter = new SimpleDateFormat("w", locale);
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this._inited) {
            if (this._todayButton != null) {
                this.updateTextAndMnemonic(this._todayButton, this.isTimeDisplayed() ? "now" : "today", locale);
            }
            if (this._noneButton != null) {
                this.updateTextAndMnemonic(this._noneButton, "none", locale);
            }
            if (this._okButton != null) {
                this.updateTextAndMnemonic(this._okButton, "ok", locale);
            }
            this.initDateFormat(locale);
            if (this._dayMap != null) {
                this.updateCalendar();
            }
        }
    }

    protected void updateTextAndMnemonic(AbstractButton abstractButton, String string, Locale locale) {
        abstractButton.setText(this.getResourceString("Date." + string, locale));
        String string2 = null;
        try {
            string2 = this.getResourceString("Date." + string + ".mnemonic", locale);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string2 != null && string2.length() > 0 && !this.isTimeDisplayed()) {
            abstractButton.setMnemonic(string2.charAt(0));
        } else {
            abstractButton.setDisplayedMnemonicIndex(-1);
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.updateCalendar();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.updateCalendar();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        boolean bl;
        if (this.isViewOnly()) {
            return;
        }
        int n = mouseWheelEvent.getUnitsToScroll();
        boolean bl2 = bl = n < 0;
        if (bl) {
            if (JideSwingUtilities.isMenuShortcutKeyDown(mouseWheelEvent)) {
                this.prevDisplayYear();
            } else {
                this.prevDisplayMonth();
            }
        } else if (JideSwingUtilities.isMenuShortcutKeyDown(mouseWheelEvent)) {
            this.nextDisplayYear();
        } else {
            this.nextDisplayMonth();
        }
    }

    public void enableMouseWheel() {
        this.removeMouseWheelListener(this);
        this.addMouseWheelListener(this);
    }

    public void disableMouseWheel() {
        this.removeMouseWheelListener(this);
    }

    protected JComponent getYearLabel() {
        return this._yearLabel;
    }

    protected void setYearLabel(JComponent jComponent) {
        this._yearLabel = jComponent;
    }

    protected JComponent getMonthLabel() {
        return this._monthLabel;
    }

    protected void setMonthLabel(JComponent jComponent) {
        this._monthLabel = jComponent;
    }

    protected JComponent getYearSpinner() {
        return this._yearSpinner;
    }

    protected void setYearSpinner(JComponent jComponent) {
        this._yearSpinner = jComponent;
    }

    protected void setYearModel(SpinnerModel spinnerModel) {
        this._yearModel = spinnerModel;
    }

    protected SpinnerModel getYearModel() {
        return this._yearModel;
    }

    protected void setMonthYearBackground(Color color) {
        this._monthyearBackground = color;
    }

    protected Color getMonthYearBackground() {
        if (this.getMonthYearPanel() != null) {
            return this.getMonthYearPanel().getBackground();
        }
        return this._monthyearBackground;
    }

    protected void setMonthYearForeground(Color color) {
        this._monthyearForeground = color;
    }

    protected Color getMonthYearForeground() {
        if (this.getMonthYearPanel() != null) {
            return this.getMonthYearPanel().getForeground();
        }
        return this._monthyearForeground;
    }

    protected void setMonthYearPanel(JPanel jPanel) {
        this._monthyearPanel = jPanel;
    }

    protected JPanel getMonthYearPanel() {
        return this._monthyearPanel;
    }

    public JPanel getTitlePanel() {
        return this._titlePanel;
    }

    protected void setNextYearButton(AbstractButton abstractButton) {
        this._nextYearButton = abstractButton;
    }

    protected AbstractButton getNextYearButton() {
        return this._nextYearButton;
    }

    protected void setPrevYearButton(AbstractButton abstractButton) {
        this._prevYearButton = abstractButton;
    }

    protected AbstractButton getPrevYearButton() {
        return this._prevYearButton;
    }

    protected void setNextButton(AbstractButton abstractButton) {
        this._nextButton = abstractButton;
    }

    protected AbstractButton getNextButton() {
        return this._nextButton;
    }

    protected void setPrevButton(AbstractButton abstractButton) {
        this._prevButton = abstractButton;
    }

    protected AbstractButton getPrevButton() {
        return this._prevButton;
    }

    protected Map<Component, Date> getDayMap() {
        return this._dayMap;
    }

    protected void setMonthYearBorder(Border border) {
        this._monthyearBorder = border;
    }

    protected Border getMonthYearBorder() {
        return this._monthyearBorder;
    }

    protected void setButtonPanel(ButtonPanel buttonPanel) {
        this._buttonPanel = buttonPanel;
    }

    protected ButtonPanel getButtonPanel() {
        return this._buttonPanel;
    }

    protected void setTodayButton(AbstractButton abstractButton) {
        this._todayButton = abstractButton;
    }

    protected AbstractButton getTodayButton() {
        return this._todayButton;
    }

    protected void setNoneButton(AbstractButton abstractButton) {
        this._noneButton = abstractButton;
    }

    protected AbstractButton getNoneButton() {
        return this._noneButton;
    }

    protected void setButtonsBorder(Border border) {
        this._buttonsBorder = border;
    }

    protected Border getButtonsBorder() {
        return this._buttonsBorder;
    }

    protected Border getEmptyBorder() {
        return this._border;
    }

    protected void setTodayCalendar(Calendar calendar) {
        this._todayCalendar = calendar;
        this.setTodayYear(this._todayCalendar.get(1));
        this.setTodayMonth(this._todayCalendar.get(2));
        this.setTodayDay(this._todayCalendar.get(5));
    }

    protected Calendar getTodayCalendar() {
        return this._todayCalendar;
    }

    protected void setTodayYear(int n) {
        this._todayYear = n;
    }

    protected int getTodayYear() {
        return this._todayYear;
    }

    protected void setTodayMonth(int n) {
        this._todayMonth = n;
    }

    protected int getTodayMonth() {
        return this._todayMonth;
    }

    protected void setTodayDay(int n) {
        this._todayDay = n;
    }

    protected int getTodayDay() {
        return this._todayDay;
    }

    protected void setSelectedYear(int n) {
        this._selectedYear = n;
    }

    protected int getSelectedYear() {
        return this._selectedYear;
    }

    protected void setSelectedMonth(int n) {
        this._selectedMonth = n;
    }

    protected int getSelectedMonth() {
        return this._selectedMonth;
    }

    protected void setSelectedDay(int n) {
        this._selectedDay = n;
    }

    protected int getSelectedDay() {
        return this._selectedDay;
    }

    public int getSelectedHour() {
        return this._selectedHour;
    }

    public void setSelectedHour(int n) {
        this._selectedHour = n;
    }

    public int getSelectedMinute() {
        return this._selectedMinute;
    }

    public void setSelectedMinute(int n) {
        this._selectedMinute = n;
    }

    public int getSelectedSecond() {
        return this._selectedSecond;
    }

    public void setSelectedSecond(int n) {
        this._selectedSecond = n;
    }

    public int getSelectedMillisecond() {
        return this._selectedMillisecond;
    }

    public void setSelectedMillisecond(int n) {
        this._selectedMillisecond = n;
    }

    protected void setShowShortWeekLabels(boolean bl) {
        this._showShortWeekLabels = bl;
    }

    protected boolean isShowShortWeekLabels() {
        return this._showShortWeekLabels;
    }

    public void setTodayHighlighted(boolean bl) {
        boolean bl2 = this._todayHighlighted;
        if (bl2 != bl) {
            this._todayHighlighted = bl;
            this.firePropertyChange(PROPERTY_TODAY_HIGHLIGHTED, bl2, this._todayHighlighted);
            this.updateCalendar();
        }
    }

    public boolean isTodayHighlighted() {
        return this._todayHighlighted;
    }

    protected boolean isDateSelected(Calendar calendar) {
        this.getSelectionModel().setTimeZone(calendar.getTimeZone());
        return this.getSelectionModel().isSelectedDate(calendar.getTime());
    }

    public boolean isAlwaysShowShortWeekLabels() {
        return this._alwaysShowShortWeekLabels;
    }

    public void setAlwaysShowShortWeekLabels(boolean bl) {
        this._alwaysShowShortWeekLabels = bl;
    }

    protected boolean isToday(Calendar calendar) {
        return calendar.get(1) == this._todayYear && calendar.get(2) == this._todayMonth && calendar.get(5) == this._todayDay;
    }

    protected String getResourceString(String string, Locale locale) {
        return DateResource.getResourceBundle(locale).getString(string);
    }

    public SimpleDateFormat getMonthFormatter() {
        this._monthFormatter.setTimeZone(this.getTimeZone());
        return this._monthFormatter;
    }

    public SimpleDateFormat getYearFormatter() {
        this._yearFormatter.setTimeZone(this.getTimeZone());
        return this._yearFormatter;
    }

    public SimpleDateFormat getWeekFormatter() {
        this._weekFormatter.setTimeZone(this.getTimeZone());
        return this._weekFormatter;
    }

    public SimpleDateFormat getWeekOfYearFormatter() {
        this._weekOfYearFormatter.setTimeZone(this.getTimeZone());
        return this._weekOfYearFormatter;
    }

    public boolean isShowYearButtons() {
        return this._showYearButtons;
    }

    public void setShowYearButtons(boolean bl) {
        boolean bl2 = this._showYearButtons;
        if (bl2 != bl) {
            this._showYearButtons = bl;
            if (this._nextYearButton != null) {
                this._nextYearButton.setVisible(this.isShowNextYearButton() && !this.isViewOnly() && this.isShowYearButtons());
            }
            if (this._prevYearButton != null) {
                this._prevYearButton.setVisible(this.isShowPreviousYearButton() && !this.isViewOnly() && this.isShowYearButtons());
            }
            this.firePropertyChange(PROPERTY_SHOW_YEAR_BUTTONS, bl2, this._showYearButtons);
        }
    }

    public boolean isShowMonthMenu() {
        return this._showMonthMenu;
    }

    public void setShowMonthMenu(boolean bl) {
        if (this._showMonthMenu == bl) {
            return;
        }
        this._showMonthMenu = bl;
        if (this._monthyearPanel != null) {
            if (this._monthLabel != null) {
                this._monthLabel.removeMouseListener(this);
                this._monthyearPanel.remove(this._monthLabel);
            }
            this._monthLabel = this.createMonthLabel();
            if (this._monthLabel instanceof JButton) {
                this._monthLabel.addMouseListener(this);
            }
            this.updateMonthLabel(this._monthLabel, (Calendar)this._displayedCalendar.clone());
            this._monthyearPanel.add((Component)this._monthLabel, 0);
            this._monthyearPanel.revalidate();
            this._monthyearPanel.repaint();
        }
    }

    public boolean isShowYearSpinner() {
        return this._showYearSpinner;
    }

    public void setShowYearSpinner(boolean bl) {
        if (this._showYearSpinner == bl) {
            return;
        }
        this._showYearSpinner = bl;
        if (this._monthyearPanel != null) {
            if (this._spinnerVisible) {
                this._monthyearPanel.remove(this._yearSpinner);
            } else {
                this._monthyearPanel.remove(this._yearLabel);
            }
            if (this._yearLabel != null && this._yearLabelListener != null) {
                this._yearLabel.removeMouseListener(this._yearLabelListener);
            }
            this._yearLabel = this.createYearLabel();
            if (this._yearLabelListener == null) {
                this._yearLabelListener = this.createYearLabelListener();
            }
            this._yearLabel.addMouseListener(this._yearLabelListener);
            this.updateYearLabel(this._yearLabel, (Calendar)this._displayedCalendar.clone());
            this._monthyearPanel.add(this._yearLabel);
            this._monthyearPanel.revalidate();
            this._monthyearPanel.repaint();
        }
    }

    public boolean isToggleMode() {
        return this._toggleMode;
    }

    public void setToggleMode(boolean bl) {
        this._toggleMode = bl;
    }

    public boolean isSelectDateOnSameMonth() {
        return this._selectDateOnSameMonth;
    }

    public void setSelectDateOnSameMonth(boolean bl) {
        this._selectDateOnSameMonth = bl;
    }

    public boolean isSelectAllDatesOnToggleMode() {
        return this._selectAllDatesOnToggleMode;
    }

    public void setSelectAllDatesOnToggleMode(boolean bl) {
        this._selectAllDatesOnToggleMode = bl;
    }

    Date getAnchorDate() {
        return this._anchorDate;
    }

    void setAnchorDate(Date date, boolean bl) {
        this._anchorDate = date;
        if (bl && this.getCalendarViewer() != null) {
            for (DateChooserPanel dateChooserPanel : this.getCalendarViewer().getDateChooserPanels()) {
                if (dateChooserPanel == this) continue;
                dateChooserPanel.setAnchorDate(date, false);
            }
        }
    }

    Date getLeadDate() {
        return this._leadDate;
    }

    void setLeadDate(Date date, boolean bl) {
        this._leadDate = date;
        if (bl && this.getCalendarViewer() != null) {
            for (DateChooserPanel dateChooserPanel : this.getCalendarViewer().getDateChooserPanels()) {
                if (dateChooserPanel == this) continue;
                dateChooserPanel.setLeadDate(date, false);
            }
        }
    }

    Date getSelectedDateInMemory() {
        return this._selectedCalendar == null ? null : this._selectedCalendar.getTime();
    }

    public boolean isTimeDisplayed() {
        return this._timeDisplayed;
    }

    public void setTimeDisplayed(boolean bl) {
        this._timeDisplayed = bl;
        if (this._timeSpinner != null) {
            this._timeSpinner.setVisible(this.isTimeDisplayed());
        }
        this.setDisplayedTime(this._selectedCalendar);
        if (this._buttonPanel != null) {
            this.updateButtons(this._buttonPanel);
        }
        if (this._todayButton != null) {
            Locale locale = this.getLocale();
            this.updateTextAndMnemonic(this._todayButton, this.isTimeDisplayed() ? "now" : "today", locale);
        }
    }

    @Override
    public Component getDefaultFocusComponent() {
        if (this.isTimeDisplayed()) {
            return this._timeSpinner;
        }
        return super.getDefaultFocusComponent();
    }

    public String getTimeFormat() {
        return this.getDateModel().getTimeFormat();
    }

    public DateSelectionModel getSelectionModel() {
        return this._selectionModel;
    }

    public void setSelectionModel(DateSelectionModel dateSelectionModel) {
        if (dateSelectionModel == null) {
            throw new IllegalArgumentException("null model");
        }
        if (!dateSelectionModel.equals(this._selectionModel)) {
            DateSelectionModel dateSelectionModel2 = this._selectionModel;
            this._selectionModel = dateSelectionModel;
            this.firePropertyChange("dateSelectionModel", dateSelectionModel2, dateSelectionModel);
            this.repaint();
            this.revalidate();
        }
    }

    public Calendar changeSelection(Date date, boolean bl, boolean bl2) {
        Calendar calendar = this.updateDisplayedTime(date);
        if (!this.isValidDate(calendar)) {
            return null;
        }
        this.changeSelectionModel(calendar.getTime(), bl, bl2);
        this.updateCalendar();
        this.repaint();
        return calendar;
    }

    private void changeSelectionModel(Date date, boolean bl, boolean bl2) {
        this.getSelectionModel().setValueIsAdjusting(true);
        if (bl2) {
            if (bl) {
                this.getSelectionModel().addSelectionInterval(this.getSelectionModel().getAnchorSelectionDate(), date);
            } else {
                this.getSelectionModel().setSelectionInterval(this.getSelectionModel().getAnchorSelectionDate(), date);
            }
        } else if (bl) {
            if (this.getSelectionModel().isSelectedDate(date)) {
                this.getSelectionModel().removeSelectionInterval(date, date);
            } else {
                this.getSelectionModel().addSelectionInterval(date, date);
            }
        } else {
            this.getSelectionModel().setSelectionInterval(date, date);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        if (this.isSingleClickToSelect()) {
            this.setSelectedDate(date);
        }
    }

    private void changeSelection(Set<Date> set, boolean bl, boolean bl2) {
        this.getSelectionModel().setValueIsAdjusting(true);
        for (Date date : set) {
            Calendar calendar = this.updateDisplayedTime(date);
            if (!this.isValidDate(calendar)) continue;
            if (bl2) {
                if (bl) {
                    this.getSelectionModel().addSelectionInterval(this.getSelectionModel().getAnchorSelectionDate(), date);
                } else {
                    this.getSelectionModel().setSelectionInterval(this.getSelectionModel().getAnchorSelectionDate(), date);
                }
            } else if (bl) {
                if (this.getSelectionModel().isSelectedDate(date)) {
                    this.getSelectionModel().removeSelectionInterval(date, date);
                } else {
                    this.getSelectionModel().addSelectionInterval(date, date);
                }
            } else {
                this.getSelectionModel().setSelectionInterval(date, date);
            }
            if (!this.isSingleClickToSelect()) continue;
            this.setSelectedDate(date);
        }
        this.updateCalendar();
        this.getSelectionModel().setValueIsAdjusting(false);
    }

    protected boolean isDoubleClickToSelect() {
        return true;
    }

    protected boolean isSingleClickToSelect() {
        return this.getSelectionModel().getSelectionMode() == 0 && !this.isShowOKButton();
    }

    public int getDisplayIndex() {
        return this._displayIndex;
    }

    public void setDisplayIndex(int n) {
        this._displayIndex = n;
    }

    public CalendarViewer getCalendarViewer() {
        return this._calendarViewer;
    }

    public void setCalendarViewer(CalendarViewer calendarViewer) {
        this._calendarViewer = calendarViewer;
    }

    public TimeZone getTimeZone() {
        return this.getDateModel().getTimeZone();
    }

    public void setTimeZone(TimeZone timeZone) {
        this.getDateModel().setTimeZone(timeZone);
    }

    protected Calendar createCalendarInstance() {
        return this.getDateModel().createCalendarInstance();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.paintVerticalLine(graphics);
    }

    private void paintVerticalLine(Graphics graphics) {
        if (!this.isShowWeekNumbers()) {
            return;
        }
        Color color = graphics.getColor();
        graphics.setColor(UIDefaultsLookup.getColor("TextField.foreground"));
        Rectangle rectangle = this._weekOfYearPanel.getBounds();
        Container container = this._weekOfYearPanel.getParent();
        while (!(container instanceof DateChooserPanel)) {
            Rectangle rectangle2 = container.getBounds();
            rectangle.x += rectangle2.x;
            rectangle.y += rectangle2.y;
            container = container.getParent();
        }
        int n = rectangle.y + rectangle.height - 2;
        if (this._lastRowEmpty) {
            n -= this._weekOfYearLabel[this._weekOfYearLabel.length - 1].getBounds().height;
        }
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, n);
        graphics.setColor(color);
    }

    @Override
    void configureSelectAction(DelegateAction delegateAction) {
        super.configureSelectAction(delegateAction);
        for (JComponent jComponent : this._dayLabels) {
            if (jComponent == null) continue;
            DelegateAction.replaceAction(jComponent, 0, KeyStroke.getKeyStroke(10, 0), delegateAction);
        }
        if (this._monthLabel != null) {
            DelegateAction.replaceAction(this._monthLabel, 0, KeyStroke.getKeyStroke(10, 0), delegateAction);
        }
        if (this._yearLabel != null) {
            DelegateAction.replaceAction(this._yearLabel, 0, KeyStroke.getKeyStroke(10, 0), delegateAction);
        }
    }

    JPopupMenu getMonthMenu() {
        return this._monthMenu;
    }

    class MonthNavigationButton
    extends JideButton {
        ImageIcon _icon;

        public MonthNavigationButton(ImageIcon imageIcon) {
            this._icon = imageIcon;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            ImageIcon imageIcon = this.getModel().isRollover() ? new ImageIcon(MaskFilter.createImage(this._icon.getImage(), Color.BLACK, DateChooserPanel.this.getMonthYearForeground().darker().darker())) : new ImageIcon(MaskFilter.createImage(this._icon.getImage(), Color.BLACK, this.isEnabled() ? DateChooserPanel.this.getMonthYearForeground() : Color.GRAY));
            boolean bl = this.getComponentOrientation().isLeftToRight();
            if (bl) {
                imageIcon.paintIcon(this, graphics, (this.getWidth() - this._icon.getIconWidth()) / 2, (this.getHeight() - this._icon.getIconHeight()) / 2);
            } else {
                IconsFactory.createRotatedImage(this, imageIcon, 180.0).paintIcon(this, graphics, (this.getWidth() - this._icon.getIconWidth()) / 2, (this.getHeight() - this._icon.getIconHeight()) / 2);
            }
        }
    }
}

