/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.style;

import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;

public class StripePaint
implements Paint {
    private TexturePaint texturePaint;
    private int width;
    private int height;
    private float lineWidth;
    private double angle;
    private Paint background = Color.white;
    private Color foreground = Color.black;
    private BasicStroke stroke;

    public StripePaint(double d, int n) {
        this(d, n, 1.0f);
    }

    public StripePaint(int n, int n2) {
        this(n, n2, 1.0f);
    }

    public StripePaint(int n, int n2, float f) {
        this(Math.toRadians(n), n2, f);
    }

    public StripePaint(double d, int n, float f) {
        this(d, n, new BasicStroke(f, 2, 2));
    }

    public StripePaint(int n, int n2, BasicStroke basicStroke) {
        this(Math.toRadians(n), n2, basicStroke);
    }

    public StripePaint(double d, int n, BasicStroke basicStroke) {
        this.angle = d;
        this.stroke = basicStroke;
        this.width = (int)Math.abs((double)n * Math.cos(d));
        this.height = (int)Math.abs((double)n * Math.sin(d));
        if (d == 0.0 || d == 1.5707963267948966) {
            this.width = n;
            this.height = n;
        }
        this.lineWidth = basicStroke.getLineWidth();
        if ((float)this.height < this.lineWidth) {
            this.height = (int)this.lineWidth;
        }
        if ((float)this.width < this.lineWidth) {
            this.width = (int)this.lineWidth;
        }
    }

    public Paint getBackground() {
        return this.background;
    }

    public void setBackground(Paint paint) {
        this.background = paint;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    private TexturePaint getTexture() {
        if (this.texturePaint == null) {
            BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setClip(null);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setPaint(this.background);
            graphics2D.fillRect(0, 0, this.width, this.height);
            graphics2D.setStroke(this.stroke);
            graphics2D.setColor(this.foreground);
            if (this.angle == 1.5707963267948966) {
                graphics2D.drawLine(this.width / 2, 0, this.width / 2, this.height);
            } else if (this.angle > 0.0) {
                graphics2D.drawLine(0, 0, this.width, this.height);
                graphics2D.drawLine(-this.width, 0, this.width, this.height * 2);
                graphics2D.drawLine(0, -this.height, this.width * 2, this.height);
            } else if (this.angle < 0.0) {
                graphics2D.drawLine(0, this.height, this.width, 0);
                graphics2D.drawLine(-this.width, this.height, this.width, -this.height);
                graphics2D.drawLine(0, 2 * this.height, this.width * 2, 0);
            } else {
                graphics2D.drawLine(0, this.height / 2, this.width, this.height / 2);
            }
            this.texturePaint = new TexturePaint(bufferedImage, new Rectangle(0, 0, this.width, this.height));
            graphics2D.dispose();
        }
        return this.texturePaint;
    }

    @Override
    public int getTransparency() {
        return this.getTexture().getTransparency();
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        return this.getTexture().createContext(colorModel, rectangle, rectangle2D, affineTransform, renderingHints);
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4096)) {
            Lm.showInvalidProductMessage(StripePaint.class.getName(), 4096);
        }
    }
}

