/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.event.PointDescriptor;
import com.jidesoft.chart.model.ChartCategory;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.model.Highlightable;
import com.jidesoft.chart.render.AbstractPieSegmentRenderer;
import com.jidesoft.chart.render.PieLabelRenderer;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.util.ColorFactory;
import com.jidesoft.range.Positionable;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.ColorUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.ListSelectionModel;

public class RaisedPieSegmentRenderer
extends AbstractPieSegmentRenderer {
    private double highlightCenterOffsetX = -0.035;
    private double highlightCenterOffsetY = -0.035;

    public double getHighlightCenterOffsetX() {
        return this.highlightCenterOffsetX;
    }

    public void setHighlightCenterOffsetX(double d) {
        this.highlightCenterOffsetX = d;
    }

    public double getHighlightCenterOffsetY() {
        return this.highlightCenterOffsetY;
    }

    public void setHighlightCenterOffsetY(double d) {
        this.highlightCenterOffsetY = d;
    }

    @Override
    public void renderSegments(Graphics graphics, Chart chart, ChartModel chartModel, Point point, int n, int[] nArray) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        ChartStyle chartStyle = chart == null || chart.getStyle(chartModel) == null ? new ChartStyle() : chart.getStyle(chartModel);
        int n2 = point.x;
        int n3 = point.y;
        int n4 = 2 * n;
        int n5 = (int)(0.2 * (double)n);
        int n6 = n2 - n;
        int n7 = n3 - n;
        float f = chartStyle.getPieOffsetAngle();
        for (int i = 0; i < nArray.length; ++i) {
            Object object2;
            object = chartModel.getPoint(i);
            Positionable positionable = object.getX();
            Highlight highlight = null;
            if (object instanceof Highlightable) {
                highlight = ((Highlightable)object).getHighlight();
            }
            if (highlight == null && positionable instanceof ChartCategory) {
                object2 = (ChartCategory)positionable;
                highlight = ((ChartCategory)object2).getHighlight();
            }
            Object object3 = (object2 = chart.getHighlightStyle(highlight)) == null ? chartStyle : object2;
            boolean bl = chart.isRolloverEnabled() && object.equals(chart.getCurrentChartPoint());
            graphics2D.setPaint(this.getPaint((ChartStyle)object3, bl, point, n));
            float f2 = f + (float)nArray[i] / 2.0f;
            ListSelectionModel listSelectionModel = chart.getSelectionsForModel(chartModel);
            boolean bl2 = listSelectionModel.isSelectedIndex(i);
            int n8 = chartStyle.isPieSegmentsAlwaysExploded() || bl2 && chart.isSelectionShowsExplodedSegments() ? (int)((double)n5 * Math.cos(Math.toRadians(f2))) : 0;
            int n9 = chartStyle.isPieSegmentsAlwaysExploded() || bl2 && chart.isSelectionShowsExplodedSegments() ? -((int)((double)n5 * Math.sin(Math.toRadians(f2)))) : 0;
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(n8, n9);
            graphics2D.transform(affineTransform);
            Arc2D.Double double_ = new Arc2D.Double(n6, n7, n4, n4, f, nArray[i], 2);
            PointDescriptor pointDescriptor = new PointDescriptor((Chartable)object, i, chartModel);
            this.recordSegment(affineTransform.createTransformedShape(double_), pointDescriptor);
            Rectangle2D rectangle2D = double_.getBounds2D();
            if (rectangle2D.getHeight() > 0.5 && rectangle2D.getWidth() > 0.5) {
                graphics2D.fill(double_);
            }
            f += (float)nArray[i];
            graphics2D.translate(-n8, -n9);
        }
        f = 0.0f;
        if (this.isAlwaysShowOutlines()) {
            this.renderOutlines(false, graphics2D, chart, chartModel, point, n, nArray, chartStyle);
        }
        this.renderOutlines(true, graphics2D, chart, chartModel, point, n, nArray, chartStyle);
        PieLabelRenderer pieLabelRenderer = this.getPieLabelRenderer();
        if (pieLabelRenderer != null) {
            object = (Graphics2D)this.getLabelGraphics();
            pieLabelRenderer.renderLabels((Graphics)(object == null ? graphics : object), chart, chartModel, point, n4, n4, nArray, chartStyle);
        }
    }

    private Paint getPaint(ChartStyle chartStyle, boolean bl, Point point, int n) {
        Paint paint;
        int n2 = point.x;
        int n3 = point.y;
        Paint paint2 = chartStyle.getBarPaint();
        if (bl) {
            if (paint2 instanceof Color) {
                paint2 = ColorFactory.intensify2((Color)paint2, 50);
            } else if (paint2 instanceof TexturePaint) {
                paint2 = this.modify((TexturePaint)paint2);
            }
        }
        if (paint2 instanceof Color) {
            Color color = (Color)paint2;
            Color color2 = ColorUtils.getDerivedColor(color, 0.25f);
            Color color3 = ColorUtils.getDerivedColor(color, 0.57f);
            Color color4 = ColorUtils.getDerivedColor(color, 0.63f);
            color = ColorUtils.getDerivedColor(color, 0.5f);
            paint = JideSwingUtilities.getRadialGradientPaint(new Point2D.Double((double)n2 + this.highlightCenterOffsetX * (double)n, (double)n3 + this.highlightCenterOffsetY * (double)n), n, new float[]{0.2f, 0.6f, 0.8f, 1.0f}, new Color[]{color4, color3, color, color2});
        } else {
            paint = paint2;
        }
        return paint;
    }
}

