/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.model.ChartCategory;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.render.AbstractBarRenderer;
import com.jidesoft.chart.render.BarRenderer2D;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.range.Positionable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.io.Serializable;

public class CylinderBarRenderer
extends AbstractBarRenderer
implements BarRenderer2D,
Serializable {
    private double depthRatio = 0.23;

    public double getDepthRatio() {
        return this.depthRatio;
    }

    public void setDepthRatio(double d) {
        this.depthRatio = d;
    }

    @Override
    public Shape renderBar(Graphics2D graphics2D, Chart chart, ChartModel chartModel, Chartable chartable, boolean bl, boolean bl2, boolean bl3, double d, double d2, double d3, double d4) {
        double d5;
        Highlight highlight;
        Object object;
        Positionable positionable;
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        boolean bl4 = false;
        ChartStyle chartStyle = chart.getStyle(chartModel);
        Orientation orientation = chartStyle == null ? Orientation.vertical : chartStyle.getBarOrientation();
        Positionable positionable2 = chartable == null ? null : chartable.getX();
        Positionable positionable3 = positionable = chartable == null ? null : chartable.getY();
        if (orientation == Orientation.vertical && positionable2 instanceof ChartCategory) {
            object = (ChartCategory)positionable2;
            highlight = ((ChartCategory)object).getHighlight();
            if (highlight != null) {
                chartStyle = chart.getHighlightStyle(highlight);
            }
        } else if (orientation == Orientation.horizontal && positionable instanceof ChartCategory && (highlight = ((ChartCategory)(object = (ChartCategory)positionable)).getHighlight()) != null) {
            chartStyle = chart.getHighlightStyle(highlight);
        }
        object = this.createBarPaint(chart, chartable, chartStyle, bl, bl2, bl3, (int)d, (int)d2, (int)d3, (int)d4);
        if (object == null) {
            object = this.getBarColor(chart, chartable, chartStyle, bl, bl2, bl3);
        }
        if (orientation == Orientation.vertical) {
            if (d3 > (double)bl4) {
                d3 -= (double)bl4;
                d += (double)bl4 / 2.0;
            } else {
                d3 = 0.0;
            }
        }
        if (orientation == Orientation.horizontal) {
            if (d4 > (double)bl4) {
                d4 -= (double)bl4;
                d2 += (double)bl4 / 2.0;
            } else {
                d4 = 0.0;
            }
        }
        boolean bl5 = true;
        if ((d4 == 0.0 && orientation == Orientation.vertical || d3 == 0.0 && orientation == Orientation.horizontal) && !this.isZeroHeightBarsVisible()) {
            bl5 = false;
        }
        GeneralPath generalPath = new GeneralPath();
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (orientation == Orientation.vertical) {
            d5 = this.depthRatio * d3;
            int n = (int)(d5 / 2.0);
            Object object2 = object instanceof Color ? this.createFrontPaint(orientation, (Color)object, (int)d, (int)d2, (int)d3, (int)d4, (int)d5) : object;
            graphics2D2.setPaint((Paint)object2);
            Ellipse2D.Double double_ = new Ellipse2D.Double(d, d2 + d4 - (double)n, d3, d5);
            if (bl5) {
                graphics2D2.fill(double_);
            }
            generalPath.append(new Arc2D.Double(d, d2 + d4 - (double)n, d3, d5, 180.0, 180.0, 0), false);
            assert (d3 >= 0.0);
            if (d4 < 0.0) {
                d2 += d4;
                d4 = -d4;
            }
            GeneralPath generalPath2 = new GeneralPath();
            generalPath2.moveTo(d, d2);
            Arc2D.Double double_2 = new Arc2D.Double(d, d2 - (double)n, d3, d5, 180.0, -180.0, 0);
            generalPath2.append(double_2, true);
            generalPath2.lineTo(d + d3, d2 + d4);
            Arc2D.Double double_3 = new Arc2D.Double(d, d2 + d4 - (double)n, d3, d5, 0.0, -180.0, 0);
            generalPath2.append(double_3, true);
            generalPath2.lineTo(d, d2);
            generalPath2.closePath();
            if (bl5) {
                graphics2D2.fill(generalPath2);
            }
            generalPath.append(new Line2D.Double(d + d3, d2 + d4, d + d3, d2), true);
            object2 = object instanceof Color ? this.createTopPaint(orientation, (Color)object, (int)d, (int)d2, (int)d3, (int)d4, (int)d5) : object;
            graphics2D2.setPaint((Paint)object2);
            Ellipse2D.Double double_4 = new Ellipse2D.Double(d, d2 - (double)n, d3, d5);
            if (bl5) {
                graphics2D2.fill(double_4);
            }
            generalPath.append(new Arc2D.Double(d, d2 - (double)n, d3, d5, 0.0, 180.0, 0), true);
            generalPath.closePath();
        } else {
            d5 = this.depthRatio * d4;
            int n = (int)Math.round(d5 / 2.0);
            Object object3 = object instanceof Color ? this.createFrontPaint(orientation, (Color)object, (int)d, (int)d2, (int)d3, (int)d4, (int)d5) : object;
            graphics2D2.setPaint((Paint)object3);
            Ellipse2D.Double double_ = new Ellipse2D.Double(d - (double)n, d2, d5, d4);
            generalPath.append(new Arc2D.Double(d - (double)n, d2, d5, d4, 90.0, 180.0, 0), false);
            if (bl5) {
                graphics2D2.fill(double_);
            }
            GeneralPath generalPath3 = new GeneralPath();
            generalPath3.moveTo(d, d2);
            Arc2D.Double double_5 = new Arc2D.Double(d - (double)n, d2, d5, d4, 90.0, 180.0, 0);
            generalPath3.append(double_5, true);
            generalPath3.lineTo(d + d3, d2 + d4);
            Arc2D.Double double_6 = new Arc2D.Double(d + d3 - (double)n, d2, d5, d4, -90.0, 180.0, 0);
            generalPath3.append(double_6, true);
            generalPath3.lineTo(d, d2);
            generalPath3.closePath();
            if (bl5) {
                graphics2D2.fill(generalPath3);
            }
            generalPath.append(new Line2D.Double(d, d2 + d4, d + d3, d2 + d4), true);
            object3 = object instanceof Color ? this.createTopPaint(orientation, (Color)object, (int)d, (int)d2, (int)d3, (int)d4, (int)d5) : object;
            graphics2D2.setPaint((Paint)object3);
            Ellipse2D.Double double_7 = new Ellipse2D.Double(d + d3 - (double)n, d2, d5, d4);
            if (bl5) {
                graphics2D2.fill(double_7);
            }
            generalPath.append(new Arc2D.Double(d + d3 - (double)n, d2, d5, d4, 270.0, 180.0, 0), true);
            generalPath.closePath();
        }
        if (this.alwaysShowOutlines || bl && chart.isSelectionShowsOutline()) {
            Color color = bl && chart.isSelectionShowsOutline() ? this.getSelectionColor() : (this.alwaysShowOutlines ? this.getOutlineColor() : chart.getBackground());
            if (bl5) {
                graphics2D2.setColor(color);
                graphics2D2.setStroke(new BasicStroke(this.getOutlineWidth()));
                graphics2D2.draw(generalPath);
            }
        }
        if (bl5 && this.isLabelsVisible()) {
            this.renderBarLabel(graphics2D2, chart, chartModel, chartable, bl, bl2, bl3, d, d2, d3, d4);
        }
        graphics2D2.dispose();
        return generalPath;
    }

    @Override
    public Shape renderBar(Graphics graphics, Chart chart, ChartModel chartModel, Chartable chartable, boolean bl, boolean bl2, boolean bl3, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        return this.renderBar(graphics2D, chart, chartModel, chartable, bl, bl2, bl3, (double)n, (double)n2, (double)n3, (double)n4);
    }

    protected Paint createFrontPaint(Orientation orientation, Color color, int n, int n2, int n3, int n4, int n5) {
        Color color2 = this.darker(color);
        Color color3 = this.brighter(color);
        if (orientation == Orientation.vertical) {
            return new GradientPaint((int)((double)n - (double)n3 / 5.0), 0.0f, color2, (int)((double)n + (double)(2 * n3) / 5.0), 0.0f, color3, true);
        }
        return new GradientPaint(0.0f, (int)((double)n2 - (double)n4 / 3.0), color2, 0.0f, (int)((double)n2 + (double)n4 / 3.0), color3, true);
    }

    protected Paint createTopPaint(Orientation orientation, Color color, int n, int n2, int n3, int n4, int n5) {
        int n6 = (int)Math.round((double)n5 / 2.0);
        Color color2 = this.brighter(color);
        Color color3 = this.darker(color);
        Color color4 = this.darker(color3);
        if (orientation == Orientation.vertical) {
            return new GradientPaint(n + n3 / 2, n2 - n6, color, n + n3 / 2, n2 + n6, color2);
        }
        return new GradientPaint(0.0f, n2, color3, 0.0f, n2 + n4, color4);
    }

    protected Color darker(Color color) {
        Color color2 = color.darker();
        return new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), color.getAlpha());
    }

    protected Color brighter(Color color) {
        Color color2 = color.brighter();
        return new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), color.getAlpha());
    }

    @Override
    public int getMinimumBreadth() {
        return 0;
    }
}

