/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.event.PointDescriptor;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.render.AbstractRenderer;
import com.jidesoft.chart.render.LinePieLabelRenderer;
import com.jidesoft.chart.render.PieLabelRenderer;
import com.jidesoft.chart.render.PieSegmentRenderer;
import com.jidesoft.chart.render.PointLabeler;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.util.ChartUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ListSelectionModel;

public abstract class AbstractPieSegmentRenderer
extends AbstractRenderer
implements PieSegmentRenderer {
    public static final String PROPERTY_ALWAYS_SHOW_OUTLINES = "Always Show Outlines";
    public static final String PROPERTY_PIE_LABEL_RENDERER = "Pie Label Renderer";
    public static final String PROPERTY_POINT_LABELER = "Point Labeler";
    public static final String PROPERTY_TICK_LENGTH = "Tick Length";
    public static final double maxExplode = 0.2;
    private final Map<Shape, PointDescriptor> segmentShapes = new HashMap<Shape, PointDescriptor>();
    private PieLabelRenderer pieLabelRenderer = new LinePieLabelRenderer();
    private Graphics labelGraphics;

    public AbstractPieSegmentRenderer() {
        this.setAlwaysShowOutlines(true);
    }

    @Override
    public void clearShapes() {
        this.segmentShapes.clear();
    }

    protected void recordSegment(Shape shape, PointDescriptor pointDescriptor) {
        pointDescriptor.setShape(shape);
        this.segmentShapes.put(shape, pointDescriptor);
    }

    public Graphics getLabelGraphics() {
        return this.labelGraphics;
    }

    @Override
    public void setLabelGraphics(Graphics graphics) {
        this.labelGraphics = graphics;
    }

    @Override
    public int getTickLength() {
        return this.pieLabelRenderer == null ? 0 : this.pieLabelRenderer.getTickLength();
    }

    @Override
    public void setTickLength(int n) {
        int n2;
        int n3 = n2 = this.pieLabelRenderer == null ? 0 : this.pieLabelRenderer.getTickLength();
        if (this.pieLabelRenderer != null) {
            this.pieLabelRenderer.setTickLength(n);
        }
        this.support.firePropertyChange(PROPERTY_TICK_LENGTH, n2, n);
    }

    @Override
    public PointLabeler getPointLabeler() {
        return this.pieLabelRenderer.getPointLabeler();
    }

    @Override
    public void setPointLabeler(PointLabeler pointLabeler) {
        PointLabeler pointLabeler2 = this.pieLabelRenderer.getPointLabeler();
        this.pieLabelRenderer.setPointLabeler(pointLabeler);
        this.support.firePropertyChange(PROPERTY_POINT_LABELER, pointLabeler2, pointLabeler);
    }

    @Override
    public PieLabelRenderer getPieLabelRenderer() {
        return this.pieLabelRenderer;
    }

    public void setPieLabelRenderer(PieLabelRenderer pieLabelRenderer) {
        PieLabelRenderer pieLabelRenderer2 = this.pieLabelRenderer;
        this.pieLabelRenderer = pieLabelRenderer;
        this.support.firePropertyChange(PROPERTY_PIE_LABEL_RENDERER, pieLabelRenderer2, this.pieLabelRenderer);
    }

    protected Paint createSegmentPaint(Chart chart, Chartable chartable, ChartStyle chartStyle, boolean bl, boolean bl2, Shape shape) {
        return null;
    }

    public void renderLabels(Graphics graphics, Chart chart, ChartModel chartModel, Point point, int n, int n2, int[] nArray, ChartStyle chartStyle) {
        if (this.pieLabelRenderer != null) {
            this.pieLabelRenderer.renderLabels(graphics, chart, chartModel, point, n, n2, nArray, chartStyle);
        }
    }

    @Override
    public PointDescriptor containingSegment(Point point) {
        for (Map.Entry<Shape, PointDescriptor> entry : this.segmentShapes.entrySet()) {
            Shape shape = entry.getKey();
            if (!shape.contains(point)) continue;
            return entry.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PointDescriptor rendered(Chartable chartable) {
        Map<Shape, PointDescriptor> map = this.segmentShapes;
        synchronized (map) {
            for (PointDescriptor pointDescriptor : this.segmentShapes.values()) {
                if (!chartable.equals(pointDescriptor.getChartable())) continue;
                return pointDescriptor;
            }
        }
        return null;
    }

    protected void renderOutlines(boolean bl, Graphics2D graphics2D, Chart chart, ChartModel chartModel, Point point, int n, int[] nArray, ChartStyle chartStyle) {
        int n2 = point.x;
        int n3 = point.y;
        int n4 = 2 * n;
        int n5 = (int)(0.2 * (double)n);
        int n6 = n2 - n;
        int n7 = n3 - n;
        float f = chartStyle.getPieOffsetAngle();
        for (int i = 0; i < nArray.length; ++i) {
            float f2 = f + (float)nArray[i] / 2.0f;
            ListSelectionModel listSelectionModel = chart.getSelectionsForModel(chartModel);
            boolean bl2 = listSelectionModel.isSelectedIndex(i);
            int n8 = chartStyle.isPieSegmentsAlwaysExploded() || bl2 && chart.isSelectionShowsExplodedSegments() ? (int)((double)n5 * Math.cos(Math.toRadians(f2))) : 0;
            int n9 = chartStyle.isPieSegmentsAlwaysExploded() || bl2 && chart.isSelectionShowsExplodedSegments() ? -((int)((double)n5 * Math.sin(Math.toRadians(f2)))) : 0;
            graphics2D.translate(n8, n9);
            if (this.alwaysShowOutlines && !bl || bl2 && chart.isSelectionShowsOutline()) {
                Color color = bl2 && bl ? this.getSelectionColor() : this.getOutlineColor();
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(this.getOutlineWidth(), 0, 1));
                graphics2D.drawLine(n2, n3, (int)Math.round((double)n2 + (double)n * Math.cos(Math.toRadians(f))), (int)Math.round((double)n3 - (double)n * Math.sin(Math.toRadians(f))));
                graphics2D.drawArc(n6, n7, n4, n4, (int)f, nArray[i]);
                graphics2D.drawLine(n2, n3, (int)Math.round((double)n2 + (double)n * Math.cos(Math.toRadians(f += (float)nArray[i]))), (int)Math.round((double)n3 - (double)n * Math.sin(Math.toRadians(f))));
            } else {
                f += (float)nArray[i];
            }
            graphics2D.translate(-n8, -n9);
        }
    }

    protected void renderOutlines2D(boolean bl, Graphics2D graphics2D, Chart chart, ChartModel chartModel, Point2D point2D, float f, float[] fArray, ChartStyle chartStyle) {
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = 2.0 * (double)f;
        double d4 = 0.2 * (double)f;
        double d5 = d - (double)f;
        double d6 = d2 - (double)f;
        double d7 = chartStyle.getPieOffsetAngle();
        for (int i = 0; i < fArray.length; ++i) {
            double d8 = d7 + (double)fArray[i] / 2.0;
            ListSelectionModel listSelectionModel = chart.getSelectionsForModel(chartModel);
            boolean bl2 = listSelectionModel.isSelectedIndex(i);
            int n = chartStyle.isPieSegmentsAlwaysExploded() || bl2 && chart.isSelectionShowsExplodedSegments() ? (int)(d4 * Math.cos(Math.toRadians(d8))) : 0;
            int n2 = chartStyle.isPieSegmentsAlwaysExploded() || bl2 && chart.isSelectionShowsExplodedSegments() ? -((int)(d4 * Math.sin(Math.toRadians(d8)))) : 0;
            graphics2D.translate(n, n2);
            if (this.alwaysShowOutlines && !bl || bl2 && chart.isSelectionShowsOutline()) {
                Color color = bl2 && bl ? this.getSelectionColor() : this.getOutlineColor();
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(this.getOutlineWidth(), 0, 1));
                Line2D.Double double_ = new Line2D.Double(d, d2, d + (double)f * Math.cos(Math.toRadians(d7)), d2 - (double)f * Math.sin(Math.toRadians(d7)));
                graphics2D.draw(double_);
                Arc2D.Double double_2 = new Arc2D.Double(d5, d6, d3, d3, d7, fArray[i], 0);
                graphics2D.draw(double_2);
                Line2D.Double double_3 = new Line2D.Double(d, d2, d + (double)f * Math.cos(Math.toRadians(d7 += (double)fArray[i])), d2 - (double)f * Math.sin(Math.toRadians(d7)));
                graphics2D.draw(double_3);
            } else {
                d7 += (double)fArray[i];
            }
            graphics2D.translate(-n, -n2);
        }
    }

    protected TexturePaint modify(TexturePaint texturePaint) {
        BufferedImage bufferedImage = texturePaint.getImage();
        HighlightFilter highlightFilter = new HighlightFilter();
        BufferedImage bufferedImage2 = highlightFilter.filter(bufferedImage, null);
        return new TexturePaint(bufferedImage2, new Rectangle(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight()));
    }

    static class HighlightFilter
    implements BufferedImageOp {
        HighlightFilter() {
        }

        @Override
        public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
            if (colorModel == null) {
                colorModel = bufferedImage.getColorModel();
            }
            return new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight()), colorModel.isAlphaPremultiplied(), null);
        }

        @Override
        public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
            if (bufferedImage2 == null) {
                bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
            }
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            int[] nArray = new int[n * n2];
            ChartUtils.getPixels(bufferedImage, 0, 0, n, n2, nArray);
            for (int i = 0; i < nArray.length; ++i) {
                Color color = new Color(nArray[i], true);
                nArray[i] = color.brighter().getRGB();
            }
            ChartUtils.setPixels(bufferedImage2, 0, 0, n, n2, nArray);
            return bufferedImage2;
        }

        @Override
        public Rectangle2D getBounds2D(BufferedImage bufferedImage) {
            return new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        }

        @Override
        public Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
            return (Point2D)point2D.clone();
        }

        @Override
        public RenderingHints getRenderingHints() {
            return null;
        }
    }
}

