/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.event;

import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.range.Positionable;
import java.awt.Shape;

public class PointDescriptor {
    private Chartable chartable;
    private ChartModel model;
    private int index;
    private PointDescriptor subPoint;
    private Shape shape;

    public PointDescriptor(Chartable chartable, int n, ChartModel chartModel) {
        this.chartable = chartable;
        this.model = chartModel;
        this.index = n;
    }

    public Chartable getChartable() {
        return this.chartable;
    }

    public ChartModel getModel() {
        return this.model;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public int getIndex() {
        return this.index;
    }

    public PointDescriptor getSubPoint() {
        return this.subPoint;
    }

    public void setSubPoint(PointDescriptor pointDescriptor) {
        this.subPoint = pointDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getModelXSum() {
        double d = 0.0;
        if (this.model == null) {
            return d;
        }
        ChartModel chartModel = this.model;
        synchronized (chartModel) {
            for (int i = 0; i < this.model.getPointCount(); ++i) {
                Positionable positionable = this.model.getPoint(i).getX();
                d += positionable.position();
            }
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getModelYSum() {
        double d = 0.0;
        if (this.model == null) {
            return d;
        }
        ChartModel chartModel = this.model;
        synchronized (chartModel) {
            for (int i = 0; i < this.model.getPointCount(); ++i) {
                Positionable positionable = this.model.getPoint(i).getY();
                d += positionable.position();
            }
        }
        return d;
    }

    public double getChartableYPercent() {
        double d = this.chartable.getY().position();
        return 100.0 * d / this.getModelYSum();
    }

    public double getChartableXPercent() {
        double d = this.chartable.getX().position();
        return 100.0 * d / this.getModelXSum();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PointDescriptor pointDescriptor = (PointDescriptor)object;
        if (this.index != pointDescriptor.index) {
            return false;
        }
        if (this.chartable != null ? !this.chartable.equals(pointDescriptor.chartable) : pointDescriptor.chartable != null) {
            return false;
        }
        if (this.model != null ? !this.model.equals(pointDescriptor.model) : pointDescriptor.model != null) {
            return false;
        }
        return !(this.subPoint != null ? !this.subPoint.equals(pointDescriptor.subPoint) : pointDescriptor.subPoint != null);
    }

    public int hashCode() {
        int n = this.chartable != null ? this.chartable.hashCode() : 0;
        n = 31 * n + (this.model != null ? this.model.hashCode() : 0);
        n = 31 * n + this.index;
        n = 31 * n + (this.subPoint != null ? this.subPoint.hashCode() : 0);
        return n;
    }

    public String toString() {
        String string = this.chartable == null ? "null" : this.chartable.toString();
        return String.format("#<%s chartable=%s index=%d model=%s>", this.getClass().getSimpleName(), string, this.index, this.model.toString());
    }
}

