/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.axis;

import com.jidesoft.chart.annotation.AutoPositionedLabel;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.axis.AxisQuantity;
import com.jidesoft.chart.axis.DefaultNumericTickCalculator;
import com.jidesoft.chart.axis.NumericTickCalculator;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Range;
import java.text.NumberFormat;

public class NumericAxis
extends Axis {
    private NumericTickCalculator tickCalculator = new DefaultNumericTickCalculator();

    public NumericAxis() {
        super(0.0, 1.0);
        this.init();
    }

    public NumericAxis(String string) {
        super(string);
        this.init();
    }

    public NumericAxis(AutoPositionedLabel autoPositionedLabel) {
        super(autoPositionedLabel);
        this.init();
    }

    public NumericAxis(double d, double d2) {
        super(d, d2);
        this.init();
    }

    public NumericAxis(double d, double d2, String string) {
        this(new NumericRange(d, d2), string);
    }

    public NumericAxis(Range<?> range) {
        super(range);
        this.init();
    }

    public NumericAxis(Range<?> range, String string) {
        super(range, string);
        this.init();
    }

    protected void init() {
        this.setTickCalculator(this.tickCalculator);
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.tickCalculator.setNumberFormat(numberFormat);
    }

    public void setNumberFormat(String string) {
        this.tickCalculator.setNumberFormat(string);
    }

    @Override
    public AxisQuantity getQuantity() {
        return AxisQuantity.NUMBER;
    }
}

