/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.annotation;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.annotation.AbstractLabel;
import com.jidesoft.chart.annotation.ChartAnnotation;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.RealPosition;
import com.jidesoft.chart.style.LabelStyle;
import com.jidesoft.range.Positionable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class ChartLabel
extends AbstractLabel
implements Chartable,
ChartAnnotation,
Comparable<Chartable> {
    private static final int defaultZOrder = 200;
    private Positionable xPos;
    private Positionable yPos;
    private Point pixelOffset;
    private Color background = null;
    private Border border = null;

    public ChartLabel(double d, double d2, String string) {
        this(new RealPosition(d), new RealPosition(d2), string);
    }

    public ChartLabel(double d, double d2) {
        this(new RealPosition(d), new RealPosition(d2), null);
    }

    public ChartLabel(Positionable positionable, Positionable positionable2) {
        this(positionable, positionable2, null, null);
    }

    public ChartLabel(Positionable positionable, Positionable positionable2, String string) {
        this(positionable, positionable2, string, null);
    }

    public ChartLabel(Positionable positionable, Positionable positionable2, String string, Color color) {
        this(positionable, positionable2, string, color, null);
    }

    public ChartLabel(Positionable positionable, Positionable positionable2, String string, Color color, Font font) {
        super(string, color, font);
        this.xPos = positionable;
        this.yPos = positionable2;
        this.setZOrder(200);
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
    }

    public Border getBorder() {
        return this.border;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    @Override
    public Positionable getX() {
        return this.xPos;
    }

    @Override
    public Positionable getY() {
        return this.yPos;
    }

    public Point getPixelOffset() {
        return this.pixelOffset;
    }

    public void setPixelOffset(Point point) {
        this.pixelOffset = point;
    }

    @Override
    public int compareTo(Chartable chartable) {
        if (chartable == null || this.xPos == null) {
            return 0;
        }
        return this.xPos.compareTo(chartable.getX());
    }

    @Override
    public void draw(Graphics2D graphics2D, Chart chart) {
        if (graphics2D != null) {
            int n;
            Color color = this.getColor();
            Font font = this.getFont();
            graphics2D.setColor(color);
            graphics2D.setFont(font);
            Point point = chart.calculatePixelPoint(new Point2D.Double(this.getX().position(), this.getY().position()));
            Point point2 = this.getPixelOffset();
            if (point2 != null) {
                point = new Point(point.x + point2.x, point.y + point2.y);
            }
            LabelStyle labelStyle = this.getLabelStyle();
            double d = chart.getAnimationPosition();
            int n2 = d == 1.0 ? point.x : chart.interpolateXForAnimation(point.x, null);
            int n3 = n = d == 1.0 ? point.y : chart.interpolateYForAnimation(point.y, null);
            if (labelStyle == null || labelStyle.getRotation() == null || labelStyle.getRotation() == 0.0) {
                String string = this.getLabel();
                if (this.renderingWithJLabel()) {
                    Font font2;
                    Color color2;
                    if (labelStyle == null) {
                        color2 = UIManager.getColor("Label.foreground");
                        font2 = UIManager.getFont("Label.font");
                    } else {
                        color2 = labelStyle.getColor();
                        if (color2 == null) {
                            color2 = UIManager.getColor("Label.foreground");
                        }
                        if ((font2 = labelStyle.getFont()) == null) {
                            font2 = UIManager.getFont("Label.font");
                        }
                    }
                    JLabel jLabel = this.getLabelComponent();
                    jLabel.setForeground(color2);
                    jLabel.setBorder(this.border);
                    jLabel.setBackground(this.background);
                    jLabel.setOpaque(this.background != null);
                    jLabel.setFont(font2);
                    jLabel.setText(string);
                    Dimension dimension = jLabel.getPreferredSize();
                    jLabel.setSize(dimension);
                    FontMetrics fontMetrics = graphics2D.getFontMetrics(font2);
                    graphics2D.translate(n2 - dimension.width / 2, n - fontMetrics.getAscent());
                    jLabel.paint(graphics2D);
                    graphics2D.translate(-n2 + dimension.width / 2, -n + fontMetrics.getAscent());
                } else {
                    FontMetrics fontMetrics = graphics2D.getFontMetrics();
                    if (string != null) {
                        int n4 = fontMetrics.stringWidth(string);
                        graphics2D.drawString(string, n2 - n4 / 2, n);
                    }
                }
            } else {
                Double d2 = labelStyle.getRotation();
                if (d2 == null) {
                    d2 = 0.0;
                }
                this.paint((Graphics)graphics2D, n2, n, d2);
            }
        }
    }

    private boolean renderingWithJLabel() {
        String string = this.getLabel();
        if (string == null) {
            return false;
        }
        return (string = string.trim().toLowerCase()).startsWith("<html>") || this.background != null || this.border != null;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.xPos == null ? 0 : this.xPos.hashCode());
        n = 31 * n + (this.yPos == null ? 0 : this.yPos.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ChartLabel chartLabel = (ChartLabel)object;
        if (this.xPos == null ? chartLabel.xPos != null : !this.xPos.equals(chartLabel.xPos)) {
            return false;
        }
        return !(this.yPos == null ? chartLabel.yPos != null : !this.yPos.equals(chartLabel.yPos));
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ChartLabel[");
        stringBuilder.append(this.getLabel());
        stringBuilder.append(", ");
        stringBuilder.append(this.xPos);
        stringBuilder.append(", ");
        stringBuilder.append(this.yPos);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

