/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.annotation;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.annotation.ChartAnnotation;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class ChartArrow
implements ChartAnnotation {
    public static final int defaultZOrder = 200;
    private Point2D from;
    private Point2D to;
    private Point fromPixelOffset = new Point(0, 0);
    private Point toPixelOffset = new Point(0, 0);
    private Color color = Color.gray;
    private int zOrder = 200;

    public ChartArrow(Point2D point2D, Point2D point2D2) {
        this.from = point2D;
        this.to = point2D2;
    }

    public void setFromPixelOffset(Point point) {
        this.fromPixelOffset = point;
    }

    public void setToPixelOffset(Point point) {
        this.toPixelOffset = point;
    }

    public void setZOrder(int n) {
        this.zOrder = n;
    }

    @Override
    public int getZOrder() {
        return this.zOrder;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public void draw(Graphics2D graphics2D, Chart chart) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = graphics2D.getColor();
        graphics2D.setColor(this.color);
        Point2D point2D = chart.calculatePixelPoint2D(this.from);
        Point2D point2D2 = chart.calculatePixelPoint2D(this.to);
        double d = chart.getAnimationPosition();
        double d2 = d == 1.0 ? point2D.getX() : (double)chart.interpolateXForAnimation((int)point2D.getX(), null);
        double d3 = d == 1.0 ? point2D.getY() : (double)chart.interpolateYForAnimation((int)point2D.getY(), null);
        double d4 = d == 1.0 ? point2D2.getX() : (double)chart.interpolateXForAnimation((int)point2D2.getX(), null);
        double d5 = d == 1.0 ? point2D2.getY() : (double)chart.interpolateYForAnimation((int)point2D2.getY(), null);
        double d6 = d * this.toPixelOffset.getX();
        double d7 = d * this.fromPixelOffset.getX();
        double d8 = d * this.toPixelOffset.getY();
        double d9 = d * this.fromPixelOffset.getY();
        double d10 = 22.5;
        double d11 = Math.toRadians(d10);
        double d12 = d4 - d2 + d6 - d7;
        double d13 = d3 - d5 + d9 - d8;
        double d14 = Math.atan(d13 / d12);
        int n = d12 >= 0.0 ? -1 : 1;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)(d4 + d6), (float)(d5 + d8));
        generalPath.lineTo((float)(d4 + d6 + (double)(n * 12) * Math.cos(d14 + d11)), (float)(d5 + d8 - (double)(n * 12) * Math.sin(d14 + d11)));
        generalPath.lineTo((float)(d4 + d6 + (double)(n * 12) * Math.cos(d14 - d11)), (float)(d5 + d8 - (double)(n * 12) * Math.sin(d14 - d11)));
        generalPath.closePath();
        Line2D.Double double_ = new Line2D.Double(d2 + d7, d3 + d9, d4 + d6, d5 + d8);
        graphics2D.draw(double_);
        graphics2D.fill(generalPath);
        graphics2D.setColor(color);
    }
}

