/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Frontable;
import com.jidesoft.chart.LazyRenderer;
import com.jidesoft.chart.UserToPixelTransform;
import com.jidesoft.chart.event.ImageChangeEvent;
import com.jidesoft.chart.event.ImageChangeListener;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.CopiedChartModel;
import com.jidesoft.chart.style.ChartStyle;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.swing.Timer;

public class SingleImageLazyChartRenderer
implements LazyRenderer<ChartModel>,
Frontable,
ActionListener {
    private static final Logger logger = Logger.getLogger(SingleImageLazyChartRenderer.class.getName());
    private final Lock lock = new ReentrantLock(false);
    private List<ChartModel> models = new ArrayList<ChartModel>();
    private BufferedImage workingImage;
    private Image image;
    private long imageTimestamp;
    private Chart chart;
    private Point2D topLeft;
    private Point2D bottomRight;
    private Point topLeftPixel;
    private Point bottomRightPixel;
    private Timer lazyChartTimer;
    private int timerDuration = 100;
    private Thread drawingThread;
    private BackgroundPlotter plotter;
    private List<ImageChangeListener> listeners = new CopyOnWriteArrayList<ImageChangeListener>();

    public SingleImageLazyChartRenderer(Chart chart) {
        this.chart = chart;
    }

    public Chart getChart() {
        return this.chart;
    }

    private void setModels(List<ChartModel> list) {
        this.lock.lock();
        try {
            this.models = list;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long lastModified() {
        return this.imageTimestamp;
    }

    public ChartModel getModel() {
        if (this.models.size() > 0) {
            return this.models.get(0);
        }
        return null;
    }

    @Override
    public void addImageChangeListener(ImageChangeListener imageChangeListener) {
        this.listeners.add(imageChangeListener);
    }

    @Override
    public void removeImageChangeListener(ImageChangeListener imageChangeListener) {
        this.listeners.remove(imageChangeListener);
    }

    protected void fireImageChange() {
        ImageChangeEvent imageChangeEvent = new ImageChangeEvent(this);
        for (ImageChangeListener imageChangeListener : this.listeners) {
            imageChangeListener.imageChanged(imageChangeEvent);
        }
    }

    @Override
    public void updateImage(ChartModel chartModel, boolean bl) {
        if (this.models.contains(chartModel)) {
            this.models.remove(chartModel);
        }
        if (!this.models.contains(chartModel)) {
            this.models.add(chartModel);
        }
        this.updateCharts(true);
    }

    @Override
    public void removeImage(ChartModel chartModel) {
    }

    @Override
    public void cancelDrawing() {
        if (this.plotter != null) {
            this.plotter.stop();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.drawImmediately();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawImmediately() {
        this.lock.lock();
        try {
            int n = this.chart.getXStart();
            int n2 = this.chart.getYEnd();
            int n3 = this.chart.getXEnd();
            int n4 = this.chart.getYStart();
            int n5 = n3 - n;
            int n6 = n4 - n2;
            this.topLeftPixel = new Point(n, n2);
            this.bottomRightPixel = new Point(n3, n4);
            Point2D point2D = this.chart.calculateUserPoint(this.topLeftPixel);
            Point2D point2D2 = this.chart.calculateUserPoint(this.bottomRightPixel);
            if (n5 > 0 && n6 > 0 && point2D != null && point2D2 != null) {
                if (this.workingImage != null) {
                    this.workingImage.flush();
                }
                this.workingImage = new BufferedImage(n5, n6, 2);
                if (this.drawingThread != null && this.drawingThread.isAlive()) {
                    if (this.plotter != null) {
                        this.plotter.stop();
                    }
                    this.drawingThread.interrupt();
                }
                this.plotter = new BackgroundPlotter(this, this.workingImage, this.models, this.chart.getCoordinateSystems(), point2D, point2D2);
                this.drawingThread = new Thread((Runnable)this.plotter, "Plotter");
                this.drawingThread.start();
            } else {
                this.image = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateImage(Image image, Point2D point2D, Point2D point2D2) {
        this.lock.lock();
        try {
            this.image = image;
            this.topLeft = point2D;
            this.bottomRight = point2D2;
            this.imageTimestamp = System.currentTimeMillis();
            this.fireImageChange();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCharts(boolean bl) {
        logger.fine("updateCharts");
        this.lock.lock();
        try {
            this.setModels(this.chart.getModels());
            int n = this.chart.getXStart();
            int n2 = this.chart.getYEnd();
            int n3 = this.chart.getXEnd();
            int n4 = this.chart.getYStart();
            int n5 = n3 - n;
            int n6 = n4 - n2;
            if (n5 > 0 && n6 > 0) {
                if (this.chart.isLazyRendering()) {
                    if (this.lazyChartTimer != null && this.lazyChartTimer.isRunning()) {
                        this.lazyChartTimer.restart();
                    } else {
                        this.lazyChartTimer = new Timer(this.timerDuration, this);
                        this.lazyChartTimer.setRepeats(false);
                        logger.fine("Starting timer");
                        this.lazyChartTimer.start();
                    }
                } else {
                    this.image = null;
                }
            } else {
                this.image = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics graphics) {
        if (!this.chart.isLazyRendering()) {
            return;
        }
        this.lock.lock();
        try {
            if (this.image == null) {
                return;
            }
            Point point = this.chart.calculatePixelPoint(this.topLeft);
            Point point2 = this.chart.calculatePixelPoint(this.bottomRight);
            int n = point.x;
            int n2 = point.y;
            int n3 = point2.x;
            int n4 = point2.y;
            int n5 = n3 - n;
            int n6 = Math.abs(n4 - n2);
            assert (n6 >= 0);
            graphics.drawImage(this.image, n, n2, n5, n6, this.chart);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isAtFront() {
        return false;
    }

    @Override
    public void setAtFront(boolean bl) {
        throw new UnsupportedOperationException("Lazy Chart Renderer cannot be moved to the front");
    }

    static class BackgroundPlotter
    implements Runnable {
        private static final transient Logger logger = Logger.getLogger(BackgroundPlotter.class.getName());
        private static BackgroundPlotter instance;
        private Image workingImage;
        private List<ChartModel> models;
        private Map<String, UserToPixelTransform> coordinates;
        private Point2D workingTopLeft;
        private Point2D workingBottomRight;
        private PropertyChangeSupport support = new PropertyChangeSupport(this);
        private SingleImageLazyChartRenderer _renderer;
        private volatile boolean stopped = false;

        BackgroundPlotter(SingleImageLazyChartRenderer singleImageLazyChartRenderer, Image image, List<ChartModel> list, Map<String, UserToPixelTransform> map, Point2D point2D, Point2D point2D2) {
            this.setModels(list);
            this.setRenderer(singleImageLazyChartRenderer);
            this.setWorkingImage(image);
            this.setCoordinates(map);
            this.setWorkingTopLeft(point2D);
            this.setWorkingBottomRight(point2D2);
        }

        void setRenderer(SingleImageLazyChartRenderer singleImageLazyChartRenderer) {
            this._renderer = singleImageLazyChartRenderer;
        }

        void setWorkingImage(Image image) {
            this.workingImage = image;
        }

        void setModels(List<ChartModel> list) {
            this.models = new ArrayList<ChartModel>(list);
        }

        void setCoordinates(Map<String, UserToPixelTransform> map) {
            this.coordinates = map;
        }

        void setWorkingTopLeft(Point2D point2D) {
            this.workingTopLeft = point2D;
        }

        void setWorkingBottomRight(Point2D point2D) {
            this.workingBottomRight = point2D;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.support.addPropertyChangeListener(propertyChangeListener);
        }

        public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
            this.support.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.support.removePropertyChangeListener(propertyChangeListener);
        }

        public void stop() {
            this.stopped = true;
        }

        @Override
        public void run() {
            long l = System.currentTimeMillis();
            Graphics2D graphics2D = (Graphics2D)this.workingImage.getGraphics();
            Chart chart = this._renderer.getChart();
            if (chart.isAntiAliasing()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            chart.clearShapes();
            for (int i = 0; this.models != null && i < this.models.size(); ++i) {
                CopiedChartModel copiedChartModel = new CopiedChartModel(this.models.get(i));
                ChartStyle chartStyle = chart.getStyle(copiedChartModel);
                UserToPixelTransform userToPixelTransform = this.coordinates.get(copiedChartModel.getName());
                if (chartStyle != null && chartStyle.isBarsVisible()) {
                    chart.paintBars(graphics2D, copiedChartModel, i, userToPixelTransform);
                }
                if (this.stopped || Thread.interrupted()) {
                    this.cleanUp();
                    break;
                }
                if (chartStyle == null || chartStyle.isLinesVisible()) {
                    chart.paintLines(graphics2D, copiedChartModel, i, userToPixelTransform);
                }
                if (this.stopped || Thread.interrupted()) {
                    this.cleanUp();
                    break;
                }
                if (chartStyle == null || chartStyle.isPointsVisible()) {
                    chart.paintPoints(graphics2D, copiedChartModel, i, userToPixelTransform);
                }
                if (!this.stopped && !Thread.interrupted()) continue;
                this.cleanUp();
                break;
            }
            graphics2D.dispose();
            long l2 = System.currentTimeMillis();
            logger.fine(String.format("Buffer image for %s drawn in %.2fs", chart.getName(), (double)(l2 - l) / 1000.0));
            if (!this.stopped) {
                this._renderer.updateImage(this.workingImage, this.workingTopLeft, this.workingBottomRight);
                this.support.firePropertyChange("dirty", false, true);
                chart.repaint();
            }
        }

        private void cleanUp() {
            this.models = null;
            this._renderer = null;
            this.workingImage = null;
            this.workingBottomRight = null;
            this.workingTopLeft = null;
        }

        static BackgroundPlotter create(SingleImageLazyChartRenderer singleImageLazyChartRenderer, Image image, List<ChartModel> list, Map<String, UserToPixelTransform> map, Point2D point2D, Point2D point2D2) {
            if (instance == null) {
                instance = new BackgroundPlotter(singleImageLazyChartRenderer, image, list, map, point2D, point2D2);
            } else {
                instance.setRenderer(singleImageLazyChartRenderer);
                instance.setWorkingImage(image);
                instance.setModels(list);
                instance.setCoordinates(map);
                instance.setWorkingTopLeft(point2D);
                instance.setWorkingBottomRight(point2D2);
            }
            return instance;
        }
    }
}

