/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.ChartPainter;
import com.jidesoft.chart.UserToPixelTransform;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.render.PieSegmentRenderer;
import com.jidesoft.chart.render.PieSegmentRenderer2D;
import com.jidesoft.chart.style.ChartStyle;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;

class PieChartPainter
implements ChartPainter {
    private static final long serialVersionUID = -819446300819357633L;
    private Integer diameter = null;
    private Graphics labelGraphics;

    public Integer getDiameter() {
        return this.diameter;
    }

    public void setDiameter(Integer n) {
        this.diameter = n;
    }

    public void setLabelGraphics(Graphics graphics) {
        this.labelGraphics = graphics;
    }

    protected int[] angles(ChartModel chartModel, double d, double d2) {
        int n = chartModel.getPointCount();
        int[] nArray = new int[n];
        int n2 = (int)(d2 * 360.0);
        for (int i = 0; i < n; ++i) {
            Chartable chartable = chartModel.getPoint(i);
            double d3 = chartable.getY().position();
            nArray[i] = (int)Math.round(d3 * (double)n2 / d);
            d -= d3;
            n2 -= nArray[i];
        }
        return nArray;
    }

    protected float[] angles2D(ChartModel chartModel, double d, double d2) {
        int n = chartModel.getPointCount();
        float[] fArray = new float[n];
        float f = (float)(d2 * 360.0);
        for (int i = 0; i < n; ++i) {
            Chartable chartable = chartModel.getPoint(i);
            double d3 = chartable.getY().position();
            fArray[i] = (float)(d3 * (double)f / d);
        }
        return fArray;
    }

    @Override
    public void drawChart(Graphics graphics, Chart chart, ChartModel chartModel, int n, UserToPixelTransform userToPixelTransform, boolean bl) {
        ChartStyle chartStyle;
        if (graphics == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ChartStyle chartStyle2 = chartStyle = chartModel == null ? null : chart.getStyle(chartModel);
        if (chartStyle == null) {
            chartStyle = new ChartStyle();
        }
        float f = chartStyle.getPieExplosionRatio();
        double d = chart.getAnimationPosition();
        PieSegmentRenderer pieSegmentRenderer = chart.getPieSegmentRenderer();
        pieSegmentRenderer.setLabelGraphics(this.labelGraphics);
        pieSegmentRenderer.clearShapes();
        int n2 = pieSegmentRenderer.getTickLength();
        Insets insets = chart.getInsets();
        int n3 = chart.getWidth() - insets.left - insets.right;
        int n4 = graphics.getFontMetrics().getAscent();
        int n5 = graphics.getFontMetrics().getDescent();
        int n6 = chart.titleHeight();
        int n7 = chart.getHeight() - insets.top - insets.bottom - n2 - n4 - n5 - n6;
        Integer n8 = this.diameter;
        if (n8 == null) {
            n8 = Math.min(n3, n7);
        }
        float f2 = chart.isSelectionShowsExplodedSegments() || chartStyle.isPieSegmentsAlwaysExploded() ? 2.0f * (1.0f + f) : 2.0f;
        float f3 = (float)n8.intValue() / f2;
        double d2 = (double)insets.left + (double)n3 / 2.0;
        double d3 = (double)(insets.top + n6) + (double)(n7 + n4 + n5 + n2) / 2.0;
        if (chartModel != null) {
            double d4 = chart.getYSum(chartModel);
            if (pieSegmentRenderer instanceof PieSegmentRenderer2D) {
                PieSegmentRenderer2D pieSegmentRenderer2D = (PieSegmentRenderer2D)pieSegmentRenderer;
                float[] fArray = this.angles2D(chartModel, d4, d);
                Point2D.Double double_ = new Point2D.Double(d2, d3);
                pieSegmentRenderer2D.renderSegments(graphics2D, chart, chartModel, double_, f3, fArray);
            } else {
                int[] nArray = this.angles(chartModel, d4, d);
                Point point = new Point((int)d2, (int)d3);
                pieSegmentRenderer.renderSegments(graphics2D, chart, chartModel, point, (int)f3, nArray);
            }
        }
    }
}

