/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.ChartType;
import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.Frontable;
import com.jidesoft.chart.LegendItem;
import com.jidesoft.chart.LegendPair;
import com.jidesoft.chart.PointLegendItem;
import com.jidesoft.chart.WrapLayout;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.util.Named;
import com.jidesoft.range.Category;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class Legend
extends JPanel
implements Drawable,
Frontable {
    private static final long serialVersionUID = 3209957448711005879L;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int LEADING = 3;
    public static final int RIGHT = 2;
    public static final int TRAILING = 4;
    public static final String PROPERTY_GENERATE_FROM_POINTS = "GenerateFromPoints";
    public static final String PROPERTY_TITLE = "title";
    public static final String PROPERTY_TITLE_COLOR = "titleColor";
    public static final String PROPERTY_COLUMNS = "columns";
    public static final String PROPERTY_KEY_LABEL_GAP = "keyLabelGap";
    public static final String PROPERTY_LABEL_COLOR = "labelColor";
    public static final String PROPERTY_LEGEND_BACKGROUND = "legendBackground";
    public static final String PROPERTY_ORDER_REVERSED = "order reversed";
    public static final String PROPERTY_AT_FRONT = "At Front";
    public static final String PROPERTY_TITLE_LABEL = "Title Label";
    public static final String PROPERTY_ROLLOVER_MODEL = "Rollover Model";
    private static final Logger logger = Logger.getLogger(Legend.class.getName());
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private int columns = 1;
    private List<WeakReference<Chart>> charts = new ArrayList<WeakReference<Chart>>();
    private Set<ChartModel> excludedModels = new HashSet<ChartModel>();
    private Set<Chartable> excludedPoints = new HashSet<Chartable>();
    private List<ChartModel> includedModels = new ArrayList<ChartModel>();
    private List<LegendItem> additionalItems = new ArrayList<LegendItem>();
    private String title;
    private JLabel titleLabel = null;
    private Color labelColor = null;
    private Color titleColor = null;
    private long lastUpdated;
    private PropertyChangeListener propListener;
    private boolean generateFromPoints = false;
    private boolean orderReversed = false;
    private Border border = null;
    private Paint legendBackground = null;
    private boolean atFront = true;
    private ChartModel rolloverModel;
    private int keyLabelGap = 0;

    public Legend() {
        this(null, 1);
    }

    public Legend(boolean bl, int n) {
        this(null, 0);
        if (bl) {
            this.setLayout(new WrapLayout(n));
        }
    }

    public Legend(Chart chart) {
        this(chart, 1);
    }

    public Legend(Chart chart, boolean bl) {
        this(chart, 0);
        if (bl) {
            this.setLayout(new WrapLayout());
        }
    }

    public Legend(Chart chart, boolean bl, int n) {
        this(chart, 0);
        if (bl) {
            this.setLayout(new WrapLayout(n));
        }
    }

    public Legend(Chart chart, int n) {
        this.columns = n;
        this.setLayout(this.gridBagLayout);
        this.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.propListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if ("Model".equals(string) || "ChartStyle".equals(string)) {
                    Legend.this.updateLegend();
                }
            }
        };
        if (chart != null) {
            this.addChart(chart);
        }
        MouseListenerAdapter mouseListenerAdapter = new MouseListenerAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                LegendItem legendItem;
                Point point = mouseEvent.getPoint();
                Component component = Legend.this.getComponentAt(point);
                if (component == null) {
                    return;
                }
                if (component instanceof JLabel) {
                    component = ((JLabel)component).getLabelFor();
                }
                if (component instanceof LegendItem && (legendItem = (LegendItem)((Object)component)).getSource() instanceof ChartModel) {
                    ChartModel chartModel = (ChartModel)legendItem.getSource();
                    Legend.this.setRolloverModel(chartModel);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                Legend.this.setRolloverModel(null);
            }
        };
        this.addMouseListener(mouseListenerAdapter);
        this.addMouseMotionListener(mouseListenerAdapter);
    }

    public int getKeyLabelGap() {
        return this.keyLabelGap;
    }

    public void setKeyLabelGap(int n) {
        int n2 = this.keyLabelGap;
        this.keyLabelGap = n;
        this.firePropertyChange(PROPERTY_KEY_LABEL_GAP, n2, n);
    }

    public Paint getLegendBackground() {
        return this.legendBackground == null ? this.getBackground() : this.legendBackground;
    }

    public void setLegendBackground(Paint paint) {
        Paint paint2 = this.legendBackground;
        this.legendBackground = paint;
        this.repaint();
        this.firePropertyChange(PROPERTY_LEGEND_BACKGROUND, paint2, paint);
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color color) {
        Color color2 = this.labelColor;
        this.labelColor = color;
        this.updateLegend();
        this.firePropertyChange(PROPERTY_LABEL_COLOR, color2, color);
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(Color color) {
        Color color2 = this.titleColor;
        this.titleColor = color;
        if (this.titleLabel != null) {
            this.titleLabel.setForeground(color);
        }
        this.updateLegend();
        this.firePropertyChange(PROPERTY_TITLE_COLOR, color2, color);
    }

    private void setRolloverModel(ChartModel chartModel) {
        ChartModel chartModel2 = this.rolloverModel;
        this.rolloverModel = chartModel;
        this.firePropertyChange(PROPERTY_ROLLOVER_MODEL, chartModel2, chartModel);
    }

    public void addExcludedModels(ChartModel ... chartModelArray) {
        Collections.addAll(this.excludedModels, chartModelArray);
        this.updateLegend();
    }

    public void removeExcludedModels(ChartModel ... chartModelArray) {
        for (ChartModel chartModel : chartModelArray) {
            this.excludedModels.remove(chartModel);
        }
        this.updateLegend();
    }

    public void clearExcludedModels() {
        this.excludedModels.clear();
        this.updateLegend();
    }

    public Legend addIncludedModel(ChartModel chartModel) {
        this.includedModels.add(chartModel);
        this.updateLegend();
        return this;
    }

    public Legend removeIncludedModel(ChartModel chartModel) {
        this.includedModels.remove(chartModel);
        this.updateLegend();
        return this;
    }

    public Legend addLegendItem(LegendItem legendItem) {
        this.additionalItems.add(legendItem);
        this.updateLegend();
        return this;
    }

    public Legend removeLegendItem(LegendItem legendItem) {
        this.additionalItems.remove(legendItem);
        this.updateLegend();
        return this;
    }

    public void addExcludedPoints(Chartable ... chartableArray) {
        Collections.addAll(this.excludedPoints, chartableArray);
        this.updateLegend();
    }

    public void removeExcludedPoints(Chartable ... chartableArray) {
        for (Chartable chartable : chartableArray) {
            this.excludedPoints.remove(chartable);
        }
        this.updateLegend();
    }

    public void clearExcludedPoints() {
        this.excludedPoints.clear();
    }

    @Override
    public void setBorder(Border border) {
        this.border = border;
        this.updateLegend();
    }

    public void addChart(Chart chart) {
        WeakReference<Chart> weakReference = new WeakReference<Chart>(chart);
        this.charts.add(weakReference);
        chart.addPropertyChangeListener(this.propListener);
        this.updateLegend();
    }

    public void removeChart(Chart chart) {
        for (int i = this.charts.size() - 1; i >= 0; --i) {
            WeakReference<Chart> weakReference = this.charts.get(i);
            Chart chart2 = (Chart)weakReference.get();
            if (chart2 != null && !chart.equals(chart2)) continue;
            this.charts.remove(i);
        }
        chart.removePropertyChangeListener(this.propListener);
    }

    int getChartCount() {
        return this.charts.size();
    }

    public void setColumns(int n) {
        int n2 = this.columns;
        this.columns = n;
        this.updateLegend();
        this.firePropertyChange(PROPERTY_COLUMNS, n2, n);
    }

    public void clear() {
        this.charts.clear();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        String string2 = this.title;
        if (string == null) {
            this.titleLabel = null;
        } else {
            if (this.titleLabel == null) {
                this.titleLabel = this.createLegendTitle(string);
            }
            this.title = string;
        }
        this.firePropertyChange(PROPERTY_TITLE, string2, string);
        this.updateLegend();
    }

    public JLabel getTitleLabel() {
        return this.titleLabel;
    }

    public void setTitleLabel(JLabel jLabel) {
        JLabel jLabel2 = this.titleLabel;
        this.titleLabel = jLabel;
        this.firePropertyChange(PROPERTY_TITLE_LABEL, jLabel2, jLabel);
    }

    public boolean isGenerateFromPoints() {
        return this.generateFromPoints;
    }

    public void setGenerateFromPoints(boolean bl) {
        boolean bl2 = this.generateFromPoints;
        this.generateFromPoints = bl;
        this.updateLegend();
        this.firePropertyChange(PROPERTY_GENERATE_FROM_POINTS, bl2, bl);
    }

    public boolean isOrderReversed() {
        return this.orderReversed;
    }

    public void setOrderReversed(boolean bl) {
        boolean bl2 = this.orderReversed;
        this.orderReversed = bl;
        this.updateLegend();
        this.firePropertyChange(PROPERTY_ORDER_REVERSED, bl2, bl);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.updateLegend();
    }

    protected void updateLegend() {
        Serializable serializable;
        Object object;
        Object object2;
        WeakReference<Chart> weakReference2;
        Cloneable cloneable;
        this.removeAll();
        super.setBorder(null);
        if (this.titleLabel != null) {
            cloneable = new GridBagConstraints(0, 0, this.columns, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0);
            this.add((Component)this.titleLabel, cloneable);
        }
        if (this.charts == null) {
            return;
        }
        cloneable = new ArrayList();
        for (WeakReference<Chart> weakReference2 : this.charts) {
            object2 = weakReference2 == null ? null : (Chart)weakReference2.get();
            if (object2 == null) continue;
            object = ((Chart)object2).getChartType();
            if (object == ChartType.PIE || this.generateFromPoints) {
                cloneable.addAll(this.createLegendPairsFromPoints((Chart)object2));
                continue;
            }
            serializable = new ArrayList<ChartModel>(((Chart)object2).getModels());
            for (ChartModel chartModel : this.includedModels) {
                serializable.add((ChartModel)chartModel);
            }
            if (this.isOrderReversed()) {
                Collections.reverse(serializable);
            }
            cloneable.addAll(this.createLegendPairsFromModels((Chart)object2, (List<ChartModel>)((Object)serializable)));
        }
        ArrayList<LegendItem> arrayList = new ArrayList<LegendItem>(this.additionalItems);
        if (this.isOrderReversed()) {
            Collections.reverse(arrayList);
        }
        weakReference2 = arrayList.iterator();
        while (weakReference2.hasNext()) {
            object2 = (LegendItem)weakReference2.next();
            cloneable.add(this.createLegendPair((LegendItem)object2, this.createLegendLabel(object2.getLabel())));
        }
        int n = 0;
        int n2 = 1;
        object = cloneable.iterator();
        while (object.hasNext()) {
            serializable = (LegendPair)object.next();
            GridBagConstraints gridBagConstraints = new GridBagConstraints(n, n2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 0, 2), 10, 0);
            this.add((Component)serializable, gridBagConstraints);
            if (this.columns <= 0 || ++n < this.columns) continue;
            ++n2;
            n = 0;
        }
        if (this.getComponentCount() > 0) {
            super.setBorder(this.border);
        }
        this.lastUpdated = System.currentTimeMillis();
    }

    private List<LegendPair> createLegendPairsFromPoints(Chart chart) {
        ArrayList<LegendPair> arrayList = new ArrayList<LegendPair>();
        ChartModel chartModel = chart.getModel();
        int n = 0;
        int n2 = 1;
        if (this.isOrderReversed()) {
            n = chartModel.getPointCount() - 1;
            n2 = -1;
        }
        for (int i = n; i >= 0 && chartModel != null && i < chartModel.getPointCount(); i += n2) {
            Chartable chartable = chartModel.getPoint(i);
            LegendItem legendItem = this.createPointLegendItem(chartable, chartModel, chart);
            JLabel jLabel = this.createLegendLabel(chartable);
            LegendPair legendPair = this.createLegendPair(legendItem, jLabel);
            arrayList.add(legendPair);
        }
        return arrayList;
    }

    protected LegendItem createPointLegendItem(Chartable chartable, ChartModel chartModel, Chart chart) {
        return new PointLegendItem(chartable, chartModel, chart);
    }

    private List<LegendPair> createLegendPairsFromModels(Chart chart, List<ChartModel> list) {
        ArrayList<LegendPair> arrayList = new ArrayList<LegendPair>();
        for (ChartModel chartModel : list) {
            if (this.excludedModels.contains(chartModel)) continue;
            LegendItem legendItem = this.createModelLegendItem(chartModel, chart);
            JComponent jComponent = this.createLegendLabel(chartModel);
            LegendPair legendPair = this.createLegendPair(legendItem, jComponent);
            arrayList.add(legendPair);
        }
        return arrayList;
    }

    protected LegendItem createModelLegendItem(ChartModel chartModel, Chart chart) {
        return new ModelLegendItem(chartModel, chart);
    }

    protected LegendItem createModelLegendItem(ChartModel chartModel, Chart chart, ChartStyle chartStyle) {
        return new ModelLegendItem(chartModel, chart, chartStyle);
    }

    protected LegendPair createLegendPair(LegendItem legendItem, JComponent jComponent) {
        return new LegendPair(this, legendItem, jComponent);
    }

    protected JLabel createLegendLabel(Chartable chartable) {
        Object object;
        if (chartable instanceof Named && (object = ((Named)((Object)chartable)).getName()) != null) {
            return new JLabel((String)object);
        }
        object = chartable.getX();
        String string = Double.toString(object.position());
        if (object instanceof Category) {
            Category category = (Category)object;
            string = category.getName();
        }
        return new JLabel(string);
    }

    protected JComponent createLegendLabel(ChartModel chartModel) {
        return this.createLegendLabel(chartModel.getName());
    }

    protected JComponent createLegendLabel(String string) {
        JLabel jLabel = new JLabel(string, 2);
        if (this.labelColor != null) {
            jLabel.setForeground(this.labelColor);
        }
        jLabel.setFont(this.getFont());
        return jLabel;
    }

    protected JLabel createLegendTitle(String string) {
        JLabel jLabel = new JLabel(string, 0);
        if (this.titleColor != null) {
            jLabel.setForeground(this.titleColor);
        }
        jLabel.setFont(this.getFont());
        return jLabel;
    }

    @Override
    public boolean isAtFront() {
        return this.atFront;
    }

    @Override
    public void setAtFront(boolean bl) {
        boolean bl2 = this.atFront;
        this.atFront = bl;
        this.firePropertyChange(PROPERTY_AT_FRONT, bl2, bl);
    }

    @Override
    public void draw(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        this.validate();
        this.doLayout();
        this.setSize(this.getPreferredSize());
        int n = this.getX();
        int n2 = this.getY();
        graphics.translate(n, n2);
        this.print(graphics);
        graphics.translate(-n, -n2);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (!this.isOpaque()) {
            super.paintComponent(graphics);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = this.legendBackground == null ? this.getBackground() : this.legendBackground;
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics2D.setPaint(paint);
        graphics2D.fillRect(0, 0, n, n2);
        this.setOpaque(false);
        super.paintComponent(graphics);
        this.setOpaque(true);
    }

    long getLastUpdated() {
        return this.lastUpdated;
    }

    class MouseListenerAdapter
    implements MouseListener,
    MouseMotionListener {
        MouseListenerAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    static class ModelLegendItem
    extends JComponent
    implements LegendItem<ChartModel, ChartModel> {
        private static final long serialVersionUID = 8445473530598990518L;
        private ChartModel model;
        private Chart chart;
        private ChartStyle style;

        public ModelLegendItem(ChartModel chartModel, Chart chart) {
            this(chartModel, chart, chart.getStyle(chartModel));
        }

        public ModelLegendItem(ChartModel chartModel, Chart chart, ChartStyle chartStyle) {
            this.setOpaque(false);
            this.model = chartModel;
            this.chart = chart;
            if (chartStyle == null) {
                chartStyle = ChartStyle.DEFAULT_STYLE;
            }
            this.style = chartStyle;
            int n = 1 + Math.max(20, chartStyle.getPointSize());
            int n2 = 1 + Math.max(30, chartStyle.getPointSize());
            Dimension dimension = new Dimension(n2, n);
            this.setMinimumSize(dimension);
            this.setSize(dimension);
            this.setPreferredSize(dimension);
        }

        @Override
        public Component getComponent() {
            return this;
        }

        @Override
        public String getLabel() {
            return this.model.getName();
        }

        @Override
        public ChartModel getSource() {
            return this.model;
        }

        @Override
        public ChartModel getItem() {
            return this.model;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Object object;
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Dimension dimension = this.getSize();
            int n = dimension.height;
            int n2 = dimension.width;
            if (this.style == null) {
                return;
            }
            if (this.style.isLinesVisible()) {
                object = this.chart.getLineRenderer(this.model);
                if (this.style.getLineFill() != null) {
                    int[] nArray = new int[]{5, 5 + (n2 - 10) / 2, n2 - 5};
                    int[] nArray2 = new int[]{3 * n / 4, (int)Math.round((double)n / 2.0) - 1, 3 * n / 4};
                    object.renderLine(graphics2D, null, nArray, nArray2, this.style);
                } else {
                    object.renderLine(graphics2D, null, new int[]{5, n2 - 5}, new int[]{n / 2, n / 2}, this.style);
                }
            }
            if (this.style.isPointsVisible()) {
                object = this.chart.getPointRenderer(this.model);
                object.renderPoint(graphics2D, this.chart, this.model, null, false, false, false, n2 / 2, n / 2);
            }
            if (this.style.isBarsVisible()) {
                object = this.chart.getBarRenderer(this.model);
                object.renderBar(graphics2D, this.chart, this.model, null, false, false, false, 5, n / 4, n2 - 10, n / 2);
            }
            graphics2D.dispose();
        }
    }
}

