/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.DockableBarManager;
import java.io.ByteArrayInputStream;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class DockableBarManagerUndoableEdit
implements UndoableEdit {
    private String _name;
    private byte[] _undoLayout;
    private byte[] _redoLayout;
    private DockableBarManager _dockableBarManager;

    public DockableBarManagerUndoableEdit(String string, DockableBarManager dockableBarManager) {
        this._name = string;
        this._dockableBarManager = dockableBarManager;
        this._undoLayout = this._dockableBarManager.getLayoutRawData();
    }

    @Override
    public void undo() throws CannotUndoException {
        this._redoLayout = this._dockableBarManager.getLayoutRawData();
        this._dockableBarManager.setLayoutRawData(this._undoLayout);
    }

    @Override
    public boolean canUndo() {
        return this._undoLayout != null;
    }

    @Override
    public void redo() throws CannotRedoException {
        this._dockableBarManager.loadLayoutFrom(new ByteArrayInputStream(this._redoLayout, 0, this._redoLayout.length));
    }

    @Override
    public boolean canRedo() {
        return this._redoLayout != null;
    }

    @Override
    public void die() {
        this._undoLayout = null;
        this._redoLayout = null;
        this._dockableBarManager = null;
    }

    @Override
    public boolean addEdit(UndoableEdit undoableEdit) {
        return false;
    }

    @Override
    public boolean replaceEdit(UndoableEdit undoableEdit) {
        return false;
    }

    @Override
    public boolean isSignificant() {
        return true;
    }

    @Override
    public String getPresentationName() {
        return this._name;
    }

    @Override
    public String getUndoPresentationName() {
        return "Undo " + this._name;
    }

    @Override
    public String getRedoPresentationName() {
        return "Redo " + this._name;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public byte[] getUndoLayout() {
        return this._undoLayout;
    }

    public void setUndoLayout(byte[] byArray) {
        this._undoLayout = byArray;
    }

    public byte[] getRedoLayout() {
        return this._redoLayout;
    }

    public void setRedoLayout(byte[] byArray) {
        this._redoLayout = byArray;
    }
}

