/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.CommandBar;
import com.jidesoft.action.CommandBarBorderListener;
import com.jidesoft.action.DockableBar;
import com.jidesoft.action.DockableBarContainer;
import com.jidesoft.action.DockableBarContext;
import com.jidesoft.action.DockableBarFactory;
import com.jidesoft.action.DockableBarItem;
import com.jidesoft.action.DockableBarList;
import com.jidesoft.action.DockableBarListList;
import com.jidesoft.action.DockableBarManager;
import com.jidesoft.action.DockableBarPersistenceUtils;
import com.jidesoft.action.DockableBarPopupMenuCustomizer;
import com.jidesoft.action.DockableBarUtils;
import com.jidesoft.action.FloatingDockableBarContainer;
import com.jidesoft.action.FloatingDockableBars;
import com.jidesoft.action.HiddenDockableBars;
import com.jidesoft.action.MainContainer;
import com.jidesoft.action.PreviousState;
import com.jidesoft.action.Resource;
import com.jidesoft.action.SaveUtils;
import com.jidesoft.action.event.DockableBarState;
import com.jidesoft.action.event.DockableBarStateTransition;
import com.jidesoft.action.event.DockableBarsRearrangedEvent;
import com.jidesoft.action.event.DockableBarsRearrangedListener;
import com.jidesoft.converter.XmlUtils;
import com.jidesoft.docking.DockingUtils;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.AbstractLayoutPersistence;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.PersistenceUtils;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.KeyEventDispatcher;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DefaultDockableBarManager
extends AbstractLayoutPersistence
implements DockableBarManager,
AWTEventListener,
SwingConstants {
    private static final Logger LOGGER;
    private static final Logger LOGGER_EVENT;
    private final Map<String, DockableBar> _allDockableBars = new HashMap<String, DockableBar>();
    private final List<String> _allDockableBarKeys = new ArrayList<String>();
    private final Map<String, DockableBarContext> _allContexts = new HashMap<String, DockableBarContext>();
    private Container _contentContainer;
    private RootPaneContainer _rootPaneContainer;
    private MainContainer _mainContainer;
    FloatingDockableBars<FloatingDockableBarContainer> _floatingDockableBars;
    HiddenDockableBars<String> _hiddenDockableBars = new HiddenDockableBars();
    DockableBarContainer _eastDockableBarContainer;
    DockableBarContainer _westDockableBarContainer;
    DockableBarContainer _northDockableBarContainer;
    DockableBarContainer _southDockableBarContainer;
    private boolean _startInFloat;
    private double _relativeX;
    private double _relativeY;
    private boolean _isDragging = false;
    private JComponent _draggingComponent = null;
    private boolean _isResizing = false;
    private DockableBarContainer _resizingPane = null;
    private boolean _rearrangeable = true;
    private boolean _floatable = true;
    private boolean _hidable = true;
    private DockableBarPopupMenuCustomizer _dockableBarPopupMenuCustomizer;
    private boolean _showContextMenu = true;
    private boolean _realized = false;
    private Rectangle _initBounds = new Rectangle();
    private int _initState;
    private boolean _hideFloatingDockableBarsWhenDeactivate = true;
    private boolean _showFloatingDockableBars = true;
    int _state;
    Rectangle _unmaximizedBounds = new Rectangle();
    public ComponentAdapter _componentListener;
    private Window _lastFocusedWindow;
    private static final int HIDE_OFFSCREEN_OFFSET = 10000;
    private boolean _loadingLayoutData = false;
    private KeyEventDispatcher _keyEventDispatcher;
    private boolean _preserveAvailableProperty = false;
    private boolean _showInitial = true;
    FloatingDockableBarContainer _currentFloatingCommandBar;
    private JPopupMenu _globalContextMenu;
    private PropertyChangeListener _dockableBarPropertyChangeListener;
    private boolean _loadDataSuccessful = true;
    protected DockableBarsSnapshot _preDragSnapshot = new DockableBarsSnapshot();
    protected DockableBarsSnapshot _postDragSnapshot = new DockableBarsSnapshot();
    protected EventListenerList listenerList = new EventListenerList();
    protected boolean _redispatchingKeyEventToFloaters = false;
    public static final String PROPERTY_INIT_BOUNDS = "initBounds";
    public static final String PROPERTY_INIT_STATE = "initState";
    public static final String PROPERTY_HIDABLE = "hidable";
    public static final String PROPERTY_FLOATABLE = "floatable";
    public static final String PROPERTY_REARRANGABLE = "rearrangable";
    public static final String PROPERTY_HIDE_FLOATING_DOCKABLE_BARS_WHEN_DEACTIVATE = "hideFloatingDockableBarsWhenDeactivate";
    public static final String PROPERTY_SHOW_CONTEXT_MENU = "showContextMenu";
    public static final String PROPERTY_DOUBLE_CLICK_ACTION = "doubleClickAction";
    private FloaterKeyEventPostProcessor _keyEventPostProcessor;
    private WindowListener _windowListener;
    protected boolean _glassPaneVisibility;
    private boolean _useGlassPaneEnabled = true;
    private int _doubleClickAction = 0;
    int _saveDeltaX;
    int _saveDeltaY;
    private DockableBarFactory _dockableBarFactory;
    private static final String NODE_MANAGERS = "Managers";
    private static final String NODE_DOCKABLE_BAR_MANAGER = "DockableBarManager";
    private static final String NODE_DOCKABLE_BARS = "DockableBars";
    private static final String NODE_DOCKABLE_BAR = "DockableBar";
    private static final String ATTRIBUTE_KEY = "key";

    public DefaultDockableBarManager(RootPaneContainer rootPaneContainer, Container container) {
        this.switchRootPaneContainer(rootPaneContainer);
        Method method = null;
        try {
            method = container.getClass().getMethod("getContentPane", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (method != null) {
            try {
                Object object = method.invoke((Object)container, new Object[0]);
                if (object instanceof Container) {
                    ((Container)object).removeAll();
                }
            }
            catch (Exception exception) {}
        } else {
            container.removeAll();
        }
        this._contentContainer = container;
        this._mainContainer = new MainContainer();
        this.getContentContainer().setBackground(UIDefaultsLookup.getColor("ContentContainer.background"));
        this.getContentContainer().setLayout(new BorderLayout());
        this.getContentContainer().add((Component)this._mainContainer, "Center");
        this.addMouseEventHandler();
        this._dockableBarPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (DefaultDockableBarManager.ATTRIBUTE_KEY.equals(propertyChangeEvent.getPropertyName())) {
                    DefaultDockableBarManager.this.updateKey((String)propertyChangeEvent.getOldValue(), (String)propertyChangeEvent.getNewValue());
                }
            }
        };
        this._keyEventPostProcessor = new FloaterKeyEventPostProcessor();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(this._keyEventPostProcessor);
        this.setRealized(false);
    }

    @Override
    public void switchRootPaneContainer(RootPaneContainer rootPaneContainer) {
        if (rootPaneContainer == null) {
            return;
        }
        this._rootPaneContainer = rootPaneContainer;
        this._componentListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                this.clearUp();
                this.getWindowGeometry(componentEvent);
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                this.clearUp();
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                this.clearUp();
                this.getWindowGeometry(componentEvent);
            }

            private void clearUp() {
                if (DefaultDockableBarManager.this.isDragging()) {
                    DefaultDockableBarManager.this.cancelDragging();
                }
            }

            private void getWindowGeometry(ComponentEvent componentEvent) {
                if (componentEvent.getComponent() instanceof Frame) {
                    Frame frame = (Frame)componentEvent.getComponent();
                    if (PortingUtils.getFrameState(frame) != 6) {
                        DefaultDockableBarManager.this._unmaximizedBounds.x = frame.getX();
                        DefaultDockableBarManager.this._unmaximizedBounds.y = frame.getY();
                        DefaultDockableBarManager.this._unmaximizedBounds.width = frame.getWidth();
                        DefaultDockableBarManager.this._unmaximizedBounds.height = frame.getHeight();
                    }
                } else if (componentEvent.getComponent() instanceof Window) {
                    Window window = (Window)componentEvent.getComponent();
                    DefaultDockableBarManager.this._unmaximizedBounds.x = window.getX();
                    DefaultDockableBarManager.this._unmaximizedBounds.y = window.getY();
                    DefaultDockableBarManager.this._unmaximizedBounds.width = window.getWidth();
                    DefaultDockableBarManager.this._unmaximizedBounds.height = window.getHeight();
                }
            }
        };
        if (this.getRootPaneContainerAsComponent() != null) {
            this.getRootPaneContainerAsComponent().addComponentListener(this._componentListener);
        }
        this._windowListener = new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                if (DefaultDockableBarManager.this.isHideFloatingDockableBarsWhenDeactivate()) {
                    DefaultDockableBarManager.this.internalSetFloatingDockableBarsVisible(true);
                }
                if (DefaultDockableBarManager.this._lastFocusedWindow != null) {
                    DefaultDockableBarManager.this._lastFocusedWindow = null;
                }
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                if (!DefaultDockableBarManager.this.isOwnedWindow(windowEvent.getOppositeWindow()) && !DefaultDockableBarManager.this.isOwnedFloatingDockableBar(windowEvent.getOppositeWindow())) {
                    Component component;
                    if (DefaultDockableBarManager.this._lastFocusedWindow == null && (component = DefaultDockableBarManager.this.getRootPaneContainerAsComponent()) instanceof Window) {
                        DefaultDockableBarManager.this._lastFocusedWindow = (Window)component;
                    }
                    if (DefaultDockableBarManager.this.isHideFloatingDockableBarsWhenDeactivate()) {
                        DefaultDockableBarManager.this.internalSetFloatingDockableBarsVisible(false);
                    }
                }
            }
        };
        if (rootPaneContainer instanceof Window) {
            ((Window)((Object)rootPaneContainer)).addWindowListener(this._windowListener);
        }
    }

    @Override
    public void setFloatingDockableBarsVisible(boolean bl) {
        this._showFloatingDockableBars = bl;
        this.internalSetFloatingDockableBarsVisible(bl);
    }

    private void internalSetFloatingDockableBarsVisible(boolean bl) {
        if (this._floatingDockableBars == null) {
            return;
        }
        for (FloatingDockableBarContainer floatingDockableBarContainer : this._floatingDockableBars) {
            if (this._showFloatingDockableBars && bl) {
                this.hackSetFrameVisible(floatingDockableBarContainer, bl);
                continue;
            }
            this.hackSetFrameVisible(floatingDockableBarContainer, false);
        }
    }

    protected void hackSetFrameVisible(FloatingDockableBarContainer floatingDockableBarContainer, boolean bl) {
        try {
            int n = floatingDockableBarContainer.getLocationOnScreen().x;
            int n2 = floatingDockableBarContainer.getLocationOnScreen().y;
            if (bl && !this.hackIsFrameVisible(floatingDockableBarContainer)) {
                floatingDockableBarContainer.setLocation(n, n2 + 10000);
            } else if (!bl && this.hackIsFrameVisible(floatingDockableBarContainer)) {
                floatingDockableBarContainer.setLocation(n, n2 - 10000);
            }
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
    }

    protected boolean hackIsFrameVisible(FloatingDockableBarContainer floatingDockableBarContainer) {
        int n = floatingDockableBarContainer.getLocationOnScreen().y;
        return n >= -5000;
    }

    protected boolean isOwnedFloatingDockableBar(Window window) {
        if (this._floatingDockableBars == null || this._floatingDockableBars.size() == 0 || window == null) {
            return false;
        }
        return this._floatingDockableBars.contains(window);
    }

    protected boolean isOwnedWindow(Window window) {
        RootPaneContainer rootPaneContainer = this.getRootPaneContainer();
        return window != null && rootPaneContainer instanceof Container && ((Container)((Object)rootPaneContainer)).isAncestorOf(window);
    }

    private void addGlobalEventHandler() {
        try {
            this._keyEventDispatcher = new KeyEventDispatcher(){

                @Override
                public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                    DefaultDockableBarManager.this.handleKeyEvent(keyEvent);
                    return false;
                }
            };
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this._keyEventDispatcher);
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(securityException);
        }
    }

    private void removeGlobalEventHandler() {
        try {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this._keyEventDispatcher);
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(securityException);
        }
    }

    private void addMouseEventHandler() {
        if (this.shouldAWTEventListenerBeUsed()) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Toolkit.getDefaultToolkit().addAWTEventListener(DefaultDockableBarManager.this, 48L);
                    return null;
                }
            });
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(securityException);
        }
    }

    private boolean shouldAWTEventListenerBeUsed() {
        return SecurityUtils.isAWTEventListenerDisabled() || "true".equals(SecurityUtils.getProperty("jide.disableAWTEventListener", "false"));
    }

    private void removeMouseEventHandler() {
        if (this.shouldAWTEventListenerBeUsed()) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(DefaultDockableBarManager.this);
                    return null;
                }
            });
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(securityException);
        }
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (aWTEvent instanceof MouseEvent) {
            if (aWTEvent.getID() == 506) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                if (this.isDragging()) {
                    Point point = mouseEvent.getPoint();
                    Object object = mouseEvent.getSource();
                    if (object instanceof Component) {
                        CommandBarBorderListener.convertPointToScreen(point, (Component)object, this._startInFloat);
                        this.dragDockableBar(null, point.x, point.y, mouseEvent.getModifiersEx());
                        mouseEvent.consume();
                    }
                }
            } else if (aWTEvent.getID() == 502) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                if (this.isDragging()) {
                    this.endDraggingDockableBar();
                    mouseEvent.consume();
                }
                if (SystemInfo.isWindows() && this._globalContextMenu != null && this._globalContextMenu.isVisible() && !this._globalContextMenu.isAncestorOf((Component)mouseEvent.getSource())) {
                    this._globalContextMenu.setVisible(false);
                    this._globalContextMenu = null;
                }
                this.triggerPopupMenu(mouseEvent);
            } else if (aWTEvent.getID() == 501) {
                this.triggerPopupMenu((MouseEvent)aWTEvent);
            }
        }
    }

    private void triggerPopupMenu(MouseEvent mouseEvent) {
        if (this.isShowContextMenu() && mouseEvent.isPopupTrigger()) {
            Component component = null;
            Object object = mouseEvent.getSource();
            if (object instanceof Component && (component = SwingUtilities.getDeepestComponentAt((Component)object, mouseEvent.getX(), mouseEvent.getY())) != null) {
                if (component instanceof JComponent && Boolean.TRUE.equals(((JComponent)component).getClientProperty("DockableBarManager.suppressContextMenu"))) {
                    return;
                }
                if ((component = DockableBarUtils.getDockableBarOrContainer(component)) instanceof DockableBar) {
                    if (((DockableBar)component).getDockableBarManager() == this) {
                        this.showContextMenu(mouseEvent, component);
                    }
                } else if (component instanceof DockableBarContainer && ((DockableBarContainer)component).getDockableBarManager() == this) {
                    this.showContextMenu(mouseEvent, component);
                }
            }
        }
    }

    private void handleKeyEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof KeyEvent) {
            if (aWTEvent.getID() == 401 && ((KeyEvent)aWTEvent).getKeyCode() == 27) {
                if (this.isDragging()) {
                    this.cancelDragging();
                }
            } else if (aWTEvent.getID() == 401 && ((KeyEvent)aWTEvent).getKeyCode() == 17) {
                this.setAllowDraggingDockableBarDocking(false);
            } else if (aWTEvent.getID() == 402 && ((KeyEvent)aWTEvent).getKeyCode() == 17) {
                this.setAllowDraggingDockableBarDocking(true);
            }
        }
    }

    @Override
    public void resetToDefault() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalResetToDefault();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockableBarManager.this.internalResetToDefault();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
        }
    }

    private void internalResetToDefault() {
        Serializable serializable;
        this.clearLayout();
        this._unmaximizedBounds = (Rectangle)this.getInitBounds().clone();
        this._state = this.getInitState();
        this._floatingDockableBars = new FloatingDockableBars();
        this._eastDockableBarContainer = this.createDockableBarContainer();
        this._eastDockableBarContainer.setSide(3);
        this._westDockableBarContainer = this.createDockableBarContainer();
        this._westDockableBarContainer.setSide(7);
        this._northDockableBarContainer = this.createDockableBarContainer();
        this._northDockableBarContainer.setSide(1);
        this._southDockableBarContainer = this.createDockableBarContainer();
        this._southDockableBarContainer.setSide(5);
        this.getContentContainer().add((Component)this._eastDockableBarContainer, "East");
        this.getContentContainer().add((Component)this._westDockableBarContainer, "West");
        this.getContentContainer().add((Component)this._southDockableBarContainer, "South");
        this.getContentContainer().add((Component)this._northDockableBarContainer, "North");
        ArrayList<DockableBar> arrayList = new ArrayList<DockableBar>();
        ArrayList<DockableBar> arrayList2 = new ArrayList<DockableBar>();
        ArrayList<DockableBar> arrayList3 = new ArrayList<DockableBar>();
        ArrayList<DockableBar> arrayList4 = new ArrayList<DockableBar>();
        ArrayList<DockableBar> arrayList5 = new ArrayList<DockableBar>();
        for (String object2 : this._allDockableBarKeys) {
            serializable = this.getDockableBar(object2);
            ((DockableBar)serializable).getContext().setInitPosition(true);
            int dockableBarListList2 = ((DockableBar)serializable).getContext().getInitMode();
            ((DockableBar)serializable).getContext().setCurrentMode(dockableBarListList2 < 0 ? 0 : dockableBarListList2);
            if (((DockableBar)serializable).isHidden()) {
                this._hiddenDockableBars.add(((DockableBar)serializable).getKey());
            }
            if (((DockableBar)serializable).isVertDocked() || ((DockableBar)serializable).isHoriDocked()) {
                int set = ((DockableBar)serializable).getContext().getInitSide();
                ((DockableBar)serializable).getContext().setCurrentDockSide(set);
                switch (DockableBarUtils.convertDockSideToSide(set)) {
                    case 3: {
                        arrayList2.add((DockableBar)serializable);
                        break;
                    }
                    case 7: {
                        arrayList.add((DockableBar)serializable);
                        break;
                    }
                    case 1: {
                        arrayList3.add((DockableBar)serializable);
                        break;
                    }
                    case 5: {
                        arrayList4.add((DockableBar)serializable);
                    }
                }
                continue;
            }
            if (!((DockableBar)serializable).isFloating()) continue;
            arrayList5.add((DockableBar)serializable);
        }
        DockableBarListList dockableBarListList = this.createDockableBarListList(arrayList2, this._eastDockableBarContainer);
        DockableBarListList dockableBarListList2 = this.createDockableBarListList(arrayList, this._westDockableBarContainer);
        serializable = this.createDockableBarListList(arrayList3, this._northDockableBarContainer);
        DockableBarListList dockableBarListList3 = this.createDockableBarListList(arrayList4, this._southDockableBarContainer);
        this._eastDockableBarContainer.setDockableBarList(dockableBarListList);
        this._westDockableBarContainer.setDockableBarList(dockableBarListList2);
        this._northDockableBarContainer.setDockableBarList((DockableBarListList)serializable);
        this._southDockableBarContainer.setDockableBarList(dockableBarListList3);
        this.createFloatedContainer(arrayList5);
        if (this._allContexts != null) {
            Set<String> set = this._allContexts.keySet();
            for (String string : set) {
                DockableBar dockableBar = this.getDockableBar(string);
                if (dockableBar == null) continue;
                dockableBar.setContext(this._allContexts.get(string));
            }
        }
        this.setRealized(true);
        this.setBoundsState();
        this.fireBarEvents();
    }

    private void createFloatedContainer(List<DockableBar> list) {
        if (list.size() == 0) {
            return;
        }
        for (DockableBar dockableBar : list) {
            this.floatDockableBar(dockableBar, dockableBar.getUndockedBounds());
        }
    }

    private List<Integer> sortByIndex(List<DockableBar> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (DockableBar dockableBar : list) {
            Integer n = dockableBar.getContext().getInitIndex();
            if (arrayList.indexOf(n) != -1) continue;
            arrayList.add(n);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private DockableBarListList createDockableBarListList(List<DockableBar> list, Container container) {
        DockableBarListList dockableBarListList = new DockableBarListList(container);
        List<Integer> list2 = this.sortByIndex(list);
        for (Integer n : list2) {
            DockableBarList dockableBarList = new DockableBarList(dockableBarListList);
            for (DockableBar dockableBar : list) {
                if (n.intValue() != dockableBar.getContext().getInitIndex()) continue;
                dockableBarList.add(new DockableBarItem(dockableBar, dockableBar.getContext().getInitSubindex()));
            }
            dockableBarListList.add(dockableBarList);
        }
        return dockableBarListList;
    }

    @Override
    public void addDockableBar(final DockableBar dockableBar) {
        if (dockableBar == null) {
            return;
        }
        if (dockableBar.getKey() == null || dockableBar.getKey().trim().length() == 0) {
            throw new IllegalArgumentException("The DockableBar is null or it has a null or empty key. Please call setKey() method to set a non-empty string as the key before adding it to DockableBarManager.");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalAddDockableBar(dockableBar);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockableBarManager.this.internalAddDockableBar(dockableBar);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
        }
    }

    private void internalAddDockableBar(DockableBar dockableBar) {
        if (this._allDockableBars.containsKey(dockableBar.getKey())) {
            throw new IllegalArgumentException("The DockableBar exists with name \"" + dockableBar.getKey() + "\". Please specify a new name for the dockable bar.");
        }
        this._allDockableBars.put(dockableBar.getKey(), dockableBar);
        this._allDockableBarKeys.add(dockableBar.getKey());
        dockableBar.addPropertyChangeListener(ATTRIBUTE_KEY, this._dockableBarPropertyChangeListener);
        dockableBar.setDockableBarManager(this);
        DockableBarContext dockableBarContext = this.getDockableBarContextOf(dockableBar.getKey());
        if (dockableBarContext == null) {
            this.addContext(dockableBar.getKey(), dockableBar.getContext());
            if (this.isRealized()) {
                if (dockableBar.isHidden()) {
                    this._hiddenDockableBars.add(dockableBar.getKey());
                } else {
                    this.loadClosePreviousState(dockableBar);
                    this._hiddenDockableBars.remove(dockableBar.getKey());
                }
            }
            dockableBar.getContext().setInitPosition(true);
        } else {
            dockableBar.setContext(dockableBarContext);
            if (this.isRealized() && !dockableBarContext.isHidden()) {
                this.loadClosePreviousState(dockableBar);
                this._hiddenDockableBars.remove(dockableBar.getKey());
            }
        }
    }

    @Override
    public void removeAllDockableBars() {
        List<String> list = this.getAllDockableBarNames();
        for (String string : list) {
            this.removeDockableBar(string);
        }
    }

    @Override
    public void removeExtraContexts() {
        if (this._allContexts != null) {
            String[] stringArray;
            for (String string : stringArray = this._allContexts.keySet().toArray(new String[this._allContexts.size()])) {
                DockableBar dockableBar = this.getDockableBar(string);
                if (dockableBar != null) continue;
                this.removeContext(string);
            }
        }
        if (this._hiddenDockableBars != null) {
            for (int i = this._hiddenDockableBars.size() - 1; i >= 0; --i) {
                String string = (String)this._hiddenDockableBars.get(i);
                DockableBar dockableBar = this.getDockableBar(string);
                if (dockableBar != null) continue;
                this._hiddenDockableBars.remove(string);
            }
        }
    }

    @Override
    public void removeDockableBar(String string) {
        this.removeDockableBar(string, false);
    }

    public void removeDockableBar(String string, final boolean bl) {
        this.checkBarKey(string, "removeDockableBar");
        final DockableBar dockableBar = this.getDockableBar(string);
        if (dockableBar == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.removeDockableBar(dockableBar, bl);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockableBarManager.this.removeDockableBar(dockableBar, bl);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
        }
    }

    private void removeDockableBar(DockableBar dockableBar, boolean bl) {
        if (this._allDockableBars.containsKey(dockableBar.getKey())) {
            int n = -1;
            if (bl) {
                DockableBarUtils.saveClosePreviousState(dockableBar);
                n = dockableBar.getContext().getCurrentMode();
            }
            if (this.isRealized() && !dockableBar.isHidden()) {
                this.doHideDockableBar(dockableBar);
            }
            this._allDockableBars.remove(dockableBar.getKey());
            this._allDockableBarKeys.remove(dockableBar.getKey());
            if (this._hiddenDockableBars.contains(dockableBar.getKey())) {
                this._hiddenDockableBars.remove(dockableBar.getKey());
            }
            dockableBar.removePropertyChangeListener(this._dockableBarPropertyChangeListener);
            if (!bl) {
                this.removeContext(dockableBar.getKey());
            } else {
                dockableBar.getContext().setCurrentMode(n);
            }
            dockableBar.fireDockableBarEvent(5000);
            dockableBar.setDockableBarManager(null);
        }
    }

    void showDockableBar(DockableBar dockableBar) {
        if (dockableBar.getContext() == null || !dockableBar.isAvailable()) {
            return;
        }
        if (!this._allDockableBars.containsKey(dockableBar.getKey())) {
            this.addDockableBar(dockableBar);
        }
        if (!dockableBar.isVisible()) {
            dockableBar.setVisible(true);
        }
        if (!this._hiddenDockableBars.contains(dockableBar.getKey()) || !this.loadHiddenPreviousState(dockableBar)) {
            if (dockableBar.isFloating()) {
                this.floatDockableBar(dockableBar, dockableBar.getUndockedBounds());
            } else {
                this.dockDockableBar(dockableBar, DockableBarUtils.convertDockSideToSide(dockableBar.getContext().getInitSide()), dockableBar.getContext().getInitIndex(), false, dockableBar.getContext().getInitSubindex());
            }
        }
        this._hiddenDockableBars.remove(dockableBar.getKey());
    }

    @Override
    public void showDockableBar(String string) {
        this.checkBarKey(string, "removeDockableBar");
        final DockableBar dockableBar = this.getDockableBar(string);
        if (dockableBar == null) {
            return;
        }
        if (!dockableBar.isHidden()) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.showDockableBar(dockableBar);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockableBarManager.this.showDockableBar(dockableBar);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
        }
    }

    @Override
    public DockableBar getDockableBar(String string) {
        this.checkBarKey(string, "getDockableBar");
        return this._allDockableBars.get(string);
    }

    @Override
    public void hideDockableBar(String string) {
        this.checkBarKey(string, "hideDockableBar");
        final DockableBar dockableBar = this.getDockableBar(string);
        if (dockableBar == null) {
            return;
        }
        if (!dockableBar.isHidable() || !this.isHidable()) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.hideDockableBar(dockableBar);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockableBarManager.this.hideDockableBar(dockableBar);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
        }
    }

    private void hideDockableBar(DockableBar dockableBar) {
        if (dockableBar.getContext() == null || !dockableBar.isAvailable()) {
            return;
        }
        if (dockableBar.isHidden()) {
            return;
        }
        if (!this._allDockableBars.containsKey(dockableBar.getKey())) {
            this.addDockableBar(dockableBar);
        }
        this.doHideDockableBar(dockableBar);
    }

    private void doHideDockableBar(DockableBar dockableBar) {
        if (dockableBar.isHidden()) {
            return;
        }
        DockableBarUtils.saveHiddenPreviousState(dockableBar);
        try {
            Container container;
            if (dockableBar.getParent() != null && dockableBar.getParent() instanceof DockableBarContainer) {
                dockableBar.getParent().remove(dockableBar);
            }
            dockableBar.setHidden();
            dockableBar.fireDockableBarEvent(5002);
            if (!this._hiddenDockableBars.contains(dockableBar.getKey())) {
                this._hiddenDockableBars.add(dockableBar.getKey());
            }
            if ((container = dockableBar.getTopLevelAncestor()) instanceof FloatingDockableBarContainer && this._floatingDockableBars != null) {
                this._floatingDockableBars.remove(container);
                container.setVisible(false);
                ((FloatingDockableBarContainer)container).dispose();
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new RuntimeException(propertyVetoException);
        }
        this.doLayout();
    }

    @Override
    public void dockDockableBar(final DockableBar dockableBar, final int n, final int n2, final boolean bl, final int n3) {
        if (dockableBar.getContext() != null && !dockableBar.isAvailable()) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalDockDockableBar(dockableBar, n, n2, bl, n3);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockableBarManager.this.internalDockDockableBar(dockableBar, n, n2, bl, n3);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
        }
    }

    private void internalDockDockableBar(DockableBar dockableBar, int n, int n2, boolean bl, int n3) {
        if (n != 1 && n != 5 && n != 3 && n != 7) {
            throw new IllegalArgumentException("Invalid argument side. side must be one of following value, WEST, EAST, NORTH, or SOUTH: " + n);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Argument start must be a positive integer.");
        }
        DockableBarContainer dockableBarContainer = this.getDockableBarContainer(n);
        if (dockableBarContainer != null) {
            dockableBarContainer.addDockableBar(dockableBar, n2, bl, n3);
            dockableBar.invalidate();
            dockableBar.repaint();
        }
    }

    @Override
    public void floatDockableBar(final DockableBar dockableBar, final Rectangle rectangle) {
        if (dockableBar.getContext() == null || !dockableBar.isAvailable()) {
            return;
        }
        if (!dockableBar.isFloatable() || !this.isFloatable()) {
            return;
        }
        dockableBar.resetDockID();
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalFloatDockableBar(dockableBar, rectangle);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockableBarManager.this.internalFloatDockableBar(dockableBar, rectangle);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
        }
    }

    private void internalFloatDockableBar(DockableBar dockableBar, Rectangle rectangle) {
        Serializable serializable;
        if (!dockableBar.isFloatable()) {
            return;
        }
        if (rectangle == null) {
            serializable = new Point(0, 0);
            try {
                serializable = dockableBar.getLocationOnScreen();
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                JideSwingUtilities.ignoreException(illegalComponentStateException);
            }
            rectangle = new Rectangle(((Point)serializable).x + 10, ((Point)serializable).y + 10, 0, 0);
        }
        if ((serializable = this.createFloatingDockableBarContainer(SwingUtilities.getWindowAncestor(this.getRootPaneContainer().getRootPane()))) != null) {
            dockableBar.setOrientation(0);
            try {
                dockableBar.setFloating();
            }
            catch (PropertyVetoException propertyVetoException) {
                throw new RuntimeException(propertyVetoException);
            }
            Container container = dockableBar.getParent();
            if (container != null) {
                container.remove(dockableBar);
            }
            ((JWindow)serializable).getContentPane().add((Component)dockableBar, "Center");
            if (rectangle.isEmpty()) {
                ((Window)serializable).setSize(dockableBar.getPreferredSize());
            } else {
                ((Window)serializable).setSize(rectangle.getSize());
            }
            ((Window)serializable).pack();
            rectangle.x -= (int)((double)((Component)serializable).getWidth() * this._relativeX);
            rectangle.y -= (int)((double)((Component)serializable).getHeight() * this._relativeY);
            Rectangle rectangle2 = PortingUtils.getScreenBounds((Component)serializable);
            if (rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) {
                rectangle.y = rectangle2.y + rectangle2.height - rectangle.height;
            }
            if (rectangle.y < rectangle2.y) {
                rectangle.y = rectangle2.y;
            }
            ((Window)serializable).setLocation(rectangle.x, rectangle.y);
            ((Window)serializable).setVisible(true);
            if (this._isDragging) {
                this._currentFloatingCommandBar = serializable;
            }
            if (this._floatingDockableBars == null) {
                this._floatingDockableBars = new FloatingDockableBars();
            }
            this._floatingDockableBars.add(serializable);
        }
    }

    @Override
    public void beginDraggingDockableBar(JComponent jComponent, int n, int n2, double d, double d2, boolean bl) {
        if (!this.isRearrangable()) {
            return;
        }
        if (jComponent instanceof DockableBar && !((DockableBar)jComponent).isRearrangable()) {
            return;
        }
        this._preDragSnapshot.clear();
        this._postDragSnapshot.clear();
        this._preDragSnapshot = this.createDockableBarsSnapshot(jComponent);
        this._relativeX = d;
        this._relativeY = d2;
        this._startInFloat = bl;
        if (jComponent.getTopLevelAncestor() instanceof FloatingDockableBarContainer) {
            this._currentFloatingCommandBar = (FloatingDockableBarContainer)jComponent.getTopLevelAncestor();
        }
        if (this._rootPaneContainer != null && this.isUseGlassPaneEnabled()) {
            this._glassPaneVisibility = this.getRootPaneContainer().getGlassPane().isVisible();
            this.getRootPaneContainer().getGlassPane().setCursor(Cursor.getPredefinedCursor(13));
            this.getRootPaneContainer().getGlassPane().setVisible(true);
        }
        this._isDragging = true;
        this._draggingComponent = jComponent;
        this.addGlobalEventHandler();
    }

    protected DockableBarsSnapshot createDockableBarsSnapshot(JComponent jComponent) {
        int[] nArray;
        DockableBarsSnapshot dockableBarsSnapshot = new DockableBarsSnapshot();
        dockableBarsSnapshot._possiblyMoved = jComponent;
        for (int n : nArray = new int[]{1, 5, 3, 7, 0}) {
            DockableBarState dockableBarState;
            DockableBarContainer dockableBarContainer = this.getDockableBarContainer(n);
            if (dockableBarContainer != null) {
                DockableBarListList dockableBarListList = dockableBarContainer.getDockableBarList();
                for (int i = 0; i < dockableBarListList.size(); ++i) {
                    DockableBarItem dockableBarItem;
                    Object object2;
                    List list = (List)dockableBarListList.get(i);
                    ArrayList<DockableBarItem> arrayList = new ArrayList<DockableBarItem>();
                    for (Object object2 : list) {
                        dockableBarItem = (DockableBarItem)object2;
                        arrayList.add(dockableBarItem);
                    }
                    this.sortDockableBarRowItems(arrayList);
                    int n2 = -1;
                    object2 = arrayList.iterator();
                    while (object2.hasNext()) {
                        Object e = object2.next();
                        dockableBarItem = (DockableBarItem)e;
                        dockableBarState = new DockableBarState();
                        dockableBarState._rowOrCol = i;
                        dockableBarState._index = ++n2;
                        dockableBarState._start = dockableBarItem.getStart();
                        dockableBarState._component = dockableBarItem.getComponent();
                        if (dockableBarState._component.isVisible()) {
                            dockableBarState._bounds = new Rectangle(dockableBarState._component.getLocationOnScreen(), dockableBarState._component.getSize());
                        }
                        dockableBarState._dockableContainerID = n;
                        if (n == 1) {
                            dockableBarState._orientation = 0;
                            dockableBarsSnapshot._northBars.add(dockableBarState);
                            continue;
                        }
                        if (n == 5) {
                            dockableBarState._orientation = 0;
                            dockableBarsSnapshot._southBars.add(dockableBarState);
                            continue;
                        }
                        if (n == 3) {
                            dockableBarState._orientation = 1;
                            dockableBarsSnapshot._eastBars.add(dockableBarState);
                            continue;
                        }
                        dockableBarState._orientation = 1;
                        dockableBarsSnapshot._westBars.add(dockableBarState);
                    }
                }
                continue;
            }
            if (this._floatingDockableBars == null) continue;
            for (FloatingDockableBarContainer floatingDockableBarContainer : this._floatingDockableBars) {
                if (floatingDockableBarContainer.getContentPane().getComponentCount() == 0) continue;
                dockableBarState = new DockableBarState();
                dockableBarState._rowOrCol = 0;
                dockableBarState._index = 0;
                dockableBarState._start = 0;
                dockableBarState._component = floatingDockableBarContainer.getContentPane().getComponent(0);
                if (dockableBarState._component.isVisible()) {
                    dockableBarState._bounds = new Rectangle(dockableBarState._component.getLocationOnScreen(), dockableBarState._component.getSize());
                }
                dockableBarState._dockableContainerID = n;
                dockableBarState._orientation = 0;
                dockableBarsSnapshot._floatingBars.add(dockableBarState);
            }
        }
        return dockableBarsSnapshot;
    }

    protected void sortDockableBarRowItems(List list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object object, Object object2) {
                if (object instanceof DockableBarItem && object2 instanceof DockableBarItem) {
                    int n;
                    int n2 = ((DockableBarItem)object).getStart();
                    if (n2 == (n = ((DockableBarItem)object2).getStart())) {
                        return 0;
                    }
                    if (n2 > n) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
        });
    }

    @Override
    public void pauseDragDockableBar() {
    }

    private boolean isDragging() {
        return this._isDragging;
    }

    public void cancelDragging() {
        this.removeGlobalEventHandler();
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalCancelDragging();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockableBarManager.this.internalCancelDragging();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
        }
    }

    private void internalCancelDragging() {
        this._relativeX = 0.0;
        this._relativeY = 0.0;
        this._startInFloat = false;
        if (this.isUseGlassPaneEnabled() && this.getRootPaneContainer() != null) {
            this.getRootPaneContainer().getGlassPane().setVisible(this._glassPaneVisibility);
            this.getRootPaneContainer().getGlassPane().setCursor(Cursor.getDefaultCursor());
        }
        this._currentFloatingCommandBar = null;
        this._isDragging = false;
        this._isResizing = false;
        this._resizingPane = null;
        this._draggingComponent = null;
        this.removeGlobalEventHandler();
    }

    private void setAllowDraggingDockableBarDocking(boolean bl) {
    }

    @Override
    public void dragDockableBar(JComponent jComponent, int n, int n2, int n3) {
        int n4;
        Cloneable cloneable;
        Point point;
        if (!this.isDragging()) {
            return;
        }
        if (jComponent == null) {
            jComponent = this._draggingComponent;
        }
        DockableBarContainer dockableBarContainer = null;
        Point point2 = new Point(n, n2);
        if (this._isResizing && this._resizingPane != null) {
            dockableBarContainer = this._resizingPane;
        } else {
            Container container = this.getContentContainer();
            if (container != null) {
                Container container2;
                point = new Point(point2);
                CommandBarBorderListener.convertPointFromScreen(point, container, this._startInFloat);
                dockableBarContainer = (DockableBarContainer)DockableBarUtils.findNearbyDockableBarContainerAt(this, container, point, 22);
                if (dockableBarContainer != null && dockableBarContainer.getDockableBarManager() != this) {
                    dockableBarContainer = null;
                }
                if (dockableBarContainer == null && (container2 = this.getContentContainer()) != null) {
                    cloneable = new Point(point2);
                    CommandBarBorderListener.convertPointFromScreen((Point)cloneable, container2, this._startInFloat);
                    n4 = DockableBarUtils.sideOfComponent(container2, point.x, point.y);
                    switch (n4) {
                        case 7: {
                            dockableBarContainer = this._westDockableBarContainer;
                            break;
                        }
                        case 1: {
                            dockableBarContainer = this._northDockableBarContainer;
                            break;
                        }
                        case 5: {
                            dockableBarContainer = this._southDockableBarContainer;
                            break;
                        }
                        case 3: {
                            dockableBarContainer = this._eastDockableBarContainer;
                        }
                    }
                    if (dockableBarContainer != null && !dockableBarContainer.isShowing()) {
                        dockableBarContainer = null;
                    }
                }
                if (dockableBarContainer != null) {
                    int n5 = dockableBarContainer.getSide();
                    if ((((DockableBar)jComponent).getAllowedDockSides() & DockableBarUtils.convertSideToDockSide(n5)) == 0) {
                        dockableBarContainer = null;
                    }
                }
                if (dockableBarContainer == null && !((DockableBar)jComponent).isFloatable() && !((DockableBar)jComponent).isFloating()) {
                    dockableBarContainer = (DockableBarContainer)jComponent.getParent();
                }
            }
        }
        if (this._currentFloatingCommandBar == null && dockableBarContainer != null) {
            point = new Point(point2);
            CommandBarBorderListener.convertPointFromScreen(point, dockableBarContainer, this._startInFloat);
            int n6 = point.x - (int)((double)jComponent.getWidth() * this._relativeX);
            int n7 = point.y - (int)((double)jComponent.getHeight() * this._relativeY);
            n4 = -1;
            if (!dockableBarContainer.equals(jComponent.getParent())) {
                Container container = jComponent.getParent();
                container.remove(jComponent);
                if (jComponent instanceof DockableBar) {
                    ((DockableBar)jComponent).setOrientation(dockableBarContainer.getOrientation());
                    ((DockableBar)jComponent).getContext().setCurrentDockSide(DockableBarUtils.convertSideToDockSide(dockableBarContainer.getSide()));
                    try {
                        if (dockableBarContainer.getOrientation() == 0) {
                            ((DockableBar)jComponent).setHoriDocked();
                        } else {
                            ((DockableBar)jComponent).setVertDocked();
                        }
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        throw new RuntimeException(propertyVetoException);
                    }
                }
                dockableBarContainer.add(jComponent);
            } else {
                n4 = dockableBarContainer.getCurrentRowOf((DockableBar)jComponent);
            }
            int n8 = dockableBarContainer.getRowAndGapIndexAt(point);
            if (((DockableBar)jComponent).isStretch() && n8 > 0 && n8 / 2 > n4 && n8 <= n4 * 2 + 2) {
                n8 = n4 * 2;
            }
            if (n4 != -1 && n8 % 2 != 0 && n8 / 2 == n4) {
                int n9 = dockableBarContainer.getOrientation() == 0 ? (dockableBarContainer.getComponentOrientation().isLeftToRight() ? n6 : dockableBarContainer.getWidth() - point.x) : n7;
                dockableBarContainer.getDockableBarList().changeComponentStart(jComponent, n9);
            } else {
                dockableBarContainer.getDockableBarList().changeComponentRow(jComponent, n8 / 2, n8 % 2 == 0, dockableBarContainer.getOrientation() == 0 ? n6 : n7);
            }
        } else if (this._currentFloatingCommandBar == null && dockableBarContainer == null) {
            if (jComponent instanceof DockableBar) {
                int n10 = n;
                int n11 = n2;
                cloneable = ((DockableBar)jComponent).getUndockedBounds();
                if (cloneable != null) {
                    this.floatDockableBar((DockableBar)jComponent, new Rectangle(n10, n11, cloneable.width, cloneable.height));
                } else {
                    this.floatDockableBar((DockableBar)jComponent, new Rectangle(n10, n11, 0, 0));
                }
            }
        } else if (this._currentFloatingCommandBar != null && dockableBarContainer == null) {
            int n12 = n - (int)((double)this._currentFloatingCommandBar.getWidth() * this._relativeX);
            int n13 = n2 - (int)((double)this._currentFloatingCommandBar.getHeight() * this._relativeY);
            cloneable = new Rectangle(n12, n13, this._currentFloatingCommandBar.getWidth(), this._currentFloatingCommandBar.getHeight());
            Rectangle rectangle = PortingUtils.getScreenBounds(this._currentFloatingCommandBar);
            if (cloneable.y + cloneable.height > rectangle.y + rectangle.height) {
                cloneable.y = rectangle.y + rectangle.height - cloneable.height;
            }
            if (cloneable.y < rectangle.y) {
                cloneable.y = rectangle.y;
            }
            this._currentFloatingCommandBar.setLocation(cloneable.x, cloneable.y);
            if (jComponent instanceof DockableBar) {
                ((DockableBar)jComponent).setUndockedBounds((Rectangle)cloneable);
            }
        } else if (this._currentFloatingCommandBar != null && dockableBarContainer != null) {
            this._currentFloatingCommandBar.setVisible(false);
            if (this._floatingDockableBars != null) {
                this._floatingDockableBars.remove(this._currentFloatingCommandBar);
            }
            this._currentFloatingCommandBar.dispose();
            this._currentFloatingCommandBar = null;
            if (jComponent instanceof DockableBar) {
                ((DockableBar)jComponent).getContext().setCurrentDockSide(DockableBarUtils.convertSideToDockSide(dockableBarContainer.getSide()));
                try {
                    if (dockableBarContainer.getOrientation() == 0) {
                        ((DockableBar)jComponent).setHoriDocked();
                    } else {
                        ((DockableBar)jComponent).setVertDocked();
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    throw new RuntimeException(propertyVetoException);
                }
            }
            point = new Point(point2);
            CommandBarBorderListener.convertPointFromScreen(point, dockableBarContainer, this._startInFloat);
            int n14 = dockableBarContainer.getRowAndGapIndexAt(point);
            if (jComponent instanceof DockableBar) {
                ((DockableBar)jComponent).setOrientation(dockableBarContainer.getOrientation());
            }
            dockableBarContainer.add(jComponent);
            int n15 = dockableBarContainer.getOrientation() == 0 ? point.x - (int)((double)jComponent.getWidth() * this._relativeX) : point.y - (int)((double)jComponent.getHeight() * this._relativeY);
            dockableBarContainer.getDockableBarList().changeComponentRow(jComponent, n14 / 2, n14 % 2 == 0, n15);
        }
    }

    @Override
    public void endDraggingDockableBar() {
        this.internalCancelDragging();
        if (this._preDragSnapshot._possiblyMoved == null) {
            return;
        }
        this._postDragSnapshot = this.createDockableBarsSnapshot(null);
        this.checkForRearrangedDockableBars();
        this._preDragSnapshot.clear();
        this._postDragSnapshot.clear();
    }

    protected void checkForRearrangedDockableBars() {
        DockableBarStateTransition dockableBarStateTransition;
        DockableBarState dockableBarState;
        Object object;
        boolean bl = false;
        DockableBarsRearrangedEvent dockableBarsRearrangedEvent = null;
        ArrayList[] arrayListArray = new ArrayList[]{this._preDragSnapshot._northBars, this._preDragSnapshot._southBars, this._preDragSnapshot._eastBars, this._preDragSnapshot._westBars, this._preDragSnapshot._floatingBars};
        ArrayList[] arrayListArray2 = new ArrayList[]{this._postDragSnapshot._northBars, this._postDragSnapshot._southBars, this._postDragSnapshot._eastBars, this._postDragSnapshot._westBars, this._postDragSnapshot._floatingBars};
        for (int i = 0; i < arrayListArray.length; ++i) {
            object = arrayListArray[i].iterator();
            Iterator iterator = arrayListArray2[i].iterator();
            while (object.hasNext()) {
                DockableBarState dockableBarState2 = (DockableBarState)object.next();
                DockableBarState dockableBarState3 = dockableBarState = iterator.hasNext() ? (DockableBarState)iterator.next() : null;
                if (!bl && dockableBarState != null && dockableBarState2._component == dockableBarState._component && dockableBarState2._dockableContainerID == dockableBarState._dockableContainerID && dockableBarState2._mode == dockableBarState._mode && dockableBarState2._orientation == dockableBarState._orientation && dockableBarState2._rowOrCol == dockableBarState._rowOrCol && dockableBarState2._index == dockableBarState._index && dockableBarState2._bounds.equals(dockableBarState._bounds) && dockableBarState2._start == dockableBarState._start) continue;
                bl = true;
                if (dockableBarsRearrangedEvent == null) {
                    dockableBarsRearrangedEvent = new DockableBarsRearrangedEvent(this._preDragSnapshot._possiblyMoved, 0);
                }
                dockableBarStateTransition = this.getTransition(dockableBarState2);
                if (dockableBarState2._component == this._preDragSnapshot._possiblyMoved) {
                    dockableBarsRearrangedEvent.setStateTransition(dockableBarStateTransition);
                    continue;
                }
                dockableBarsRearrangedEvent.addOtherRearrangedBar(dockableBarStateTransition);
            }
        }
        boolean bl2 = false;
        for (int i = 0; i < arrayListArray2.length && !bl2; ++i) {
            Iterator iterator = arrayListArray2[i].iterator();
            while (iterator.hasNext() && !bl2) {
                dockableBarState = (DockableBarState)iterator.next();
                DockableBarState dockableBarState4 = this.findComponentInSnapshot(dockableBarState._component, this._preDragSnapshot);
                if (dockableBarState4 != null) continue;
                dockableBarStateTransition = new DockableBarStateTransition();
                dockableBarStateTransition.setComponent(dockableBarState._component);
                dockableBarStateTransition.setPostState(dockableBarState);
                object = new DockableBarState();
                ((DockableBarState)object)._component = dockableBarState._component;
                ((DockableBarState)object)._mode = 1;
                dockableBarStateTransition.setPreState((DockableBarState)object);
                dockableBarStateTransition.setTransitionID(5102);
                bl = true;
                if (dockableBarsRearrangedEvent == null) {
                    dockableBarsRearrangedEvent = new DockableBarsRearrangedEvent(this._preDragSnapshot._possiblyMoved, 0);
                }
                dockableBarsRearrangedEvent.setStateTransition(dockableBarStateTransition);
                bl2 = true;
            }
        }
        if (dockableBarsRearrangedEvent != null) {
            this.fireDockableBarsRearranged(dockableBarsRearrangedEvent);
            dockableBarsRearrangedEvent.clear();
        }
    }

    @Override
    public void addDockableBarsRearrangedListener(DockableBarsRearrangedListener dockableBarsRearrangedListener) {
        this.listenerList.add(DockableBarsRearrangedListener.class, dockableBarsRearrangedListener);
    }

    @Override
    public void removeDockableBarsRearrangedListener(DockableBarsRearrangedListener dockableBarsRearrangedListener) {
        this.listenerList.remove(DockableBarsRearrangedListener.class, dockableBarsRearrangedListener);
    }

    @Override
    public DockableBarsRearrangedListener[] getDockableBarsRearrangedListeners() {
        return (DockableBarsRearrangedListener[])this.listenerList.getListeners(DockableBarsRearrangedListener.class);
    }

    protected void fireDockableBarsRearranged(DockableBarsRearrangedEvent dockableBarsRearrangedEvent) {
        Object object;
        if (dockableBarsRearrangedEvent == null) {
            return;
        }
        int n = dockableBarsRearrangedEvent.getID();
        if (LOGGER_EVENT.isLoggable(Level.FINE)) {
            object = dockableBarsRearrangedEvent.getComponent() != null && dockableBarsRearrangedEvent.getComponent() instanceof DockableBar ? " \"" + ((DockableBar)dockableBarsRearrangedEvent.getComponent()).getKey() + "\"" : "";
            switch (n) {
                case 5099: {
                    LOGGER_EVENT.fine("Dock rearranged, DockableBar" + (String)object + " is added");
                    break;
                }
                case 5100: {
                    LOGGER_EVENT.fine("Dock rearranged, DockableBar" + (String)object + " is removed");
                    break;
                }
                case 5101: {
                    LOGGER_EVENT.fine("Dock rearranged, DockableBar" + (String)object + " is floated");
                    break;
                }
                case 5102: {
                    LOGGER_EVENT.fine("Dock rearranged, DockableBar" + (String)object + " is docked");
                    break;
                }
                case 5103: {
                    LOGGER_EVENT.fine("Dock rearranged, DockableBar" + (String)object + " is hidden");
                    break;
                }
                case 5104: {
                    LOGGER_EVENT.fine("Dock rearranged, DockableBar" + (String)object + " is moved to another container");
                    break;
                }
                case 5105: {
                    LOGGER_EVENT.fine("Dock rearranged, DockableBar" + (String)object + " is moved to another row or column");
                    break;
                }
                case 5106: {
                    LOGGER_EVENT.fine("Dock rearranged, DockableBar" + (String)object + " is moved within its row or column");
                    break;
                }
                case 5107: {
                    LOGGER_EVENT.fine("Dock rearranged, DockableBar" + (String)object + " is resized");
                    break;
                }
                case 5108: {
                    LOGGER_EVENT.fine("Dock rearranged, DockableBar" + (String)object + " is moved");
                    break;
                }
            }
        }
        object = this.listenerList.getListenerList();
        for (int i = ((Object[])object).length - 2; i >= 0; i -= 2) {
            if (object[i] != DockableBarsRearrangedListener.class) continue;
            ((DockableBarsRearrangedListener)object[i + 1]).dockableBarsRearranged(dockableBarsRearrangedEvent);
        }
    }

    protected DockableBarState findComponentInSnapshot(Component component, DockableBarsSnapshot dockableBarsSnapshot) {
        ArrayList[] arrayListArray;
        if (component == null || dockableBarsSnapshot == null) {
            return null;
        }
        for (ArrayList arrayList : arrayListArray = new ArrayList[]{dockableBarsSnapshot._northBars, dockableBarsSnapshot._southBars, dockableBarsSnapshot._eastBars, dockableBarsSnapshot._westBars, dockableBarsSnapshot._floatingBars}) {
            for (Object e : arrayList) {
                DockableBarState dockableBarState = (DockableBarState)e;
                if (dockableBarState._component != component) continue;
                return dockableBarState;
            }
        }
        return null;
    }

    protected DockableBarStateTransition getTransition(DockableBarState dockableBarState) {
        if (dockableBarState == null) {
            throw new IllegalArgumentException("arguments may not be null");
        }
        DockableBarStateTransition dockableBarStateTransition = new DockableBarStateTransition();
        DockableBarState dockableBarState2 = this.findComponentInSnapshot(dockableBarState._component, this._postDragSnapshot);
        DockableBarState dockableBarState3 = this.findComponentInSnapshot(dockableBarState._component, this._preDragSnapshot);
        int n = -1;
        if (this._preDragSnapshot._floatingBars.contains(dockableBarState3) == this._postDragSnapshot._floatingBars.contains(dockableBarState2)) {
            if (dockableBarState2._dockableContainerID != dockableBarState._dockableContainerID) {
                n = 5104;
            } else if (dockableBarState2._rowOrCol != dockableBarState._rowOrCol) {
                n = 5105;
            } else if (dockableBarState2._index != dockableBarState._index) {
                n = 5106;
            } else if (dockableBarState2._start != dockableBarState._start) {
                n = 5108;
            } else if (!dockableBarState2._bounds.getLocation().equals(dockableBarState._bounds.getLocation())) {
                n = 5108;
            } else if (!dockableBarState2._bounds.getSize().equals(dockableBarState._bounds.getSize())) {
                n = 5107;
            }
        } else {
            dockableBarState2 = new DockableBarState();
            dockableBarState2._component = dockableBarState._component;
            if (dockableBarState._component instanceof DockableBar) {
                DockableBar dockableBar = (DockableBar)dockableBarState._component;
                dockableBarState2._orientation = dockableBar.getOrientation();
                if (this.getAllDockableBars().contains(dockableBar)) {
                    if (dockableBar.isFloating()) {
                        n = 5101;
                        dockableBarState2._mode = 1;
                    } else if (dockableBar.isHidden()) {
                        n = 5103;
                        dockableBarState2._mode = 0;
                    } else if (dockableBar.isVertDocked()) {
                        n = 5102;
                        dockableBarState2._mode = 3;
                    } else if (dockableBar.isHoriDocked()) {
                        n = 5102;
                        dockableBarState2._mode = 2;
                    } else {
                        n = 5100;
                    }
                } else {
                    n = 5100;
                }
            } else {
                n = 5100;
            }
        }
        dockableBarStateTransition.setComponent(dockableBarState._component);
        dockableBarStateTransition.setTransitionID(n);
        dockableBarStateTransition.setPreState(dockableBarState);
        dockableBarStateTransition.setPostState(dockableBarState2);
        return dockableBarStateTransition;
    }

    @Override
    public void beginResizingDockableBar(JComponent jComponent, int n) {
        this._preDragSnapshot.clear();
        this._postDragSnapshot.clear();
        this._preDragSnapshot = this.createDockableBarsSnapshot(jComponent);
    }

    @Override
    public void resizingDockableBar(JComponent jComponent, int n, int n2, int n3, int n4, int n5, int n6) {
        Container container;
        if (jComponent instanceof CommandBar) {
            ((CommandBar)jComponent).purposeBounds(n, n2, n3, n4, n5, this._saveDeltaX, n6, this._saveDeltaY);
        }
        if ((container = jComponent.getTopLevelAncestor()) instanceof Window) {
            Window window = (Window)container;
            Rectangle rectangle = window.getBounds();
            if (rectangle.width != jComponent.getWidth() || rectangle.height != jComponent.getHeight()) {
                this._saveDeltaX = n5;
                this._saveDeltaY = n6;
                ((DockableBar)jComponent).setUndockedBounds(new Rectangle(rectangle.x + n, rectangle.y + n2, jComponent.getWidth(), jComponent.getHeight()));
                window.setBounds(((DockableBar)jComponent).getUndockedBounds());
                window.validate();
            }
        }
    }

    @Override
    public void endResizingDockableBar(JComponent jComponent) {
        if (this._preDragSnapshot._possiblyMoved == null) {
            return;
        }
        this._postDragSnapshot = this.createDockableBarsSnapshot(null);
        this.checkForRearrangedDockableBars();
        this._preDragSnapshot.clear();
        this._postDragSnapshot.clear();
    }

    void removeExtraFloatingDockableBars() {
        if (this._floatingDockableBars != null) {
            for (int i = 0; i < this._floatingDockableBars.size(); ++i) {
                FloatingDockableBarContainer floatingDockableBarContainer = (FloatingDockableBarContainer)this._floatingDockableBars.get(i);
                if (floatingDockableBarContainer.isVisible()) continue;
                this._floatingDockableBars.remove(floatingDockableBarContainer);
                --i;
            }
        }
    }

    private boolean loadHiddenPreviousState(DockableBar dockableBar) {
        PreviousState previousState = dockableBar.getContext().getHiddenPreviousState();
        if (previousState != null) {
            this.restorePreviousState(dockableBar, previousState);
            return true;
        }
        return false;
    }

    private boolean loadClosePreviousState(DockableBar dockableBar) {
        PreviousState previousState = dockableBar.getContext().getClosePreviousState();
        if (previousState != null) {
            this.restorePreviousState(dockableBar, previousState);
            return true;
        }
        if (dockableBar.getContext().getInitMode() == 1) {
            Point point = dockableBar.getLocationOnScreen();
            this.floatDockableBar(dockableBar, new Rectangle(point.x + 10, point.y + 10, 0, 0));
        } else {
            this.dockDockableBar(dockableBar, DockableBarUtils.convertDockSideToSide(dockableBar.getContext().getInitSide()), dockableBar.getContext().getInitIndex(), false, 0);
        }
        return true;
    }

    private boolean loadDockPreviousState(DockableBar dockableBar) {
        PreviousState previousState = dockableBar.getContext().getDockPreviousState();
        if (previousState != null) {
            this.restorePreviousState(dockableBar, previousState);
            return true;
        }
        this.dockDockableBar(dockableBar, 1, Integer.MAX_VALUE, true, 0);
        return true;
    }

    private boolean loadFloatPreviousState(DockableBar dockableBar) {
        PreviousState previousState = dockableBar.getContext().getFloatPreviousState();
        if (previousState != null) {
            this.restorePreviousState(dockableBar, previousState);
            return true;
        }
        Point point = dockableBar.getLocationOnScreen();
        this.floatDockableBar(dockableBar, new Rectangle(point.x + 10, point.y + 10, 0, 0));
        return true;
    }

    private void restorePreviousState(DockableBar dockableBar, PreviousState previousState) {
        if (previousState.mode == 1) {
            if (dockableBar.isFloatable() && this.isFloatable()) {
                this.floatDockableBar(dockableBar, previousState.rcBounds);
            } else {
                this.loadDockPreviousState(dockableBar);
                this.doLayout();
            }
        } else if (previousState.mode == 2 || previousState.mode == 3) {
            int n = previousState.side;
            if (previousState.side != 1 && previousState.side != 7 && previousState.side != 3 && previousState.side != 5) {
                n = 1;
            }
            this.dockDockableBar(dockableBar, n, previousState.row, previousState.newRow, previousState.start);
        }
    }

    @Override
    public RootPaneContainer getRootPaneContainer() {
        Container container;
        if (this._rootPaneContainer == null && this.getContentContainer() instanceof JComponent && (container = ((JComponent)this.getContentContainer()).getTopLevelAncestor()) instanceof RootPaneContainer) {
            return (RootPaneContainer)((Object)container);
        }
        return this._rootPaneContainer;
    }

    private Component getRootPaneContainerAsComponent() {
        return (Component)((Object)this._rootPaneContainer);
    }

    @Override
    public MainContainer getMainContainer() {
        return this._mainContainer;
    }

    @Override
    public boolean isLoadDataSuccessful() {
        return this._loadDataSuccessful;
    }

    @Override
    public void beginLoadLayoutData() {
        this.setRealized(false);
    }

    void clearLayout() {
        Collection<DockableBar> collection = this._allDockableBars.values();
        for (DockableBar container : collection) {
            if (container.getParent() == null) continue;
            container.getParent().remove(container);
        }
        if (this.getContentContainer() != null) {
            if (this._eastDockableBarContainer != null) {
                this.getContentContainer().remove(this._eastDockableBarContainer);
            }
            if (this._westDockableBarContainer != null) {
                this.getContentContainer().remove(this._westDockableBarContainer);
            }
            if (this._northDockableBarContainer != null) {
                this.getContentContainer().remove(this._northDockableBarContainer);
            }
            if (this._southDockableBarContainer != null) {
                this.getContentContainer().remove(this._southDockableBarContainer);
            }
        }
        if (this._floatingDockableBars != null) {
            for (FloatingDockableBarContainer floatingDockableBarContainer : this._floatingDockableBars) {
                floatingDockableBarContainer.removeAll();
                floatingDockableBarContainer.setVisible(false);
                floatingDockableBarContainer.dispose();
            }
            this._floatingDockableBars.clear();
        }
        this._hiddenDockableBars.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadLayoutFrom(final Document document) {
        this._loadDataSuccessful = false;
        boolean bl = this._loadingLayoutData;
        this._loadingLayoutData = true;
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this._loadDataSuccessful = DockableBarPersistenceUtils.internalLoad(this, document, this.getLoadCallback());
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            DefaultDockableBarManager.this._loadDataSuccessful = DockableBarPersistenceUtils.internalLoad(DefaultDockableBarManager.this, document, DefaultDockableBarManager.this.getLoadCallback());
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    this._loadDataSuccessful = false;
                    this.resetToDefault();
                }
                catch (InvocationTargetException invocationTargetException) {
                    this._loadDataSuccessful = false;
                    this.resetToDefault();
                    JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
                }
            }
        }
        finally {
            this._loadingLayoutData = bl;
        }
        return this._loadDataSuccessful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadLayoutFrom(final InputStream inputStream) {
        this._loadDataSuccessful = false;
        boolean bl = this._loadingLayoutData;
        this._loadingLayoutData = true;
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this._loadDataSuccessful = this.internalLoadLayoutDataDockableBar(inputStream);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            DefaultDockableBarManager.this._loadDataSuccessful = DefaultDockableBarManager.this.internalLoadLayoutDataDockableBar(inputStream);
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    this._loadDataSuccessful = false;
                    this.resetToDefault();
                }
                catch (InvocationTargetException invocationTargetException) {
                    this._loadDataSuccessful = false;
                    this.resetToDefault();
                    JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
                }
            }
        }
        finally {
            this._loadingLayoutData = bl;
        }
        return this._loadDataSuccessful;
    }

    private boolean internalLoadLayoutDataDockableBar(InputStream inputStream) {
        Object object;
        boolean bl = false;
        if (inputStream == null) {
            this.resetToDefault();
            return bl;
        }
        InputStream inputStream2 = inputStream;
        if (this.isNeedFormatCheck()) {
            try {
                object = PersistenceUtils.bufferStreamToArray(inputStream);
            }
            catch (IOException iOException) {
                this.resetToDefault();
                return bl;
            }
            inputStream2 = new ByteArrayInputStream((byte[])object);
            if (PersistenceUtils.isXmlFormat(object)) {
                try {
                    DockableBarPersistenceUtils.load(this, inputStream2, this.getLoadCallback());
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    this.resetToDefault();
                    return false;
                }
                catch (SAXException sAXException) {
                    this.resetToDefault();
                    return false;
                }
                catch (IOException iOException) {
                    this.resetToDefault();
                    return false;
                }
                return true;
            }
        }
        try {
            this.clearLayout();
            object = new DataInputStream(inputStream2);
            short s = SaveUtils.readVersion((DataInputStream)object);
            if (!this.isVersionCompatible(s)) {
                throw new IOException("Layout data version number changed. Ignore previous layout data");
            }
            Rectangle rectangle = SaveUtils.readRectangle((DataInputStream)object);
            if (this.isUseFrameBounds()) {
                this._unmaximizedBounds = rectangle;
            }
            this._state = SaveUtils.readInt((DataInputStream)object);
            SaveUtils.readContext((DataInputStream)object, this._allContexts);
            if (this._allContexts != null) {
                Set<String> set = this._allContexts.keySet();
                String[] object22 = set.toArray(new String[set.size()]);
                for (String string : object22) {
                    DockableBarFactory dockableBarFactory;
                    DockableBar dockableBar = this.getDockableBar(string);
                    if (dockableBar == null && (dockableBarFactory = this.getDockableBarFactory()) != null) {
                        dockableBar = dockableBarFactory.create(string);
                        this.addDockableBar(dockableBar);
                    }
                    if (dockableBar != null) {
                        dockableBar.setContext(this._allContexts.get(string));
                    }
                    this._hiddenDockableBars.add(string);
                }
            }
            this._eastDockableBarContainer = (DockableBarContainer)SaveUtils.readComponent(this, (DataInputStream)object);
            this._southDockableBarContainer = (DockableBarContainer)SaveUtils.readComponent(this, (DataInputStream)object);
            this._westDockableBarContainer = (DockableBarContainer)SaveUtils.readComponent(this, (DataInputStream)object);
            this._northDockableBarContainer = (DockableBarContainer)SaveUtils.readComponent(this, (DataInputStream)object);
            if (this._eastDockableBarContainer == null || this._westDockableBarContainer == null || this._northDockableBarContainer == null || this._southDockableBarContainer == null) {
                throw new IOException("Layout Data is corrupted. Layout will be reset.");
            }
            this.getContentContainer().add((Component)this._eastDockableBarContainer, "East");
            this.getContentContainer().add((Component)this._southDockableBarContainer, "South");
            this.getContentContainer().add((Component)this._westDockableBarContainer, "West");
            this.getContentContainer().add((Component)this._northDockableBarContainer, "North");
            this._floatingDockableBars = SaveUtils.readFloatingDockableBars(this, (DataInputStream)object);
            for (FloatingDockableBarContainer floatingDockableBarContainer : this._floatingDockableBars) {
                floatingDockableBarContainer.setVisible(true);
            }
            for (int i = this._hiddenDockableBars.size() - 1; i >= 0; --i) {
                String string = (String)this._hiddenDockableBars.get(i);
                DockableBar dockableBar = this.getDockableBar(string);
                if (dockableBar == null || dockableBar.isHidden()) continue;
                this.showDockableBar(dockableBar);
            }
            this.setRealized(true);
            this.fireBarEvents();
            this.setBoundsState();
            bl = true;
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Error loading layout - " + exception.getLocalizedMessage());
            }
            this.resetToDefault();
        }
        return bl;
    }

    void fireBarEvents() {
        List<String> list = this.getAllDockableBarNames();
        for (String string : list) {
            DockableBar dockableBar = this.getDockableBar(string);
            this.fireBarEvent(dockableBar);
        }
    }

    private void fireBarEvent(DockableBar dockableBar) {
        if (dockableBar != null) {
            if (!dockableBar.isHidden()) {
                if (dockableBar.isHoriDocked()) {
                    dockableBar.fireDockableBarEvent(5001);
                } else if (dockableBar.isVertDocked()) {
                    dockableBar.fireDockableBarEvent(5001);
                } else if (dockableBar.isFloating()) {
                    dockableBar.fireDockableBarEvent(5001);
                }
            } else {
                dockableBar.fireDockableBarEvent(5002);
            }
        }
    }

    void setBoundsState() {
        if (this._useFrameBounds) {
            boolean bl;
            Component component = this.getRootPaneContainerAsComponent();
            this._unmaximizedBounds = PortingUtils.ensureVisible(component, this._unmaximizedBounds);
            if (component != null && this.shouldUseFrameBounds(bl = component.isVisible())) {
                component.setBounds(this._unmaximizedBounds);
            }
        }
        if (this.isShowInitial()) {
            this.showInitial();
        }
    }

    @Override
    public void setShowInitial(boolean bl) {
        this._showInitial = bl;
    }

    @Override
    public boolean isShowInitial() {
        return this._showInitial;
    }

    @Override
    public void showInitial() {
        boolean bl = false;
        Component component = this.getRootPaneContainerAsComponent();
        if (component != null) {
            bl = component.isVisible();
        }
        if (this.shouldUseFrameBounds(bl) && !SystemInfo.isJdk142Above() && component != null) {
            component.setVisible(true);
        }
        if (this.shouldUseFrameState(bl) && component instanceof Frame) {
            PortingUtils.setFrameState((Frame)component, this._state);
        }
        if (this.shouldUseFrameBounds(bl) && SystemInfo.isJdk142Above() && component != null) {
            component.setVisible(true);
        }
    }

    void saveCurrentContext() {
        for (String string : this._allDockableBarKeys) {
            DockableBar dockableBar = this.getDockableBar(string);
            boolean bl = dockableBar.isAvailable();
            if (!bl) {
                this.setDockableBarAvailable(dockableBar);
            }
            dockableBar.getContext().setClosePreviousState(PreviousState.createPreviousState(dockableBar));
            if (!this.isPreserveAvailableProperty() || bl) continue;
            this.setDockableBarUnavailable(dockableBar);
        }
    }

    @Override
    public void saveLayoutTo(Document document) throws ParserConfigurationException {
        DockableBarPersistenceUtils.saveToDocument(this, document, this.getSaveCallback());
    }

    @Override
    public void saveLayoutTo(OutputStream outputStream) throws IOException {
        if (this._loadingLayoutData) {
            return;
        }
        if (this.isXmlFormat()) {
            try {
                DockableBarPersistenceUtils.save(this, outputStream);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
            }
            return;
        }
        this.removeExtraFloatingDockableBars();
        this.saveCurrentContext();
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        SaveUtils.writeVersion(dataOutputStream, this._version);
        SaveUtils.writeRectangle(dataOutputStream, this._unmaximizedBounds);
        if (this.getRootPaneContainerAsComponent() instanceof Frame) {
            SaveUtils.writeInt(dataOutputStream, PortingUtils.getFrameState((Frame)this.getRootPaneContainerAsComponent()));
        } else {
            SaveUtils.writeInt(dataOutputStream, 0);
        }
        SaveUtils.writeContext(dataOutputStream, this._allContexts);
        SaveUtils.writeComponent(dataOutputStream, this.getDockableBarContainer(3));
        SaveUtils.writeComponent(dataOutputStream, this.getDockableBarContainer(5));
        SaveUtils.writeComponent(dataOutputStream, this.getDockableBarContainer(7));
        SaveUtils.writeComponent(dataOutputStream, this.getDockableBarContainer(1));
        SaveUtils.writeFloatingDockableBars(dataOutputStream, this._floatingDockableBars);
    }

    Container getContentContainer() {
        return this._contentContainer;
    }

    private void doLayout() {
        this.getContentContainer().validate();
        this.getMainContainer().validate();
        this.getContentContainer().repaint();
        this.setRealized(true);
    }

    @Override
    public void toggleState(String string) {
        this.checkBarKey(string, "toggleState");
        final DockableBar dockableBar = this.getDockableBar(string);
        if (dockableBar == null) {
            return;
        }
        if (!dockableBar.isHidden()) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.toggleState(dockableBar);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockableBarManager.this.toggleState(dockableBar);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
        }
    }

    @Override
    public void toggleState(DockableBar dockableBar) {
        if (!dockableBar.isAvailable()) {
            return;
        }
        if (!(dockableBar.isRearrangable() && dockableBar.isFloatable() && this.isRearrangable() && this.isFloatable())) {
            return;
        }
        this._preDragSnapshot.clear();
        this._postDragSnapshot.clear();
        this._preDragSnapshot = this.createDockableBarsSnapshot(dockableBar);
        if (dockableBar.isFloating()) {
            PreviousState previousState = PreviousState.createPreviousState(dockableBar);
            PreviousState.disposePreviousState(dockableBar.getContext().getFloatPreviousState());
            dockableBar.getContext().setFloatPreviousState(previousState);
            this.loadDockPreviousState(dockableBar);
        } else {
            PreviousState previousState = PreviousState.createPreviousState(dockableBar);
            PreviousState.disposePreviousState(dockableBar.getContext().getDockPreviousState());
            dockableBar.getContext().setDockPreviousState(previousState);
            this.loadFloatPreviousState(dockableBar);
        }
        if (this._preDragSnapshot._possiblyMoved == null) {
            return;
        }
        this._postDragSnapshot = this.createDockableBarsSnapshot(null);
        this.checkForRearrangedDockableBars();
        this._preDragSnapshot.clear();
        this._postDragSnapshot.clear();
    }

    @Override
    public void removeFromHiddenDockableBars(String string) {
        this._hiddenDockableBars.remove(string);
    }

    @Override
    public boolean isRearrangable() {
        return this._rearrangeable && !this.shouldAWTEventListenerBeUsed();
    }

    @Override
    public void setRearrangable(boolean bl) {
        boolean bl2 = this._rearrangeable;
        if (bl2 != bl) {
            this._rearrangeable = bl;
            List<String> list = this.getAllDockableBarNames();
            for (String string : list) {
                DockableBar dockableBar = this.getDockableBar(string);
                if (dockableBar == null) continue;
                dockableBar.firePropertyChange(PROPERTY_REARRANGABLE, bl2, bl);
            }
            this.firePropertyChange(PROPERTY_REARRANGABLE, bl2, bl);
        }
    }

    @Override
    public boolean isFloatable() {
        return this._floatable;
    }

    @Override
    public void setFloatable(boolean bl) {
        boolean bl2 = this._floatable;
        if (bl2 != bl) {
            this._floatable = bl;
            List<String> list = this.getAllDockableBarNames();
            for (String string : list) {
                String string2 = string;
                DockableBar dockableBar = this.getDockableBar(string2);
                if (dockableBar == null) continue;
                dockableBar.firePropertyChange(PROPERTY_FLOATABLE, bl2, bl);
            }
            this.firePropertyChange(PROPERTY_FLOATABLE, bl2, bl);
        }
    }

    @Override
    public boolean isHidable() {
        return this._hidable;
    }

    @Override
    public void setHidable(boolean bl) {
        boolean bl2 = this._hidable;
        if (bl2 != bl) {
            this._hidable = bl;
            List<String> list = this.getAllDockableBarNames();
            for (String string : list) {
                String string2 = string;
                DockableBar dockableBar = this.getDockableBar(string2);
                if (dockableBar == null) continue;
                dockableBar.firePropertyChange(PROPERTY_HIDABLE, bl2, bl);
            }
            this.firePropertyChange(PROPERTY_HIDABLE, bl2, bl);
        }
    }

    @Override
    public void updateComponentTreeUI() {
        if (this.getRootPaneContainerAsComponent() != null) {
            SwingUtilities.updateComponentTreeUI(this.getRootPaneContainerAsComponent());
        }
        if (this._floatingDockableBars != null) {
            for (FloatingDockableBarContainer object2 : this._floatingDockableBars) {
                SwingUtilities.updateComponentTreeUI(object2);
            }
        }
        List<String> list = this.getAllDockableBarNames();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            String string = (String)e;
            DockableBar dockableBar = this.getDockableBar(string);
            if (dockableBar == null || !dockableBar.isHidden()) continue;
            SwingUtilities.updateComponentTreeUI(dockableBar);
        }
        this.getContentContainer().invalidate();
        this.getContentContainer().doLayout();
    }

    @Override
    public Collection<DockableBar> getAllDockableBars() {
        return this._allDockableBars.values();
    }

    @Override
    public List<String> getAllDockableBarNames() {
        return new ArrayList<String>(this._allDockableBarKeys);
    }

    @Override
    public Rectangle getInitBounds() {
        if (this._initBounds.isEmpty()) {
            Dimension dimension = PortingUtils.getScreenSize(this.getRootPaneContainerAsComponent());
            if (dimension.width <= 1024) {
                this._initBounds.setBounds(0, 0, dimension.width, dimension.height);
            } else {
                this._initBounds.setBounds(0, 0, 1024, 768);
            }
        }
        return this._initBounds;
    }

    @Override
    public void setInitBounds(Rectangle rectangle) {
        if (rectangle == null) {
            throw new IllegalArgumentException("InitBounds value cannot be null.");
        }
        Rectangle rectangle2 = this._initBounds;
        if (!rectangle.equals(rectangle2)) {
            this._initBounds = rectangle;
            this.firePropertyChange(PROPERTY_INIT_BOUNDS, rectangle2, rectangle);
        }
    }

    private void addContext(String string, DockableBarContext dockableBarContext) {
        this._allContexts.put(string, dockableBarContext);
    }

    private void removeContext(String string) {
        this._allContexts.remove(string);
    }

    @Override
    public int getInitState() {
        Dimension dimension = PortingUtils.getScreenSize(this.getRootPaneContainerAsComponent());
        Rectangle rectangle = this.getInitBounds();
        if (rectangle.width > dimension.width || rectangle.height > dimension.height) {
            return 6;
        }
        return this._initState;
    }

    @Override
    public void setInitState(int n) {
        int n2 = this._initState;
        if (n2 != n) {
            this._initState = n;
            this.firePropertyChange(PROPERTY_INIT_STATE, n2, n);
        }
    }

    @Override
    public DockableBarContext getDockableBarContextOf(String string) {
        DockableBarContext dockableBarContext = this._allContexts.get(string);
        if (dockableBarContext != null) {
            return dockableBarContext;
        }
        return null;
    }

    @Override
    public DockableBarPopupMenuCustomizer getDockableBarPopupMenuCustomizer() {
        return this._dockableBarPopupMenuCustomizer;
    }

    @Override
    public void setDockableBarPopupMenuCustomizer(DockableBarPopupMenuCustomizer dockableBarPopupMenuCustomizer) {
        this._dockableBarPopupMenuCustomizer = dockableBarPopupMenuCustomizer;
    }

    @Override
    public void dispose() {
        this.removeAllDockableBars();
        this.removeMouseEventHandler();
        this._keyEventDispatcher = null;
        if (this._allContexts != null) {
            this._allContexts.clear();
        }
        if (this.getRootPaneContainerAsComponent() != null) {
            this.getRootPaneContainerAsComponent().removeComponentListener(this._componentListener);
        }
        this._componentListener = null;
        this._eastDockableBarContainer = null;
        this._westDockableBarContainer = null;
        this._northDockableBarContainer = null;
        this._southDockableBarContainer = null;
        this._currentFloatingCommandBar = null;
        if (this._floatingDockableBars != null) {
            this._floatingDockableBars.clear();
            this._floatingDockableBars = null;
        }
        if (this._hiddenDockableBars != null) {
            this._hiddenDockableBars.clear();
        }
        this._contentContainer = null;
        this._dockableBarPopupMenuCustomizer = null;
        this._mainContainer = null;
        if (this._rootPaneContainer instanceof Window) {
            ((Window)((Object)this._rootPaneContainer)).removeWindowListener(this._windowListener);
        }
        this._rootPaneContainer = null;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(this._keyEventPostProcessor);
    }

    @Override
    public boolean isHideFloatingDockableBarsWhenDeactivate() {
        return this._hideFloatingDockableBarsWhenDeactivate;
    }

    @Override
    public void setHideFloatingDockableBarsWhenDeactivate(boolean bl) {
        boolean bl2 = this._hideFloatingDockableBarsWhenDeactivate;
        if (bl2 != bl) {
            this._hideFloatingDockableBarsWhenDeactivate = bl;
            this.firePropertyChange(PROPERTY_HIDE_FLOATING_DOCKABLE_BARS_WHEN_DEACTIVATE, bl2, bl);
        }
    }

    @Override
    public DockableBarContainer getDockableBarContainer(int n) {
        switch (n) {
            case 7: {
                return this._westDockableBarContainer;
            }
            case 3: {
                return this._eastDockableBarContainer;
            }
            case 1: {
                return this._northDockableBarContainer;
            }
            case 5: {
                return this._southDockableBarContainer;
            }
            case 0: {
                return null;
            }
        }
        return null;
    }

    @Override
    public DockableBarContainer createDockableBarContainer() {
        return new DockableBarContainer(this);
    }

    @Override
    public void showContextMenu(MouseEvent mouseEvent, Component component) {
        this._globalContextMenu = this.getContextMenu();
        if (this.getDockableBarPopupMenuCustomizer() != null) {
            this.getDockableBarPopupMenuCustomizer().customizePopupMenu(this._globalContextMenu, this, component);
        }
        if (this._globalContextMenu.getComponentCount() > 0) {
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), component);
            this._globalContextMenu.show(component, point.x, point.y);
        }
    }

    @Override
    public JPopupMenu getContextMenu() {
        List<String> list = this.getAllDockableBarNames();
        JidePopupMenu jidePopupMenu = new JidePopupMenu();
        for (final String object2 : list) {
            DockableBar dockableBar = this.getDockableBar(object2);
            if (dockableBar == null) continue;
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)jidePopupMenu.add(new JCheckBoxMenuItem(dockableBar.getTitle()));
            jCheckBoxMenuItem.setName(dockableBar.getKey());
            if (dockableBar.isHidable() && this.isHidable()) {
                jCheckBoxMenuItem.addActionListener(new AbstractAction(){
                    private static final long serialVersionUID = -1046823503732889210L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DockableBar dockableBar = DefaultDockableBarManager.this.getDockableBar(object2);
                        if (dockableBar != null) {
                            if (dockableBar.isHidden()) {
                                DefaultDockableBarManager.this.showDockableBar(object2);
                            } else {
                                DefaultDockableBarManager.this.hideDockableBar(object2);
                            }
                        }
                    }
                });
            } else {
                jCheckBoxMenuItem.setEnabled(false);
            }
            jCheckBoxMenuItem.setSelected(!dockableBar.isHidden());
        }
        jidePopupMenu.addSeparator();
        ResourceBundle resourceBundle = Resource.getResourceBundle(Locale.getDefault());
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)jidePopupMenu.add(new JCheckBoxMenuItem(resourceBundle.getString("DockableBar.rearrangeable")));
        jCheckBoxMenuItem.setName("DockableBar.rearrangeable");
        jCheckBoxMenuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 6759293385626521734L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultDockableBarManager.this.setRearrangable(!DefaultDockableBarManager.this.isRearrangable());
            }
        });
        jCheckBoxMenuItem.setSelected(this.isRearrangable());
        JCheckBoxMenuItem jCheckBoxMenuItem2 = (JCheckBoxMenuItem)jidePopupMenu.add(new JCheckBoxMenuItem(resourceBundle.getString("DockableBar.hidable")));
        jCheckBoxMenuItem2.setName("DockableBar.hidable");
        jCheckBoxMenuItem2.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -5475345567338601724L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultDockableBarManager.this.setHidable(!DefaultDockableBarManager.this.isHidable());
            }
        });
        jCheckBoxMenuItem2.setSelected(this.isHidable());
        JCheckBoxMenuItem jCheckBoxMenuItem3 = (JCheckBoxMenuItem)jidePopupMenu.add(new JCheckBoxMenuItem(resourceBundle.getString("DockableBar.floatable")));
        jCheckBoxMenuItem3.setName("DockableBar.floatable");
        jCheckBoxMenuItem3.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 7175150795685209459L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultDockableBarManager.this.setFloatable(!DefaultDockableBarManager.this.isFloatable());
            }
        });
        jCheckBoxMenuItem3.setSelected(this.isFloatable());
        return jidePopupMenu;
    }

    @Override
    public FloatingDockableBarContainer createFloatingDockableBarContainer(Window window) {
        FloatingDockableBarContainer floatingDockableBarContainer;
        if (this.getRootPaneContainer() instanceof Applet) {
            Frame frame = JideSwingUtilities.getFrame((Applet)((Object)this._rootPaneContainer));
            floatingDockableBarContainer = new FloatingDockableBarContainer((Window)frame);
        } else {
            Window window2 = DockingUtils.getWindowFor(this.getContentContainer());
            if (window2 instanceof Dialog) {
                floatingDockableBarContainer = new FloatingDockableBarContainer(window2);
            } else if (window2 instanceof Frame) {
                floatingDockableBarContainer = new FloatingDockableBarContainer(window2);
            } else {
                throw new UnsupportedOperationException("JIDE Action Framework doesn't support floating command bar if rootPaneContainer is " + this._rootPaneContainer.getClass().getName());
            }
        }
        return floatingDockableBarContainer;
    }

    private void updateKey(String string, String string2) {
        Serializable serializable;
        if (this._allContexts != null && this._allContexts.containsKey(string)) {
            serializable = this._allContexts.get(string);
            this._allContexts.remove(string);
            this._allContexts.put(string2, (DockableBarContext)serializable);
        }
        if (this._allDockableBars != null && this._allDockableBars.containsKey(string)) {
            serializable = this._allDockableBars.get(string);
            this._allDockableBars.remove(string);
            this._allDockableBars.put(string2, (DockableBar)serializable);
        }
        if (this._allDockableBarKeys != null && this._allDockableBarKeys.contains(string)) {
            this._allDockableBarKeys.set(this._allDockableBarKeys.indexOf(string), string2);
        }
        if (this._hiddenDockableBars.contains(string)) {
            this._hiddenDockableBars.set(this._hiddenDockableBars.indexOf(string), string2);
        }
    }

    private boolean isRealized() {
        return this._realized;
    }

    void setRealized(boolean bl) {
        this._realized = bl;
    }

    @Override
    public boolean isShowContextMenu() {
        return this._showContextMenu;
    }

    @Override
    public void setShowContextMenu(boolean bl) {
        boolean bl2 = this._showContextMenu;
        if (bl2 != bl) {
            this._showContextMenu = bl;
            this.firePropertyChange(PROPERTY_SHOW_CONTEXT_MENU, bl2, bl);
        }
    }

    protected boolean redispatchKeyEventToFloatingContainers(KeyEvent keyEvent) {
        if (this._floatingDockableBars == null) {
            return false;
        }
        for (Object e : this._floatingDockableBars) {
            Object e2 = e;
            if (!(e2 instanceof FloatingDockableBarContainer)) continue;
            FloatingDockableBarContainer floatingDockableBarContainer = (FloatingDockableBarContainer)e2;
            this.processKeyBindingForFloatingDockableWindow(keyEvent, floatingDockableBarContainer);
            if (!keyEvent.isConsumed()) continue;
            return true;
        }
        return false;
    }

    protected void processKeyBindingForFloatingDockableWindow(KeyEvent keyEvent, JWindow jWindow) {
        Component[] componentArray;
        if (keyEvent == null || jWindow == null) {
            return;
        }
        for (Component component : componentArray = jWindow.getComponents()) {
            if (!(component instanceof Container)) continue;
            this.processKeyBindingsForContainerInFloatingDockable(keyEvent, (Container)component);
            if (!keyEvent.isConsumed()) continue;
            return;
        }
    }

    protected void processKeyBindingsForContainerInFloatingDockable(KeyEvent keyEvent, Container container) {
        Component[] componentArray;
        if (container instanceof JComponent) {
            this.processKeyBindingForComponentInFloatingDockable(keyEvent, (JComponent)container);
        }
        if (keyEvent.isConsumed()) {
            return;
        }
        for (Component component : componentArray = container.getComponents()) {
            if (!(component instanceof Container)) continue;
            this.processKeyBindingsForContainerInFloatingDockable(keyEvent, (Container)component);
            if (!keyEvent.isConsumed()) continue;
            return;
        }
    }

    protected void processKeyBindingForComponentInFloatingDockable(KeyEvent keyEvent, JComponent jComponent) {
        boolean bl;
        if (keyEvent == null || jComponent == null) {
            return;
        }
        boolean bl2 = bl = keyEvent.getID() == 401;
        KeyStroke keyStroke = keyEvent.getID() == 400 ? KeyStroke.getKeyStroke(keyEvent.getKeyChar()) : KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers(), !bl);
        InputMap inputMap = jComponent.getInputMap(2);
        ActionMap actionMap = jComponent.getActionMap();
        if (inputMap != null && actionMap != null && jComponent.isEnabled()) {
            Action action;
            Object object = inputMap.get(keyStroke);
            Action action2 = action = object == null ? null : actionMap.get(object);
            if (action != null) {
                SwingUtilities.notifyAction(action, keyStroke, keyEvent, jComponent, keyEvent.getModifiers());
            }
        }
    }

    @Override
    public DockableBarFactory getDockableBarFactory() {
        return this._dockableBarFactory;
    }

    @Override
    public void setDockableBarFactory(DockableBarFactory dockableBarFactory) {
        this._dockableBarFactory = dockableBarFactory;
    }

    @Override
    public void loadInitialLayout(Document document) {
        NodeList nodeList = document.getElementsByTagName(NODE_MANAGERS).item(0).getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!NODE_DOCKABLE_BAR_MANAGER.equals(node.getNodeName())) continue;
            Element element = (Element)node;
            XmlUtils.readElement(this, element);
            Element element2 = (Element)element.getElementsByTagName(NODE_DOCKABLE_BARS).item(0);
            NodeList nodeList2 = element2.getElementsByTagName(NODE_DOCKABLE_BAR);
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Element element3 = (Element)nodeList2.item(j);
                this.readBarElement(element3);
            }
            break;
        }
    }

    private void readBarElement(Element element) {
        DockableBarFactory dockableBarFactory;
        String string = element.getAttribute(ATTRIBUTE_KEY);
        DockableBar dockableBar = this.getDockableBar(string);
        if (dockableBar == null && (dockableBarFactory = this.getDockableBarFactory()) != null) {
            dockableBar = dockableBarFactory.create(string);
        }
        if (dockableBar == null) {
            return;
        }
        if (this.getDockableBar(string) == null) {
            this.addDockableBar(dockableBar);
        }
        XmlUtils.readElement(dockableBar, element);
    }

    @Override
    public boolean isUseGlassPaneEnabled() {
        return this._useGlassPaneEnabled;
    }

    @Override
    public void setUseGlassPaneEnabled(boolean bl) {
        this._useGlassPaneEnabled = bl;
    }

    @Override
    public void setDockableBarAvailable(String string) {
        this.checkBarKey(string, "setDockableBarAvailable");
        final DockableBar dockableBar = this.getDockableBar(string);
        if (dockableBar == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.setDockableBarAvailable(dockableBar);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockableBarManager.this.setDockableBarAvailable(dockableBar);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
        }
    }

    private void setDockableBarAvailable(DockableBar dockableBar) {
        if (dockableBar.getContext() == null || dockableBar.isAvailable()) {
            return;
        }
        if (!this._allDockableBars.containsKey(dockableBar.getKey())) {
            this.addDockableBar(dockableBar);
        }
        if (!dockableBar.isHidden() && !dockableBar.isVisible()) {
            dockableBar.setVisible(true);
        }
        dockableBar.setAvailable(true);
        if (!this.loadAvailablePreviousState(dockableBar)) {
            if (dockableBar.isFloating()) {
                this.floatDockableBar(dockableBar, dockableBar.getUndockedBounds());
            } else {
                this.dockDockableBar(dockableBar, DockableBarUtils.convertDockSideToSide(dockableBar.getContext().getInitSide()), dockableBar.getContext().getInitIndex(), false, dockableBar.getContext().getInitSubindex());
            }
        }
    }

    @Override
    public void setDockableBarUnavailable(String string) {
        this.checkBarKey(string, "setDockableBarUnavailable");
        final DockableBar dockableBar = this.getDockableBar(string);
        if (dockableBar == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.setDockableBarUnavailable(dockableBar);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockableBarManager.this.setDockableBarUnavailable(dockableBar);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
        }
    }

    private void setDockableBarUnavailable(DockableBar dockableBar) {
        if (dockableBar.getContext() == null || !dockableBar.isAvailable()) {
            return;
        }
        if (!this._allDockableBars.containsKey(dockableBar.getKey())) {
            this.addDockableBar(dockableBar);
        }
        DockableBarUtils.saveAvailablePreviousState(dockableBar);
        if (dockableBar.getParent() != null && dockableBar.getParent() instanceof DockableBarContainer) {
            dockableBar.getParent().remove(dockableBar);
        }
        dockableBar.setAvailable(false);
        Container container = dockableBar.getTopLevelAncestor();
        if (container instanceof FloatingDockableBarContainer && this._floatingDockableBars != null) {
            this._floatingDockableBars.remove(container);
            container.setVisible(false);
            ((FloatingDockableBarContainer)container).dispose();
        }
        this.doLayout();
    }

    public boolean isPreserveAvailableProperty() {
        return this._preserveAvailableProperty;
    }

    public void setPreserveAvailableProperty(boolean bl) {
        this._preserveAvailableProperty = bl;
    }

    private boolean loadAvailablePreviousState(DockableBar dockableBar) {
        PreviousState previousState = dockableBar.getContext().getAvailablePreviousState();
        if (previousState != null) {
            this.restorePreviousState(dockableBar, previousState);
            return true;
        }
        return false;
    }

    protected void checkBarKey(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("The dockable bar key passed to " + string2 + " is empty. Please use DockableBar#getKey() method to get the unique key when using APIs on DockableBarManager.");
        }
    }

    @Override
    public int getDoubleClickAction() {
        return this._doubleClickAction;
    }

    @Override
    public void setDoubleClickAction(int n) {
        int n2 = this._doubleClickAction;
        if (this._doubleClickAction != n) {
            this._doubleClickAction = n;
            this.firePropertyChange(PROPERTY_DOUBLE_CLICK_ACTION, n2, this._doubleClickAction);
        }
    }

    Rectangle getUnmaximizedBounds() {
        return this._unmaximizedBounds;
    }

    Map<String, DockableBarContext> getAllContexts() {
        return this._allContexts;
    }

    boolean isUseFrameBounds() {
        return this._useFrameBounds;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(16)) {
            Lm.showInvalidProductMessage(DefaultDockableBarManager.class.getName(), 16);
        }
        LOGGER = Logger.getLogger(DefaultDockableBarManager.class.getName());
        LOGGER_EVENT = Logger.getLogger(DockableBarsRearrangedEvent.class.getName());
    }

    protected class FloaterKeyEventPostProcessor
    implements KeyEventPostProcessor {
        protected FloaterKeyEventPostProcessor() {
        }

        @Override
        public boolean postProcessKeyEvent(KeyEvent keyEvent) {
            if (DefaultDockableBarManager.this._redispatchingKeyEventToFloaters) {
                return false;
            }
            if (keyEvent.isConsumed() || !keyEvent.isAltDown()) {
                return false;
            }
            return DefaultDockableBarManager.this.redispatchKeyEventToFloatingContainers(keyEvent);
        }
    }

    protected class DockableBarsSnapshot {
        protected Component _possiblyMoved;
        protected ArrayList<DockableBarState> _northBars = new ArrayList();
        protected ArrayList<DockableBarState> _southBars = new ArrayList();
        protected ArrayList<DockableBarState> _eastBars = new ArrayList();
        protected ArrayList<DockableBarState> _westBars = new ArrayList();
        protected ArrayList<DockableBarState> _floatingBars = new ArrayList();

        protected DockableBarsSnapshot() {
        }

        protected void clear() {
            this._possiblyMoved = null;
            this._northBars.clear();
            this._southBars.clear();
            this._eastBars.clear();
            this._westBars.clear();
            this._floatingBars.clear();
        }
    }
}

