/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.CommandBarPane;
import com.jidesoft.action.CommandBarSeparator;
import java.awt.AWTError;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.SizeRequirements;
import javax.swing.SwingConstants;

class CommandBarPaneLayout
implements LayoutManager2,
Serializable,
SwingConstants {
    private HashMap _hiddenOrder = new HashMap();
    private Dimension _savePreferredDimension;
    private int[] _splits;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int LINE_AXIS = 2;
    public static final int PAGE_AXIS = 3;
    private Container _target;
    private transient SizeRequirements[] xChildren;
    private transient SizeRequirements[] yChildren;
    private transient SizeRequirements xTotal;
    private transient SizeRequirements yTotal;
    private List<Result> _result = null;

    public Rectangle getActualSize(Container container, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        CommandBarPane commandBarPane = (CommandBarPane)container;
        Insets insets = container.getInsets();
        n3 = (int)Math.min((long)n3 - (long)insets.left - (long)insets.right, Integer.MAX_VALUE);
        n4 = (int)Math.min((long)n4 - (long)insets.top - (long)insets.bottom, Integer.MAX_VALUE);
        this.checkRequests();
        if (n5 == 0) {
            int n6 = this.retrieveByWidth(n3, bl2);
            Result result = this._result.get(n6);
            n3 = result.width;
            n4 = result.height;
            this._splits = result.splits;
            commandBarPane.setPreferredRowCount(result.rowCount);
        } else {
            int n7 = this.retrieveByHeight(n4, bl2);
            Result result = this._result.get(n7);
            n3 = result.width;
            n4 = result.height;
            this._splits = result.splits;
            commandBarPane.setPreferredRowCount(result.rowCount);
        }
        n3 = (int)Math.min((long)n3 + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        n4 = (int)Math.min((long)n4 + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        this._savePreferredDimension = new Dimension(n3, n4);
        return new Rectangle(n, n2, n3, n4);
    }

    private int getMinWidth(SizeRequirements[] sizeRequirementsArray) {
        int n = 0;
        for (int i = 0; i < sizeRequirementsArray.length; ++i) {
            SizeRequirements sizeRequirements = sizeRequirementsArray[i];
            if (n >= sizeRequirements.preferred) continue;
            n = sizeRequirements.preferred;
        }
        return n;
    }

    public CommandBarPaneLayout(Container container) {
        this._target = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void invalidateLayout(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this.checkContainer(container);
            this.xChildren = null;
            this.yChildren = null;
            this.xTotal = null;
            this.yTotal = null;
            this._savePreferredDimension = null;
            this._result = null;
        }
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            this._hiddenOrder.remove(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component component, Object object) {
        Object object2 = component.getTreeLock();
        synchronized (object2) {
            if (object instanceof Integer) {
                this._hiddenOrder.put(component, object);
            } else {
                this._hiddenOrder.put(component, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container container) {
        if (this._savePreferredDimension != null) {
            return this._savePreferredDimension;
        }
        Dimension dimension = new Dimension(0, 0);
        Object object = container.getTreeLock();
        synchronized (object) {
            this.checkContainer(container);
            this.checkRequests();
            if (this._target instanceof CommandBarPane) {
                CommandBarPane commandBarPane = (CommandBarPane)this._target;
                if (commandBarPane.isUsePreferredRowCount()) {
                    int n;
                    if (this._splits == null) {
                        n = this.retrieveByWidth(200, true);
                        Result result = this._result.get(n);
                        this._splits = result.splits;
                        commandBarPane.setPreferredRowCount(result.rowCount);
                    }
                    n = commandBarPane.getPreferredRowCount();
                    dimension = this.getPreferredSizeByRowCount(n);
                } else {
                    dimension = new Dimension(this.xTotal.preferred, this.yTotal.preferred);
                }
            }
        }
        object = container.getInsets();
        dimension.width = (int)Math.min((long)dimension.width + (long)((Insets)object).left + (long)((Insets)object).right, Integer.MAX_VALUE);
        dimension.height = (int)Math.min((long)dimension.height + (long)((Insets)object).top + (long)((Insets)object).bottom, Integer.MAX_VALUE);
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        Object object = container.getTreeLock();
        synchronized (object) {
            this.checkRequests();
            this.checkContainer(container);
            Vector vector = this.sortComponentByOrder();
            this.checkRequests();
            if (this._target instanceof CommandBarPane) {
                CommandBarPane commandBarPane = (CommandBarPane)this._target;
                dimension = commandBarPane.getOrientation() == 0 ? new Dimension(vector.size() == 0 ? 0 : ((Component)vector.get((int)0)).getPreferredSize().width, this.yTotal.minimum) : new Dimension(this.xTotal.minimum, vector.size() == 0 ? 0 : ((Component)vector.get((int)0)).getPreferredSize().height);
            }
        }
        object = container.getInsets();
        dimension.width = (int)Math.min((long)dimension.width + (long)((Insets)object).left + (long)((Insets)object).right, Integer.MAX_VALUE);
        dimension.height = (int)Math.min((long)dimension.height + (long)((Insets)object).top + (long)((Insets)object).bottom, Integer.MAX_VALUE);
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension maximumLayoutSize(Container container) {
        Dimension dimension;
        Object object = container.getTreeLock();
        synchronized (object) {
            this.checkContainer(container);
            this.checkRequests();
            dimension = new Dimension(this.xTotal.maximum, this.yTotal.maximum);
        }
        object = container.getInsets();
        dimension.width = (int)Math.min((long)dimension.width + (long)((Insets)object).left + (long)((Insets)object).right, Integer.MAX_VALUE);
        dimension.height = (int)Math.min((long)dimension.height + (long)((Insets)object).top + (long)((Insets)object).bottom, Integer.MAX_VALUE);
        return dimension;
    }

    @Override
    public synchronized float getLayoutAlignmentX(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        return this.xTotal.alignment;
    }

    @Override
    public synchronized float getLayoutAlignmentY(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        return this.yTotal.alignment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        if (!container.isVisible()) {
            return;
        }
        Object object = container.getTreeLock();
        synchronized (object) {
            this.checkContainer(container);
            CommandBarPane commandBarPane = (CommandBarPane)container;
            Dimension dimension = this._target.getSize();
            Insets insets = this._target.getInsets();
            dimension.width -= insets.left + insets.right;
            dimension.height -= insets.top + insets.bottom;
            int n = dimension.width;
            int n2 = dimension.height;
            int n3 = insets.top;
            int n4 = insets.left;
            if (commandBarPane.isUsePreferredRowCount()) {
                Object object2;
                int n5;
                Vector vector = this.getComponents();
                int n6 = n4;
                int n7 = 0;
                int n8 = 0;
                this.checkRequests();
                if (this._splits == null) {
                    n5 = this.retrieveByWidth(200, true);
                    object2 = this._result.get(n5);
                    n = ((Result)object2).width;
                    n2 = ((Result)object2).height;
                    this._splits = ((Result)object2).splits;
                    commandBarPane.setPreferredRowCount(((Result)object2).rowCount);
                }
                for (n5 = 0; n5 < vector.size(); ++n5) {
                    if (this._splits != null && n7 <= this._splits.length - 1 && n5 == this._splits[n7]) {
                        n8 = 0;
                        n3 += this.yTotal.preferred;
                        n4 = n6;
                        ++n7;
                    }
                    if (n8 == 0) {
                        int n9 = this._splits != null && n7 <= this._splits.length - 1 ? this._splits[n7] : vector.size();
                        for (int i = n5; i < n9; ++i) {
                            if (n8 >= this.yChildren[i].preferred) continue;
                            n8 = this.yChildren[i].preferred;
                        }
                    }
                    object2 = (Component)vector.get(n5);
                    Dimension dimension2 = ((Component)object2).getPreferredSize();
                    ((Component)object2).setBounds(n4, n3, dimension2.width, n8);
                    n4 += dimension2.width;
                }
            } else {
                Vector vector = this.getComponents();
                int n10 = vector.size();
                if (commandBarPane.getOrientation() == 0) {
                    Dimension dimension3;
                    Component component;
                    int n11;
                    for (n11 = 0; n11 < vector.size(); ++n11) {
                        component = (Component)vector.get(n11);
                        dimension3 = component.getPreferredSize();
                        if ((n -= dimension3.width) == 0) {
                            n10 = n11;
                            break;
                        }
                        if (n >= 0) continue;
                        n10 = n11 - 1;
                        break;
                    }
                    if (this._target instanceof CommandBarPane) {
                        ((CommandBarPane)this._target).removeAllHiddenComponents();
                    }
                    for (n11 = 0; n11 < vector.size(); ++n11) {
                        component = (Component)vector.get(n11);
                        if (vector.indexOf(component) == -1) continue;
                        if (vector.indexOf(component) > n10) {
                            if (!(this._target instanceof CommandBarPane)) continue;
                            ((CommandBarPane)this._target).addHiddenComponent(component);
                            continue;
                        }
                        if (component.getParent() != this._target && this._target instanceof CommandBarPane) {
                            ((CommandBarPane)this._target).removeHiddenComponent(component);
                        }
                        component.setVisible(true);
                        dimension3 = component.getPreferredSize();
                        component.setBounds(n4, n3, dimension3.width, n2);
                        n4 += dimension3.width;
                    }
                } else {
                    Dimension dimension4;
                    Component component;
                    int n12;
                    for (n12 = 0; n12 < vector.size(); ++n12) {
                        component = (Component)vector.get(n12);
                        dimension4 = component.getPreferredSize();
                        if ((n2 -= dimension4.height) == 0) {
                            n10 = n12;
                            break;
                        }
                        if (n2 >= 0) continue;
                        n10 = n12 - 1;
                        break;
                    }
                    if (this._target instanceof CommandBarPane) {
                        ((CommandBarPane)this._target).removeAllHiddenComponents();
                    }
                    for (n12 = 0; n12 < vector.size(); ++n12) {
                        component = (Component)vector.get(n12);
                        if (vector.indexOf(component) == -1) continue;
                        if (vector.indexOf(component) > n10) {
                            if (!(this._target instanceof CommandBarPane)) continue;
                            ((CommandBarPane)this._target).addHiddenComponent(component);
                            continue;
                        }
                        if (component.getParent() != this._target && this._target instanceof CommandBarPane) {
                            ((CommandBarPane)this._target).removeHiddenComponent(component);
                        }
                        component.setVisible(true);
                        dimension4 = component.getPreferredSize();
                        component.setBounds(n4, n3, n, dimension4.height);
                        n3 += dimension4.height;
                    }
                }
            }
        }
    }

    int getHiddenOrder(Object object) {
        Object v = this._hiddenOrder.get(object);
        if (v != null) {
            return (Integer)v;
        }
        return 0;
    }

    Vector sortComponentByOrder() {
        Vector vector = this.getComponents();
        Collections.sort(vector, new Comparator(){

            public int compare(Object object, Object object2) {
                if (CommandBarPaneLayout.this.getHiddenOrder(object) > CommandBarPaneLayout.this.getHiddenOrder(object2)) {
                    return -1;
                }
                if (CommandBarPaneLayout.this.getHiddenOrder(object) < CommandBarPaneLayout.this.getHiddenOrder(object2)) {
                    return 1;
                }
                return -1;
            }
        });
        return vector;
    }

    protected Vector getComponents() {
        Vector<Component> vector = new Vector<Component>();
        for (int i = 0; i < this._target.getComponentCount(); ++i) {
            Component component = this._target.getComponent(i);
            if (i == 0 && component instanceof CommandBarSeparator) continue;
            vector.add(component);
        }
        return vector;
    }

    void checkContainer(Container container) {
        if (this._target != container) {
            throw new AWTError("CommandBarLayout can't be shared");
        }
    }

    void checkRequests() {
        if (this.xChildren == null || this.yChildren == null) {
            Vector vector = this.getComponents();
            int n = vector.size();
            this.xChildren = new SizeRequirements[n];
            this.yChildren = new SizeRequirements[n];
            for (int i = 0; i < n; ++i) {
                Component component = (Component)vector.get(i);
                Dimension dimension = component.getMinimumSize();
                Dimension dimension2 = component.getPreferredSize();
                Dimension dimension3 = component.getMaximumSize();
                this.xChildren[i] = new SizeRequirements(dimension.width, dimension2.width, dimension3.width, 0.0f);
                this.yChildren[i] = new SizeRequirements(dimension.height, dimension2.height, dimension3.height, 0.0f);
            }
            this.xTotal = SizeRequirements.getTiledSizeRequirements(this.xChildren);
            this.yTotal = SizeRequirements.getAlignedSizeRequirements(this.yChildren);
        }
        this.calculateResult(this.xChildren);
    }

    private void calculateResult(SizeRequirements[] sizeRequirementsArray) {
        int n;
        if (this._result != null) {
            return;
        }
        this._result = new Vector<Result>();
        int n2 = this.getMinWidth(sizeRequirementsArray);
        for (int i = n = this.xTotal.preferred; i >= n2; --i) {
            int n3 = this.getEstimateRowCount(sizeRequirementsArray, i);
            int n4 = i;
            int n5 = this.xTotal.preferred / n3;
            int n6 = 0;
            int[] nArray = new int[sizeRequirementsArray.length];
            for (int j = n5; j <= n4; ++j) {
                n6 = 0;
                int n7 = 0;
                int n8 = 0;
                for (int k = 0; k < sizeRequirementsArray.length; ++k) {
                    if (n6 < n3 - 1 && n7 + sizeRequirementsArray[k].preferred > j) {
                        nArray[n6] = k;
                        ++n6;
                        if (n8 < n7) {
                            n8 = n7;
                        }
                        n7 = 0;
                    }
                    n7 += sizeRequirementsArray[k].preferred;
                }
                if (n8 < n7) {
                    n8 = n7;
                }
                n4 = n8;
            }
            if (n6 + 1 <= this._result.size() || this._result.size() != 0 && n6 < this._result.get((int)(this._result.size() - 1)).rowCount) continue;
            Result result = new Result();
            result.rowCount = n6 + 1;
            result.width = n4;
            result.splits = new int[n6];
            System.arraycopy(nArray, 0, result.splits, 0, n6);
            result.width = n4;
            result.height = result.rowCount * this.yTotal.preferred;
            this._result.add(result);
        }
    }

    private int retrieveByWidth(int n, boolean bl) {
        if (bl) {
            for (int i = 0; i < this._result.size(); ++i) {
                Result result = this._result.get(i);
                if (n < result.width) continue;
                return i;
            }
        } else {
            for (int i = this._result.size() - 1; i >= 0; --i) {
                Result result = this._result.get(i);
                if (result.width <= n) continue;
                return i;
            }
        }
        return bl ? this._result.size() - 1 : 0;
    }

    private int retrieveByHeight(int n, boolean bl) {
        if (bl) {
            for (int i = this._result.size() - 1; i >= 0; --i) {
                Result result = this._result.get(i);
                if (n < result.height) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this._result.size(); ++i) {
                Result result = this._result.get(i);
                if (result.height <= n) continue;
                return i;
            }
        }
        return bl ? 0 : this._result.size() - 1;
    }

    private int getEstimateRowCount(SizeRequirements[] sizeRequirementsArray, int n) {
        for (int i = 1; i < sizeRequirementsArray.length; ++i) {
            int n2 = this.xTotal.preferred / i;
            if (n < n2) continue;
            return i;
        }
        return -1;
    }

    Dimension getPreferredSizeByRowCount(int n) {
        if (n < 1) {
            n = 1;
        }
        for (Result result : this._result) {
            if (result.rowCount != n) continue;
            return new Dimension(result.width, result.height);
        }
        return new Dimension(0, 0);
    }

    private static class Result {
        int rowCount;
        int[] splits;
        int width;
        int height;

        private Result() {
        }
    }
}

