/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.CommandBar;
import com.jidesoft.action.CommandMenuBar;
import com.jidesoft.action.DockableBar;
import com.jidesoft.action.DockableBarHolder;
import com.jidesoft.action.Resource;
import com.jidesoft.docking.DefaultDockableHolder;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockableHolder;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.document.DocumentPane;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.office2003.Office2003Painter;
import com.jidesoft.plaf.office2003.Office2003Theme;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideComboBox;
import com.jidesoft.swing.JideMenu;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.swing.JideToggleSplitButton;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyleFactory;

public class CommandBarFactory {
    static final String[] SYNTHETICA_LAFS = new String[]{"de.javasoft.plaf.synthetica.SyntheticaStandardLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaWhiteVisionLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaSkyMetallicLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaMauveMetallicLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaOrangeMetallicLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaBlueSteelLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaBlueMoonLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaBlackMoonLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaSilverMoonLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaBlueIceLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaGreenDreamLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaBlackStarLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaBlackEyeLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaSimple2DLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaClassyLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaAluOxideLookAndFeel"};

    public static CommandBar createMenuCommandBar(JMenuBar jMenuBar) {
        CommandMenuBar commandMenuBar = new CommandMenuBar("Menu Bar");
        commandMenuBar.getContext().setInitSide(1);
        commandMenuBar.setPaintBackground(false);
        commandMenuBar.setStretch(true);
        commandMenuBar.setFloatable(true);
        commandMenuBar.add(jMenuBar);
        return commandMenuBar;
    }

    protected static AbstractButton createButton(Icon icon) {
        return CommandBarFactory.createButton(null, icon);
    }

    protected static AbstractButton createButton(String string) {
        return CommandBarFactory.createButton(string, null);
    }

    protected static AbstractButton createButton(String string, Icon icon) {
        JideButton jideButton = new JideButton(string, icon);
        jideButton.setOpaque(false);
        jideButton.setFocusable(false);
        return jideButton;
    }

    protected static JideSplitButton createSplitButton(Icon icon) {
        return CommandBarFactory.createSplitButton(null, icon);
    }

    protected static JideSplitButton createSplitButton(String string) {
        return CommandBarFactory.createSplitButton(string, null);
    }

    protected static JideSplitButton createSplitButton(String string, Icon icon) {
        JideSplitButton jideSplitButton = new JideSplitButton(string);
        jideSplitButton.setIcon(icon);
        jideSplitButton.setOpaque(true);
        jideSplitButton.setFocusable(false);
        return jideSplitButton;
    }

    protected static JideToggleSplitButton createToggleSplitButton(String string, Icon icon) {
        JideToggleSplitButton jideToggleSplitButton = new JideToggleSplitButton(string);
        jideToggleSplitButton.setIcon(icon);
        jideToggleSplitButton.setOpaque(true);
        jideToggleSplitButton.setFocusable(false);
        return jideToggleSplitButton;
    }

    protected static JideMenu createMenu(Icon icon) {
        JideMenu jideMenu = new JideMenu("");
        jideMenu.setIcon(icon);
        jideMenu.setOpaque(false);
        return jideMenu;
    }

    protected static JideMenu createMenu(String string, char c) {
        JideMenu jideMenu = new JideMenu(string);
        jideMenu.setMnemonic(c);
        jideMenu.setOpaque(false);
        return jideMenu;
    }

    protected static JideMenu createMenu(String string, char c, Icon icon) {
        JideMenu jideMenu = new JideMenu(string);
        jideMenu.setIcon(icon);
        jideMenu.setMnemonic(c);
        jideMenu.setOpaque(false);
        return jideMenu;
    }

    protected static JComboBox createComboBox(String string) {
        JideComboBox jideComboBox = new JideComboBox(new Object[]{string});
        jideComboBox.setEditable(true);
        jideComboBox.setPrototypeDisplayValue(string + "    ");
        jideComboBox.setOpaque(false);
        return jideComboBox;
    }

    public static void addDemoMenus(JComponent jComponent, String[] stringArray) {
        for (String string : stringArray) {
            JideMenu jideMenu = new JideMenu(string);
            jideMenu.setMnemonic(string.charAt(0));
            JMenuItem jMenuItem = new JMenuItem("<< Empty >>");
            jideMenu.add(jMenuItem);
            jComponent.add(jideMenu);
        }
    }

    private static void updateComponentTreeUI(final Container container) {
        Object object;
        if (container == null) {
            return;
        }
        final ArrayList<String> arrayList = new ArrayList<String>();
        if (container instanceof DockableHolder) {
            object = ((DockableHolder)((Object)container)).getDockingManager().getAllFrameNames();
            Iterator<String> iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                DockableFrame dockableFrame = ((DockableHolder)((Object)container)).getDockingManager().getFrame(string);
                if (!dockableFrame.isFloated()) continue;
                arrayList.add(string);
            }
        }
        if (container instanceof JFrame) {
            if (container instanceof DefaultDockableHolder) {
                ((DefaultDockableHolder)container).setAutoDispose(false);
            }
            if (!LookAndFeelFactory.isCurrentLnfDecorated()) {
                ((JFrame)container).dispose();
                ((JFrame)container).setUndecorated(true);
                ((JFrame)container).getRootPane().setWindowDecorationStyle(1);
            } else if (((JFrame)container).isUndecorated() && LookAndFeelFactory.isCurrentLnfDecorated()) {
                ((JFrame)container).dispose();
                ((JFrame)container).setUndecorated(false);
                ((JFrame)container).getRootPane().setWindowDecorationStyle(0);
            }
            if (container instanceof DefaultDockableHolder) {
                ((DefaultDockableHolder)container).setAutoDispose(true);
            }
        }
        JideSwingUtilities.setRecursively(container, new JideSwingUtilities.Handler(){

            @Override
            public boolean condition(Component component) {
                return component instanceof DockableHolder || component instanceof DockableBarHolder;
            }

            @Override
            public void action(Component component) {
                if (component instanceof DockableHolder) {
                    ((DockableHolder)((Object)component)).getDockingManager().updateComponentTreeUI();
                }
                if (component instanceof DockableBarHolder) {
                    ((DockableBarHolder)((Object)component)).getDockableBarManager().updateComponentTreeUI();
                    List<String> list = ((DockableBarHolder)((Object)component)).getDockableBarManager().getAllDockableBarNames();
                    boolean bl = LookAndFeelFactory.isCurrentLnfDecorated();
                    for (String string : list) {
                        DockableBar dockableBar = ((DockableBarHolder)((Object)component)).getDockableBarManager().getDockableBar(string);
                        if (bl) {
                            if (!dockableBar.isMenuBar()) {
                                dockableBar.setOpaque(false);
                                dockableBar.setStretch(false);
                                dockableBar.setPaintBackground(true);
                                continue;
                            }
                            dockableBar.setOpaque(false);
                            dockableBar.setPaintBackground(false);
                            dockableBar.setRearrangable(true);
                            continue;
                        }
                        if (!dockableBar.isMenuBar()) {
                            dockableBar.setOpaque(true);
                            dockableBar.setStretch(true);
                            dockableBar.setPaintBackground(true);
                            continue;
                        }
                        dockableBar.setOpaque(false);
                        dockableBar.setPaintBackground(true);
                        dockableBar.setRearrangable(dockableBar.isRearrangable());
                    }
                }
            }

            @Override
            public void postAction(Component component) {
            }
        });
        SwingUtilities.updateComponentTreeUI(container);
        if (container instanceof JFrame) {
            container.setVisible(true);
        }
        object = new Runnable(){

            @Override
            public void run() {
                if (arrayList.size() > 0 && container instanceof DockableHolder) {
                    DockingManager dockingManager = ((DockableHolder)((Object)container)).getDockingManager();
                    for (String string : arrayList) {
                        dockingManager.showFrame(string);
                    }
                }
            }
        };
        SwingUtilities.invokeLater((Runnable)object);
    }

    private static JMenu createLAFMenu(String string, Container container, String[] stringArray) {
        String string2 = UIManager.getLookAndFeel().getClass().getName();
        JMenu jMenu = new JMenu(string);
        ButtonGroup buttonGroup = new ButtonGroup();
        for (String string3 : stringArray) {
            try {
                Class.forName(string3);
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new LAFChangeAction(container, string3));
                jMenu.add(jRadioButtonMenuItem);
                buttonGroup.add(jRadioButtonMenuItem);
                if (!string3.equals(string2)) continue;
                jRadioButtonMenuItem.setSelected(true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return jMenu;
    }

    public static JMenu createLookAndFeelMenu(final Container container) {
        ResourceBundle resourceBundle = Resource.getResourceBundle(Locale.getDefault());
        JideMenu jideMenu = new JideMenu(resourceBundle.getString("Menu.lookAndFeel"));
        jideMenu.setMnemonic(resourceBundle.getString("Menu.lookAndFeel.mnemonic").charAt(0));
        JMenuItem jMenuItem = new JMenuItem(resourceBundle.getString("Menu.windowsVsnet"));
        jMenuItem.setMnemonic(resourceBundle.getString("Menu.windowsVsnet.mnemonic").charAt(0));
        jMenuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 7329857403026223556L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.setProperty("shadingtheme", "false");
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(1);
                UIManager.getLookAndFeelDefaults().put("JideTabbedPane.defaultTabShape", (Object)2);
                UIManager.getLookAndFeelDefaults().put("JideTabbedPane.defaultTabColorTheme", (Object)3);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        jideMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(resourceBundle.getString("Menu.windowsVsnetGradient"));
        jMenuItem.setMnemonic(resourceBundle.getString("Menu.windowsVsnetGradient.mnemonic").charAt(0));
        jMenuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1317964936229802115L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.setProperty("shadingtheme", "true");
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(1);
                UIManager.getLookAndFeelDefaults().put("JideTabbedPane.defaultTabShape", (Object)1);
                UIManager.getLookAndFeelDefaults().put("JideTabbedPane.defaultTabColorTheme", (Object)4);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        jideMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(resourceBundle.getString("Menu.windowsVsnetClassic"));
        jMenuItem.setMnemonic(resourceBundle.getString("Menu.windowsVsnetClassic.mnemonic").charAt(0));
        jMenuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -7357162252817623330L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.setProperty("shadingtheme", "false");
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(1);
                UIManager.getLookAndFeelDefaults().put("JideTabbedPane.defaultTabShape", (Object)1);
                UIManager.getLookAndFeelDefaults().put("JideTabbedPane.defaultTabColorTheme", (Object)1);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        jideMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(resourceBundle.getString("Menu.windowsOffice2003"));
        jMenuItem.setMnemonic(resourceBundle.getString("Menu.windowsOffice2003.mnemonic").charAt(0));
        jMenuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -7357162252817623330L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.setProperty("shadingtheme", "false");
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(3);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        jMenuItem.setEnabled(SystemInfo.isWindows());
        jideMenu.add(jMenuItem);
        JideMenu jideMenu2 = new JideMenu(resourceBundle.getString("Menu.office2003Themes"));
        jMenuItem.setMnemonic(resourceBundle.getString("Menu.office2003Themes.mnemonic").charAt(0));
        Collection<Office2003Theme> collection = ((Office2003Painter)Office2003Painter.getInstance()).getAvailableThemes();
        for (Office2003Theme office2003Theme : collection) {
            jMenuItem = new JMenuItem(office2003Theme.getThemeName());
            jMenuItem.addActionListener(new AbstractAction(office2003Theme.getThemeName()){
                private static final long serialVersionUID = -5040987591603805273L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((Office2003Painter)Office2003Painter.getInstance()).setColorName((String)this.getValue("Name"));
                    CommandBarFactory.updateComponentTreeUI(container);
                }
            });
            jideMenu2.add(jMenuItem);
        }
        jideMenu2.setEnabled(SystemInfo.isWindows());
        jideMenu.add(jideMenu2);
        jMenuItem = new JMenuItem(resourceBundle.getString("Menu.windowsOffice2007"));
        jMenuItem.setMnemonic(resourceBundle.getString("Menu.windowsOffice2007.mnemonic").charAt(0));
        jMenuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 9196873570605698569L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.setProperty("shadingtheme", "false");
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(7);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        jMenuItem.setEnabled(SystemInfo.isWindowsVistaAbove());
        jideMenu.add(jMenuItem);
        jideMenu.addSeparator();
        jMenuItem = new JMenuItem(resourceBundle.getString("Menu.windowsEclipse"));
        jMenuItem.setMnemonic(resourceBundle.getString("Menu.windowsEclipse.mnemonic").charAt(0));
        jMenuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -439933116198670257L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.setProperty("shadingtheme", "false");
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(2);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        jideMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(resourceBundle.getString("Menu.windowsEclipse3x"));
        jMenuItem.setMnemonic(resourceBundle.getString("Menu.windowsEclipse3x.mnemonic").charAt(0));
        jMenuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 5752902379748846824L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.setProperty("shadingtheme", "false");
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(5);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        jideMenu.add(jMenuItem);
        jideMenu.addSeparator();
        jMenuItem = new JMenuItem(resourceBundle.getString("Menu.xerto"));
        jMenuItem.setMnemonic(resourceBundle.getString("Menu.xerto.mnemonic").charAt(0));
        jMenuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 8106961103954712663L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (!SystemInfo.isWindows()) {
                        UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                    } else {
                        UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(4);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        jideMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(resourceBundle.getString("Menu.metalVsnet"));
        jMenuItem.setMnemonic(resourceBundle.getString("Menu.metalVsnet.mnemonic").charAt(0));
        jMenuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -8280662735260996990L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.setProperty("shadingtheme", "false");
                try {
                    UIManager.setLookAndFeel(MetalLookAndFeel.class.getName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(1);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        jideMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(resourceBundle.getString("Menu.aqua"));
        jMenuItem.setMnemonic(resourceBundle.getString("Menu.aqua.mnemonic").charAt(0));
        jMenuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -2607089212872234201L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.setProperty("shadingtheme", "false");
                try {
                    UIManager.setLookAndFeel("apple.laf.AquaLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(1);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        jMenuItem.setEnabled(SystemInfo.isMacOSX());
        jideMenu.add(jMenuItem);
        if (LookAndFeelFactory.isPlastic3DLnfInstalled() || LookAndFeelFactory.isPlasticXPLnfInstalled() || LookAndFeelFactory.isAlloyLnfInstalled() || LookAndFeelFactory.isA03LnfInstalled() || LookAndFeelFactory.isSyntheticaLnfInstalled()) {
            jideMenu.addSeparator();
        }
        if (LookAndFeelFactory.isPlastic3DLnfInstalled()) {
            jMenuItem = new JMenuItem(resourceBundle.getString("Menu.plastic3DVsnet"));
            jMenuItem.setMnemonic(resourceBundle.getString("Menu.plastic3DVsnet.mnemonic").charAt(0));
            jMenuItem.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = -9166134683152348076L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    System.setProperty("shadingtheme", "true");
                    try {
                        UIManager.setLookAndFeel("com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                        // empty catch block
                    }
                    LookAndFeelFactory.installJideExtension(1);
                    CommandBarFactory.updateComponentTreeUI(container);
                }
            });
            jideMenu.add(jMenuItem);
        }
        if (LookAndFeelFactory.isPlasticXPLnfInstalled()) {
            jMenuItem = new JMenuItem(resourceBundle.getString("Menu.plasticXPVsnet"));
            jMenuItem.setMnemonic(resourceBundle.getString("Menu.plasticXPVsnet.mnemonic").charAt(0));
            jMenuItem.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 7907842697885724816L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    System.setProperty("shadingtheme", "true");
                    try {
                        UIManager.setLookAndFeel("com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                        // empty catch block
                    }
                    LookAndFeelFactory.installJideExtension(1);
                    CommandBarFactory.updateComponentTreeUI(container);
                }
            });
            jideMenu.add(jMenuItem);
        }
        if (LookAndFeelFactory.isBizlafLnfInstalled()) {
            jMenuItem = new JMenuItem(resourceBundle.getString("Menu.bizlaf"));
            jMenuItem.setMnemonic(resourceBundle.getString("Menu.bizlaf.mnemonic").charAt(0));
            jMenuItem.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 6326560496018798344L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    System.setProperty("shadingtheme", "true");
                    try {
                        UIManager.setLookAndFeel("de.centigrade.bizlaf.BizLookAndFeel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                        // empty catch block
                    }
                    LookAndFeelFactory.installJideExtension();
                    CommandBarFactory.updateComponentTreeUI(container);
                }
            });
            jideMenu.add(jMenuItem);
        }
        if (LookAndFeelFactory.isAlloyLnfInstalled()) {
            jMenuItem = new JMenuItem(resourceBundle.getString("Menu.alloyVsnet"));
            jMenuItem.setMnemonic(resourceBundle.getString("Menu.alloyVsnet.mnemonic").charAt(0));
            jMenuItem.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = -2585526602120461611L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    System.setProperty("shadingtheme", "true");
                    try {
                        UIManager.setLookAndFeel("com.incors.plaf.alloy.AlloyLookAndFeel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                        // empty catch block
                    }
                    LookAndFeelFactory.installJideExtension(1);
                    CommandBarFactory.updateComponentTreeUI(container);
                }
            });
            jideMenu.add(jMenuItem);
        }
        if (LookAndFeelFactory.isA03LnfInstalled()) {
            jMenuItem = new JMenuItem(resourceBundle.getString("Menu.a03Xerto"));
            jMenuItem.setMnemonic(resourceBundle.getString("Menu.a03Xerto.mnemonic").charAt(0));
            jMenuItem.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 6326560496018798344L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    System.setProperty("shadingtheme", "true");
                    try {
                        UIManager.setLookAndFeel("a03.swing.plaf.A03LookAndFeel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                        // empty catch block
                    }
                    LookAndFeelFactory.installJideExtension(4);
                    CommandBarFactory.updateComponentTreeUI(container);
                }
            });
            jideMenu.add(jMenuItem);
        }
        if (LookAndFeelFactory.isSyntheticaLnfInstalled()) {
            jideMenu.add(CommandBarFactory.createLAFMenu(resourceBundle.getString("Menu.synthetica"), container, SYNTHETICA_LAFS));
        }
        if (LookAndFeelFactory.isPlastic3DLnfInstalled() || LookAndFeelFactory.isPlasticXPLnfInstalled() || LookAndFeelFactory.isAlloyLnfInstalled() || LookAndFeelFactory.isA03LnfInstalled() || LookAndFeelFactory.isSyntheticaLnfInstalled()) {
            jideMenu.addSeparator();
        }
        jMenuItem = new JMenuItem(resourceBundle.getString("Menu.systemDefault"));
        jMenuItem.setMnemonic(resourceBundle.getString("Menu.systemDefault.mnemonic").charAt(0));
        jMenuItem.setToolTipText(resourceBundle.getString("Menu.systemDefault.toolTip"));
        jMenuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 7329857403026223556L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LookAndFeelFactory.installDefaultLookAndFeelAndExtension();
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        jideMenu.add(jMenuItem);
        return jideMenu;
    }

    public static CommandBar createLookAndFeelCommandBar(final Container container) {
        ResourceBundle resourceBundle = Resource.getResourceBundle(Locale.getDefault());
        CommandBar commandBar = new CommandBar(resourceBundle.getString("Menu.lookAndFeel"));
        commandBar.setInitSide(1);
        commandBar.setInitMode(2);
        commandBar.setInitIndex(2);
        JButton jButton = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.windowsVsnet.abbr")));
        jButton.setMnemonic(resourceBundle.getString("Menu.windowsVsnet.mnemonic").charAt(0));
        jButton.setToolTipText(resourceBundle.getString("Menu.windowsVsnet"));
        jButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 3201541150821346747L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.setProperty("shadingtheme", "false");
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(1);
                UIManager.getLookAndFeelDefaults().put("JideTabbedPane.defaultTabShape", (Object)2);
                UIManager.getLookAndFeelDefaults().put("JideTabbedPane.defaultTabColorTheme", (Object)3);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        jButton.setEnabled(SystemInfo.isWindows());
        jButton = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.windowsVsnetGradient.abbr")));
        jButton.setMnemonic(resourceBundle.getString("Menu.windowsVsnetGradient.abbr.mnemonic").charAt(0));
        jButton.setToolTipText(resourceBundle.getString("Menu.windowsVsnetGradient"));
        jButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 8646024555450082333L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.setProperty("shadingtheme", "true");
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(1);
                UIManager.getLookAndFeelDefaults().put("JideTabbedPane.defaultTabShape", (Object)1);
                UIManager.getLookAndFeelDefaults().put("JideTabbedPane.defaultTabColorTheme", (Object)4);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        jButton.setEnabled(SystemInfo.isWindows());
        jButton = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.windowsVsnetClassic.abbr")));
        jButton.setMnemonic(resourceBundle.getString("Menu.windowsVsnetClassic.mnemonic").charAt(0));
        jButton.setToolTipText(resourceBundle.getString("Menu.windowsVsnetClassic"));
        jButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 3201541150821346747L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.setProperty("shadingtheme", "false");
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(1);
                UIManager.getLookAndFeelDefaults().put("JideTabbedPane.defaultTabShape", (Object)1);
                UIManager.getLookAndFeelDefaults().put("JideTabbedPane.defaultTabColorTheme", (Object)1);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        jButton.setEnabled(SystemInfo.isWindows());
        jButton = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.windowsOffice2003.abbr")));
        jButton.setMnemonic(resourceBundle.getString("Menu.windowsOffice2003.mnemonic").charAt(0));
        jButton.setToolTipText(resourceBundle.getString("Menu.windowsOffice2003"));
        jButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -1327530702444587931L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.setProperty("shadingtheme", "false");
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(3);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        jButton.setEnabled(SystemInfo.isWindows());
        JideSplitButton jideSplitButton = (JideSplitButton)commandBar.add(CommandBarFactory.createSplitButton(resourceBundle.getString("Menu.office2003Themes.abbr")));
        jideSplitButton.setMnemonic(resourceBundle.getString("Menu.office2003Themes.mnemonic").charAt(0));
        jideSplitButton.setToolTipText(resourceBundle.getString("Menu.office2003Themes"));
        jideSplitButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -8255668487163004250L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = ((Office2003Painter)Office2003Painter.getInstance()).getColorName();
                if (string == null || string.trim().length() == 0) {
                    string = "Default";
                }
                Collection<Office2003Theme> collection = ((Office2003Painter)Office2003Painter.getInstance()).getAvailableThemes();
                String string2 = null;
                Iterator<Office2003Theme> iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Office2003Theme office2003Theme = iterator.next();
                    if (string2 == null) {
                        string2 = office2003Theme.getThemeName();
                    }
                    if (!office2003Theme.getThemeName().equals(string)) continue;
                    if (iterator.hasNext()) {
                        Office2003Theme office2003Theme2 = iterator.next();
                        ((Office2003Painter)Office2003Painter.getInstance()).setColorName(office2003Theme2.getThemeName());
                        CommandBarFactory.updateComponentTreeUI(container);
                        continue;
                    }
                    ((Office2003Painter)Office2003Painter.getInstance()).setColorName(string2);
                    CommandBarFactory.updateComponentTreeUI(container);
                }
            }
        });
        Collection<Office2003Theme> collection = ((Office2003Painter)Office2003Painter.getInstance()).getAvailableThemes();
        for (Office2003Theme componentArray : collection) {
            JMenuItem jMenuItem = new JMenuItem(componentArray.getThemeName());
            jMenuItem.addActionListener(new AbstractAction(componentArray.getThemeName()){
                private static final long serialVersionUID = -3081613616829830963L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((Office2003Painter)Office2003Painter.getInstance()).setColorName((String)this.getValue("Name"));
                    CommandBarFactory.updateComponentTreeUI(container);
                }
            });
            jideSplitButton.add(jMenuItem);
        }
        jideSplitButton.setEnabled(SystemInfo.isWindows());
        jButton = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.windowsOffice2007.abbr")));
        jButton.setMnemonic(resourceBundle.getString("Menu.windowsOffice2007.mnemonic").charAt(0));
        jButton.setToolTipText(resourceBundle.getString("Menu.windowsOffice2007"));
        jButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 2947691667876664962L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.setProperty("shadingtheme", "false");
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(7);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        jButton.setEnabled(SystemInfo.isWindowsVistaAbove());
        commandBar.addSeparator();
        jButton = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.windowsEclipse.abbr")));
        jButton.setMnemonic(resourceBundle.getString("Menu.windowsEclipse.mnemonic").charAt(0));
        jButton.setToolTipText(resourceBundle.getString("Menu.windowsEclipse"));
        jButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -2312049199057067200L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.setProperty("shadingtheme", "false");
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(2);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        jButton.setEnabled(SystemInfo.isWindows());
        jButton = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.windowsEclipse3x.abbr")));
        jButton.setMnemonic(resourceBundle.getString("Menu.windowsEclipse3x.mnemonic").charAt(0));
        jButton.setToolTipText(resourceBundle.getString("Menu.windowsEclipse3x"));
        jButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1934151950524403252L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.setProperty("shadingtheme", "false");
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(5);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        jButton.setEnabled(SystemInfo.isWindows());
        commandBar.addSeparator();
        jButton = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.xerto.abbr")));
        jButton.setMnemonic(resourceBundle.getString("Menu.xerto.mnemonic").charAt(0));
        jButton.setToolTipText(resourceBundle.getString("Menu.xerto"));
        jButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 8377070200610409569L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (!SystemInfo.isWindows()) {
                        UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                    } else {
                        UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(4);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        commandBar.addSeparator();
        jButton = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.metalVsnet.abbr")));
        jButton.setMnemonic(resourceBundle.getString("Menu.metalVsnet.mnemonic").charAt(0));
        jButton.setToolTipText(resourceBundle.getString("Menu.metalVsnet"));
        jButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 135917786379131644L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    UIManager.setLookAndFeel(MetalLookAndFeel.class.getName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(1);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        commandBar.addSeparator();
        jButton = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.aqua.abbr")));
        jButton.setMnemonic(resourceBundle.getString("Menu.aqua.mnemonic").charAt(0));
        jButton.setToolTipText(resourceBundle.getString("Menu.aqua"));
        jButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -3414435917876447440L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    UIManager.setLookAndFeel("apple.laf.AquaLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                LookAndFeelFactory.installJideExtension(1);
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        jButton.setEnabled(SystemInfo.isMacOSX());
        if (LookAndFeelFactory.isPlastic3DLnfInstalled() || LookAndFeelFactory.isPlasticXPLnfInstalled() || LookAndFeelFactory.isAlloyLnfInstalled() || LookAndFeelFactory.isA03LnfInstalled() || LookAndFeelFactory.isSyntheticaLnfInstalled()) {
            commandBar.addSeparator();
        }
        if (LookAndFeelFactory.isPlastic3DLnfInstalled()) {
            jButton = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.plastic3DVsnet.abbr")));
            jButton.setMnemonic(resourceBundle.getString("Menu.plastic3DVsnet.mnemonic").charAt(0));
            jButton.setToolTipText(resourceBundle.getString("Menu.plastic3DVsnet"));
            jButton.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = -8944151945641690341L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    System.setProperty("shadingtheme", "true");
                    try {
                        UIManager.setLookAndFeel("com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                        // empty catch block
                    }
                    LookAndFeelFactory.installJideExtension(1);
                    CommandBarFactory.updateComponentTreeUI(container);
                }
            });
        }
        if (LookAndFeelFactory.isPlasticXPLnfInstalled()) {
            jButton = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.plasticXPVsnet.abbr")));
            jButton.setMnemonic(resourceBundle.getString("Menu.plasticXPVsnet.mnemonic").charAt(0));
            jButton.setToolTipText(resourceBundle.getString("Menu.plasticXPVsnet"));
            jButton.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = -5532844695635634405L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    System.setProperty("shadingtheme", "true");
                    try {
                        UIManager.setLookAndFeel("com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                        // empty catch block
                    }
                    LookAndFeelFactory.installJideExtension(1);
                    CommandBarFactory.updateComponentTreeUI(container);
                }
            });
        }
        if (LookAndFeelFactory.isBizlafLnfInstalled()) {
            jButton = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.bizlaf.abbr")));
            jButton.setMnemonic(resourceBundle.getString("Menu.bizlaf.mnemonic").charAt(0));
            jButton.setToolTipText(resourceBundle.getString("Menu.bizlaf"));
            jButton.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = -8161576554724617386L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    System.setProperty("shadingtheme", "true");
                    try {
                        UIManager.setLookAndFeel("de.centigrade.bizlaf.BizLookAndFeel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                        // empty catch block
                    }
                    LookAndFeelFactory.installJideExtension();
                    CommandBarFactory.updateComponentTreeUI(container);
                }
            });
        }
        if (LookAndFeelFactory.isAlloyLnfInstalled()) {
            jButton = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.alloyVsnet.abbr")));
            jButton.setMnemonic(resourceBundle.getString("Menu.alloyVsnet.mnemonic").charAt(0));
            jButton.setToolTipText(resourceBundle.getString("Menu.alloyVsnet"));
            jButton.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 5740971958571563440L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    System.setProperty("shadingtheme", "true");
                    try {
                        UIManager.setLookAndFeel("com.incors.plaf.alloy.AlloyLookAndFeel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                        // empty catch block
                    }
                    LookAndFeelFactory.installJideExtension(1);
                    CommandBarFactory.updateComponentTreeUI(container);
                }
            });
        }
        if (LookAndFeelFactory.isA03LnfInstalled()) {
            jButton = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.a03Xerto.abbr")));
            jButton.setMnemonic(resourceBundle.getString("Menu.a03Xerto.mnemonic").charAt(0));
            jButton.setToolTipText(resourceBundle.getString("Menu.a03Xerto"));
            jButton.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 4255442222043846798L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        UIManager.setLookAndFeel("a03.swing.plaf.A03LookAndFeel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                        // empty catch block
                    }
                    LookAndFeelFactory.installJideExtension(4);
                    CommandBarFactory.updateComponentTreeUI(container);
                }
            });
        }
        if (LookAndFeelFactory.isSyntheticaLnfInstalled()) {
            Component[] componentArray;
            jideSplitButton = (JideSplitButton)commandBar.add(CommandBarFactory.createSplitButton(resourceBundle.getString("Menu.synthetica.abbr")));
            jideSplitButton.setToolTipText(resourceBundle.getString("Menu.synthetica"));
            jideSplitButton.setAlwaysDropdown(true);
            JMenu jMenu = CommandBarFactory.createLAFMenu(resourceBundle.getString("Menu.synthetica.abbr"), container, SYNTHETICA_LAFS);
            for (Component component : componentArray = jMenu.getPopupMenu().getComponents()) {
                jideSplitButton.add(component);
            }
        }
        if (LookAndFeelFactory.isPlastic3DLnfInstalled() || LookAndFeelFactory.isPlasticXPLnfInstalled() || LookAndFeelFactory.isAlloyLnfInstalled() || LookAndFeelFactory.isA03LnfInstalled() || LookAndFeelFactory.isSyntheticaLnfInstalled()) {
            commandBar.addSeparator();
        }
        jButton = (JButton)commandBar.add(CommandBarFactory.createButton(resourceBundle.getString("Menu.systemDefault.abbr")));
        jButton.setMnemonic(resourceBundle.getString("Menu.systemDefault.mnemonic").charAt(0));
        jButton.setToolTipText(resourceBundle.getString("Menu.systemDefault.toolTip"));
        jButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -8161576554724617386L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LookAndFeelFactory.installDefaultLookAndFeelAndExtension();
                CommandBarFactory.updateComponentTreeUI(container);
            }
        });
        return commandBar;
    }

    public static CommandBar createDockingFrameworkCommandBar(final DockingManager dockingManager, final DocumentPane documentPane) {
        CommandBar commandBar = new CommandBar("Docking Framework");
        commandBar.setInitSide(1);
        commandBar.setInitMode(2);
        commandBar.setInitIndex(2);
        JButton jButton = (JButton)commandBar.add(CommandBarFactory.createButton("Top"));
        jButton.setToolTipText("Top tab placement");
        jButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 4135078754055558874L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (dockingManager != null) {
                    dockingManager.setTabbedPaneCustomizer(new DockingManager.TabbedPaneCustomizer(){

                        @Override
                        public void customize(JideTabbedPane jideTabbedPane) {
                            jideTabbedPane.setTabPlacement(1);
                            jideTabbedPane.setHideOneTab(false);
                        }
                    });
                    dockingManager.setShowTitleBar(false);
                    dockingManager.setEasyTabDock(true);
                }
                if (documentPane != null) {
                    documentPane.setTabbedPaneCustomizer(new DocumentPane.TabbedPaneCustomizer(){

                        @Override
                        public void customize(JideTabbedPane jideTabbedPane) {
                            jideTabbedPane.setTabPlacement(1);
                        }
                    });
                }
            }
        });
        jButton = (JButton)commandBar.add(CommandBarFactory.createButton("Bottom"));
        jButton.setToolTipText("Bottom tab placement");
        jButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 6847790109101126330L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (dockingManager != null) {
                    dockingManager.setTabbedPaneCustomizer(new DockingManager.TabbedPaneCustomizer(){

                        @Override
                        public void customize(JideTabbedPane jideTabbedPane) {
                            jideTabbedPane.setTabPlacement(3);
                            jideTabbedPane.setHideOneTab(false);
                        }
                    });
                    dockingManager.setShowTitleBar(true);
                    dockingManager.setEasyTabDock(true);
                }
                if (documentPane != null) {
                    documentPane.setTabbedPaneCustomizer(new DocumentPane.TabbedPaneCustomizer(){

                        @Override
                        public void customize(JideTabbedPane jideTabbedPane) {
                            jideTabbedPane.setTabPlacement(3);
                        }
                    });
                }
            }
        });
        jButton = (JButton)commandBar.add(CommandBarFactory.createButton("Left"));
        jButton.setToolTipText("Left tab placement");
        jButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -1104897090152965257L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (dockingManager != null) {
                    dockingManager.setTabbedPaneCustomizer(new DockingManager.TabbedPaneCustomizer(){

                        @Override
                        public void customize(JideTabbedPane jideTabbedPane) {
                            jideTabbedPane.setTabPlacement(2);
                            jideTabbedPane.setHideOneTab(false);
                        }
                    });
                    dockingManager.setShowTitleBar(true);
                    dockingManager.setEasyTabDock(true);
                }
                if (documentPane != null) {
                    documentPane.setTabbedPaneCustomizer(new DocumentPane.TabbedPaneCustomizer(){

                        @Override
                        public void customize(JideTabbedPane jideTabbedPane) {
                            jideTabbedPane.setTabPlacement(2);
                        }
                    });
                }
            }
        });
        jButton = (JButton)commandBar.add(CommandBarFactory.createButton("Right"));
        jButton.setToolTipText("Left tab placement");
        jButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -5748306323043845404L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (dockingManager != null) {
                    dockingManager.setTabbedPaneCustomizer(new DockingManager.TabbedPaneCustomizer(){

                        @Override
                        public void customize(JideTabbedPane jideTabbedPane) {
                            jideTabbedPane.setTabPlacement(4);
                            jideTabbedPane.setHideOneTab(false);
                        }
                    });
                    dockingManager.setShowTitleBar(true);
                    dockingManager.setEasyTabDock(true);
                }
                if (documentPane != null) {
                    documentPane.setTabbedPaneCustomizer(new DocumentPane.TabbedPaneCustomizer(){

                        @Override
                        public void customize(JideTabbedPane jideTabbedPane) {
                            jideTabbedPane.setTabPlacement(4);
                        }
                    });
                }
            }
        });
        if (documentPane != null) {
            jButton = (JButton)commandBar.add(CommandBarFactory.createButton("Top/Bottom"));
            jButton.setToolTipText("Docking Framework has top tab placement and DocumentPane has bottom tab placement.");
            jButton.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = -2469596780235715617L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (dockingManager != null) {
                        dockingManager.setTabbedPaneCustomizer(new DockingManager.TabbedPaneCustomizer(){

                            @Override
                            public void customize(JideTabbedPane jideTabbedPane) {
                                jideTabbedPane.setTabPlacement(1);
                                jideTabbedPane.setHideOneTab(false);
                            }
                        });
                        dockingManager.setShowTitleBar(false);
                        dockingManager.setEasyTabDock(true);
                    }
                    documentPane.setTabbedPaneCustomizer(new DocumentPane.TabbedPaneCustomizer(){

                        @Override
                        public void customize(JideTabbedPane jideTabbedPane) {
                            jideTabbedPane.setTabPlacement(3);
                        }
                    });
                }
            });
            jButton = (JButton)commandBar.add(CommandBarFactory.createButton("Bottom/Top"));
            jButton.setToolTipText("Docking Framework has bottom tab placement and DocumentPane has bottom top placement.");
            jButton.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 6013309586801799467L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (dockingManager != null) {
                        dockingManager.setTabbedPaneCustomizer(new DockingManager.TabbedPaneCustomizer(){

                            @Override
                            public void customize(JideTabbedPane jideTabbedPane) {
                                jideTabbedPane.setTabPlacement(3);
                                jideTabbedPane.setHideOneTab(false);
                            }
                        });
                        dockingManager.setShowTitleBar(true);
                        dockingManager.setEasyTabDock(true);
                    }
                    documentPane.setTabbedPaneCustomizer(new DocumentPane.TabbedPaneCustomizer(){

                        @Override
                        public void customize(JideTabbedPane jideTabbedPane) {
                            jideTabbedPane.setTabPlacement(1);
                        }
                    });
                }
            });
        }
        return commandBar;
    }

    static class LAFChangeAction
    extends AbstractAction {
        private String className;
        private Container container;
        private static final long serialVersionUID = -6659135494779426406L;

        public LAFChangeAction(Container container, String string) {
            this.container = container;
            this.className = string;
            this.putValue("Name", this.toString());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                SynthStyleFactory synthStyleFactory;
                if (!this.className.contains("Synthetica") && (synthStyleFactory = SynthLookAndFeel.getStyleFactory()) != null) {
                    Method method = synthStyleFactory.getClass().getMethod("prepareMetalLAFSwitch", new Class[0]);
                    method.invoke((Object)synthStyleFactory, new Object[0]);
                }
                UIManager.setLookAndFeel(this.className);
                CommandBarFactory.updateComponentTreeUI(this.container);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public String toString() {
            return this.className.substring(this.className.lastIndexOf(46) + 1);
        }
    }
}

