/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.comparator.ComparatorContext;
import com.jidesoft.comparator.ObjectComparatorManager;
import com.jidesoft.grid.CompoundTableModelEvent;
import com.jidesoft.grid.DefaultTableModelWrapper;
import com.jidesoft.grid.FilterableTableModel;
import com.jidesoft.grid.GridResource;
import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.SortEvent;
import com.jidesoft.grid.SortItemSupport;
import com.jidesoft.grid.SortListener;
import com.jidesoft.grid.SortableTreeTableModel;
import com.jidesoft.grid.TableModelWrapper;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableModelsWrapper;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SecurityUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;

public class SortableTableModel
extends DefaultTableModelWrapper
implements ISortableTableModel {
    protected SortItemSupport _sortItemSupport = new SortItemSupport();
    private boolean \u0d20 = true;
    private boolean[] \u0d22;
    private boolean \u0d1e = true;
    private ColumnComparatorContextProvider \u0d18;
    private transient Comparator[] \u0d23;
    private transient int[] \u0d1c = null;
    private transient List<ISortableTableModel.SortItem> \u0d1f = null;
    private boolean \u0d19 = false;
    private boolean \u0d21 = false;
    private boolean \u0d1a = true;
    private static final Logger \u0d1d = Logger.getLogger(SortableTableModel.class.getName());
    private static final long \u0d17 = -2403018550641649960L;
    private boolean \u0d1b = true;

    public SortableTableModel(TableModel tableModel) {
        super(tableModel);
        this.setCacheEnabled(true);
    }

    @Override
    public int getSortedRowAt(int n2) {
        return this.getVisualRowAt(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        int n2 = this.fireIndexChanging();
        this.\u092b = tableModelEvent instanceof CompoundTableModelEvent ? ((CompoundTableModelEvent)tableModelEvent).getOriginalEvent() : tableModelEvent;
        CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
        A a2 = null;
        boolean bl = this.isCacheEnabled();
        try {
            a2 = this.\u0105(compoundTableModelEvent, tableModelEvent);
        }
        finally {
            if (a2 != null && a2.\u0103) {
                this.setCacheEnabled(false);
            }
            try {
                CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
            }
            finally {
                this.setCacheEnabled(bl);
            }
            if (a2 != null && a2.\u0102) {
                this.fireSortEvent();
            }
            this.fireIndexChanged(n2);
            this.\u092b = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private A \u0105(CompoundTableModelEvent compoundTableModelEvent, TableModelEvent tableModelEvent) {
        TableModelEvent tableModelEvent2;
        int n2;
        A a2 = new A();
        if (this.isSortingPaused()) {
            boolean bl = false;
            if (tableModelEvent.getType() == 1) {
                this.\u0102(compoundTableModelEvent, tableModelEvent);
            } else if (tableModelEvent.getType() == 0) {
                if (this._indexes != null && this._model.getRowCount() != this._indexes.length) {
                    this.reallocateIndexes();
                    bl = true;
                }
                if ((tableModelEvent.getFirstRow() == -1 || tableModelEvent.getLastRow() == -1) && tableModelEvent.getColumn() == -1) {
                    compoundTableModelEvent.addEvent(new TableModelEvent(this, -1));
                    bl = true;
                } else if (tableModelEvent.getLastRow() == Integer.MAX_VALUE) {
                    if (tableModelEvent instanceof CompoundTableModelEvent && ((CompoundTableModelEvent)tableModelEvent).getEvents() != null && ((CompoundTableModelEvent)tableModelEvent).getEvents().length > 0) {
                        void var7_19;
                        TableModelEvent[] objectArray = ((CompoundTableModelEvent)tableModelEvent).getEvents();
                        n2 = objectArray.length;
                        boolean bl2 = false;
                        while (var7_19 < n2) {
                            tableModelEvent2 = objectArray[var7_19];
                            this.\u0105(compoundTableModelEvent, tableModelEvent2);
                            ++var7_19;
                        }
                    } else {
                        compoundTableModelEvent.addEvent(new TableModelEvent(this, 0, this.getRowCount() - 1));
                    }
                } else {
                    this.\u0101(compoundTableModelEvent, tableModelEvent);
                }
            } else if (tableModelEvent.getType() == -1) {
                this.\u0104(compoundTableModelEvent, tableModelEvent);
            }
            if (tableModelEvent.getType() != 0 || !bl) {
                return a2;
            }
        }
        List<ISortableTableModel.SortItem> list = this.getSortingColumns();
        if (tableModelEvent.getFirstRow() == -1 || tableModelEvent.getLastRow() == -1) {
            ArrayList<ISortableTableModel.SortItem> bl = new ArrayList<ISortableTableModel.SortItem>();
            for (ISortableTableModel.SortItem sortItem : list) {
                if (sortItem.getColumn() < this.getColumnCount()) continue;
                bl.add(sortItem);
            }
            for (ISortableTableModel.SortItem sortItem : bl) {
                list.remove(sortItem);
            }
        }
        if (list.size() == 0) {
            this.setIndexes(null);
            if (tableModelEvent.getFirstRow() == -1 || tableModelEvent.getLastRow() == -1) {
                this.\u0d22 = null;
            }
            if (tableModelEvent instanceof CompoundTableModelEvent && ((CompoundTableModelEvent)tableModelEvent).getEvents() != null && ((CompoundTableModelEvent)tableModelEvent).getEvents().length > 0) {
                void var7_23;
                TableModelEvent[] n4 = ((CompoundTableModelEvent)tableModelEvent).getEvents();
                n2 = n4.length;
                boolean bl = false;
                while (var7_23 < n2) {
                    tableModelEvent2 = n4[var7_23];
                    compoundTableModelEvent.addEvent(new TableModelEvent(this, tableModelEvent2.getFirstRow(), tableModelEvent2.getLastRow(), tableModelEvent2.getColumn(), tableModelEvent2.getType()));
                    ++var7_23;
                }
            } else {
                compoundTableModelEvent.addEvent(new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), tableModelEvent.getColumn(), tableModelEvent.getType()));
            }
            return a2;
        }
        if (!this.isOptimized()) {
            this.fireSortingEvent();
            if (this.isAutoResort()) {
                this.sort();
            } else if (this.isRowCountChanged()) {
                list.clear();
                this.reallocateIndexes();
            }
            if (tableModelEvent.getFirstRow() == -1 || tableModelEvent.getLastRow() == -1) {
                compoundTableModelEvent.addEvent(new TableModelEvent(this, -1));
                this.\u0d22 = null;
            } else {
                compoundTableModelEvent.addEvent(new TableModelEvent(this));
            }
            a2.\u0102 = true;
            return a2;
        }
        if (tableModelEvent.getFirstRow() == -1 || tableModelEvent.getLastRow() == -1 || tableModelEvent.getFirstRow() == 0 && tableModelEvent.getLastRow() == Integer.MAX_VALUE) {
            if (!(tableModelEvent instanceof CompoundTableModelEvent) || ((CompoundTableModelEvent)tableModelEvent).getEvents() == null || ((CompoundTableModelEvent)tableModelEvent).getEvents().length <= 0) {
                if (this.isAutoResort()) {
                    this.fireSortingEvent();
                    if (list.size() > 0) {
                        this.sort();
                    } else {
                        this.setIndexes(null);
                    }
                    a2.\u0102 = true;
                } else if (this.isRowCountChanged()) {
                    if (tableModelEvent.getFirstRow() == -1 || tableModelEvent.getLastRow() == -1) {
                        list.clear();
                    }
                    this.fireSortingEvent();
                    this.reallocateIndexes();
                    a2.\u0102 = true;
                }
                compoundTableModelEvent.addEvent(new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), tableModelEvent.getColumn(), tableModelEvent.getType()));
            } else {
                void var7_25;
                TableModelEvent[] bl = ((CompoundTableModelEvent)tableModelEvent).getEvents();
                n2 = bl.length;
                boolean bl3 = false;
                while (var7_25 < n2) {
                    tableModelEvent2 = bl[var7_25];
                    this.\u0105(compoundTableModelEvent, tableModelEvent2);
                    ++var7_25;
                }
            }
        } else if (tableModelEvent.getColumn() != -1 && tableModelEvent.getType() == 0) {
            if (this.isAutoResort() && this.isColumnSorted(tableModelEvent.getColumn())) {
                this.cacheComparators();
                if (!this.shouldOptimize(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow())) {
                    this.fireSortingEvent();
                    this.sort();
                    compoundTableModelEvent.addEvent(new TableModelEvent(this, 0, this.getRowCount() - 1));
                    a2.\u0102 = true;
                } else {
                    a2.\u0103 = this.\u0103(compoundTableModelEvent, tableModelEvent);
                }
            } else if (this.shouldOptimize(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow()) || !this.isAutoResort()) {
                a2.\u0103 = true;
                boolean bl = this.isCacheEnabled();
                this.setCacheEnabled(false);
                try {
                    for (n2 = tableModelEvent.getFirstRow(); n2 <= tableModelEvent.getLastRow(); ++n2) {
                        int n3 = this.getSortedRowAt(n2);
                        compoundTableModelEvent.addEvent(new TableModelEvent(this, n3, n3, tableModelEvent.getColumn()));
                    }
                }
                finally {
                    this.setCacheEnabled(bl);
                }
            } else {
                this.cacheComparators();
                this.fireSortingEvent();
                this.sort();
                compoundTableModelEvent.addEvent(new TableModelEvent(this, 0, this.getRowCount() - 1, tableModelEvent.getColumn()));
                a2.\u0102 = true;
            }
        } else if (tableModelEvent.getColumn() == -1 && tableModelEvent.getType() == 0) {
            if (this.isAutoResort()) {
                this.cacheComparators();
                if (!this.shouldOptimize(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow())) {
                    this.fireSortingEvent();
                    this.sort();
                    compoundTableModelEvent.addEvent(new TableModelEvent(this, 0, this.getRowCount() - 1));
                    a2.\u0102 = true;
                } else {
                    a2.\u0103 = this.\u0103(compoundTableModelEvent, tableModelEvent);
                }
            } else {
                a2.\u0103 = true;
                boolean bl = this.isCacheEnabled();
                this.setCacheEnabled(false);
                try {
                    for (n2 = tableModelEvent.getFirstRow(); n2 <= tableModelEvent.getLastRow(); ++n2) {
                        int n4 = this.getSortedRowAt(n2);
                        compoundTableModelEvent.addEvent(new TableModelEvent(this, n4, n4, -1, 0));
                    }
                }
                finally {
                    this.setCacheEnabled(bl);
                }
            }
        } else if (tableModelEvent.getColumn() == -1 && tableModelEvent.getType() == 1) {
            if (this.isAutoResort()) {
                this.cacheComparators();
                if (!this.shouldOptimize(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow())) {
                    compoundTableModelEvent.addEvent(new TableModelEvent(this, 0, this.getRowCount() - 1, -1, -1));
                    this.fireSortingEvent();
                    this.sort();
                    compoundTableModelEvent.addEvent(new TableModelEvent(this, 0, this.getRowCount() - 1, -1, 1));
                    a2.\u0102 = true;
                } else if (this._indexes == null) {
                    if (this.getSortingColumns().size() != 0) {
                        this.reallocateIndexes();
                    }
                    compoundTableModelEvent.addEvent(new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), -1, 1));
                } else {
                    int n5 = tableModelEvent.getLastRow() - tableModelEvent.getFirstRow() + 1;
                    for (n2 = 0; n2 < this._indexes.length; ++n2) {
                        int n6 = this._indexes[n2];
                        if (n6 < tableModelEvent.getFirstRow()) continue;
                        this._indexes[n2] = n6 + n5;
                    }
                    for (n2 = tableModelEvent.getFirstRow(); n2 <= tableModelEvent.getLastRow(); ++n2) {
                        int n7 = this.insert(n2);
                        compoundTableModelEvent.addEvent(new TableModelEvent(this, n7, n7, -1, 1));
                    }
                }
            } else {
                int[] nArray = this.append(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                if (nArray != null && nArray.length >= 2) {
                    compoundTableModelEvent.addEvent(new TableModelEvent(this, nArray[0], nArray[1], -1, 1));
                }
            }
        } else if (tableModelEvent.getColumn() == -1 && tableModelEvent.getType() == -1) {
            if (this.isAutoResort() && !this.shouldOptimize(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow())) {
                this.fireSortingEvent();
                compoundTableModelEvent.addEvent(new TableModelEvent(this, 0, this.getRowCount(), -1, -1));
                this.sort();
                compoundTableModelEvent.addEvent(new TableModelEvent(this, 0, this.getRowCount(), -1, 1));
                a2.\u0102 = true;
            } else {
                a2.\u0103 = true;
                boolean bl = this.isCacheEnabled();
                this.setCacheEnabled(false);
                try {
                    void var7_31;
                    int n8 = n2 = tableModelEvent.getFirstRow();
                    while (var7_31 <= tableModelEvent.getLastRow()) {
                        int n9 = this.getSortedRowAt(n2);
                        if (n9 != -1) {
                            this.\u0123(n2);
                            compoundTableModelEvent.addEvent(new TableModelEvent(this, n9, n9, -1, -1));
                        }
                        ++var7_31;
                    }
                }
                finally {
                    this.setCacheEnabled(bl);
                }
            }
        } else if (this.isAutoResort()) {
            this.resort();
        } else {
            compoundTableModelEvent.addEvent(new TableModelEvent(this, 0, this.getRowCount()));
        }
        return a2;
    }

    private void \u0102(CompoundTableModelEvent compoundTableModelEvent, TableModelEvent tableModelEvent) {
        int[] nArray = this.getIndexes();
        int n2 = tableModelEvent.getFirstRow();
        if (this._indexes != null) {
            n2 = FilterableTableModel.getNearestRow(nArray, tableModelEvent.getFirstRow(), true);
            this._indexes = FilterableTableModel.insertIndexes(nArray, this._model.getRowCount(), tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), true);
        }
        compoundTableModelEvent.addEvent(new TableModelEvent(this, n2, n2 + tableModelEvent.getLastRow() - tableModelEvent.getFirstRow(), -1, 1));
    }

    /*
     * WARNING - void declaration
     */
    private void \u0104(CompoundTableModelEvent compoundTableModelEvent, TableModelEvent tableModelEvent) {
        int n2 = tableModelEvent.getFirstRow();
        int n3 = tableModelEvent.getLastRow();
        int n4 = n3 - n2 + 1;
        if (this._indexes == null) {
            compoundTableModelEvent.addEvent(new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), -1, -1));
        } else {
            int n5;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n5 = tableModelEvent.getFirstRow(); n5 <= tableModelEvent.getLastRow(); ++n5) {
                arrayList.add(this.getVisualRowAt(n5));
            }
            n5 = Integer.MAX_VALUE;
            for (Integer n6 : arrayList) {
                if (n6 >= n5) continue;
                n5 = n6;
            }
            boolean bl = true;
            int n7 = n5 + tableModelEvent.getLastRow() - tableModelEvent.getFirstRow();
            if (n5 < 0) {
                bl = false;
            } else {
                for (Integer object : arrayList) {
                    if (object >= n5 && object <= n7) continue;
                    bl = false;
                    break;
                }
            }
            if (bl) {
                void var11_16;
                Object object = new int[this._indexes.length - n4];
                if (n5 > 0) {
                    System.arraycopy(this._indexes, 0, object, 0, n5);
                }
                if (n5 < ((Object)object).length) {
                    System.arraycopy(this._indexes, n7 + 1, object, n5, ((Object)object).length - n5);
                }
                boolean i2 = false;
                while (var11_16 < ((Object)object).length) {
                    if (object[var11_16] > n3) {
                        Object object2 = object;
                        void v1 = var11_16;
                        object2[v1] = object2[v1] - n4;
                    }
                    ++var11_16;
                }
                this.setIndexes((int[])object);
                compoundTableModelEvent.addEvent(new TableModelEvent(this, n5, n7, -1, -1));
            } else {
                int n9 = 0;
                int[] nArray = new int[this._indexes.length - n4];
                for (int i2 = 0; i2 < this._indexes.length; ++i2) {
                    if (this._indexes[i2] < n2) {
                        nArray[i2 - n9] = this._indexes[i2];
                        continue;
                    }
                    if (this._indexes[i2] > n3) {
                        nArray[i2 - n9] = this._indexes[i2] - n4;
                        continue;
                    }
                    compoundTableModelEvent.addEvent(new TableModelEvent(this, i2, i2, -1, -1));
                    ++n9;
                }
                this.setIndexes(nArray);
            }
        }
    }

    private void \u0101(CompoundTableModelEvent compoundTableModelEvent, TableModelEvent tableModelEvent) {
        int n2 = this.getRowCount();
        for (int i2 = tableModelEvent.getFirstRow(); i2 <= tableModelEvent.getLastRow(); ++i2) {
            int n3 = TableModelWrapperUtils.getRowAt(this, this._model, tableModelEvent.getFirstRow());
            if (n3 < 0 || n3 >= n2) continue;
            compoundTableModelEvent.addEvent(new TableModelEvent(this, n3, n3, tableModelEvent.getColumn(), 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean \u0103(CompoundTableModelEvent compoundTableModelEvent, TableModelEvent tableModelEvent) {
        int n2;
        int n3;
        boolean bl = false;
        for (n3 = tableModelEvent.getFirstRow(); n3 <= tableModelEvent.getLastRow(); ++n3) {
            int n4;
            n2 = this.getSortedRowAt(n3);
            if (n2 == -1 || !this.isInSortRanges(n2)) continue;
            if (n2 < this.getRowCount() - 1 && this.isInSortRanges(n2 + 1) && (n4 = this.compare(n3, this.getActualRowAt(n2 + 1))) > 0) {
                bl = true;
                break;
            }
            if (n2 <= 0 || !this.isInSortRanges(n2 - 1) || (n4 = this.compare(this.getActualRowAt(n2 - 1), n3)) <= 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            for (n3 = tableModelEvent.getFirstRow(); n3 <= tableModelEvent.getLastRow(); ++n3) {
                n2 = this.getSortedRowAt(n3);
                if (n2 == -1) continue;
                compoundTableModelEvent.addEvent(new TableModelEvent(this, n2, n2, tableModelEvent.getColumn(), tableModelEvent.getType()));
            }
        } else {
            n3 = this.isCacheEnabled() ? 1 : 0;
            this.setCacheEnabled(false);
            try {
                for (n2 = tableModelEvent.getFirstRow(); n2 <= tableModelEvent.getLastRow(); ++n2) {
                    this.\u010a(compoundTableModelEvent, n2, tableModelEvent.getColumn());
                }
            }
            finally {
                this.setCacheEnabled(n3 != 0);
            }
        }
        return bl;
    }

    protected boolean shouldOptimize(int n2, int n3) {
        int n4 = n3 - n2;
        return n4 == 1;
    }

    protected boolean isInSortRanges(int n2) {
        int[] nArray = this.getSortRanges();
        if (nArray.length % 2 == 1) {
            throw new IllegalArgumentException("The sort range array must have even length");
        }
        for (int i2 = 0; i2 < nArray.length; i2 += 2) {
            int n3 = nArray[i2];
            int n4 = nArray[i2 + 1];
            if (n2 < n3 || n2 >= n4) continue;
            return true;
        }
        return false;
    }

    private void \u010a(CompoundTableModelEvent compoundTableModelEvent, int n2, int n3) {
        int n4;
        int n5 = this.getSortedRowAt(n2);
        if (n5 == -1) {
            return;
        }
        if (!this.isInSortRanges(n5)) {
            compoundTableModelEvent.addEvent(new TableModelEvent(this, n5, n5, -1, 0));
            return;
        }
        boolean bl = false;
        if (n5 < this.getRowCount() - 1 && this.isInSortRanges(n5 + 1) && (n4 = this.compare(n2, this.getActualRowAt(n5 + 1))) > 0) {
            bl = true;
        }
        if (n5 > 0 && this.isInSortRanges(n5 - 1) && (n4 = this.compare(this.getActualRowAt(n5 - 1), n2)) > 0) {
            bl = true;
        }
        if (bl) {
            this.\u0123(n2);
            compoundTableModelEvent.addEvent(new TableModelEvent(this, n5, n5, -1, -1));
            if (this._indexes != null) {
                for (n4 = 0; n4 < this._indexes.length; ++n4) {
                    int n6 = this._indexes[n4];
                    if (n6 < n2) continue;
                    this._indexes[n4] = n6 + 1;
                }
                n5 = this.insert(n2);
            } else {
                n5 = n2;
            }
            compoundTableModelEvent.addEvent(new TableModelEvent(this, n5, n5, -1, 1));
        } else if (n3 != -1) {
            compoundTableModelEvent.addEvent(new TableModelEvent(this, n5, n5, n3));
        } else {
            compoundTableModelEvent.addEvent(new TableModelEvent(this, n5, n5, -1, 0));
        }
    }

    protected void sort() {
        this.reallocateIndexes();
        if (this._indexes != null) {
            this.cacheComparators();
            int[] nArray = this.getSortRanges();
            if (nArray.length % 2 == 1) {
                throw new IllegalArgumentException("The sort range array must have even length");
            }
            for (int i2 = 0; i2 < nArray.length; i2 += 2) {
                int n2 = nArray[i2];
                int n3 = nArray[i2 + 1];
                this.sort((int[])this._indexes.clone(), this._indexes, n2, n3);
            }
        }
    }

    protected int[] getSortRanges() {
        int[] nArray;
        if (this._indexes == null) {
            nArray = new int[]{};
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = this._indexes.length;
        }
        return nArray;
    }

    private void \u0123(int n2) {
        if (this._indexes == null) {
            return;
        }
        int n3 = this.getSortedRowAt(n2);
        int[] nArray = (int[])this._indexes.clone();
        this._indexes = new int[nArray.length - 1];
        System.arraycopy(nArray, 0, this._indexes, 0, n3);
        System.arraycopy(nArray, n3 + 1, this._indexes, n3, this._indexes.length - n3);
        for (int i2 = 0; i2 < this._indexes.length; ++i2) {
            int n4 = this._indexes[i2];
            if (n4 <= n2) continue;
            this._indexes[i2] = n4 - 1;
        }
    }

    protected int insert(int n2) {
        int n3 = this.search(this._indexes, n2);
        int[] nArray = (int[])this._indexes.clone();
        this._indexes = new int[nArray.length + 1];
        System.arraycopy(nArray, 0, this._indexes, 0, n3);
        this._indexes[n3] = n2;
        System.arraycopy(nArray, n3, this._indexes, n3 + 1, this._indexes.length - n3 - 1);
        return n3;
    }

    protected int[] append(int n2, int n3) {
        if (this._indexes == null) {
            return new int[]{n2, n3};
        }
        int n4 = n3 - n2 + 1;
        for (int i2 = 0; i2 < this._indexes.length; ++i2) {
            int n5 = this._indexes[i2];
            if (n5 < n2) continue;
            this._indexes[i2] = n5 + n4;
        }
        int[] nArray = new int[2];
        int[] nArray2 = (int[])this._indexes.clone();
        this._indexes = new int[nArray2.length + n4];
        if ("true".equals(SecurityUtils.getProperty("jide.sortableTableModel.append", "true"))) {
            System.arraycopy(nArray2, 0, this._indexes, 0, nArray2.length);
            for (int i3 = 0; i3 < n4; ++i3) {
                this._indexes[nArray2.length + i3] = n2 + i3;
            }
            nArray[0] = nArray2.length;
            nArray[1] = nArray2.length + n4 - 1;
        } else {
            for (int i4 = 0; i4 < n4; ++i4) {
                this._indexes[i4] = n2 + i4;
            }
            System.arraycopy(nArray2, 0, this._indexes, n4, nArray2.length);
            nArray[0] = 0;
            nArray[1] = n4 - 1;
        }
        return nArray;
    }

    protected int search(int[] nArray, int n2) {
        return this.\u0102(nArray, n2);
    }

    private int \u0102(int[] nArray, int n2) {
        int n3;
        int[] nArray2 = this.getSortRanges();
        if (nArray2.length % 2 == 1) {
            throw new IllegalArgumentException("The sort range array must have even length");
        }
        int n4 = nArray2[0];
        int n5 = n3 = nArray2[1] - 1;
        boolean bl = false;
        while (n4 <= n3) {
            int n6 = n4 + n3 >> 1;
            int n7 = this.compare(nArray[n6], n2);
            if (n7 < 0) {
                n4 = n6 + 1;
                continue;
            }
            if (n7 > 0) {
                n3 = n6 - 1;
                continue;
            }
            n5 = n6;
            bl = true;
            break;
        }
        if (!bl) {
            n5 = n4;
        }
        return n5;
    }

    protected void sort(int[] nArray, int[] nArray2, int n2, int n3) {
        this.\u0103(nArray, nArray2, n2, n3);
    }

    protected void cacheComparators() {
        this.\u0d1c = this.getMasterSortColumns();
        this.\u0d1f = this.getSortingColumns();
        this.\u0d23 = new Comparator[this.getColumnCount()];
        for (ISortableTableModel.SortItem sortItem : this.getSortingColumns()) {
            int n2 = sortItem.getColumn();
            if (n2 < 0 || n2 >= this.getColumnCount()) continue;
            Comparator comparator = this.getComparator(n2);
            if (comparator == null) {
                this.\u0d23[n2] = ObjectComparatorManager.getComparator(String.class);
                continue;
            }
            this.\u0d23[n2] = comparator;
        }
    }

    @Override
    public int[] getMasterSortColumns() {
        return this._sortItemSupport.getMasterSortColumns();
    }

    @Override
    public void setMasterSortColumns(int[] nArray) {
        this._sortItemSupport.setMasterSortColumns(nArray);
    }

    public int getMasterSortColumnIndex(int n2) {
        return this.\u0101(n2, this.getMasterSortColumns());
    }

    private int \u0101(int n2, int[] nArray) {
        if (nArray != null) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                int n3 = nArray[i2];
                if (n3 != n2) continue;
                return i2;
            }
        }
        return -1;
    }

    protected int compare(int n2, int n3) {
        if (this.\u0d1f != null) {
            for (ISortableTableModel.SortItem sortItem : this.\u0d1f) {
                int n4;
                int n5 = sortItem.getColumn();
                if (this.\u0d1c != null) {
                    n4 = this.\u0101(n5, this.\u0d1c);
                    for (int i2 = 0; i2 < this.\u0d1c.length && i2 != n4; ++i2) {
                        int n6 = this.\u0d1c[i2];
                        int n7 = this.compare(n2, n3, n6);
                        if (n7 == 0) continue;
                        return n2 > n3 ? 1 : -1;
                    }
                }
                if ((n4 = this.compare(n2, n3, n5)) == 0) continue;
                if (n4 == Integer.MAX_VALUE || n4 == Integer.MIN_VALUE) {
                    return n4;
                }
                return sortItem.isAscending() ? n4 : -n4;
            }
        }
        return 0;
    }

    private void \u0103(int[] nArray, int[] nArray2, int n2, int n3) {
        if (n3 - n2 < 2) {
            return;
        }
        int n4 = (n2 + n3) / 2;
        this.\u0103(nArray2, nArray, n2, n4);
        this.\u0103(nArray2, nArray, n4, n3);
        int n5 = n2;
        int n6 = n4;
        if (n3 - n2 >= 4 && this.compare(nArray[n4 - 1], nArray[n4]) <= 0) {
            System.arraycopy(nArray, n2, nArray2, n2, n3 - n2);
            return;
        }
        for (int i2 = n2; i2 < n3; ++i2) {
            if (n6 >= n3 || n5 < n4 && this.compare(nArray[n5], nArray[n6]) <= 0) {
                nArray2[i2] = nArray[n5];
                ++n5;
                continue;
            }
            nArray2[i2] = nArray[n6];
            ++n6;
        }
    }

    public int compare(int n2, int n3, int n4) {
        Object object = this._model.getValueAt(n2, n4);
        Object object2 = this._model.getValueAt(n3, n4);
        return this.compare(object, object2, n4);
    }

    protected int compare(Object object, Object object2, int n2) {
        try {
            if (this.isAlwaysUseComparators() && this.\u0d23 != null && n2 < this.\u0d23.length && this.\u0d23[n2] != null) {
                return this.\u0d23[n2].compare(object, object2);
            }
            if (object == null && object2 == null) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (object instanceof String && object2 instanceof String) {
                return ((String)object).compareToIgnoreCase((String)object2);
            }
            if (object instanceof Comparable && object2 instanceof Comparable && object.getClass().isAssignableFrom(object2.getClass())) {
                return ((Comparable)object).compareTo(object2);
            }
            if (object instanceof Comparable && object2 instanceof Comparable && object2.getClass().isAssignableFrom(object.getClass())) {
                return -((Comparable)object2).compareTo(object);
            }
            if (this.\u0d23 != null && n2 < this.\u0d23.length && this.\u0d23[n2] != null) {
                return this.\u0d23[n2].compare(object, object2);
            }
            if (\u0d1d.isLoggable(Level.FINE)) {
                \u0d1d.fine("SortableTableModel \" no way to compare between " + object + " and " + object2 + " at column " + n2 + ".");
            }
            return 0;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected Comparator getComparator(int n2) {
        return ObjectComparatorManager.getComparator(this.getColumnClass(n2), this.getColumnComparatorContext(n2));
    }

    public ComparatorContext getColumnComparatorContext(int n2) {
        ColumnComparatorContextProvider columnComparatorContextProvider = this.getColumnComparatorContextProvider();
        if (columnComparatorContextProvider == null) {
            return null;
        }
        return columnComparatorContextProvider.getColumnComparatorContext(this, n2);
    }

    public boolean isResetOnTableStructureChangeEvent() {
        return this.\u0d1a;
    }

    public void setResetOnTableStructureChangeEvent(boolean bl) {
        this.\u0d1a = bl;
    }

    @Override
    public void fireTableStructureChanged() {
        if (this.isResetOnTableStructureChangeEvent()) {
            this._sortItemSupport.reset();
        }
        super.fireTableStructureChanged();
    }

    @Override
    public void fireTableChanged(TableModelEvent tableModelEvent) {
        if (this.isResetOnTableStructureChangeEvent() && (tableModelEvent == null || tableModelEvent.getFirstRow() == -1 && tableModelEvent.getColumn() == -1 && tableModelEvent.getType() == 0)) {
            this._sortItemSupport.reset();
        }
        super.fireTableChanged(tableModelEvent);
    }

    public ColumnComparatorContextProvider getColumnComparatorContextProvider() {
        return this.\u0d18;
    }

    public void setColumnComparatorContextProvider(ColumnComparatorContextProvider columnComparatorContextProvider) {
        this.\u0d18 = columnComparatorContextProvider;
        if (this.\u0d18 != null) {
            this.setAlwaysUseComparators(true);
        }
    }

    @Override
    public synchronized void setIndexes(int[] nArray) {
        this.getSortingColumns().clear();
        super.setIndexes(nArray);
    }

    public JMenuItem[] getPopupMenuItems(final int n2) {
        ResourceBundle resourceBundle = GridResource.getResourceBundle(Locale.getDefault());
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setAction(new AbstractAction(resourceBundle.getString("Sort.ascending")){
            private static final long \u0103 = 2530096572929787133L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!SortableTableModel.this.isColumnAscending(n2)) {
                    SortableTableModel.this.sortColumn(n2, true, true);
                }
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem();
        jMenuItem2.setAction(new AbstractAction(resourceBundle.getString("Sort.descending")){
            private static final long \u0103 = 2434345236380501634L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SortableTableModel.this.isColumnAscending(n2)) {
                    SortableTableModel.this.reverseColumnSortOrder(n2);
                } else if (!SortableTableModel.this.isColumnSorted(n2)) {
                    SortableTableModel.this.sortColumn(n2, true, true);
                    SortableTableModel.this.reverseColumnSortOrder(n2);
                }
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem();
        jMenuItem3.setAction(new AbstractAction(resourceBundle.getString("Sort.unsort")){
            private static final long \u0103 = 5959338348674285285L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SortableTableModel.this.unsortColumn(n2);
            }
        });
        return new JMenuItem[]{jMenuItem, jMenuItem2, jMenuItem3};
    }

    public static ISortableTableModel getSortableModel(TableModel tableModel) {
        while (true) {
            if (tableModel instanceof ISortableTableModel) {
                return (ISortableTableModel)tableModel;
            }
            if (tableModel instanceof TableModelWrapper) {
                tableModel = ((TableModelWrapper)((Object)tableModel)).getActualModel();
                continue;
            }
            if (!(tableModel instanceof TableModelsWrapper)) break;
            tableModel = ((TableModelsWrapper)((Object)tableModel)).getActualModel(0, 0);
        }
        return null;
    }

    public boolean isOptimized() {
        return this.\u0d1b;
    }

    public void setOptimized(boolean bl) {
        this.\u0d1b = bl;
    }

    public boolean isAutoResort() {
        return this.\u0d20;
    }

    public void setAutoResort(boolean bl) {
        this.\u0d20 = bl;
    }

    @Override
    public void sortColumn(int n2) {
        if (this._sortItemSupport.sortColumn(n2)) {
            this.resort();
        }
    }

    @Override
    public void sortColumn(int n2, boolean bl) {
        if (this._sortItemSupport.sortColumn(n2, bl)) {
            this.resort();
        }
    }

    @Override
    public void unsortColumn(int n2) {
        if (this._sortItemSupport.unsortColumn(n2)) {
            this.resort();
        }
    }

    @Override
    public void reverseColumnSortOrder(int n2) {
        if (this._sortItemSupport.reverseColumnSortOrder(n2)) {
            this.resort();
        }
    }

    @Override
    public void sortColumn(int n2, boolean bl, boolean bl2) {
        if (this._sortItemSupport.sortColumn(n2, bl, bl2)) {
            this.resort();
        }
    }

    @Override
    public boolean isColumnSorted(int n2) {
        return this._sortItemSupport.isColumnSorted(n2);
    }

    @Override
    public boolean isColumnAscending(int n2) {
        return this._sortItemSupport.isColumnAscending(n2);
    }

    @Override
    public void reset() {
        if (this._sortItemSupport.reset()) {
            this.resort();
        }
    }

    @Override
    public List<ISortableTableModel.SortItem> getSortingColumns() {
        return this._sortItemSupport.getSortingColumns();
    }

    @Override
    public void setSortingColumns(List<ISortableTableModel.SortItem> list) {
        if ((list == null || list.size() == 0) && this.getSortingColumns().size() == 0) {
            return;
        }
        this._sortItemSupport.setSortingColumns(list);
        this.resort();
    }

    @Override
    public int getColumnSortRank(int n2) {
        return this._sortItemSupport.getColumnSortRank(n2);
    }

    @Override
    public boolean isMultiColumnSortable() {
        return this._sortItemSupport.isMultiColumnSortable();
    }

    @Override
    public void setMultiColumnSortable(boolean bl) {
        this._sortItemSupport.setMultiColumnSortable(bl);
    }

    @Override
    public boolean isColumnSortable(int n2) {
        if (this.getActualModel().getColumnCount() == 0) {
            return false;
        }
        if (!this.isSortable()) {
            return false;
        }
        if (n2 >= 0 && n2 < this.getActualModel().getColumnCount()) {
            this.\u01e6();
            return this.\u0d22[n2];
        }
        return false;
    }

    @Override
    public void setColumnSortable(int n2, boolean bl) {
        if (n2 >= 0 && n2 < this.getActualModel().getColumnCount()) {
            this.\u01e6();
            this.\u0d22[n2] = bl;
        }
    }

    private void \u01e6() {
        if (this.\u0d22 == null || this.\u0d22.length != this.getActualModel().getColumnCount()) {
            this.\u0d22 = new boolean[this.getActualModel().getColumnCount()];
            Arrays.fill(this.\u0d22, true);
        }
    }

    @Override
    public boolean isSortable() {
        return this.\u0d1e;
    }

    @Override
    public void setSortable(boolean bl) {
        this.\u0d1e = bl;
    }

    @Override
    public void resort() {
        this.fireSortingEvent();
        int n2 = this.fireIndexChanging();
        try {
            List<ISortableTableModel.SortItem> list = this.getSortingColumns();
            if (list != null && list.size() > 0) {
                this.sort();
            } else {
                this.setIndexes(null);
            }
            this.fireTableDataChanged();
        }
        finally {
            this.fireIndexChanged(n2);
        }
        this.fireSortEvent();
    }

    @Override
    public void addSortListener(SortListener sortListener) {
        if (!JideSwingUtilities.isListenerRegistered(this.listenerList, SortListener.class, (EventListener)sortListener)) {
            this.listenerList.add(SortListener.class, sortListener);
        }
    }

    @Override
    public void removeSortListener(SortListener sortListener) {
        this.listenerList.remove(SortListener.class, sortListener);
    }

    @Override
    public SortListener[] getSortListeners() {
        return (SortListener[])this.listenerList.getListeners(SortListener.class);
    }

    public void fireSortEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        SortEvent sortEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != SortListener.class) continue;
            if (sortEvent == null) {
                sortEvent = new SortEvent(this);
            }
            ((SortListener)objectArray[i2 + 1]).sortChanged(sortEvent);
        }
    }

    public void fireSortingEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        SortEvent sortEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != SortListener.class) continue;
            if (sortEvent == null) {
                sortEvent = new SortEvent(this);
            }
            ((SortListener)objectArray[i2 + 1]).sortChanging(sortEvent);
        }
    }

    @Override
    public int getSortPriority() {
        return this._sortItemSupport.getSortPriority();
    }

    @Override
    public void setSortPriority(int n2) {
        this._sortItemSupport.setSortPriority(n2);
    }

    @Override
    public int getMaximumSortColumns() {
        return this._sortItemSupport.getMaximumSortColumns();
    }

    @Override
    public void setMaximumSortColumns(int n2) {
        this._sortItemSupport.setMaximumSortColumns(n2);
    }

    public SortOrderHandler getSortOrderHandler() {
        if (this._sortItemSupport != null && this._sortItemSupport.getSortOrderHandler() instanceof SortOrderHandler) {
            return (SortOrderHandler)this._sortItemSupport.getSortOrderHandler();
        }
        return null;
    }

    public void setSortOrderHandler(SortOrderHandler sortOrderHandler) {
        if (this._sortItemSupport != null) {
            this._sortItemSupport.setSortOrderHandler(sortOrderHandler);
        }
    }

    @Override
    public void toggleSortOrder(int n2, boolean bl) {
        boolean bl2 = this.isSortingPaused();
        if (bl2) {
            this.setSortingPaused(false);
        }
        if (!this.isColumnSortable(n2)) {
            return;
        }
        if (this instanceof SortableTreeTableModel && ((SortableTreeTableModel)this).getSortableOption(n2) == 0) {
            return;
        }
        boolean bl3 = this.getSortingColumns().size() == 1 && this.getSortingColumns().get(0).getColumn() == n2;
        boolean bl4 = bl3 && this.getSortingColumns().get(0).isAscending();
        this._sortItemSupport.toggleSortOrder(n2, bl);
        if (this.shouldReverseIndices(n2, bl3, bl4)) {
            this.\u01e5();
        } else {
            this.resort();
        }
        if (bl2) {
            this.setSortingPaused(true);
        }
    }

    protected boolean shouldReverseIndices(int n2, boolean bl, boolean bl2) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void \u01e5() {
        if (this._indexes == null) {
            return;
        }
        this.fireSortingEvent();
        int n2 = this.fireIndexChanging();
        try {
            for (int i2 = this._indexes.length / 2 - 1; i2 >= 0; --i2) {
                int n3 = this._indexes[i2];
                this._indexes[i2] = this._indexes[this._indexes.length - 1 - i2];
                this._indexes[this._indexes.length - 1 - i2] = n3;
            }
            this.fireTableDataChanged();
        }
        finally {
            this.fireIndexChanged(n2);
        }
        this.fireSortEvent();
    }

    public boolean isAlwaysUseComparators() {
        return this.\u0d21;
    }

    public void setAlwaysUseComparators(boolean bl) {
        this.\u0d21 = bl;
    }

    public void setSortingPaused(boolean bl) {
        this.\u0d19 = bl;
    }

    public boolean isSortingPaused() {
        return this.\u0d19;
    }

    private class A {
        boolean \u0102;
        boolean \u0103;

        private A() {
        }
    }

    public static interface SortOrderHandler
    extends SortItemSupport.SortOrderHandler {
    }

    public static interface ColumnComparatorContextProvider {
        public ComparatorContext getColumnComparatorContext(SortableTableModel var1, int var2);
    }
}

