/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gantt;

import com.jidesoft.gantt.DefaultGanttEntryRenderer;
import com.jidesoft.gantt.GanttChartPane;
import com.jidesoft.gantt.GanttEntry;
import com.jidesoft.gantt.GanttEntryRelationEvent;
import com.jidesoft.gantt.GanttEntryRelationListener;
import com.jidesoft.gantt.GanttEntryRenderer;
import com.jidesoft.gantt.GanttLabelRenderer;
import com.jidesoft.gantt.GanttModel;
import com.jidesoft.gantt.GanttModelEvent;
import com.jidesoft.gantt.GanttModelListener;
import com.jidesoft.gantt.GanttResources;
import com.jidesoft.gantt.PeriodBackgroundPainter;
import com.jidesoft.gantt.SubEntryGanttEntry;
import com.jidesoft.grid.TreeTable;
import com.jidesoft.plaf.GanttChartUI;
import com.jidesoft.plaf.GanttEntryRelationPainter;
import com.jidesoft.plaf.GanttUIDefaultsCustomizer;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicGanttChartUI;
import com.jidesoft.range.Range;
import com.jidesoft.scale.ScaleArea;
import com.jidesoft.scale.ScaleModel;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.SizeSequence;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.JTableHeader;

public class GanttChart<T, S extends GanttEntry<T>>
extends JComponent
implements Scrollable,
GanttModelListener,
GanttEntryRelationListener,
ListSelectionListener,
PropertyChangeListener {
    private static final long \u0108 = -9094319801088118704L;
    private static final String \u0116 = "GanttChartUI";
    public static final String PROPERTY_SCALE_AREA = "scaleArea";
    public static final String PROPERTY_GANTT_MODEL = "ganttModel";
    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_VIEW_MODE = "viewMode";
    public static final String PROPERTY_ROW_HEIGHT = "rowHeight";
    public static final String PROPERTY_ROW_MARGIN = "rowMargin";
    public static final String PROPERTY_GRID_COLOR = "gridColor";
    public static final String PROPERTY_SHOW_GRID = "showGrid";
    public static final String PROPERTY_LABEL_POSITION = "labelPosition";
    public static final String PROPERTY_LABEL_ENTRY_GAP = "labelEntryGap";
    public static final int VIEW_MODE_EDITING = 0;
    public static final int VIEW_MODE_PANNING = 1;
    private static final int \u0103 = 2;
    private static final int \u0102 = 4;
    private final Map<Integer, GanttEntryRelationPainter> \u0105 = new HashMap<Integer, GanttEntryRelationPainter>();
    private final List<PeriodBackgroundPainter<T>> \u010f = new ArrayList<PeriodBackgroundPainter<T>>();
    private ScaleArea<T> \u0110;
    private GanttModel<T, S> \u0106;
    private SizeSequence \u011c;
    private ListSelectionModel \u0107;
    private Color \u0119;
    private Color \u011a;
    private int \u0118;
    private int \u011b;
    private boolean \u0104;
    private Color \u0115;
    private boolean \u0101;
    private Dimension \u0113;
    private boolean \u010c = true;
    private int \u0114;
    private GanttEntryRenderer \u0112 = new DefaultGanttEntryRenderer();
    private GanttLabelRenderer \u010a;
    private int \u010e = 11;
    private int \u011d = 8;
    private boolean \u010b = true;
    private boolean \u010d = true;
    private int \u0117 = 4;
    private static final Insets \u0111;
    private boolean \u0109;

    public GanttChart() {
        this(new ScaleArea());
    }

    public GanttChart(GanttModel<T, S> ganttModel) {
        this(ganttModel, new ScaleArea());
    }

    public GanttChart(ScaleArea<T> scaleArea) {
        this(null, scaleArea);
    }

    public GanttChart(GanttModel<T, S> ganttModel, ScaleArea<T> scaleArea) {
        this.setScaleArea(scaleArea);
        this.setModel(ganttModel);
        this.setRowHeight(16);
        this.setAutoscrolls(true);
        this.setSelectionModel(this.createDefaultSelectionModel());
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
        this.updateUI();
    }

    public void setScaleArea(ScaleArea<T> scaleArea) {
        Container container;
        ScaleArea<T> scaleArea2 = this.\u0110;
        if (scaleArea2 == scaleArea) {
            return;
        }
        if (this.\u0110 != null) {
            this.\u0110.removePropertyChangeListener(this);
        }
        this.\u0110 = scaleArea;
        if (this.\u0110 != null) {
            this.\u0110.removePropertyChangeListener(this);
            this.\u0110.addPropertyChangeListener(this);
        }
        if (this.\u0110 != null && this.\u0106 != null) {
            this.\u0110.setScaleModel(this.\u0106.getScaleModel());
        }
        this.\u0104();
        this.configureEnclosingScrollPane();
        for (container = this.getParent(); container != null && !(container instanceof GanttChartPane); container = container.getParent()) {
        }
        if (container != null && ((GanttChartPane)container).getTreeTable() != null) {
            JTableHeader jTableHeader = ((GanttChartPane)container).getTreeTable().getTableHeader();
            for (container = jTableHeader.getParent(); container != null && !(container instanceof JViewport); container = container.getParent()) {
            }
            if (container != null) {
                container.invalidate();
                container.repaint();
                container.doLayout();
            }
        }
        this.firePropertyChange(PROPERTY_SCALE_AREA, scaleArea2, this.\u0110);
        this.resizeAndRepaint();
    }

    public ScaleArea<T> getScaleArea() {
        return this.\u0110;
    }

    public GanttModel<T, S> getModel() {
        return this.\u0106;
    }

    public boolean isEditable() {
        return this.\u010c;
    }

    public void setEditable(boolean bl) {
        if (this.\u010c != bl) {
            this.\u010c = bl;
            this.firePropertyChange(PROPERTY_EDITABLE, !bl, bl);
        }
    }

    @Override
    public void ganttEntryRelationChanged(GanttEntryRelationEvent ganttEntryRelationEvent) {
        this.resizeAndRepaint();
    }

    @Override
    public void ganttChartChanged(GanttModelEvent ganttModelEvent) {
        if (ganttModelEvent.getFirstRow() == -2 || ganttModelEvent.getLastRow() == -2) {
            this.\u0103();
        }
        this.resizeAndRepaint();
    }

    private void \u0103() {
        if (this.\u0110 != null) {
            Rectangle rectangle;
            Range<T> range = this.\u0106.getRange();
            T t2 = this.\u0110.getStart();
            if (!t2.equals(range.lower())) {
                rectangle = this.\u0110.getVisibleRect();
                boolean bl = rectangle.contains(this.\u0110.getX(range.lower()), rectangle.y);
                this.\u0110.setStart(range.lower());
                if (bl) {
                    this.scrollSpanToVisible(range.lower(), range.upper());
                }
            }
            if (!((Object)(rectangle = this.\u0110.getEnd())).equals(range.upper())) {
                Rectangle rectangle2 = this.getVisibleRect();
                int n2 = this.\u0110.getX(range.upper());
                boolean bl = rectangle2.contains(n2, rectangle2.y);
                this.\u0110.setEnd(range.upper());
                if (bl) {
                    this.scrollRectToVisible(new Rectangle(n2, rectangle2.y, rectangle2.width, rectangle2.height));
                }
            }
        }
    }

    public void setModel(GanttModel<T, S> ganttModel) {
        GanttModel<T, S> ganttModel2 = this.\u0106;
        if (this.\u0106 != null) {
            this.\u0106.removeGanttModelListener(this);
            this.\u0106.getGanttEntryRelationModel().removeGanttEntryRelationListener(this);
        }
        this.\u0106 = ganttModel;
        if (this.\u0106 != null) {
            this.\u0106.addGanttModelListener(this);
            this.\u0106.getGanttEntryRelationModel().addGanttEntryRelationListener(this);
            if (this.\u0110 != null) {
                this.\u0110.setScaleModel(this.\u0106.getScaleModel());
            }
        } else if (this.\u0110 != null) {
            this.\u0110.setScaleModel(null);
        }
        this.\u0104();
        this.firePropertyChange(PROPERTY_GANTT_MODEL, ganttModel2, this.\u0106);
        this.resizeAndRepaint();
    }

    private void \u0104() {
        if (this.\u0110 != null) {
            if (this.\u0106 != null) {
                Range<T> range = this.\u0106.getRange();
                if (range != null) {
                    this.\u0110.setStart(range.lower());
                    this.\u0110.setEnd(range.upper());
                }
            } else if (this.\u0110.getScaleModel() != null) {
                ScaleModel<T> scaleModel = this.\u0110.getScaleModel();
                this.\u0110.setStart(scaleModel.getDefaultStart());
                this.\u0110.setEnd(scaleModel.getDefaultEnd());
            }
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (this.\u0113 != null) {
            return this.\u0113;
        }
        GanttChartUI ganttChartUI = this.getUI();
        if (ganttChartUI != null) {
            return ganttChartUI.getPreferredScrollableViewportSize(this);
        }
        int n2 = 400;
        if (this.\u0110 != null) {
            n2 = this.\u0110.getPreferredPeriodSize().width * this.\u0110.getVisiblePeriodCount();
        }
        return new Dimension(n2, 400);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n2, int n3) {
        if (n2 == 0) {
            return rectangle.width;
        }
        if (this.\u0110 != null && this.\u0110.getTreeTable() != null) {
            return this.\u0110.getTreeTable().getScrollableBlockIncrement(rectangle, n2, n3);
        }
        return rectangle.height;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.getParent() instanceof JViewport && this.getParent().getHeight() > this.getPreferredSize().height;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.getParent() instanceof JViewport && this.getParent().getWidth() > this.getPreferredSize().width;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n2, int n3) {
        switch (n2) {
            case 0: {
                if (this.\u0110 != null) {
                    return this.\u0110.getPreferredPeriodSize().width;
                }
                return Math.max(1, rectangle.width / 100);
            }
        }
        if (this.\u0110 != null && this.\u0110.getTreeTable() != null) {
            return this.\u0110.getTreeTable().getScrollableUnitIncrement(rectangle, n2, n3);
        }
        if (this.isRowHeightSet()) {
            return this.getRowHeight();
        }
        return Math.max(1, rectangle.height / 100);
    }

    protected void setUI(GanttChartUI ganttChartUI) {
        super.setUI(ganttChartUI);
    }

    @Override
    public String getUIClassID() {
        return \u0116;
    }

    @Override
    public GanttChartUI getUI() {
        return (GanttChartUI)this.ui;
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get(\u0116) == null) {
            LookAndFeelFactory.installJideExtension();
            new GanttUIDefaultsCustomizer().customize(UIManager.getLookAndFeelDefaults());
        }
        this.setUI((GanttChartUI)UIManager.getUI(this));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.configureEnclosingScrollPane();
    }

    protected void configureEnclosingScrollPane() {
        Container container;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            ScaleArea<T> scaleArea = this.getScaleArea();
            if (scaleArea != null) {
                jScrollPane.setColumnHeaderView(scaleArea);
            }
        }
    }

    public int getEntryCount() {
        GanttModel<T, S> ganttModel = this.getModel();
        if (ganttModel != null) {
            return ganttModel.getEntryCount();
        }
        return 0;
    }

    public S getEntryAt(Point point) {
        int n2 = this.rowAtPoint(point);
        int n3 = -1;
        if (n2 != -1 && this.getUI() instanceof BasicGanttChartUI) {
            n3 = ((BasicGanttChartUI)this.getUI()).getSubEntryIndex(n2, point);
        }
        S s2 = this.getEntryAt(n2, n3);
        Rectangle rectangle = this.getEntryRect((GanttEntry<T>)s2, n2);
        if (s2 != null && n3 < 0 && rectangle != null && !rectangle.contains(point)) {
            s2 = null;
        }
        return s2;
    }

    public S getEntryAt(int n2) {
        GanttModel<T, S> ganttModel = this.getModel();
        if (ganttModel != null) {
            return ganttModel.getEntryAt(n2);
        }
        return null;
    }

    public S getEntryAt(int n2, int n3) {
        if (n3 < 0) {
            return this.getEntryAt(n2);
        }
        GanttModel<T, S> ganttModel = this.getModel();
        if (ganttModel != null) {
            List list;
            S s2 = ganttModel.getEntryAt(n2);
            if (s2 instanceof SubEntryGanttEntry && (list = ((SubEntryGanttEntry)s2).getSubEntries()) != null && n3 >= 0 && n3 < list.size()) {
                return (S)list.get(n3);
            }
            return s2;
        }
        return null;
    }

    public int getIndexOf(S s2) {
        GanttModel<T, S> ganttModel = this.getModel();
        if (ganttModel != null) {
            return ganttModel.getIndexOf(s2);
        }
        return -1;
    }

    protected void resizeAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    public void setRowHeight(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("New row height less than 1");
        }
        int n3 = this.\u0118;
        this.\u0118 = n2;
        this.\u011c = null;
        this.\u0101 = true;
        this.resizeAndRepaint();
        this.firePropertyChange(PROPERTY_ROW_HEIGHT, n3, n2);
    }

    public boolean isRowHeightSet() {
        return this.\u0101;
    }

    public int getRowHeight() {
        return this.\u0118;
    }

    public int getTotalRowHeight() {
        if (this.isRowHeightSet()) {
            return this.getEntryCount() * this.getRowHeight();
        }
        return this.\u0101(this.\u011c.getSizes());
    }

    private int \u0101(int ... nArray) {
        int n2 = 0;
        for (int n3 : nArray) {
            n2 += n3;
        }
        return n2;
    }

    private SizeSequence \u0102() {
        if (this.\u011c == null) {
            this.\u011c = new SizeSequence(this.getEntryCount(), this.getRowHeight());
        }
        return this.\u011c;
    }

    public void setRowHeight(int n2, int n3) {
        if (n3 <= 0) {
            throw new IllegalArgumentException("New row height less than 1");
        }
        this.\u0102().setSize(n2, n3);
        this.resizeAndRepaint();
    }

    public int getRowHeight(int n2) {
        return this.\u011c == null ? this.getRowHeight() : this.\u011c.getSize(n2);
    }

    public void setRowMargin(int n2) {
        int n3 = this.\u011b;
        this.\u011b = n2;
        this.resizeAndRepaint();
        this.firePropertyChange(PROPERTY_ROW_MARGIN, n3, n2);
    }

    public int getRowMargin() {
        return this.\u011b;
    }

    public void setGridColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("New color is null");
        }
        Color color2 = this.\u0115;
        this.\u0115 = color;
        this.firePropertyChange(PROPERTY_GRID_COLOR, color2, color);
        this.repaint();
    }

    public Color getGridColor() {
        return this.\u0115;
    }

    public void setShowGrid(boolean bl) {
        boolean bl2 = this.\u0104;
        this.\u0104 = bl;
        this.firePropertyChange(PROPERTY_SHOW_GRID, bl2, bl);
        this.repaint();
    }

    public boolean isShowGrid() {
        return this.\u0104;
    }

    public void setViewMode(int n2) {
        if (n2 != this.\u0114) {
            int n3 = this.\u0114;
            this.\u0114 = n2;
            this.firePropertyChange(PROPERTY_VIEW_MODE, n3, this.\u0114);
        }
    }

    public int getViewMode() {
        return this.\u0114;
    }

    public int rowAtPoint(Point point) {
        int n2;
        int n3 = point.y;
        int n4 = n2 = this.\u011c == null ? n3 / this.getRowHeight() : this.\u011c.getIndex(n3);
        if (n2 < 0) {
            return -1;
        }
        if (n2 >= this.getEntryCount()) {
            return -1;
        }
        return n2;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        Point point = mouseEvent.getPoint();
        int n2 = this.rowAtPoint(point);
        if (n2 != -1) {
            Rectangle rectangle;
            GanttEntryRenderer ganttEntryRenderer;
            Component component;
            int n3 = -1;
            if (this.getUI() instanceof BasicGanttChartUI) {
                n3 = ((BasicGanttChartUI)this.getUI()).getSubEntryIndex(n2, point);
            }
            if ((component = this.prepareRenderer(ganttEntryRenderer = this.getEntryRenderer(n2, n3), n2, n3, \u0111)) instanceof JComponent && (rectangle = this.getEntryRect(n2)) != null) {
                if (rectangle.width == 0) {
                    rectangle.x -= 2;
                    rectangle.width += 4;
                }
                point.translate(-rectangle.x, -rectangle.y);
                if (point.x >= 0 && point.y >= 0 && point.x < rectangle.width && point.y < rectangle.height) {
                    MouseEvent mouseEvent2 = SystemInfo.isJdk6Above() ? new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), 0) : new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), 0);
                    string = ((JComponent)component).getToolTipText(mouseEvent2);
                }
            }
        }
        if (string == null) {
            string = this.getToolTipText();
        }
        return string;
    }

    public Rectangle getEntryRect(int n2) {
        S s2 = this.getEntryAt(n2);
        return this.getEntryRect((GanttEntry<T>)s2, n2);
    }

    public Rectangle getEntryRect(GanttEntry<T> ganttEntry, int n2) {
        if (ganttEntry != null) {
            int n3;
            int n4;
            Range<T> range = ganttEntry.getRange();
            if (!this.\u0101(range)) {
                return null;
            }
            if (this.\u011c != null) {
                n4 = this.\u011c.getPosition(n2);
                n3 = this.getRowHeight(n2);
            } else {
                n3 = this.getRowHeight();
                n4 = n2 * n3;
            }
            ScaleArea<T> scaleArea = this.getScaleArea();
            int n5 = scaleArea.getX(range.lower());
            int n6 = scaleArea.getX(range.upper());
            if (n5 > n6) {
                int n7 = n6;
                n6 = n5;
                n5 = n7;
            }
            return new Rectangle(n5, n4, n6 - n5, n3);
        }
        return null;
    }

    public Rectangle getRowRect(int n2, boolean bl) {
        int n3;
        int n4;
        if (this.\u011c != null) {
            n4 = this.\u011c.getPosition(n2);
            n3 = this.getRowHeight(n2);
        } else {
            n3 = this.getRowHeight();
            n4 = n2 * n3;
        }
        int n5 = this.getRowMargin();
        if (bl) {
            return new Rectangle(0, n4, this.getWidth(), n3);
        }
        return new Rectangle(0, n4, this.getWidth(), n3 - n5);
    }

    public void autoResizePeriods(boolean bl) {
        if (this.\u0110 != null && this.\u0110.getScaleModel() != null) {
            ScaleModel scaleModel = this.getScaleArea().getScaleModel();
            T t2 = scaleModel.getDefaultStart();
            T t3 = scaleModel.getDefaultEnd();
            if (bl && this.getEntryCount() > 0) {
                Rectangle rectangle = this.getVisibleRect();
                Point point = rectangle.getLocation();
                int n2 = this.rowAtPoint(point);
                point.x += rectangle.width;
                point.y += rectangle.height;
                int n3 = this.rowAtPoint(point);
                if (n3 == -1) {
                    n3 = this.getEntryCount() - 1;
                }
                long l2 = Long.MAX_VALUE;
                long l3 = Long.MIN_VALUE;
                for (int i2 = n2; i2 <= n3; ++i2) {
                    Range range = this.getEntryAt(i2).getRange();
                    if (!this.\u0101(range)) continue;
                    Object t4 = range.lower();
                    long l4 = scaleModel.getPosition(t4);
                    if (l4 < l2) {
                        l2 = l4;
                        t2 = t4;
                    }
                    if ((l4 = scaleModel.getPosition(t4 = range.upper())) <= l3) continue;
                    l3 = l4;
                    t3 = t4;
                }
            } else {
                Range<T> range = this.\u0106.getRange();
                if (this.\u0101(range)) {
                    t2 = range.lower();
                    t3 = range.upper();
                }
            }
            this.zoomPeriods(t2, t3);
        }
    }

    private boolean \u0101(Range<T> range) {
        return range != null && range.lower() != null && range.upper() != null;
    }

    public void zoomPeriods(T t2, T t3) {
        ScaleArea<T> scaleArea = this.getScaleArea();
        if (scaleArea != null) {
            int n2 = this.getVisibleRect().width;
            if (n2 <= 0) {
                n2 = this.getPreferredScrollableViewportSize().width;
            }
            scaleArea.setVisiblePeriodsToFit(t2, t3, n2);
            this.resizeAndRepaint();
            this.scrollSpanToVisible(t2, t3);
        }
    }

    public void zoomInPeriods() {
        this.zoomPeriods(1.2);
    }

    public void zoomOutPeriods() {
        this.zoomPeriods(0.8);
    }

    public void zoomPeriods(double d2) {
        ScaleArea<T> scaleArea = this.getScaleArea();
        if (scaleArea != null) {
            scaleArea.zoomPeriodWidth(d2);
            this.resizeAndRepaint();
            this.scrollRowToVisible(this.getSelectedRow());
        }
    }

    public void scrollSpanToVisible(Range<T> range) {
        this.scrollSpanToVisible(range.lower(), range.upper());
    }

    public void scrollSpanToVisible(T t2, T t3) {
        if (this.\u0110 != null) {
            int n2;
            int n3;
            Rectangle rectangle = this.getVisibleRect();
            int n4 = this.\u0110.getX(t2);
            if (n4 > (n3 = this.\u0110.getX(t3))) {
                n2 = n3;
                n3 = n4;
                n4 = n2;
            }
            n2 = rectangle.width;
            int n5 = this.\u0110.getPeriodMargin();
            int n6 = n4 - n5;
            int n7 = n3 - n4 + n5 * 2;
            if (n7 < n2) {
                n6 = Math.max(0, n6 - (n2 - n7) / 2);
                n7 = n2;
            }
            this.scrollRectToVisible(new Rectangle(n6, rectangle.y, n7, rectangle.height));
        }
    }

    public void scrollRowToVisible(int n2) {
        Rectangle rectangle;
        if (n2 >= 0 && n2 < this.getEntryCount() && (rectangle = this.getEntryRect(n2)) != null) {
            int n3 = this.getRowHeight(n2);
            rectangle.y = Math.max(0, rectangle.y - n3);
            rectangle.height = Math.min(this.getHeight(), rectangle.height + n3 * 2);
            if (this.\u0110 != null) {
                int n4 = this.\u0110.getPeriodMargin();
                rectangle.x -= n4;
                rectangle.width += n4 * 2;
            }
            this.scrollRectToVisible(rectangle);
        }
    }

    public GanttEntryRenderer getEntryRenderer(int n2) {
        return this.getDefaultEntryRenderer();
    }

    public GanttEntryRenderer getEntryRenderer(int n2, int n3) {
        return this.getEntryRenderer(n2);
    }

    public GanttEntryRenderer getDefaultEntryRenderer() {
        return this.\u0112;
    }

    public void setDefaultEntryRenderer(GanttEntryRenderer ganttEntryRenderer) {
        this.\u0112 = ganttEntryRenderer;
    }

    public GanttLabelRenderer getLabelRenderer(int n2) {
        return this.getDefaultLabelRenderer();
    }

    public GanttLabelRenderer getLabelRenderer(int n2, int n3) {
        return this.getDefaultLabelRenderer();
    }

    public GanttLabelRenderer getDefaultLabelRenderer() {
        return this.\u010a;
    }

    public void setDefaultLabelRenderer(GanttLabelRenderer ganttLabelRenderer) {
        this.\u010a = ganttLabelRenderer;
    }

    public int getLabelPosition() {
        return this.\u010e;
    }

    public void setLabelPosition(int n2) {
        int n3 = this.\u010e;
        if (n3 != n2) {
            this.\u010e = n2;
            this.firePropertyChange(PROPERTY_LABEL_POSITION, n3, this.\u010e);
        }
    }

    public int getLabelEntryGap() {
        return this.\u011d;
    }

    public void setLabelEntryGap(int n2) {
        int n3 = this.\u011d;
        if (n3 != n2) {
            this.\u011d = n2;
            this.firePropertyChange(PROPERTY_LABEL_ENTRY_GAP, n3, this.\u011d);
        }
    }

    @Deprecated
    public Component prepareRenderer(GanttEntryRenderer ganttEntryRenderer, int n2, Insets insets) {
        return this.prepareRenderer(ganttEntryRenderer, n2, -1, insets);
    }

    public Component prepareRenderer(GanttEntryRenderer ganttEntryRenderer, int n2, int n3, Insets insets) {
        S s2 = this.getEntryAt(n2, n3);
        boolean bl = false;
        boolean bl2 = false;
        if (!this.isPaintingForPrint()) {
            bl = this.isRowSelected(n2);
            boolean bl3 = this.getSelectionModel().getLeadSelectionIndex() == n2;
            bl2 = bl3 && this.isFocusOwner();
        }
        return ganttEntryRenderer.getGanttEntryRendererComponent(this, (GanttEntry<?>)s2, bl, bl2, n2, n3, insets);
    }

    public Component prepareLabelRenderer(GanttLabelRenderer ganttLabelRenderer, int n2) {
        return this.prepareLabelRenderer(ganttLabelRenderer, n2, -1);
    }

    public Component prepareLabelRenderer(GanttLabelRenderer ganttLabelRenderer, int n2, int n3) {
        S s2 = this.getEntryAt(n2, n3);
        boolean bl = false;
        boolean bl2 = false;
        if (!this.isPaintingForPrint()) {
            bl = this.isRowSelected(n2);
            boolean bl3 = this.getSelectionModel().getLeadSelectionIndex() == n2;
            bl2 = bl3 && this.isFocusOwner();
        }
        return ganttLabelRenderer.getGanttLabelRendererComponent(this, (GanttEntry<?>)s2, bl, bl2, n2, n3);
    }

    public GanttEntryRelationPainter getRelationPainter(int n2) {
        return this.\u0105.get(n2);
    }

    public void setRelationPainter(int n2, GanttEntryRelationPainter ganttEntryRelationPainter) {
        this.\u0105.put(n2, ganttEntryRelationPainter);
    }

    public List<PeriodBackgroundPainter<T>> getPeriodBackgroundPainters() {
        return this.\u010f;
    }

    public void addPeriodBackgroundPainter(PeriodBackgroundPainter<T> periodBackgroundPainter) {
        this.addPeriodBackgroundPainter(this.\u010f.size(), periodBackgroundPainter);
    }

    public void addPeriodBackgroundPainter(int n2, PeriodBackgroundPainter<T> periodBackgroundPainter) {
        this.\u010f.add(Math.min(n2, this.\u010f.size()), periodBackgroundPainter);
    }

    public void removePeriodBackgroundPainter(PeriodBackgroundPainter<T> periodBackgroundPainter) {
        this.\u010f.remove(periodBackgroundPainter);
    }

    public int getSelectionMode() {
        return this.getSelectionModel().getSelectionMode();
    }

    public ListSelectionModel getSelectionModel() {
        return this.\u0107;
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (listSelectionModel == null) {
            throw new IllegalArgumentException("Cannot set a null SelectionModel");
        }
        ListSelectionModel listSelectionModel2 = this.\u0107;
        if (listSelectionModel != listSelectionModel2) {
            if (listSelectionModel2 != null) {
                listSelectionModel2.removeListSelectionListener(this);
            }
            this.\u0107 = listSelectionModel;
            this.\u0107.addListSelectionListener(this);
            this.firePropertyChange("selectionModel", listSelectionModel2, this.\u0107);
            this.repaint();
        }
    }

    public void setSelectionMode(int n2) {
        this.clearSelection();
        this.getSelectionModel().setSelectionMode(n2);
    }

    public void clearSelection() {
        this.\u0107.clearSelection();
    }

    private void \u0101() {
        this.\u0107.setValueIsAdjusting(true);
        this.clearSelection();
        this.\u0107.setAnchorSelectionIndex(-1);
        this.\u0107.setLeadSelectionIndex(-1);
        this.\u0107.setValueIsAdjusting(false);
    }

    private int \u0102(int n2) {
        int n3 = this.getEntryCount();
        return n2 < n3 ? n2 : -1;
    }

    public void selectAll() {
        if (this.getEntryCount() > 0) {
            ListSelectionModel listSelectionModel = this.\u0107;
            listSelectionModel.setValueIsAdjusting(true);
            this.setSelectionInterval(0, this.getEntryCount() - 1);
            listSelectionModel.setValueIsAdjusting(false);
            listSelectionModel.setValueIsAdjusting(false);
        }
    }

    private int \u0101(int n2) throws IllegalArgumentException {
        if (n2 < 0 || n2 >= this.getEntryCount()) {
            throw new IllegalArgumentException("Entry index out of range");
        }
        return n2;
    }

    public void setSelectedIndex(int n2) {
        if (n2 >= this.getEntryCount()) {
            return;
        }
        this.getSelectionModel().setSelectionInterval(n2, n2);
    }

    public void setSelectionInterval(int n2, int n3) {
        this.\u0107.setSelectionInterval(this.\u0101(n2), this.\u0101(n3));
    }

    public void addSelectionInterval(int n2, int n3) {
        this.\u0107.addSelectionInterval(this.\u0101(n2), this.\u0101(n3));
    }

    public void removeSelectionInterval(int n2, int n3) {
        this.\u0107.removeSelectionInterval(this.\u0101(n2), this.\u0101(n3));
    }

    public int getSelectedRow() {
        return this.\u0107.getMinSelectionIndex();
    }

    public int[] getSelectedRows() {
        int n2 = this.\u0107.getMinSelectionIndex();
        int n3 = this.\u0107.getMaxSelectionIndex();
        if (n2 == -1 || n3 == -1) {
            return new int[0];
        }
        int[] nArray = new int[1 + (n3 - n2)];
        int n4 = 0;
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (!this.\u0107.isSelectedIndex(i2)) continue;
            nArray[n4++] = i2;
        }
        int[] nArray2 = new int[n4];
        System.arraycopy(nArray, 0, nArray2, 0, n4);
        return nArray2;
    }

    public int getSelectedRowCount() {
        int n2 = this.\u0107.getMinSelectionIndex();
        int n3 = this.\u0107.getMaxSelectionIndex();
        int n4 = 0;
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (!this.\u0107.isSelectedIndex(i2)) continue;
            ++n4;
        }
        return n4;
    }

    public int getAnchorSelectionIndex() {
        return this.getSelectionModel().getAnchorSelectionIndex();
    }

    public int getLeadSelectionIndex() {
        return this.getSelectionModel().getLeadSelectionIndex();
    }

    public int getMinSelectionIndex() {
        return this.getSelectionModel().getMinSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.getSelectionModel().getMaxSelectionIndex();
    }

    public void setValueIsAdjusting(boolean bl) {
        this.getSelectionModel().setValueIsAdjusting(bl);
    }

    public boolean getValueIsAdjusting() {
        return this.getSelectionModel().getValueIsAdjusting();
    }

    public boolean isRowSelected(int n2) {
        return this.\u0107.isSelectedIndex(n2);
    }

    private void \u0101(ListSelectionModel listSelectionModel, int n2, boolean bl, boolean bl2, boolean bl3, int n3, boolean bl4) {
        if (bl2) {
            if (bl) {
                if (bl4) {
                    listSelectionModel.addSelectionInterval(n3, n2);
                } else {
                    listSelectionModel.removeSelectionInterval(n3, n2);
                    if (Boolean.TRUE == this.getClientProperty("Table.isFileList")) {
                        listSelectionModel.addSelectionInterval(n2, n2);
                        listSelectionModel.setAnchorSelectionIndex(n3);
                    }
                }
            } else {
                listSelectionModel.setSelectionInterval(n3, n2);
            }
        } else if (bl) {
            if (bl3) {
                listSelectionModel.removeSelectionInterval(n2, n2);
            } else {
                listSelectionModel.addSelectionInterval(n2, n2);
            }
        } else {
            listSelectionModel.setSelectionInterval(n2, n2);
        }
    }

    public void changeSelection(int n2, boolean bl, boolean bl2) {
        Rectangle rectangle;
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        int n3 = this.\u0102(listSelectionModel.getAnchorSelectionIndex());
        boolean bl3 = true;
        if (n3 == -1) {
            if (this.getEntryCount() > 0) {
                n3 = 0;
            }
            bl3 = false;
        }
        boolean bl4 = this.isRowSelected(n2);
        bl3 = bl3 && this.isRowSelected(n3);
        this.\u0101(listSelectionModel, n2, bl, bl2, bl4, n3, bl3);
        if (this.getAutoscrolls() && (rectangle = this.getRowRect(n2, false)) != null) {
            this.scrollRectToVisible(rectangle);
        }
    }

    public Color getSelectionForeground() {
        return this.\u0119;
    }

    public void setSelectionForeground(Color color) {
        Color color2 = this.\u0119;
        this.\u0119 = color;
        this.firePropertyChange("selectionForeground", color2, color);
        if (!color.equals(color2)) {
            this.repaint();
        }
    }

    public Color getSelectionBackground() {
        return this.\u011a;
    }

    public void setSelectionBackground(Color color) {
        Color color2 = this.\u011a;
        this.\u011a = color;
        this.firePropertyChange("selectionBackground", color2, color);
        if (!color.equals(color2)) {
            this.repaint();
        }
    }

    protected ListSelectionModel createDefaultSelectionModel() {
        return new DefaultListSelectionModel();
    }

    private int \u0101(int n2, int n3, int n4) {
        return Math.min(n4, Math.max(n2, n3));
    }

    public void ensureRowIsVisible(int n2) {
        Rectangle rectangle = this.getRowRect(n2, true);
        if (rectangle != null) {
            this.scrollRectToVisible(rectangle);
        }
    }

    @Override
    public void repaint(long l2, int n2, int n3, int n4, int n5) {
        super.repaint(l2, n2, n3, n4, n5);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl = listSelectionEvent.getValueIsAdjusting();
        if (this.\u0109 && !bl) {
            this.\u0109 = false;
            return;
        }
        this.\u0109 = bl;
        if (this.getEntryCount() <= 0) {
            return;
        }
        int n2 = this.\u0101(listSelectionEvent.getFirstIndex(), 0, this.getEntryCount() - 1);
        int n3 = this.\u0101(listSelectionEvent.getLastIndex(), 0, this.getEntryCount() - 1);
        Rectangle rectangle = this.getRowRect(n2, !this.isShowGrid());
        Rectangle rectangle2 = this.getRowRect(n3, !this.isShowGrid());
        Rectangle rectangle3 = rectangle.union(rectangle2);
        this.repaint(rectangle3);
    }

    public String getResourceString(String string) {
        return GanttResources.getResourceBundle(this.getLocale()).getString(string);
    }

    public boolean isAllowMoveEntry() {
        return this.\u010b;
    }

    public void setAllowMoveEntry(boolean bl) {
        this.\u010b = bl;
    }

    public boolean isAllowMouseWheelZoom() {
        return this.\u010d;
    }

    public void setAllowMouseWheelZoom(boolean bl) {
        this.\u010d = bl;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("treeTable".equals(propertyChangeEvent.getPropertyName())) {
            FocusListener[] focusListenerArray;
            for (FocusListener focusListener : focusListenerArray = this.getFocusListeners()) {
                if (!(focusListener instanceof KeyListener) || !(focusListener instanceof TreeWillExpandListener) || !(focusListener instanceof TreeExpansionListener) || !(focusListener instanceof PropertyChangeListener)) continue;
                if (propertyChangeEvent.getOldValue() instanceof TreeTable) {
                    ((TreeTable)propertyChangeEvent.getOldValue()).removeTreeExpansionListener((TreeExpansionListener)((Object)focusListener));
                    ((TreeTable)propertyChangeEvent.getOldValue()).removeTreeWillExpandListener((TreeWillExpandListener)((Object)focusListener));
                }
                if (!(propertyChangeEvent.getNewValue() instanceof TreeTable)) break;
                ((TreeTable)propertyChangeEvent.getNewValue()).addTreeExpansionListener((TreeExpansionListener)((Object)focusListener));
                ((TreeTable)propertyChangeEvent.getNewValue()).addTreeWillExpandListener((TreeWillExpandListener)((Object)focusListener));
                break;
            }
        }
    }

    public int getResizeAreaWidth() {
        return this.\u0117;
    }

    public void setResizeAreaWidth(int n2) {
        this.\u0117 = n2;
    }

    public boolean isResizeWestArea(Point point, Rectangle rectangle) {
        return point.x < rectangle.x;
    }

    public boolean isResizeEastArea(Point point, Rectangle rectangle) {
        return point.x >= rectangle.x + rectangle.width;
    }

    public boolean isAllowResizeEntry(GanttEntry<T> ganttEntry, T t2, T t3) {
        return true;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(8192)) {
            Lm.showInvalidProductMessage(GanttChart.class.getName(), 8192);
        }
        \u0111 = UIDefaultsLookup.getInsets("TaskBar.padding");
    }
}

