/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.diff;

import com.jidesoft.diff.D;
import com.jidesoft.diff.DiffDivider;
import com.jidesoft.diff.DiffResource;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.AutoRepeatButtonUtils;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public abstract class AbstractDiffPane
extends JPanel {
    private static final Logger \u0105 = Logger.getLogger(AbstractDiffPane.class.getName());
    protected Color _insertedColor;
    protected Color _changedColor;
    protected Color _deletedColor;
    private JLabel \u0106;
    protected Map<String, Action> _actions;
    public static final String COMMAND_FIRST = "first";
    public static final String COMMAND_PREVIOUS = "previous";
    public static final String COMMAND_NEXT = "next";
    public static final String COMMAND_LAST = "last";
    private D \u0101;
    private D \u0103;
    private D \u0102;
    private List<Object> \u0104 = new ArrayList<Object>();

    public AbstractDiffPane(Object ... objectArray) {
        Collections.addAll(this.\u0104, objectArray);
        this.\u0101(objectArray);
    }

    public void flip() {
        if (this.\u0104 == null) {
            return;
        }
        Object[] objectArray = new Object[this.\u0104.size()];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray[i2] = this.\u0104.get(objectArray.length - 1 - i2);
        }
        this.\u0104 = new ArrayList<Object>();
        Collections.addAll(this.\u0104, objectArray);
        this.\u0101(objectArray);
    }

    private void \u0101(Object[] objectArray) {
        Object object;
        JComponent[] jComponentArray = new JComponent[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            object = objectArray[i2];
            jComponentArray[i2] = this.createPane(object, i2);
            this.customizePane(jComponentArray[i2], i2);
        }
        this.customizePanes(jComponentArray);
        JComponent jComponent = this.createContentArea(jComponentArray);
        this.createActions();
        object = this.createToolBar();
        this.customizeToolBar((JComponent)object);
        this.initLayout(jComponent, (JComponent)object, this.createStatusBar());
        this.installListeners();
        this.updateActions(1);
        this.doLayout();
    }

    protected void initLayout(JComponent jComponent, JComponent jComponent2, JComponent jComponent3) {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add(jComponent);
        this.add((Component)jComponent2, "First");
        this.add((Component)jComponent3, "Last");
    }

    protected JComponent createContentArea(JComponent ... jComponentArray) {
        JideSplitPane jideSplitPane = new JideSplitPane();
        JComponent[] jComponentArray2 = jComponentArray;
        int n2 = jComponentArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            JComponent jComponent = jComponentArray2[i2];
            jideSplitPane.addPane(jComponent);
        }
        for (int i3 = 0; i3 < jideSplitPane.getPaneCount() - 1; ++i3) {
            DiffDivider diffDivider = this.createDivider(i3);
            this.customizeDivider(diffDivider, i3);
            if (i3 == 0) {
                jideSplitPane.setDividerSize(diffDivider.getPreferredSize().width);
            }
            this.adjustDividerOffset(diffDivider, i3);
            jideSplitPane.getDividerAt(i3).setLayout(new BorderLayout());
            jideSplitPane.getDividerAt(i3).add((Component)diffDivider, "Center");
        }
        jideSplitPane.setProportionalLayout(true);
        double[] dArray = new double[jideSplitPane.getPaneCount() - 1];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            dArray[n2] = 1.0 / (double)jideSplitPane.getPaneCount();
        }
        jideSplitPane.setProportions(dArray);
        return jideSplitPane;
    }

    protected void customizeDivider(DiffDivider diffDivider, int n2) {
    }

    protected void adjustDividerOffset(DiffDivider diffDivider, int n2) {
    }

    protected void customizePane(JComponent jComponent, int n2) {
    }

    protected void customizePanes(JComponent[] jComponentArray) {
    }

    protected JComponent createToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setBorder(BorderFactory.createEmptyBorder());
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        return jToolBar;
    }

    protected AbstractButton createButton(Action action) {
        JideButton jideButton = new JideButton(action);
        jideButton.setName("" + action.getValue("ActionCommandKey"));
        jideButton.setDisabledIcon((Icon)action.getValue("disabledIcon"));
        jideButton.setRequestFocusEnabled(false);
        AutoRepeatButtonUtils.install(jideButton, 50, 200);
        return jideButton;
    }

    protected String getResourceString(String string) {
        return DiffResource.getResourceBundle(Locale.getDefault()).getString(string);
    }

    protected void createActions() {
        this._actions = new HashMap<String, Action>();
        this._actions.put(COMMAND_FIRST, this.customizeAction(new AbstractAction(){
            private static final long \u0102 = 6893754686428212999L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractDiffPane.this.firstChange();
            }
        }, COMMAND_FIRST));
        this._actions.put(COMMAND_PREVIOUS, this.customizeAction(new AbstractAction(){
            private static final long \u0102 = -2253705874929832246L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractDiffPane.this.previousChange();
            }
        }, COMMAND_PREVIOUS));
        this._actions.put(COMMAND_NEXT, this.customizeAction(new AbstractAction(){
            private static final long \u0102 = -1009332954318544219L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractDiffPane.this.nextChange();
            }
        }, COMMAND_NEXT));
        this._actions.put(COMMAND_LAST, this.customizeAction(new AbstractAction(){
            private static final long \u0102 = 6893754686428212999L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractDiffPane.this.lastChange();
            }
        }, COMMAND_LAST));
        this.registerKeyboardAction(this._actions.get(COMMAND_PREVIOUS), KeyStroke.getKeyStroke(118, 64), 1);
        this.registerKeyboardAction(this._actions.get(COMMAND_NEXT), KeyStroke.getKeyStroke(118, 0), 1);
    }

    protected Action customizeAction(Action action, String string) {
        block19: {
            String string2;
            String string3;
            block18: {
                ImageIcon imageIcon;
                String string4;
                block17: {
                    block16: {
                        block15: {
                            action.putValue("ActionCommandKey", string);
                            string3 = "DiffPane." + string + ".";
                            try {
                                string4 = this.getResourceString(string3 + "text");
                                if (string4 != null && string4.trim().length() > 0) {
                                    action.putValue("Name", string4);
                                }
                            }
                            catch (Exception exception) {
                                if (!\u0105.isLoggable(Level.FINE)) break block15;
                                \u0105.fine(exception.getMessage());
                            }
                        }
                        string4 = null;
                        try {
                            string4 = this.getResourceString(string3 + "icon");
                        }
                        catch (Exception exception) {
                            if (!\u0105.isLoggable(Level.FINE)) break block16;
                            \u0105.fine(exception.getMessage());
                        }
                    }
                    if (string4 == null || string4.trim().length() == 0) {
                        string4 = String.format("icons/%s.png", string);
                    }
                    imageIcon = IconsFactory.getImageIcon(AbstractDiffPane.class, string4);
                    action.putValue("SmallIcon", imageIcon);
                    string4 = null;
                    try {
                        string4 = this.getResourceString(string3 + "disabledIcon");
                    }
                    catch (Exception exception) {
                        if (!\u0105.isLoggable(Level.FINE)) break block17;
                        \u0105.fine(exception.getMessage());
                    }
                }
                if (string4 == null || string4.trim().length() == 0) {
                    string4 = String.format("icons/%s_disabled.png", string);
                }
                imageIcon = IconsFactory.getImageIcon(AbstractDiffPane.class, string4);
                action.putValue("disabledIcon", imageIcon);
                try {
                    string2 = this.getResourceString(string3 + "tooltip");
                    if (string2 != null && string2.trim().length() > 0) {
                        action.putValue("ShortDescription", string2);
                    }
                }
                catch (Exception exception) {
                    if (!\u0105.isLoggable(Level.FINE)) break block18;
                    \u0105.fine(exception.getMessage());
                }
            }
            try {
                string2 = this.getResourceString(string3 + "mnemonic");
                if (string2 != null && string2.trim().length() > 1) {
                    action.putValue("MnemonicKey", Character.valueOf(string2.charAt(0)));
                }
            }
            catch (Exception exception) {
                if (!\u0105.isLoggable(Level.FINE)) break block19;
                \u0105.fine(exception.getMessage());
            }
        }
        return action;
    }

    protected void customizeToolBar(JComponent jComponent) {
        jComponent.add(this.createButton(this._actions.get(COMMAND_FIRST)));
        jComponent.add(this.createButton(this._actions.get(COMMAND_PREVIOUS)));
        jComponent.add(this.createButton(this._actions.get(COMMAND_NEXT)));
        jComponent.add(this.createButton(this._actions.get(COMMAND_LAST)));
    }

    protected JComponent createStatusBar() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.\u0106 = new JLabel();
        jPanel.add(this.\u0106);
        jPanel.add((Component)this.createLegendBar(), "After");
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        return jPanel;
    }

    protected JComponent createLegendBar() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.\u0102 = new D();
        this.\u0102.\u0101(this.getChangedColor());
        jPanel.add(this.\u0102);
        jPanel.add(Box.createHorizontalStrut(6));
        jPanel.add(new JLabel(this.getResourceString("DiffPane.changed")));
        jPanel.add(Box.createHorizontalStrut(10));
        this.\u0101 = new D();
        this.\u0101.\u0101(this.getInsertedColor());
        jPanel.add(this.\u0101);
        jPanel.add(Box.createHorizontalStrut(6));
        jPanel.add(new JLabel(this.getResourceString("DiffPane.inserted")));
        jPanel.add(Box.createHorizontalStrut(10));
        this.\u0103 = new D();
        this.\u0103.\u0101(this.getDeletedColor());
        jPanel.add(this.\u0103);
        jPanel.add(Box.createHorizontalStrut(6));
        jPanel.add(new JLabel(this.getResourceString("DiffPane.deleted")));
        jPanel.add(Box.createHorizontalStrut(10));
        return jPanel;
    }

    public Color getInsertedColor() {
        if (this._insertedColor == null) {
            this._insertedColor = UIDefaultsLookup.getColor("DiffMerge.inserted");
        }
        return this._insertedColor;
    }

    public void setInsertedColor(Color color) {
        this._insertedColor = color;
        if (this.\u0101 != null) {
            this.\u0101.\u0101(this._insertedColor);
        }
    }

    public Color getChangedColor() {
        if (this._changedColor == null) {
            this._changedColor = UIDefaultsLookup.getColor("DiffMerge.changed");
        }
        return this._changedColor;
    }

    public void setChangedColor(Color color) {
        this._changedColor = color;
        if (this.\u0102 != null) {
            this.\u0102.\u0101(this._changedColor);
        }
    }

    public Color getDeletedColor() {
        if (this._deletedColor == null) {
            this._deletedColor = UIDefaultsLookup.getColor("DiffMerge.deleted");
        }
        return this._deletedColor;
    }

    public void setDeletedColor(Color color) {
        this._deletedColor = color;
        if (this.\u0103 != null) {
            this.\u0103.\u0101(this._deletedColor);
        }
    }

    public abstract JComponent createPane(Object var1, int var2);

    public abstract DiffDivider createDivider(int var1);

    public void setMessage(String string) {
        if (this.\u0106 != null) {
            this.\u0106.setText(string);
        }
    }

    public String getMessage() {
        if (this.\u0106 != null) {
            return this.\u0106.getText();
        }
        return "";
    }

    protected void updateActions(int n2) {
    }

    protected void firstChange() {
    }

    protected void previousChange() {
    }

    protected void nextChange() {
    }

    protected void lastChange() {
    }

    protected void installListeners() {
    }

    protected void uninstallListeners() {
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(16384)) {
            Lm.showInvalidProductMessage(AbstractDiffPane.class.getName(), 16384);
        }
    }
}

