/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.util.artifact;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.onseven.dbvis.util.file.d;
import com.onseven.dbvis.util.n;
import com.onseven.dbvis.util.w;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;

public class ArtifactFile {
    @JsonProperty(value="Path")
    private String filePath;
    private String rootPath;
    @JacksonXmlProperty(localName="type", isAttribute=true)
    private _b fileType = null;

    public ArtifactFile(String string, _b _b2) {
        this.filePath = n.c(string);
        if (_b2 == null) {
            _b2 = ArtifactFile.autoDetectType(string);
        }
        this.fileType = _b2;
    }

    public ArtifactFile(String string, String string2, _b _b2) {
        this.initFilePath(string, new File(string2));
        this.rootPath = string;
        if (_b2 == null) {
            _b2 = ArtifactFile.autoDetectType(string2);
        }
        this.fileType = _b2;
    }

    public ArtifactFile() {
    }

    public ArtifactFile(String string) {
        this.filePath = n.c(string);
        this.fileType = ArtifactFile.autoDetectType(string);
    }

    public ArtifactFile(ArtifactFile artifactFile) {
        this.filePath = n.c(artifactFile.filePath);
        this.fileType = artifactFile.fileType;
        this.rootPath = n.c(artifactFile.rootPath);
    }

    @JsonIgnore
    public boolean isInBundleRoot() {
        return !new File(this.filePath).isAbsolute();
    }

    public static _b autoDetectType(String string) {
        d d2 = d.b(string);
        switch (d2) {
            case i: 
            case eb: {
                return _b.e;
            }
            case ab: {
                return _b.f;
            }
        }
        File file = new File(string);
        if (file.getName().endsWith(".so") || file.getName().contains(".so.")) {
            return _b.f;
        }
        if (file.getName().endsWith(".dylib")) {
            return _b.f;
        }
        return _b.b;
    }

    public _b getArtifactFileType() {
        if (this.fileType == null) {
            this.fileType = ArtifactFile.autoDetectType(this.filePath);
        }
        return this.fileType;
    }

    public void setArtifactFileType(_b _b2) {
        this.fileType = _b2;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String string) {
        this.filePath = n.c(string);
    }

    public void setRootPath(String string) {
        this.rootPath = string;
        if (w.j(this.filePath)) {
            this.setFilePath(ArtifactFile.adoptToRelativePathIfPossible(string, new File(this.filePath)));
        }
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void initFilePath(String string, File file) {
        this.setFilePath(ArtifactFile.adoptToRelativePathIfPossible(string, file));
        this.fileType = ArtifactFile.autoDetectType(file.getAbsolutePath());
    }

    private static String adoptToRelativePathIfPossible(String string, File file) {
        if (string == null) {
            return file.getAbsolutePath();
        }
        String string2 = n.e(new File(string), file);
        String string3 = string2 != null ? string2 : file.getAbsolutePath();
        return string3;
    }

    public File getFile() {
        if (this.filePath == null) {
            return null;
        }
        Path path = FileSystems.getDefault().getPath(this.filePath, new String[0]);
        if (path.isAbsolute()) {
            return path.toFile();
        }
        return new File(this.rootPath, path.toString());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ArtifactFile)) {
            return false;
        }
        ArtifactFile artifactFile = (ArtifactFile)object;
        return Objects.equals(this.filePath, artifactFile.filePath) && this.fileType == artifactFile.fileType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.filePath, this.fileType});
    }

    public static enum _b {
        e,
        c,
        f,
        b;


        public boolean b(Collection<_b> collection) {
            return collection.contains((Object)this);
        }
    }
}

