/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.data.handlers;

import com.ibm.db2.cmx.runtime.StoredProcedureResult;
import com.ibm.db2.cmx.runtime.data.handlers.IteratorCallResultHandler;
import com.ibm.db2.cmx.runtime.data.handlers.IteratorResultHandler;
import com.ibm.db2.cmx.runtime.data.handlers.ListCallResultHandler;
import com.ibm.db2.cmx.runtime.data.handlers.MapRowHandler;
import com.ibm.db2.cmx.runtime.exception.DataRuntimeException;
import com.ibm.db2.cmx.runtime.exception.DataSQLException;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.handlers.ResultHandler;
import com.ibm.db2.cmx.runtime.handlers.RowHandler;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.db.JdbcData;
import com.ibm.db2.cmx.runtime.internal.metadata.BeanInformationCache;
import com.ibm.db2.cmx.runtime.internal.metadata.BeanIntrospection;
import com.ibm.db2.cmx.runtime.internal.metadata.BeanPropertyInformation;
import com.ibm.db2.cmx.runtime.internal.metadata.ParameterInfoArray;
import com.ibm.db2.cmx.runtime.internal.metadata.StatementDescriptorImpl;
import com.ibm.db2.cmx.runtime.internal.proxy.PDQResultSetProxyHandler;
import com.ibm.db2.cmx.runtime.internal.proxy.ProxyCache;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.runtime.statement.JavaType;
import com.ibm.db2.cmx.tools.internal.StatementUtilities;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BaseStoredProcedureResult
implements StoredProcedureResult {
    public CallableStatement cstmt_;
    public StatementDescriptorImpl statementDescriptor_;
    public Object[] parametersFromMethod_;
    protected int callStmtUpdateCount_;
    protected boolean callStmtHasResultSet_;
    protected boolean alreadyHaveMoreResults_;
    public Object[] outputParameters_;
    private ResultSet resultSet_;
    private static final Class[] SHORT_SET_PARAMS = new Class[]{String.class, Object.class};

    public BaseStoredProcedureResult() {
        this.statementDescriptor_ = null;
        this.cstmt_ = null;
        this.callStmtHasResultSet_ = false;
        this.callStmtUpdateCount_ = -1;
        this.alreadyHaveMoreResults_ = true;
        this.outputParameters_ = null;
        this.parametersFromMethod_ = null;
    }

    public BaseStoredProcedureResult(StatementDescriptorImpl statementDescriptorImpl, CallableStatement callableStatement, Object ... objectArray) {
        this.statementDescriptor_ = statementDescriptorImpl;
        this.cstmt_ = callableStatement;
        this.callStmtHasResultSet_ = false;
        this.callStmtUpdateCount_ = -1;
        this.alreadyHaveMoreResults_ = true;
        this.outputParameters_ = null;
        this.parametersFromMethod_ = objectArray;
    }

    public void getOutAndInOutParameters(CallableStatement callableStatement, boolean bl2) throws DataRuntimeException {
        int[] nArray;
        this.cstmt_ = callableStatement;
        ParameterInfoArray parameterInfoArray = this.statementDescriptor_.getMethodInfoArray();
        if (parameterInfoArray == null) {
            return;
        }
        int n2 = parameterInfoArray.getSqlParameterInfo().size();
        if (this.outputParametersExist(callableStatement, n2, nArray = this.statementDescriptor_.getParameterMetaDataMode()) && bl2) {
            try {
                this.processOutParmsToUserParameters(callableStatement, parameterInfoArray, n2, nArray, this.parametersFromMethod_);
            }
            catch (DataSQLException dataSQLException) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_SP_FAILED_OUTP", new Object[0]), dataSQLException, 10018);
            }
        }
    }

    private void fillOutputParametersArray(CallableStatement callableStatement, int n2, int[] nArray, int[] nArray2) {
        for (int i10 = 0; i10 < n2; ++i10) {
            int n3 = nArray[i10];
            if (n3 != 4 && n3 != 2) {
                this.outputParameters_[i10] = null;
                continue;
            }
            try {
                if (nArray2[i10] == -100010) {
                    this.outputParameters_[i10] = StatementUtilities.getDBTimestamp(callableStatement, i10 + 1);
                    continue;
                }
                this.outputParameters_[i10] = callableStatement.getObject(i10 + 1);
                continue;
            }
            catch (SQLException sQLException) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_SP_OUTP", i10 + 1), sQLException, 10028);
            }
        }
    }

    private boolean outputParametersExist(CallableStatement callableStatement, int n2, int[] nArray) {
        boolean bl2;
        block2: {
            block1: {
                bl2 = false;
                if (0 >= n2 || null != nArray && n2 <= nArray.length) break block1;
                Logger logger = Log.getAPILogger();
                String string = null == this.statementDescriptor_ ? null : this.statementDescriptor_.getOriginalSql();
                String string2 = string = null == string || 0 == string.length() ? "" : "The SQL statment is: \"" + string + "\"";
                if (null == logger) break block2;
                logger.log(Level.FINER, "An SQL statement contains parameter markers, but the metadata for the parameters was not set correctly.  " + string);
                break block2;
            }
            for (int i10 = 0; i10 < n2; ++i10) {
                int n3 = nArray[i10];
                if (n3 != 4 && n3 != 2) continue;
                bl2 = true;
                break;
            }
        }
        return bl2;
    }

    private void processOutParmsToUserParameters(CallableStatement callableStatement, ParameterInfoArray parameterInfoArray, int n2, int[] nArray, Object ... objectArray) throws DataSQLException {
        Object object;
        JdbcData.InputParameterType[] inputParameterTypeArray = this.statementDescriptor_.getParameterTypeinMethod();
        HashMap<Integer, Map<String, BeanPropertyInformation>> hashMap = new HashMap<Integer, Map<String, BeanPropertyInformation>>();
        int n3 = inputParameterTypeArray.length;
        for (int i10 = 0; i10 < n3; ++i10) {
            if (inputParameterTypeArray[i10] != JdbcData.InputParameterType.INPUT_PARAMETERS_AS_BEAN) continue;
            object = BeanInformationCache.getBeanInformation(objectArray[i10].getClass()).getBeanPropertyMap();
            hashMap.put(i10, (Map<String, BeanPropertyInformation>)object);
        }
        int[] nArray2 = this.statementDescriptor_.getParameterMetaData()[0];
        block8: for (int i11 = 0; i11 < n2; ++i11) {
            int n4 = nArray[i11];
            if (n4 != 4 && n4 != 2) continue;
            object = parameterInfoArray.getSqlParameterInfo().get(i11).getParameterEntryTypeInSQLString();
            switch (2.$SwitchMap$com$ibm$db2$cmx$runtime$internal$metadata$SqlParameterInfo$ParameterEntryInfoInSQL[((Enum)object).ordinal()]) {
                case 1: {
                    int n5 = parameterInfoArray.getSqlParameterInfo().get(i11).getParameterPositionZeroBased();
                    this.returnOutParameter(callableStatement, i11, objectArray[n5], nArray2[i11]);
                    continue block8;
                }
                case 2: {
                    this.returnOutParameter(callableStatement, i11, objectArray[i11], nArray2[i11]);
                    continue block8;
                }
                case 3: {
                    if (objectArray.length > 1) {
                        throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_MULTIPLE_METHOD_PARAMETERS_WITH_HOST_VARIABLE_INLINE", objectArray.length), null, 10029);
                    }
                    String string = parameterInfoArray.getSqlParameterInfo().get(i11).getHostVariableName();
                    if (inputParameterTypeArray[0] == JdbcData.InputParameterType.INPUT_PARAMETERS_AS_OBJECT_MAP) {
                        this.getOutputParms();
                        ((Map)objectArray[0]).put(string, this.outputParameters_[i11]);
                        continue block8;
                    }
                    this.returnOutputParameterUsingBean(callableStatement, i11, string, (Map)hashMap.get(0), objectArray[0]);
                    continue block8;
                }
                case 4: {
                    this.returnOutParameter(callableStatement, i11, objectArray[i11], nArray2[i11]);
                    continue block8;
                }
                case 5: {
                    int n5 = parameterInfoArray.getSqlParameterInfo().get(i11).getParameterPositionZeroBased();
                    String string = parameterInfoArray.getSqlParameterInfo().get(i11).getHostVariableName();
                    if (inputParameterTypeArray[n5] == JdbcData.InputParameterType.INPUT_PARAMETERS_AS_OBJECT_MAP) {
                        this.getOutputParms();
                        ((Map)objectArray[n5]).put(string, this.outputParameters_[i11]);
                        continue block8;
                    }
                    this.returnOutputParameterUsingBean(callableStatement, i11, string, (Map)hashMap.get(n5), objectArray[n5]);
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.cstmt_ == null) {
            return;
        }
        try {
            this.cstmt_.close();
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_STMT_CLOSE", new Object[0]), sQLException, 10030);
        }
        finally {
            this.cstmt_ = null;
        }
    }

    public StatementDescriptorImpl getStatementDescriptor() {
        return this.statementDescriptor_;
    }

    public void setStatementDescriptor(StatementDescriptorImpl statementDescriptorImpl) {
        this.statementDescriptor_ = statementDescriptorImpl;
    }

    private void returnOutputParameterUsingBean(CallableStatement callableStatement, int n2, String string, Map<String, BeanPropertyInformation> map, Object object) throws DataSQLException {
        block9: {
            Class<?> clazz = object.getClass();
            Method method = null;
            Method method2 = null;
            Field field = null;
            BeanPropertyInformation beanPropertyInformation = null;
            JavaType javaType = null;
            Object object2 = null;
            beanPropertyInformation = BeanIntrospection.getPropertyUsingCaseSensitiveName(map, string);
            if (beanPropertyInformation != null) {
                method2 = beanPropertyInformation.getWriteMethod();
                field = beanPropertyInformation.getFieldFromIntrospector();
                javaType = beanPropertyInformation.propertyType_;
                try {
                    object2 = this.getColumnValue(callableStatement, n2 + 1, javaType);
                }
                catch (SQLException sQLException) {
                    throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_SP_OUTP", n2 + 1), sQLException, 10583);
                }
                try {
                    if (method2 != null) {
                        method2.invoke(object, object2);
                        break block9;
                    }
                    if (field != null) {
                        field.set(object, object2);
                        break block9;
                    }
                    method = this.findSetWrapperMethodInBean(clazz);
                    if (method != null) {
                        method.invoke(object, string, object2);
                        break block9;
                    }
                    throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_FIELD_NOT_FND", string), null, 10031);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_SET_VAL", string), illegalAccessException, 10032);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_SET_VAL", string), invocationTargetException, 10262);
                }
            }
        }
    }

    private Method findSetWrapperMethodInBean(Class clazz) {
        try {
            return this.getMethodWithParmsForClass(clazz);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        return null;
    }

    public void returnOutParameter(CallableStatement callableStatement, int n2, Object object, int n3) {
        if (object == null) {
            return;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            try {
                objectArray[0] = n3 == -100010 ? StatementUtilities.getDBTimestamp(callableStatement, n2 + 1) : callableStatement.getObject(n2 + 1);
            }
            catch (SQLException sQLException) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_SP_OUTP", n2 + 1), sQLException, 10645);
            }
        }
    }

    public Object[] getUserParameters() {
        return this.parametersFromMethod_;
    }

    public void setUserParameters(Object[] objectArray) {
        this.parametersFromMethod_ = objectArray;
    }

    public void setCallableStatement(CallableStatement callableStatement) {
        this.cstmt_ = callableStatement;
    }

    private ResultSet checkPreconditionsAndGetResultSet(boolean bl2) throws DataRuntimeException {
        if (!this.moveToNext()) {
            return null;
        }
        if (!this.callStmtHasResultSet_) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_NO_RS", new Object[0]), null, 10034);
        }
        if (this.cstmt_ == null) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_SP_CLOSED", new Object[0]), null, 10033);
        }
        this.alreadyHaveMoreResults_ = false;
        ResultSet resultSet = this.resultSet_;
        if (resultSet == null) {
            try {
                resultSet = this.cstmt_.getResultSet();
            }
            catch (SQLException sQLException) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_GET_RS", new Object[0]), sQLException, 10035);
            }
        } else {
            this.resultSet_ = null;
        }
        if (bl2) {
            return (ResultSet)ProxyCache.createInstance(resultSet, new PDQResultSetProxyHandler(resultSet, true));
        }
        return resultSet;
    }

    @Override
    public Map<String, Object>[] getArray() {
        ResultSet resultSet = this.checkPreconditionsAndGetResultSet(false);
        if (resultSet == null) {
            return null;
        }
        MapRowHandler mapRowHandler = new MapRowHandler();
        ListCallResultHandler<Map<String, Object>> listCallResultHandler = new ListCallResultHandler<Map<String, Object>>(mapRowHandler);
        Object object = listCallResultHandler.handle(resultSet);
        return object.toArray((Map[])Array.newInstance(Map.class, object.size()));
    }

    public <T> T[] getArray(Class<T> clazz) {
        ResultSet resultSet = this.checkPreconditionsAndGetResultSet(false);
        if (resultSet == null) {
            return null;
        }
        ListCallResultHandler<T> listCallResultHandler = new ListCallResultHandler<T>(clazz);
        Object object = listCallResultHandler.handle(resultSet);
        return object.toArray((Object[])Array.newInstance(clazz, object.size()));
    }

    public <T> T[] getArray(RowHandler<T> rowHandler) {
        ResultSet resultSet = this.checkPreconditionsAndGetResultSet(true);
        if (resultSet == null) {
            return null;
        }
        ListCallResultHandler<T> listCallResultHandler = new ListCallResultHandler<T>(rowHandler);
        Object object = listCallResultHandler.handle(resultSet);
        return object.toArray((Object[])Array.newInstance(object.get(0).getClass(), object.size()));
    }

    public <T> T[] getArray(Class<T> clazz, RowHandler<T> rowHandler) {
        ResultSet resultSet = this.checkPreconditionsAndGetResultSet(true);
        if (resultSet == null) {
            return null;
        }
        ListCallResultHandler<T> listCallResultHandler = new ListCallResultHandler<T>(rowHandler);
        Object object = listCallResultHandler.handle(resultSet);
        return object.toArray((Object[])Array.newInstance(clazz, object.size()));
    }

    public CallableStatement getCallStatement() {
        return this.cstmt_;
    }

    @Override
    public Iterator<Map<String, Object>> getIterator() {
        ResultSet resultSet = this.checkPreconditionsAndGetResultSet(false);
        if (resultSet == null) {
            return null;
        }
        MapRowHandler mapRowHandler = new MapRowHandler();
        IteratorCallResultHandler<Map<String, Object>> iteratorCallResultHandler = new IteratorCallResultHandler<Map<String, Object>>(mapRowHandler);
        return ((IteratorResultHandler)iteratorCallResultHandler).handle(resultSet);
    }

    public <T> Iterator<T> getIterator(Class<T> clazz) {
        ResultSet resultSet = this.checkPreconditionsAndGetResultSet(false);
        if (resultSet == null) {
            return null;
        }
        IteratorCallResultHandler<T> iteratorCallResultHandler = new IteratorCallResultHandler<T>(clazz);
        return ((IteratorResultHandler)iteratorCallResultHandler).handle(resultSet);
    }

    public <T> Iterator<T> getIterator(RowHandler<T> rowHandler) {
        ResultSet resultSet = this.checkPreconditionsAndGetResultSet(true);
        if (resultSet == null) {
            return null;
        }
        IteratorCallResultHandler<T> iteratorCallResultHandler = new IteratorCallResultHandler<T>(rowHandler);
        return ((IteratorResultHandler)iteratorCallResultHandler).handle(resultSet);
    }

    @Override
    public List<Map<String, Object>> getList() {
        ResultSet resultSet = this.checkPreconditionsAndGetResultSet(false);
        if (resultSet == null) {
            return null;
        }
        MapRowHandler mapRowHandler = new MapRowHandler();
        ListCallResultHandler<Map<String, Object>> listCallResultHandler = new ListCallResultHandler<Map<String, Object>>(mapRowHandler);
        return listCallResultHandler.handle(resultSet);
    }

    public <T> List<T> getList(Class<T> clazz) {
        ResultSet resultSet = this.checkPreconditionsAndGetResultSet(false);
        if (resultSet == null) {
            return null;
        }
        ListCallResultHandler<T> listCallResultHandler = new ListCallResultHandler<T>(clazz);
        return listCallResultHandler.handle(resultSet);
    }

    public <T> List<T> getList(RowHandler<T> rowHandler) {
        ResultSet resultSet = this.checkPreconditionsAndGetResultSet(true);
        if (resultSet == null) {
            return null;
        }
        ListCallResultHandler<T> listCallResultHandler = new ListCallResultHandler<T>(rowHandler);
        return listCallResultHandler.handle(resultSet);
    }

    @Override
    public Object[] getOutputParms() {
        if (this.cstmt_ == null) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_SP_CLOSED", new Object[0]), null, 10036);
        }
        if (this.outputParameters_ == null) {
            int n2 = 0;
            int[] nArray = this.statementDescriptor_.getParameterMetaDataMode();
            int[] nArray2 = this.statementDescriptor_.getParameterMetaData()[0];
            n2 = nArray.length;
            this.outputParameters_ = new Object[n2];
            this.fillOutputParametersArray(this.cstmt_, n2, nArray, nArray2);
        }
        return this.outputParameters_;
    }

    public <T> T getQuery(ResultHandler<T> resultHandler) {
        ResultSet resultSet = this.checkPreconditionsAndGetResultSet(true);
        if (resultSet == null) {
            return null;
        }
        return resultHandler.handle(resultSet);
    }

    @Override
    public ResultSet getResults() {
        ResultSet resultSet = this.checkPreconditionsAndGetResultSet(true);
        return resultSet;
    }

    private int getUpdateCount() {
        this.alreadyHaveMoreResults_ = false;
        return this.callStmtUpdateCount_;
    }

    public void setupForResults(CallableStatement callableStatement) throws SQLException {
        this.alreadyHaveMoreResults_ = true;
        this.callStmtUpdateCount_ = -1;
        this.cstmt_ = callableStatement;
        this.resultSet_ = this.cstmt_.getResultSet();
        boolean bl2 = this.callStmtHasResultSet_ = this.resultSet_ != null;
        if (!this.callStmtHasResultSet_) {
            this.callStmtUpdateCount_ = callableStatement.getUpdateCount();
        }
    }

    private boolean hasMoreResults() {
        if (this.cstmt_ == null) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_SP_CLOSED", new Object[0]), null, 10038);
        }
        return this.hasResultSet() || this.callStmtUpdateCount_ != -1;
    }

    private boolean hasResultSet() {
        if (this.cstmt_ == null) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_SP_CLOSED", new Object[0]), null, 10039);
        }
        return this.callStmtHasResultSet_;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean moveToNext() {
        if (this.cstmt_ == null) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_SP_CLOSED", new Object[0]), null, 10040);
        }
        if (!this.alreadyHaveMoreResults_) {
            this.alreadyHaveMoreResults_ = true;
            this.callStmtUpdateCount_ = -1;
            try {
                this.callStmtHasResultSet_ = this.cstmt_.getMoreResults(2);
                if (this.callStmtHasResultSet_) ** GOTO lbl14
                this.callStmtUpdateCount_ = this.cstmt_.getUpdateCount();
            }
            catch (SQLException var1_1) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_MORE_RES", new Object[0]), var1_1, 10263);
            }
        } else {
            this.alreadyHaveMoreResults_ = false;
        }
lbl14:
        // 3 sources

        var1_2 = this.hasMoreResults();
        if (!var1_2) {
            this.close();
        }
        return var1_2;
    }

    public void setCallStatement(CallableStatement callableStatement) {
        this.cstmt_ = callableStatement;
    }

    private Object getColumnValue(CallableStatement callableStatement, int n2, JavaType javaType) throws SQLException {
        Object object = null;
        switch (javaType) {
            case STRING: {
                object = callableStatement.getString(n2);
                break;
            }
            case BOOLEAN: {
                object = callableStatement.getBoolean(n2);
                if (!callableStatement.wasNull()) break;
                object = null;
                break;
            }
            case SIMPLE_BOOLEAN: {
                object = callableStatement.getBoolean(n2);
                break;
            }
            case BYTE: {
                object = callableStatement.getByte(n2);
                if (!callableStatement.wasNull()) break;
                object = null;
                break;
            }
            case SIMPLE_BYTE: {
                object = callableStatement.getByte(n2);
                break;
            }
            case SHORT: {
                object = callableStatement.getShort(n2);
                if (!callableStatement.wasNull()) break;
                object = null;
                break;
            }
            case SIMPLE_SHORT: {
                object = callableStatement.getShort(n2);
                break;
            }
            case INTEGER: {
                object = callableStatement.getInt(n2);
                if (!callableStatement.wasNull()) break;
                object = null;
                break;
            }
            case SIMPLE_INTEGER: {
                object = callableStatement.getInt(n2);
                break;
            }
            case LONG: {
                object = callableStatement.getLong(n2);
                if (!callableStatement.wasNull()) break;
                object = null;
                break;
            }
            case SIMPLE_LONG: {
                object = callableStatement.getLong(n2);
                break;
            }
            case FLOAT: {
                object = Float.valueOf(callableStatement.getFloat(n2));
                if (!callableStatement.wasNull()) break;
                object = null;
                break;
            }
            case SIMPLE_FLOAT: {
                object = Float.valueOf(callableStatement.getFloat(n2));
                break;
            }
            case DOUBLE: {
                object = callableStatement.getDouble(n2);
                if (!callableStatement.wasNull()) break;
                object = null;
                break;
            }
            case SIMPLE_DOUBLE: {
                object = callableStatement.getDouble(n2);
                break;
            }
            case BYTE_ARRAY: {
                object = callableStatement.getBytes(n2);
                break;
            }
            case DATE: {
                object = callableStatement.getDate(n2);
                break;
            }
            case TIME: {
                object = callableStatement.getTime(n2);
                break;
            }
            case TIMESTAMP: {
                object = callableStatement.getTimestamp(n2);
                break;
            }
            case TIMESTAMPTZ: {
                object = StatementUtilities.getDBTimestamp(callableStatement, n2);
                break;
            }
            case BIGDECIMAL: {
                object = callableStatement.getBigDecimal(n2);
                break;
            }
            case BLOB: {
                object = callableStatement.getBlob(n2);
                break;
            }
            case CLOB: {
                object = callableStatement.getClob(n2);
                break;
            }
            case OBJECT: {
                object = callableStatement.getObject(n2);
            }
        }
        return object;
    }

    private Method getMethodWithParmsForClass(Class clazz) throws PrivilegedActionException, SecurityException, NoSuchMethodException {
        if (DataProperties.runningUnderSecurityManager_) {
            return AccessController.doPrivileged(BaseStoredProcedureResult.getMethodWithParms(clazz, "get", SHORT_SET_PARAMS));
        }
        return BaseStoredProcedureResult.getMethodWithParmsNoSM(clazz, "get", SHORT_SET_PARAMS);
    }

    private static Method getMethodWithParmsNoSM(Class clazz, String string, Class[] classArray) throws SecurityException, NoSuchMethodException {
        return clazz.getMethod(string, classArray);
    }

    private static final PrivilegedExceptionAction<Method> getMethodWithParms(final Class clazz, final String string, final Class[] classArray) {
        return new PrivilegedExceptionAction<Method>(){

            @Override
            public Method run() throws NoSuchMethodException {
                return BaseStoredProcedureResult.getMethodWithParmsNoSM(clazz, string, classArray);
            }
        };
    }
}

