/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.util.ChartUtils;
import com.jidesoft.gauge.AbstractIndicatorRenderer;
import com.jidesoft.gauge.Bullet;
import com.jidesoft.gauge.BulletAxis;
import com.jidesoft.gauge.BulletAxisPlacement;
import com.jidesoft.gauge.IndicatorStyle;
import com.jidesoft.gauge.PointerIndicatorPlacement;
import com.jidesoft.gauge.PointerLabelPlacement;
import com.jidesoft.swing.ShadowRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import javax.swing.UIManager;

public class PointerIndicatorRenderer
extends AbstractIndicatorRenderer<Bullet> {
    private static final double \u0123 = 0.15;
    private static final double \u0121 = 0.15;
    private double \u0122 = 0.15;
    private double \u0124 = 0.15;
    private PointerIndicatorPlacement \u0120 = PointerIndicatorPlacement.LEADING_INSIDE;
    private PointerLabelPlacement \u011f = PointerLabelPlacement.ABOVE;

    public PointerIndicatorRenderer() {
    }

    public PointerIndicatorRenderer(PointerIndicatorPlacement pointerIndicatorPlacement) {
        this();
        this.setPointerPlacement(pointerIndicatorPlacement);
    }

    public double getPointerBreadth() {
        return this.\u0122;
    }

    public void setPointerBreadth(double d2) {
        this.\u0122 = d2;
    }

    public double getPointerLength() {
        return this.\u0124;
    }

    public void setPointerLength(double d2) {
        this.\u0124 = d2;
    }

    public BulletAxisPlacement getAxisPlacement() {
        switch (this.\u0120) {
            case LEADING_INSIDE: 
            case LEADING_OUTSIDE: {
                return BulletAxisPlacement.LEADING;
            }
            case TRAILING_INSIDE: 
            case TRAILING_OUTSIDE: {
                return BulletAxisPlacement.TRAILING;
            }
        }
        throw new IllegalStateException("Unexpected pointer placement: " + (Object)((Object)this.\u0120));
    }

    public void setAxisPlacement(BulletAxisPlacement bulletAxisPlacement) {
        if (bulletAxisPlacement == BulletAxisPlacement.LEADING) {
            this.setPointerPlacement(PointerIndicatorPlacement.LEADING_INSIDE);
        } else if (bulletAxisPlacement == BulletAxisPlacement.TRAILING) {
            this.setPointerPlacement(PointerIndicatorPlacement.TRAILING_INSIDE);
        } else {
            throw new IllegalArgumentException("Unexpected BulletAxisPlacement: " + (Object)((Object)bulletAxisPlacement));
        }
    }

    public PointerIndicatorPlacement getPointerPlacement() {
        return this.\u0120;
    }

    public void setPointerPlacement(PointerIndicatorPlacement pointerIndicatorPlacement) {
        if (pointerIndicatorPlacement == null) {
            throw new IllegalArgumentException("PointerPlacement cannot be null");
        }
        this.\u0120 = pointerIndicatorPlacement;
    }

    public PointerLabelPlacement getLabelPlacement() {
        return this.\u011f;
    }

    public void setLabelPlacement(PointerLabelPlacement pointerLabelPlacement) {
        this.\u011f = pointerLabelPlacement;
    }

    private double[] \u0101(Bullet bullet, Double d2) {
        Orientation orientation = bullet.getOrientation();
        BulletAxis bulletAxis = bullet.getAxis();
        double d3 = bullet.calculatePixelCoordinate(bulletAxis, d2);
        double d4 = bullet.getBulletBreadth();
        double d5 = bullet.getMidY();
        double d6 = bullet.getMidX();
        double d7 = this.\u0122 * d4;
        double d8 = this.\u0124 * d4;
        return this.\u0101(orientation, d3, d6, d5, d4, d7, d8);
    }

    private double[] \u0101(Orientation orientation, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8;
        double d9;
        double d10;
        double d11;
        block13: {
            double d12;
            double d13;
            block12: {
                double d14 = d4 - d5 / 2.0;
                double d15 = d4 + d5 / 2.0;
                d13 = d3 - d5 / 2.0;
                d12 = d3 + d5 / 2.0;
                if (orientation != Orientation.horizontal) break block12;
                d11 = d2 - d6 / 2.0;
                d10 = d2 + d6 / 2.0;
                switch (this.\u0120) {
                    case LEADING_INSIDE: {
                        d9 = d15 - d7 - 1.0;
                        d8 = d15 - 1.0;
                        break block13;
                    }
                    case LEADING_OUTSIDE: {
                        d9 = d15 + 1.0;
                        d8 = d15 + 1.0 + d7;
                        break block13;
                    }
                    case TRAILING_INSIDE: {
                        d9 = d14 + 1.0;
                        d8 = d14 + d7 + 1.0;
                        break block13;
                    }
                    case TRAILING_OUTSIDE: {
                        d9 = d14 - 1.0 - d7;
                        d8 = d14 - 1.0;
                        break block13;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected pointer placement: " + (Object)((Object)this.\u0120));
                    }
                }
            }
            d9 = d2 - d6 / 2.0;
            d8 = d2 + d6 / 2.0;
            switch (this.\u0120) {
                case LEADING_INSIDE: {
                    d11 = d13 + 1.0;
                    d10 = d13 + 1.0 + d7;
                    break;
                }
                case LEADING_OUTSIDE: {
                    d11 = d13 - 1.0 - d7;
                    d10 = d13 - 1.0;
                    break;
                }
                case TRAILING_INSIDE: {
                    d11 = d12 - d7 - 1.0;
                    d10 = d12 - 1.0;
                    break;
                }
                case TRAILING_OUTSIDE: {
                    d11 = d12 + 1.0;
                    d10 = d12 + 1.0 + d7;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected pointer placement: " + (Object)((Object)this.\u0120));
                }
            }
        }
        return new double[]{d11, d10, d9, d8};
    }

    @Override
    protected Shape calculateShape(Bullet bullet, Double d2) {
        BulletAxis bulletAxis = bullet.getAxis();
        double d3 = bullet.calculatePixelCoordinate(bulletAxis, d2);
        double[] dArray = this.\u0101(bullet, d2);
        Orientation orientation = bullet.getOrientation();
        return this.calculateShape(orientation, d3, dArray);
    }

    protected Shape calculateShape(Orientation orientation, double d2, double[] dArray) {
        int[] nArray;
        int[] nArray2;
        block13: {
            double d3;
            double d4;
            double d5;
            double d6;
            block12: {
                d6 = dArray[0];
                d5 = dArray[1];
                d4 = dArray[2];
                d3 = dArray[3];
                if (orientation != Orientation.horizontal) break block12;
                nArray2 = new int[]{(int)d2, (int)d6, (int)d5};
                switch (this.\u0120) {
                    case LEADING_INSIDE: {
                        nArray = new int[]{(int)d3, (int)d4, (int)d4};
                        break block13;
                    }
                    case LEADING_OUTSIDE: {
                        nArray = new int[]{(int)d4, (int)d3, (int)d3};
                        break block13;
                    }
                    case TRAILING_INSIDE: {
                        nArray = new int[]{(int)d4, (int)d3, (int)d3};
                        break block13;
                    }
                    case TRAILING_OUTSIDE: {
                        nArray = new int[]{(int)d3, (int)d4, (int)d4};
                        break block13;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected pointer placement: " + (Object)((Object)this.\u0120));
                    }
                }
            }
            nArray = new int[]{(int)d2, (int)d4, (int)d3};
            switch (this.\u0120) {
                case LEADING_INSIDE: {
                    nArray2 = new int[]{(int)d6, (int)d5, (int)d5};
                    break;
                }
                case LEADING_OUTSIDE: {
                    nArray2 = new int[]{(int)d5, (int)d6, (int)d6};
                    break;
                }
                case TRAILING_INSIDE: {
                    nArray2 = new int[]{(int)d5, (int)d6, (int)d6};
                    break;
                }
                case TRAILING_OUTSIDE: {
                    nArray2 = new int[]{(int)d6, (int)d5, (int)d5};
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected pointer placement: " + (Object)((Object)this.\u0120));
                }
            }
        }
        return new Polygon(nArray2, nArray, 3);
    }

    @Override
    protected void drawIndicator(Graphics2D graphics2D, Bullet bullet, Shape shape, IndicatorStyle indicatorStyle) {
        double d2 = bullet.getBulletBreadth();
        this.drawIndicator(graphics2D, d2, shape, indicatorStyle);
    }

    @Override
    protected void drawIndicator(Graphics2D graphics2D, double d2, Shape shape, IndicatorStyle indicatorStyle) {
        if (shape == null) {
            return;
        }
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        graphics2D2.setPaint(indicatorStyle.getFill());
        graphics2D2.fill(shape);
        graphics2D2.draw(shape);
        Color color = indicatorStyle.getOutline();
        if (color != null) {
            Color color2 = graphics2D2.getColor();
            Stroke stroke = graphics2D2.getStroke();
            float f2 = indicatorStyle.getOutlineWidth();
            float f3 = (float)((double)f2 * d2 / 100.0);
            if (f3 < 1.0f) {
                f3 = 1.0f;
            }
            BasicStroke basicStroke = new BasicStroke(f3);
            graphics2D2.setStroke(basicStroke);
            graphics2D2.setColor(color);
            graphics2D2.draw(shape);
            graphics2D2.setColor(color2);
            graphics2D2.setStroke(stroke);
        }
        graphics2D2.dispose();
    }

    @Override
    public void paintLabel(Graphics2D graphics2D, Bullet bullet, Double d2, IndicatorStyle indicatorStyle) {
        String string = this.generateLabel(d2);
        if (string != null && this.\u011f != null && this.labelVisible) {
            Orientation orientation = bullet.getOrientation();
            Font font = this.getLabelFont() == null ? UIManager.getFont("Label.font") : this.getLabelFont();
            Dimension dimension = bullet.getFontComparisonSize();
            Font font2 = ChartUtils.deriveResizedFont(font, dimension, bullet);
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font2);
            int n2 = fontMetrics.stringWidth("o");
            int n3 = fontMetrics.stringWidth(string);
            Float f2 = null;
            Float f3 = null;
            double[] dArray = this.\u0101(bullet, d2);
            double d3 = dArray[0];
            double d4 = dArray[1];
            double d5 = dArray[2];
            double d6 = dArray[3];
            if (orientation == Orientation.horizontal) {
                if (this.\u011f == PointerLabelPlacement.ABOVE) {
                    f2 = Float.valueOf((float)((d3 + d4) / 2.0 - (double)n3 / 2.0));
                    f3 = Float.valueOf((float)(d5 - (double)fontMetrics.getDescent()));
                } else if (this.\u011f == PointerLabelPlacement.BELOW) {
                    f2 = Float.valueOf((float)((d3 + d4) / 2.0 - (double)n3 / 2.0));
                    f3 = Float.valueOf((float)(d6 + (double)fontMetrics.getAscent()));
                } else if (this.\u011f == PointerLabelPlacement.LEFT) {
                    f2 = Float.valueOf((float)(d3 + 0.25 * (d4 - d3) - (double)n2 / 2.0 - (double)n3));
                    f3 = Float.valueOf((float)(d6 + d5) / 2.0f + (float)fontMetrics.getAscent() / 2.0f);
                } else if (this.\u011f == PointerLabelPlacement.RIGHT) {
                    f2 = Float.valueOf((float)(d3 + 0.75 * (d4 - d3) + (double)((float)n2 / 2.0f)));
                    f3 = Float.valueOf((float)(d6 + d5) / 2.0f + (float)fontMetrics.getAscent() / 2.0f);
                }
            } else if (this.\u011f == PointerLabelPlacement.ABOVE) {
                f2 = Float.valueOf((float)((d3 + d4) / 2.0 - (double)((float)n3 / 2.0f)));
                f3 = Float.valueOf((float)(d5 - (double)fontMetrics.getDescent()));
            } else if (this.\u011f == PointerLabelPlacement.BELOW) {
                f2 = Float.valueOf((float)((d3 + d4) / 2.0 - (double)((float)n3 / 2.0f)));
                f3 = Float.valueOf((float)(d6 + (double)fontMetrics.getAscent()));
            } else if (this.\u011f == PointerLabelPlacement.LEFT) {
                f2 = Float.valueOf((float)(d3 - (double)((float)n2 / 2.0f) - (double)n3));
                f3 = Float.valueOf((float)((d6 + d5) / 2.0 + (double)((float)(fontMetrics.getAscent() + fontMetrics.getDescent()) / 2.0f) - (double)fontMetrics.getDescent()));
            } else if (this.\u011f == PointerLabelPlacement.RIGHT) {
                f2 = Float.valueOf((float)(d4 + (double)((float)n2 / 2.0f)));
                f3 = Float.valueOf((float)((d6 + d5) / 2.0 + (double)((float)(fontMetrics.getAscent() + fontMetrics.getDescent()) / 2.0f) - (double)fontMetrics.getDescent()));
            }
            if (f2 != null && f3 != null) {
                Color color = this.getLabelColor();
                graphics2D.setColor(color == null ? Color.BLACK : color);
                graphics2D.setFont(font2);
                graphics2D.drawString(string, f2.floatValue(), f3.floatValue());
            }
        }
    }

    @Override
    public Shape paintLegendItem(Graphics graphics, Bullet bullet, IndicatorStyle indicatorStyle, int n2, int n3) {
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        BulletAxis bulletAxis = bullet.getAxis();
        double d2 = bulletAxis.minimum();
        Orientation orientation = bullet.getOrientation();
        double d3 = bullet.calculatePixelCoordinate(bulletAxis, d2);
        double d4 = 10.0;
        double d5 = d4 / 0.15;
        double d6 = 0.15 * d5;
        double[] dArray = this.\u0101(orientation, d3, 0.0, 0.0, d5, d6, d4);
        Shape shape = this.calculateShape(orientation, d3, dArray);
        Rectangle rectangle = shape.getBounds();
        graphics2D.translate(-rectangle.x, -rectangle.y);
        this.drawIndicator(graphics2D, d5, shape, indicatorStyle);
        int n4 = n2 / 2 - rectangle.width / 2;
        int n5 = n3 / 2 - rectangle.height / 2;
        ShadowRenderer shadowRenderer = this.getShadowRenderer();
        if (bullet.isShadowVisible()) {
            BufferedImage bufferedImage2 = shadowRenderer.createShadow(bufferedImage);
            graphics.drawImage(bufferedImage2, n4, n5, bullet);
        }
        graphics.drawImage(bufferedImage, n4, n5, bullet);
        graphics2D.translate(rectangle.x, rectangle.y);
        graphics2D.dispose();
        return null;
    }
}

