/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tooltip;

import com.jidesoft.popup.JidePopup;
import com.jidesoft.tooltip.BalloonShape;
import com.jidesoft.tooltip.BalloonTipUI;
import com.jidesoft.tooltip.ShadowSettings;
import com.jidesoft.tooltip.ShadowStyle;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;

public class BalloonTip
extends JToolTip {
    transient JidePopup \u0105;
    private BalloonShape \u0101;
    private ShadowStyle \u0103;
    private ShadowSettings \u0104 = new ShadowSettings();
    private Component \u0102;

    public BalloonTip() {
        this.updateUI();
    }

    @Override
    public void updateUI() {
        this.setUI(new BalloonTipUI(this));
    }

    public Dimension getContentSize() {
        return this.\u0102.getSize();
    }

    public Dimension getBalloonSize() {
        return ((BalloonTipUI)this.getUI()).getBalloonSize();
    }

    public Dimension getBalloonPreferredSize() {
        return ((BalloonTipUI)this.getUI()).getBalloonPreferredSize();
    }

    public Point getHotSpot() {
        return ((BalloonTipUI)this.getUI()).getHotSpot();
    }

    public Dimension getShadowSize() {
        return ((BalloonTipUI)this.getUI()).\u0101();
    }

    public BalloonTip(Component component) {
        this();
        this.setContent(component);
    }

    public void setContent(Component component) {
        this.\u0102 = component;
        ((BalloonTipUI)this.getUI()).setContent(component);
    }

    @Override
    public boolean isVisible() {
        return this.\u0105 != null && this.\u0105.isPopupVisible();
    }

    public void show(JComponent jComponent, int n2, int n3) {
        if (this.isVisible()) {
            this.\u0105.hidePopupImmediately();
        }
        this.\u0105 = this.createPopup();
        this.\u0105.setOwner(jComponent);
        this.customizePopup(this.\u0105);
        Point point = null;
        if (this.getBalloonShape() != null) {
            this.doLayout();
            point = this.getHotSpot();
            n2 -= point.x;
            n3 -= point.y;
        }
        Point point2 = new Point(n2, n3);
        SwingUtilities.convertPointToScreen(point2, jComponent);
        this.\u0105.getContentPane().setLayout(new BorderLayout());
        this.\u0105.getContentPane().add(this);
        this.\u0105.showPopup(point2.x, point2.y, jComponent);
        if (this.getBalloonShape() != null) {
            Point point3 = this.getHotSpot();
            if (point != null && (point3.x != point.x || point3.y != point.y)) {
                this.\u0105.showPopup(point2.x - point3.x + point.x, point2.y - point3.y + point.y, jComponent);
            }
        }
    }

    protected JidePopup createPopup() {
        return new JidePopup(){

            @Override
            public boolean isClickOnPopup(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                Point point2 = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, BalloonTip.this.getContent().getParent());
                return BalloonTip.this.getContent().getParent().contains(point2);
            }
        };
    }

    protected void customizePopup(JidePopup jidePopup) {
        jidePopup.setPopupType(0);
        jidePopup.setTransient(true);
        jidePopup.setPopupBorder(BorderFactory.createEmptyBorder());
        jidePopup.setOpaque(false);
        ((JComponent)jidePopup.getContentPane()).setOpaque(false);
    }

    @Override
    public void hide() {
        if (this.isVisible()) {
            this.\u0105.hidePopupImmediately();
            this.\u0105 = null;
        }
    }

    public BalloonShape getBalloonShape() {
        return this.\u0101;
    }

    public void setBalloonShape(BalloonShape balloonShape) {
        this.\u0101 = balloonShape;
    }

    public Component getContent() {
        return this.\u0102;
    }

    public ShadowStyle getShadowStyle() {
        return this.\u0103;
    }

    public void setShadowStyle(ShadowStyle shadowStyle) {
        this.\u0103 = shadowStyle;
    }

    public ShadowSettings getShadowSettings() {
        return this.\u0104;
    }

    public void setShadowSettings(ShadowSettings shadowSettings) {
        this.\u0104 = shadowSettings;
    }

    public void paintBalloonBackground(Graphics2D graphics2D, Shape shape) {
        graphics2D.setColor(this.getBackground());
        graphics2D.fill(shape);
    }

    public void paintBalloonForeground(Graphics2D graphics2D, Shape shape) {
        graphics2D.setColor(this.getForeground());
        graphics2D.draw(shape);
    }

    public void packPopup() {
        if (this.\u0105 != null) {
            this.\u0105.packPopup();
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(2)) {
            Lm.showInvalidProductMessage(BalloonTip.class.getName(), 2);
        }
    }
}

