/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.PeriodHeaderPainter;
import com.jidesoft.plaf.ScaleAreaUI;
import com.jidesoft.plaf.basic.BasicPeriodHeaderPainter;
import com.jidesoft.scale.Period;
import com.jidesoft.scale.ScaleArea;
import com.jidesoft.scale.ScaleAreaPopupMenuCustomizer;
import com.jidesoft.scale.ScaleModel;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DimensionUIResource;

public class BasicScaleAreaUI
extends ScaleAreaUI {
    public static final String UI_PERIOD_HEADER_PAINTER = "ScaleArea.periodHeaderPainter";
    public static final String UI_MOUSE_DRAG_RESIZABLE = "ScaleAreaUI.mouseDragResizable";
    private ScaleArea<Object> \u0104;
    private Handler \u0103;
    private int \u0106 = 27;
    private int \u0102 = 21;
    private long \u0101 = 0L;
    private double \u0105 = 1.0;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicScaleAreaUI();
    }

    protected ScaleArea<Object> getScaleArea() {
        return this.\u0104;
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.\u0104 = (ScaleArea)jComponent;
        this.installDefaults(this.\u0104);
        this.installListeners(this.\u0104);
        this.recalculateScale(this.\u0104);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners(this.\u0104);
        this.uninstallDefaults(this.\u0104);
        this.\u0104 = null;
    }

    protected void installDefaults(ScaleArea<Object> scaleArea) {
        PeriodHeaderPainter periodHeaderPainter = (PeriodHeaderPainter)UIManager.get(UI_PERIOD_HEADER_PAINTER);
        if (periodHeaderPainter == null) {
            periodHeaderPainter = this.createDefaultPeriodHeaderPainter(scaleArea);
        }
        scaleArea.setPeriodHeaderPainter(periodHeaderPainter);
    }

    protected PeriodHeaderPainter createDefaultPeriodHeaderPainter(ScaleArea<Object> scaleArea) {
        return new BasicPeriodHeaderPainter();
    }

    protected void uninstallDefaults(ScaleArea<Object> scaleArea) {
    }

    protected void installListeners(ScaleArea<Object> scaleArea) {
        this.\u0103 = this.createHandler();
        scaleArea.addPropertyChangeListener(this.\u0103);
        scaleArea.addMouseListener(this.\u0103);
        scaleArea.addMouseMotionListener(this.\u0103);
    }

    protected Handler createHandler() {
        return new Handler(this);
    }

    protected void uninstallListeners(ScaleArea<Object> scaleArea) {
        scaleArea.removeMouseMotionListener(this.\u0103);
        scaleArea.removeMouseListener(this.\u0103);
        scaleArea.removePropertyChangeListener(this.\u0103);
        this.\u0103 = null;
    }

    protected void paintBackground(Graphics graphics, ScaleArea<Object> scaleArea) {
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(scaleArea.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        ScaleArea scaleArea = (ScaleArea)jComponent;
        this.paintBackground(graphics, scaleArea);
        scaleArea.getPeriodHeaderPainter().paintPeriodHeaders(scaleArea, graphics);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        int n2;
        ScaleArea scaleArea = (ScaleArea)jComponent;
        ScaleModel scaleModel = scaleArea.getScaleModel();
        Dimension dimension = scaleArea.getPreferredPeriodSize();
        int n3 = scaleArea.getVisiblePeriods().size();
        int n4 = n3 * dimension.height;
        if (scaleModel != null) {
            n2 = this.getLeftToRightX(scaleModel.getPosition(scaleArea.getEnd())) - this.getLeftToRightX(scaleModel.getPosition(scaleArea.getStart()));
        } else {
            n4 = dimension.height;
            n2 = dimension.width;
        }
        if (n2 == Integer.MAX_VALUE) {
            n2 = 2147482647;
        }
        return new DimensionUIResource(n2 += scaleArea.getPeriodMargin() * 2, n4);
    }

    protected void recalculateScale(ScaleArea<Object> scaleArea) {
        ScaleModel<Object> scaleModel = scaleArea.getScaleModel();
        if (scaleModel != null) {
            Object object = scaleArea.getStart();
            this.\u0101 = scaleModel.getPosition(object);
            Period period = scaleArea.getSmallestVisiblePeriod();
            Object object2 = scaleModel.getPeriodStart(period, object);
            Object object3 = scaleModel.getPeriodEnd(period, object);
            long l2 = scaleModel.getPosition(object3) - scaleModel.getPosition(object2);
            this.\u0105 = (double)scaleArea.getPreferredPeriodSize().width / (double)l2;
        } else {
            this.\u0101 = 0L;
            this.\u0105 = 1.0;
        }
    }

    @Override
    public long getPositionAt(int n2) {
        if (!this.\u0104.getComponentOrientation().isLeftToRight()) {
            n2 = this.\u0104.getWidth() - n2;
        }
        int n3 = this.\u0104.getPeriodMargin();
        long l2 = (long)Math.floor((double)(n2 - n3) / this.\u0105);
        return l2 + this.\u0101;
    }

    @Override
    public int getX(long l2) {
        int n2 = this.getLeftToRightX(l2);
        if (this.\u0104.getComponentOrientation().isLeftToRight()) {
            return n2;
        }
        return this.\u0104.getWidth() - n2;
    }

    protected int getLeftToRightX(long l2) {
        int n2 = this.\u0104.getPeriodMargin();
        return n2 + (int)Math.round((double)(l2 - this.\u0101) * this.\u0105);
    }

    protected void setPreferredPeriodSize(Dimension dimension) {
        this.\u0106 = dimension.width;
        this.\u0102 = dimension.height;
        this.\u0104.revalidate();
    }

    @Override
    public Dimension getPreferredPeriodSize(Period period) {
        return new DimensionUIResource(this.\u0106, this.\u0102);
    }

    @Override
    public Period getPeriodAt(int n2) {
        if (n2 < 0 || n2 >= this.\u0104.getHeight()) {
            return null;
        }
        int n3 = (this.\u0104.getHeight() - n2) / this.\u0104.getPreferredPeriodSize().height;
        List<Period> list = this.\u0104.getVisiblePeriods();
        if (n3 >= 0 && n3 < list.size()) {
            return list.get(n3);
        }
        return null;
    }

    protected static class Handler
    implements PropertyChangeListener,
    MouseListener,
    MouseMotionListener {
        protected static final Set<String> SCALE_PROPERTIES = new HashSet<String>(Arrays.asList("scaleModel", "scaleStart", "scaleEnd", "visiblePeriods", "preferredPeriodSize", "periodMargin"));
        protected static final int MINIMUM_PERIOD_WIDTH = 10;
        protected static final int AREA_SIZE_RESIZE = 2;
        protected static final int NONE = 0;
        protected static final int RESIZE_PERIOD = 1;
        protected final BasicScaleAreaUI _ui;
        protected final boolean _resizable;
        private int \u0102 = 0;
        private Point \u0103;
        private int \u0101;

        public Handler(BasicScaleAreaUI basicScaleAreaUI) {
            this._ui = basicScaleAreaUI;
            this._resizable = UIManager.getBoolean(BasicScaleAreaUI.UI_MOUSE_DRAG_RESIZABLE);
        }

        protected int getCurrentAction() {
            return this.\u0102;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (SCALE_PROPERTIES.contains(propertyChangeEvent.getPropertyName())) {
                this._ui.recalculateScale((ScaleArea)propertyChangeEvent.getSource());
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                this.\u0103 = mouseEvent.getPoint();
                this.\u0101 = this._ui.getScaleArea().getPreferredPeriodSize().width;
            }
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                this.\u0103 = null;
            }
            this.maybeShowPopup(mouseEvent);
        }

        protected void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                JidePopupMenu jidePopupMenu = new JidePopupMenu();
                ScaleArea scaleArea = (ScaleArea)mouseEvent.getComponent();
                Period period = scaleArea.getUI().getPeriodAt(mouseEvent.getY());
                Object t2 = scaleArea.getInstantAt(mouseEvent.getX());
                for (ScaleAreaPopupMenuCustomizer scaleAreaPopupMenuCustomizer : scaleArea.getPopupMenuCustomizers()) {
                    JideSwingUtilities.addSeparatorIfNecessary(jidePopupMenu);
                    scaleAreaPopupMenuCustomizer.customizePopup(jidePopupMenu, scaleArea, period, t2);
                }
                if (jidePopupMenu.getComponentCount() > 0) {
                    Object object = scaleArea.getPopupLocation(mouseEvent);
                    if (object == null) {
                        object = mouseEvent.getPoint();
                    }
                    jidePopupMenu.show(scaleArea, ((Point)object).x, ((Point)object).y);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (!this._resizable) {
                return;
            }
            Point point = mouseEvent.getPoint();
            Period period = this._ui.getPeriodAt(point.y);
            ScaleArea<Object> scaleArea = this._ui.getScaleArea();
            Period period2 = scaleArea.getSmallestVisiblePeriod();
            if (period2 == period) {
                ScaleModel<Object> scaleModel = scaleArea.getScaleModel();
                long l2 = this._ui.getPositionAt(point.x);
                Object object = scaleModel.getInstantAt(l2);
                long l3 = scaleModel.getPosition(scaleModel.getPeriodStart(period, object));
                int n2 = this._ui.getX(l3);
                long l4 = scaleModel.getPosition(scaleModel.getPeriodEnd(period, object));
                int n3 = this._ui.getX(l4);
                if (Math.abs(point.x - n2) - 1 <= 2 || Math.abs(point.x - n3) - 1 <= 2) {
                    this.\u0102 = 1;
                    scaleArea.setCursor(Cursor.getPredefinedCursor(10));
                } else {
                    this.\u0102 = 0;
                    scaleArea.setCursor(Cursor.getDefaultCursor());
                }
            } else {
                this.\u0102 = 0;
                scaleArea.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.\u0102 == 1 && this.\u0103 != null) {
                ScaleArea<Object> scaleArea = this._ui.getScaleArea();
                int n2 = scaleArea.getComponentOrientation().isLeftToRight() ? 1 : -1;
                int n3 = Math.max(10, this.\u0101 + n2 * (mouseEvent.getX() - this.\u0103.x));
                Dimension dimension = scaleArea.getPreferredPeriodSize();
                scaleArea.setPreferredPeriodSize(new Dimension(n3, dimension.height));
            }
        }
    }
}

