/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.event;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.DefaultChartModel;
import com.jidesoft.range.CombinedNumericRange;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Positionable;
import com.jidesoft.range.Range;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.List;

public class PanIndicator
implements Drawable {
    private Chart \u01c7;
    private Placement \u01c4;
    private Color \u01c8 = new Color(100, 100, 100, 150);
    private Color \u01c6 = new Color(200, 200, 200, 200);
    private int \u01c2 = 10;
    private int \u01c3 = 40;
    private static final int \u01c5 = 5;

    public PanIndicator(Chart chart, Placement placement) {
        this.\u01c7 = chart;
        this.\u01c4 = placement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CombinedNumericRange \u0106() {
        List<ChartModel> list = this.\u01c7.getModels();
        CombinedNumericRange combinedNumericRange = new CombinedNumericRange();
        List<ChartModel> list2 = list;
        synchronized (list2) {
            for (ChartModel chartModel : this.\u01c7.getModels()) {
                if (chartModel instanceof DefaultChartModel) {
                    combinedNumericRange.add(((DefaultChartModel)chartModel).getXRange());
                    continue;
                }
                combinedNumericRange.add(this.\u0103(chartModel));
            }
        }
        return combinedNumericRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Range<Double> \u0103(ChartModel chartModel) {
        Double d2 = Double.MAX_VALUE;
        Double d3 = Double.MIN_VALUE;
        ChartModel chartModel2 = chartModel;
        synchronized (chartModel2) {
            for (Chartable chartable : chartModel) {
                Positionable positionable = chartable.getX();
                if (positionable == null) continue;
                double d4 = positionable.position();
                if (d4 < d2) {
                    d2 = d4;
                }
                if (!(d4 > d3)) continue;
                d3 = d4;
            }
        }
        return new NumericRange(d2, d3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CombinedNumericRange \u0105() {
        List<ChartModel> list = this.\u01c7.getModels();
        CombinedNumericRange combinedNumericRange = new CombinedNumericRange();
        List<ChartModel> list2 = list;
        synchronized (list2) {
            for (ChartModel chartModel : this.\u01c7.getModels()) {
                if (chartModel instanceof DefaultChartModel) {
                    combinedNumericRange.add(((DefaultChartModel)chartModel).getYRange());
                    continue;
                }
                combinedNumericRange.add(this.\u0104(chartModel));
            }
        }
        return combinedNumericRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Range<Double> \u0104(ChartModel chartModel) {
        Double d2 = Double.MAX_VALUE;
        Double d3 = Double.MIN_VALUE;
        ChartModel chartModel2 = chartModel;
        synchronized (chartModel2) {
            for (Chartable chartable : chartModel) {
                Positionable positionable = chartable.getY();
                if (positionable == null) continue;
                double d4 = positionable.position();
                if (d4 < d2) {
                    d2 = d4;
                }
                if (!(d4 > d3)) continue;
                d3 = d4;
            }
        }
        return new NumericRange(d2, d3);
    }

    private void \u0101(Graphics2D graphics2D, Shape shape) {
        graphics2D.setColor(this.\u01c8);
        graphics2D.fill(shape);
        graphics2D.setColor(this.\u01c6);
        graphics2D.draw(shape);
    }

    @Override
    public void draw(Graphics graphics) {
        CombinedNumericRange combinedNumericRange;
        Graphics2D graphics2D = (Graphics2D)graphics;
        CombinedNumericRange combinedNumericRange2 = combinedNumericRange = this.\u01c4 == Placement.LEFT || this.\u01c4 == Placement.RIGHT ? this.\u0106() : this.\u0105();
        if (combinedNumericRange.rangeCount() == 0) {
            return;
        }
        Point point = new Point(this.\u01c7.getXStart(), this.\u01c7.getYStart());
        Point point2 = new Point(this.\u01c7.getXEnd(), this.\u01c7.getYEnd());
        Point2D point2D = this.\u01c7.calculateUserPoint(point);
        Point2D point2D2 = this.\u01c7.calculateUserPoint(point2);
        if (this.\u01c4 == Placement.LEFT) {
            int n2 = this.\u01c7.getXStart() + 5;
            int n3 = (point.y + point2.y) / 2;
            if (point2D != null && point2D.getX() > combinedNumericRange.minimum()) {
                Polygon polygon = new Polygon();
                polygon.addPoint(n2, n3);
                polygon.addPoint(n2 + this.\u01c2, n3 - this.\u01c3 / 2);
                polygon.addPoint(n2 + this.\u01c2, n3 + this.\u01c3 / 2);
                this.\u0101(graphics2D, polygon);
            }
        } else if (this.\u01c4 == Placement.RIGHT) {
            int n4 = this.\u01c7.getXEnd() - 5;
            int n5 = (point.y + point2.y) / 2;
            if (point2D2 != null && point2D2.getX() < combinedNumericRange.maximum()) {
                Polygon polygon = new Polygon();
                polygon.addPoint(n4, n5);
                polygon.addPoint(n4 - this.\u01c2, n5 - this.\u01c3 / 2);
                polygon.addPoint(n4 - this.\u01c2, n5 + this.\u01c3 / 2);
                this.\u0101(graphics2D, polygon);
            }
        } else if (this.\u01c4 == Placement.TOP) {
            int n6 = (this.\u01c7.getXEnd() + this.\u01c7.getXStart()) / 2;
            int n7 = this.\u01c7.getYEnd() + 5;
            if (point2D2.getY() < combinedNumericRange.maximum()) {
                Polygon polygon = new Polygon();
                polygon.addPoint(n6, n7);
                polygon.addPoint(n6 - this.\u01c3 / 2, n7 + this.\u01c2);
                polygon.addPoint(n6 + this.\u01c3 / 2, n7 + this.\u01c2);
                this.\u0101(graphics2D, polygon);
            }
        } else {
            int n8 = (this.\u01c7.getXEnd() + this.\u01c7.getXStart()) / 2;
            int n9 = this.\u01c7.getYStart() - 5;
            if (point2D.getY() > combinedNumericRange.minimum()) {
                Polygon polygon = new Polygon();
                polygon.addPoint(n8, n9);
                polygon.addPoint(n8 - this.\u01c3 / 2, n9 - this.\u01c2);
                polygon.addPoint(n8 + this.\u01c3 / 2, n9 - this.\u01c2);
                this.\u0101(graphics2D, polygon);
            }
        }
    }

    public static enum Placement {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

