/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.wizard;

import com.jidesoft.dialog.AbstractDialogPage;
import com.jidesoft.dialog.AbstractPage;
import com.jidesoft.dialog.BannerPanel;
import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.ButtonResources;
import com.jidesoft.dialog.PageList;
import com.jidesoft.dialog.StandardDialogPane;
import com.jidesoft.wizard.AbstractWizardPage;
import com.jidesoft.wizard.GraphicLeftPane;
import com.jidesoft.wizard.JavaHelpPane;
import com.jidesoft.wizard.JavaStepsPane;
import com.jidesoft.wizard.LeftPane;
import com.jidesoft.wizard.MacOSXStepsPane;
import com.jidesoft.wizard.StepsPane;
import com.jidesoft.wizard.WizardStyle;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;

public class WizardDialogPane
extends StandardDialogPane {
    private boolean _traditionalWizard = true;
    private PageList _pageList;
    private Dimension _contentSize;
    private int _leftPanelWidth;
    private AbstractDialogPage _currentPage;
    private AbstractDialogPage _nextPage;
    private List<AbstractPage> _visitedPages = new ArrayList<AbstractPage>();
    private JComponent _leftPanel;
    private JComponent _pagesPanel;
    private CardLayout _cardLayout;
    private JButton _backButton;
    private JButton _nextButton;
    private JButton _cancelButton;
    private JButton _finishButton;
    private AbstractAction _backAction;
    private AbstractAction _nextAction;
    private AbstractAction _cancelAction;
    private AbstractAction _finishAction;
    private StepsPane _stepsPane;
    private JavaHelpPane _helpPane;
    private Image _defaultGraphic;
    private PropertyChangeListener _currentPagePropertyListener = this.createCurrentPagePropertyListener();
    private boolean _stepsPaneNavigable = false;
    private static final Logger LOGGER_EVENT = Logger.getLogger(WizardDialogPane.class.getName());

    @Override
    public JComponent createBannerPanel() {
        BannerPanel bannerPanel = new BannerPanel("AAAAA", "AAAAAAA");
        bannerPanel.setBackground(WizardStyle.getColor("Wizard.bannerBackground"));
        if (WizardStyle.getStyle() == 0) {
            bannerPanel.setTitleFont(WizardStyle.getFont("Wizard.bannerTitleFont"));
        }
        bannerPanel.setPreferredSize(new Dimension(0, WizardStyle.getInt("Wizard.bannerHeight")));
        bannerPanel.setBorder(WizardStyle.getBorder("Wizard.bannerBorder"));
        return bannerPanel;
    }

    private PropertyChangeListener createCurrentPagePropertyListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WizardDialogPane.this.updateBannerPanel(propertyChangeEvent);
            }
        };
    }

    private void updateBannerPanel(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() instanceof AbstractDialogPage) {
            this.updateBannerPanel(this._bannerPanel, (AbstractDialogPage)propertyChangeEvent.getSource());
        }
    }

    protected void updateBannerPanel(JComponent jComponent, AbstractDialogPage abstractDialogPage) {
        if (jComponent instanceof BannerPanel) {
            BannerPanel bannerPanel = (BannerPanel)jComponent;
            bannerPanel.setTitle(abstractDialogPage.getTitle());
            bannerPanel.setTitleIcon((ImageIcon)abstractDialogPage.getIcon());
            bannerPanel.setSubtitle(abstractDialogPage.getDescription());
        }
    }

    @Override
    public JComponent createContentPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this._leftPanel = this.createLeftPanel();
        this._pagesPanel = this.createPagesPanel();
        if (this._leftPanel != null) {
            jPanel.add((Component)this._leftPanel, "Before");
        }
        jPanel.add((Component)this._pagesPanel, "Center");
        jPanel.setPreferredSize(this.getContentPreferredSize());
        this._leftPanel.setPreferredSize(new Dimension(this.getLeftPanePreferredWidth(), this.getContentPreferredSize().height));
        if (this._pageList.getPageCount() > 0) {
            this.setCurrentPage(this.getPossibleNextPage(), false, this);
        }
        return jPanel;
    }

    @Override
    public ButtonPanel createButtonPanel() {
        this.createActions();
        ButtonPanel buttonPanel = new ButtonPanel();
        this._backButton = new JButton();
        this._backButton.setName("BACK");
        this._nextButton = new JButton();
        this._nextButton.setName("NEXT");
        this._backButton.setAction(this._backAction);
        this._nextButton.setAction(this._nextAction);
        ResourceBundle resourceBundle = ButtonResources.getResourceBundle(this.getLocale());
        if (WizardStyle.getStyle() == 3) {
            this._backButton.setMnemonic(resourceBundle.getString("Button.goback.mnemonic").charAt(0));
            this._nextButton.setMnemonic(resourceBundle.getString("Button.continue.mnemonic").charAt(0));
        } else {
            this._backButton.setMnemonic(resourceBundle.getString("Button.back.mnemonic").charAt(0));
            this._nextButton.setMnemonic(resourceBundle.getString("Button.next.mnemonic").charAt(0));
        }
        buttonPanel.addButton((AbstractButton)this._backButton, "ALTERNATIVE");
        buttonPanel.addButton((AbstractButton)this._nextButton, "ALTERNATIVE");
        this._cancelButton = new JButton();
        this._cancelButton.setName("CANCEL");
        this._finishButton = new JButton();
        this._finishButton.setName("FINISH");
        buttonPanel.addButton((AbstractButton)this._finishButton, "ALTERNATIVE");
        buttonPanel.addButton((AbstractButton)this._cancelButton, "CANCEL");
        this._cancelButton.setAction(this._cancelAction);
        this._finishButton.setAction(this._finishAction);
        this._finishButton.setMnemonic(resourceBundle.getString("Button.finish.mnemonic").charAt(0));
        buttonPanel.setButtonGap(WizardStyle.getInt("Wizard.buttonGap"));
        buttonPanel.setGroupGap(WizardStyle.getInt("Wizard.buttonGroupGap"));
        buttonPanel.setButtonOrder(WizardStyle.getString("Wizard.buttonOrder"));
        buttonPanel.setOppositeButtonOrder(WizardStyle.getString("Wizard.buttonOppositeOrder"));
        buttonPanel.setMinButtonWidth(WizardStyle.getInt("Wizard.minButtonWidth"));
        this.setDefaultCancelAction(this._cancelButton.getAction());
        if (WizardStyle.getStyle() == 2) {
            buttonPanel.setBorder(BorderFactory.createCompoundBorder(this.getButtonBorder(), BorderFactory.createEmptyBorder(0, this.getLeftPanePreferredWidth(), 0, 0)));
        } else {
            buttonPanel.setBorder(this.getButtonBorder());
        }
        return buttonPanel;
    }

    private Border getButtonBorder() {
        return WizardStyle.getBorder("Wizard.buttonPanelBorder");
    }

    protected void createActions() {
        if (this._backAction == null) {
            this._backAction = new AbstractAction(ButtonResources.getResourceBundle(this.getLocale()).getString("Button.back")){
                private static final long serialVersionUID = 4385066302479498641L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (WizardDialogPane.this._visitedPages.size() > 0) {
                        WizardDialogPane.this.setCurrentPage((AbstractDialogPage)WizardDialogPane.this._visitedPages.get(WizardDialogPane.this._visitedPages.size() - 1), true, WizardDialogPane.this._backButton);
                    } else {
                        int n = WizardDialogPane.this._pageList.getPageIndexByFullTitle(WizardDialogPane.this._currentPage.getFullTitle());
                        if (n > 0) {
                            WizardDialogPane.this.setCurrentPage(WizardDialogPane.this._pageList.getPage(--n), true, WizardDialogPane.this._backButton);
                        }
                    }
                }
            };
        }
        if (this._nextAction == null) {
            this._nextAction = new AbstractAction(ButtonResources.getResourceBundle(this.getLocale()).getString("Button.next")){
                private static final long serialVersionUID = 7657535522410908942L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WizardDialogPane.this.setCurrentPage(null, false, WizardDialogPane.this._nextButton);
                }
            };
        }
        if (WizardStyle.getStyle() == 3) {
            this._backAction.putValue("Name", ButtonResources.getResourceBundle(this.getLocale()).getString("Button.goback"));
            this._nextAction.putValue("Name", ButtonResources.getResourceBundle(this.getLocale()).getString("Button.continue"));
        }
    }

    protected AbstractDialogPage getPossibleNextPage() {
        if (this._nextPage != null) {
            return this._nextPage;
        }
        int n = 0;
        if (this._currentPage != null) {
            n = this._pageList.getPageIndexByFullTitle(this._currentPage.getFullTitle());
            ++n;
        }
        if (n < this._pageList.getPageCount()) {
            return this._pageList.getPage(n);
        }
        return null;
    }

    public void setBackAction(AbstractAction abstractAction) {
        this._backAction = abstractAction;
        if (this._backButton != null) {
            this._backButton.setAction(abstractAction);
        }
    }

    public AbstractAction getBackAction() {
        return this._backAction;
    }

    public void setNextAction(AbstractAction abstractAction) {
        this._nextAction = abstractAction;
        if (this._nextButton != null) {
            this._nextButton.setAction(abstractAction);
        }
    }

    public AbstractAction getNextAction() {
        return this._nextAction;
    }

    public void setCancelAction(AbstractAction abstractAction) {
        if (abstractAction == null) {
            throw new IllegalArgumentException("cancelAction cannot be null");
        }
        this._cancelAction = abstractAction;
        this.setDefaultCancelAction(abstractAction);
        if (this._cancelButton != null) {
            this._cancelButton.setAction(abstractAction);
        }
    }

    public void setFinishAction(AbstractAction abstractAction) {
        if (abstractAction == null) {
            throw new IllegalArgumentException("finishAction cannot be null");
        }
        this._finishAction = abstractAction;
        if (this._finishButton != null) {
            this._finishButton.setAction(abstractAction);
        }
    }

    public AbstractAction getCancelAction() {
        return this._cancelAction;
    }

    public AbstractAction getFinishAction() {
        return this._finishAction;
    }

    protected JComponent createPagesPanel() {
        JPanel jPanel = new JPanel();
        this._cardLayout = new CardLayout();
        jPanel.setLayout(this._cardLayout);
        if (this._pageList == null) {
            throw new IllegalStateException("The page list is null. Please call setPageList before calling initComponents.");
        }
        for (int i = 0; i < this._pageList.getPageCount(); ++i) {
            AbstractDialogPage abstractDialogPage = this._pageList.getPage(i);
            jPanel.add((Component)abstractDialogPage, abstractDialogPage.getFullTitle());
        }
        return jPanel;
    }

    public void setPageList(PageList pageList) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < pageList.getPageCount(); ++i) {
            AbstractWizardPage abstractWizardPage = (AbstractWizardPage)pageList.getPage(i);
            abstractWizardPage.setOwner(this);
            if (hashMap.get(abstractWizardPage.getFullTitle()) != null) {
                throw new IllegalArgumentException("Page " + (i + 1) + " has a duplicated title '" + abstractWizardPage.getFullTitle() + "' with page " + (String)hashMap.get(abstractWizardPage.getFullTitle()) + ". All pages in the page list should have different titles.");
            }
            hashMap.put(abstractWizardPage.getFullTitle(), "" + (i + 1));
        }
        this._pageList = pageList;
    }

    public PageList getPageList() {
        return this._pageList;
    }

    public AbstractDialogPage getCurrentPage() {
        return this._currentPage;
    }

    public boolean setCurrentPage(String string) {
        return this._pageList != null && this.setCurrentPage(this._pageList.getPageByFullTitle(string), false);
    }

    protected boolean setCurrentPage(String string, boolean bl) {
        return this._pageList != null && this.setCurrentPage(this._pageList.getPageByFullTitle(string), bl);
    }

    protected boolean setCurrentPage(AbstractDialogPage abstractDialogPage, boolean bl) {
        return this.setCurrentPage(abstractDialogPage, bl, null);
    }

    public boolean closeCurrentPage() {
        return this.closeCurrentPage(null, this);
    }

    public boolean closeCurrentPage(Object object) {
        return this.closeCurrentPage(null, object);
    }

    protected boolean closeCurrentPage(AbstractDialogPage abstractDialogPage, Object object) {
        if (this._currentPage != null && !this._currentPage.equals(abstractDialogPage)) {
            this._currentPage.setAllowClosing(true);
            this._currentPage.firePageEvent(object, 3200);
            if (!this._currentPage.allowClosing()) {
                return false;
            }
            this._currentPage.firePageEvent(object, 3201);
            this._currentPage.removePropertyChangeListener(this._currentPagePropertyListener);
        }
        return true;
    }

    protected boolean setCurrentPage(AbstractDialogPage abstractDialogPage, boolean bl, Object object) {
        if (this._pagesPanel == null) {
            this.setNextPage(abstractDialogPage);
            return false;
        }
        if (!this.closeCurrentPage(abstractDialogPage, object)) {
            return false;
        }
        if (abstractDialogPage == null) {
            abstractDialogPage = this.getPossibleNextPage();
        }
        if (abstractDialogPage == null) {
            return true;
        }
        if (LOGGER_EVENT.isLoggable(Level.FINE) && this._pageList.getIndexOf(abstractDialogPage) < 0) {
            LOGGER_EVENT.fine("WizardDialogPane \" setCurrentPage should not set a page which is not an element of page list.");
        }
        if (this._traditionalWizard) {
            if (bl) {
                if (this._visitedPages.size() > 0) {
                    this._visitedPages.remove(this._visitedPages.size() - 1);
                }
            } else if (this._currentPage != null) {
                this._visitedPages.add(this._currentPage);
            }
        }
        this._currentPage = abstractDialogPage;
        if (this._currentPage.getParent() == null || this._currentPage.getParent() == this._pagesPanel) {
            this._pagesPanel.add((Component)this._currentPage, this._currentPage.getFullTitle());
            this._currentPage.addButtonListener(this.getButtonPanel());
        }
        if (this._currentPage instanceof AbstractWizardPage && ((AbstractWizardPage)this._currentPage).getOwner() == null) {
            ((AbstractWizardPage)this._currentPage).setOwner(this);
        }
        this._cardLayout.show(this._pagesPanel, this._currentPage.getFullTitle());
        if (this._currentPage instanceof AbstractWizardPage) {
            if (((AbstractWizardPage)this._currentPage).showBannerPane()) {
                this._currentPage.addPropertyChangeListener(this._currentPagePropertyListener);
                this.updateBannerPanel(this._bannerPanel, this._currentPage);
                if (this._bannerPanel != null) {
                    this._bannerPanel.setVisible(true);
                    this._bannerPanel.invalidate();
                }
            } else if (this._bannerPanel != null) {
                this._bannerPanel.setVisible(false);
            }
            this._leftPanel.removeAll();
            this._leftPanel.setLayout(new BorderLayout());
            AbstractWizardPage abstractWizardPage = (AbstractWizardPage)this._currentPage;
            int n = abstractWizardPage.getLeftPaneItems();
            if (n == 0) {
                this._leftPanel.setVisible(false);
            } else if (n == 1) {
                JComponent jComponent = this.createEmptyPane();
                this._leftPanel.setVisible(true);
                this._leftPanel.add((Component)jComponent, "Center");
            } else {
                Object object2;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                if ((n & 2) != 0) {
                    object2 = abstractWizardPage.getGraphic();
                    if (object2 != null) {
                        arrayList.add(new GraphicLeftPane((Image)object2));
                    } else {
                        JComponent jComponent = this.createGraphicPane();
                        if (jComponent != null) {
                            arrayList.add(jComponent);
                        }
                    }
                }
                if ((n & 0x10) != 0 && (object2 = abstractWizardPage.getCustomLeftPane()) != null) {
                    arrayList.add(object2);
                }
                if ((n & 4) != 0) {
                    this._stepsPane = (StepsPane)this.createStepsPane(abstractWizardPage.getSteps(), abstractWizardPage.getSelectedStepIndex());
                    if (this._stepsPane != null) {
                        arrayList.add(this._stepsPane);
                    }
                }
                if ((n & 8) != 0) {
                    object2 = this.createHelpPane();
                    if (object2 != null) {
                        arrayList.add(object2);
                    }
                    if (this._currentPage instanceof AbstractWizardPage) {
                        ((AbstractWizardPage)this._currentPage).setHelpText(((AbstractWizardPage)this._currentPage).getHelpText());
                    }
                }
                if (arrayList.size() > 1) {
                    object2 = this.createLeftTabbedPane();
                    for (JComponent jComponent : arrayList) {
                        ((Container)object2).add(jComponent);
                    }
                    this._leftPanel.setVisible(true);
                    this._leftPanel.add((Component)object2, "Center");
                    this._leftPanel.repaint();
                } else if (arrayList.size() == 1) {
                    this._leftPanel.setVisible(true);
                    this._leftPanel.add((Component)arrayList.get(0), "Center");
                    this._leftPanel.repaint();
                } else {
                    this._leftPanel.setVisible(false);
                }
            }
        }
        this._currentPage.firePageEvent(object, 3199);
        this._currentPage.focusDefaultFocusComponent();
        return true;
    }

    protected JComponent createLeftTabbedPane() {
        return new JTabbedPane(3, 1);
    }

    protected JComponent createStepsPane(List<String> list, int n) {
        StepsPane stepsPane = this.createStepsPane();
        stepsPane.setNavigable(this.isStepsPaneNavigable());
        stepsPane.setWizardDialogPane(this);
        stepsPane.setPageList(list);
        stepsPane.setSelectedIndex(n, false);
        return stepsPane;
    }

    protected StepsPane createStepsPane() {
        StepsPane stepsPane;
        if (WizardStyle.getStyle() == 3) {
            stepsPane = new MacOSXStepsPane();
        } else {
            stepsPane = new JavaStepsPane();
            stepsPane.setBackground(WizardStyle.getColor("Wizard.bannerBackground"));
        }
        return stepsPane;
    }

    protected JComponent createHelpPane() {
        this._helpPane = new JavaHelpPane();
        this._helpPane.setHelpText("");
        this._helpPane.setBackground(WizardStyle.getColor("Wizard.bannerBackground"));
        return this._helpPane;
    }

    private JComponent createLeftPanel() {
        return new JPanel(new BorderLayout());
    }

    public JComponent getLeftPanel() {
        return this._leftPanel;
    }

    public JComponent getPagesPanel() {
        return this._pagesPanel;
    }

    public int getLeftPanelWidth() {
        return this._leftPanelWidth;
    }

    public void setLeftPanelWidth(int n) {
        this._leftPanelWidth = n;
    }

    public Dimension getContentSize() {
        return this._contentSize;
    }

    public void setContentSize(Dimension dimension) {
        this._contentSize = dimension;
    }

    private Dimension getContentPreferredSize() {
        if (this.getContentSize() == null) {
            return this.getContentStandardSize();
        }
        return this.getContentSize();
    }

    private int getLeftPanePreferredWidth() {
        if (this.getLeftPanelWidth() <= 0) {
            return this.getStandardLeftPaneWidth();
        }
        return this.getLeftPanelWidth();
    }

    public Dimension getContentStandardSize() {
        return WizardStyle.getDimension("Wizard.standardSize");
    }

    public int getStandardLeftPaneWidth() {
        return WizardStyle.getInt("Wizard.standardLeftPaneWidth");
    }

    public Dimension getContentLargerSize() {
        return WizardStyle.getDimension("Wizard.largerSize");
    }

    public int getLargerLeftPaneWidth() {
        return WizardStyle.getInt("Wizard.largerLeftPaneWidth");
    }

    public AbstractDialogPage getPageByTitle(String string) {
        return this._pageList.getPageByFullTitle(string);
    }

    public AbstractDialogPage getNextPage() {
        return this._nextPage;
    }

    public void setNextPage(AbstractDialogPage abstractDialogPage) {
        this._nextPage = abstractDialogPage;
        if (LOGGER_EVENT.isLoggable(Level.FINE) && abstractDialogPage != null && this._pageList.getIndexOf(abstractDialogPage) < 0) {
            LOGGER_EVENT.fine("WizardDialogPane \" setNextPage should not set a page which is not an element of page list.");
        }
    }

    public List<AbstractPage> getVisitedPages() {
        return this._visitedPages;
    }

    public JComponent createGraphicPane() {
        if (this.getDefaultGraphic() != null) {
            return new GraphicLeftPane(this.getDefaultGraphic());
        }
        return null;
    }

    public JComponent createEmptyPane() {
        return new LeftPane();
    }

    public Image getDefaultGraphic() {
        return this._defaultGraphic;
    }

    public void setDefaultGraphic(Image image) {
        this._defaultGraphic = image;
    }

    public StepsPane getStepsPane() {
        return this._stepsPane;
    }

    public JavaHelpPane getHelpPane() {
        return this._helpPane;
    }

    public boolean isResizable() {
        return false;
    }

    public boolean isStepsPaneNavigable() {
        return this._stepsPaneNavigable;
    }

    public void setStepsPaneNavigable(boolean bl) {
        this._stepsPaneNavigable = bl;
    }
}

