/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tree;

import com.jidesoft.list.ListModelWrapper;
import com.jidesoft.swing.CheckBoxTreeSelectionModel;
import com.jidesoft.tree.FilterableTreeModel;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class FilterableCheckBoxTreeSelectionModel
extends CheckBoxTreeSelectionModel {
    private static final long serialVersionUID = -6441733809661075802L;

    public FilterableCheckBoxTreeSelectionModel(TreeModel treeModel) {
        super(treeModel);
    }

    public FilterableCheckBoxTreeSelectionModel(TreeModel treeModel, boolean bl) {
        super(treeModel, bl);
    }

    @Override
    protected void addSelectionPaths(TreePath[] treePathArray, boolean bl) {
        if (!this.isDigIn()) {
            super.addSelectionPaths(treePathArray, bl);
            return;
        }
        for (TreePath treePath : treePathArray) {
            if (!this.isNodeHasFilteredChild(treePath)) {
                super.addSelectionPaths(new TreePath[]{treePath}, bl);
                continue;
            }
            ListModelWrapper listModelWrapper = ((FilterableTreeModel)this.getModel()).getListModelWrapper(treePath.getLastPathComponent());
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            int n = defaultMutableTreeNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                if (listModelWrapper.getIndexAt(i) < 0) continue;
                TreePath treePath2 = treePath.pathByAddingChild(defaultMutableTreeNode.getChildAt(i));
                this.addSelectionPaths(new TreePath[]{treePath2}, bl);
            }
        }
    }

    @Override
    public void removeSelectionPaths(TreePath[] treePathArray) {
        if (!this.isDigIn()) {
            super.removeSelectionPaths(treePathArray);
            return;
        }
        for (TreePath treePath : treePathArray) {
            if (!this.isNodeHasFilteredChild(treePath)) {
                super.removeSelectionPaths(new TreePath[]{treePath});
                continue;
            }
            ListModelWrapper listModelWrapper = ((FilterableTreeModel)this.getModel()).getListModelWrapper(treePath.getLastPathComponent());
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            int n = defaultMutableTreeNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                if (listModelWrapper.getIndexAt(i) < 0) continue;
                TreePath treePath2 = treePath.pathByAddingChild(defaultMutableTreeNode.getChildAt(i));
                this.removeSelectionPaths(new TreePath[]{treePath2});
            }
        }
    }

    @Override
    public boolean isPartiallySelected(TreePath treePath) {
        if (!this.isDigIn()) {
            return super.isPartiallySelected(treePath);
        }
        boolean bl = super.isPartiallySelected(treePath);
        if (!bl && super.isPathSelected(treePath)) {
            return this.isNodeHasFilteredChild(treePath);
        }
        return bl;
    }

    @Override
    protected boolean isParentActuallySelected(TreePath treePath, TreePath treePath2) {
        return treePath2 != treePath || !this.isNodeHasFilteredChild(treePath2);
    }

    @Override
    protected boolean areSiblingsSelected(TreePath treePath) {
        return !this.isNodeHasFilteredChild(treePath.getParentPath()) && super.areSiblingsSelected(treePath);
    }

    @Override
    protected int getChildrenCount(Object object) {
        if (!(object instanceof DefaultMutableTreeNode) || !this.isNodeHasFilteredChild((DefaultMutableTreeNode)object)) {
            return super.getChildrenCount(object);
        }
        ListModelWrapper listModelWrapper = ((FilterableTreeModel)this.getModel()).getListModelWrapper(object);
        return listModelWrapper == null ? 0 : listModelWrapper.getActualModel().getSize();
    }

    @Override
    protected Object getChild(Object object, int n) {
        if (!(object instanceof DefaultMutableTreeNode) || !this.isNodeHasFilteredChild((DefaultMutableTreeNode)object)) {
            return super.getChild(object, n);
        }
        ListModelWrapper listModelWrapper = ((FilterableTreeModel)this.getModel()).getListModelWrapper(object);
        return listModelWrapper == null ? null : listModelWrapper.getActualModel().getElementAt(n);
    }

    private boolean isNodeHasFilteredChild(TreePath treePath) {
        return treePath != null && treePath.getLastPathComponent() instanceof DefaultMutableTreeNode && this.isNodeHasFilteredChild((DefaultMutableTreeNode)treePath.getLastPathComponent());
    }

    private boolean isNodeHasFilteredChild(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (this.getModel() instanceof FilterableTreeModel && defaultMutableTreeNode.getChildCount() > 0) {
            ListModelWrapper listModelWrapper = ((FilterableTreeModel)this.getModel()).getListModelWrapper(defaultMutableTreeNode);
            return listModelWrapper != null && listModelWrapper.getIndexes() != null && listModelWrapper.getIndexes().length != listModelWrapper.getActualModel().getSize();
        }
        return false;
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        if (!(this.getModel() instanceof FilterableTreeModel) || !((FilterableTreeModel)this.getModel()).isRefreshing()) {
            super.treeStructureChanged(treeModelEvent);
        }
    }
}

