/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tooltip.shapes;

import com.jidesoft.tooltip.BalloonShape;
import com.jidesoft.tooltip.BalloonTip;
import com.jidesoft.tooltip.shapes.RoundedRectangularShape;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;

public class RoundedRectangularBalloonShape
implements BalloonShape {
    protected int _cornerSize = 18;
    protected double _balloonSizeRatio = 0.75;
    protected double _arrowLeftRatio = 0.5;
    protected double _arrowRightRatio = 0.25;
    protected double _vertexPosition = 0.25;
    private int _position = 1;

    @Override
    public Shape createOutline(Dimension dimension, Dimension dimension2) {
        GeneralPath generalPath;
        int n = dimension.width;
        int n2 = dimension.height;
        switch (this._position) {
            case 3: {
                generalPath = this.createPathForTopBottom(dimension, this.getRoundedCornerSize());
                AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(180.0), n / 2, n2 / 2);
                generalPath.transform(affineTransform);
                break;
            }
            case 2: {
                generalPath = this.createPathForRightLeft(dimension, this.getRoundedCornerSize());
                break;
            }
            case 4: {
                generalPath = this.createPathForRightLeft(dimension, this.getRoundedCornerSize());
                AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(180.0), n / 2, n2 / 2);
                generalPath.transform(affineTransform);
                break;
            }
            default: {
                generalPath = this.createPathForTopBottom(dimension, this.getRoundedCornerSize());
            }
        }
        return generalPath;
    }

    protected int getRoundedCornerSize() {
        return this.getCornerSize();
    }

    private GeneralPath createPathForTopBottom(Dimension dimension, int n) {
        int n2 = dimension.width;
        int n3 = dimension.height;
        int n4 = (int)((double)n3 * this.getBalloonSizeRatio());
        int n5 = (int)((double)n2 * this.getArrowLeftRatio());
        int n6 = (int)((double)n2 * this.getArrowRightRatio());
        int n7 = (int)((double)n2 * this.getVertexPosition());
        int n8 = 1;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(n, n8);
        generalPath.lineTo(n2 - n - n8, n8);
        generalPath.curveTo(n2 - n - n8, n8, n2 - n8, n8, n2 - n8, n);
        generalPath.lineTo(n2 - n8, n4 - n - n8);
        generalPath.curveTo(n2 - n8, n4 - n - n8, n2 - n8, n4 - n8, n2 - n - n8, n4 - n8);
        generalPath.lineTo(n2 - n6, n4 - n8);
        generalPath.lineTo(n7, n3 - n8);
        generalPath.lineTo(n5, n4 - n8);
        generalPath.lineTo(n, n4 - n8);
        generalPath.curveTo(n, n4 - n8, n8, n4 - n8, n8, n4 - n - n8);
        generalPath.lineTo(n8, n - n8);
        generalPath.curveTo(n8, n - n8, n8, n8, n - n8, n8);
        generalPath.closePath();
        return generalPath;
    }

    private GeneralPath createPathForRightLeft(Dimension dimension, int n) {
        int n2 = dimension.width;
        int n3 = dimension.height;
        int n4 = (int)((double)n2 * this.getBalloonSizeRatio());
        int n5 = (int)((double)n3 * this.getArrowLeftRatio());
        int n6 = (int)((double)n3 * this.getArrowRightRatio());
        int n7 = (int)((double)n3 * this.getVertexPosition());
        int n8 = 1;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(n, n8);
        generalPath.lineTo(n4 - n - n8, n8);
        generalPath.curveTo(n4 - n - n8, n8, n4 - n8, n8, n4 - n8, n);
        generalPath.lineTo(n4 - n8, n5);
        generalPath.lineTo(n2 - n8, n7);
        generalPath.lineTo(n4 - n8, n3 - n6);
        generalPath.lineTo(n4 - n8, n3 - n);
        generalPath.curveTo(n4 - n8, n3 - n, n4 - n8, n3, n4 - n, n3 - n8);
        generalPath.lineTo(n, n3 - n8);
        generalPath.curveTo(n, n3 - n8, n8, n3 - n8, n8, n3 - n - n8);
        generalPath.lineTo(n8, n - n8);
        generalPath.curveTo(n8, n - n8, n8, n8, n - n8, n8);
        generalPath.closePath();
        return generalPath;
    }

    @Override
    public Point getHotSpot(Dimension dimension) {
        Point point;
        int n = dimension.width;
        int n2 = dimension.height;
        switch (this._position) {
            case 1: {
                int n3 = (int)((double)n * this.getVertexPosition());
                point = new Point(n3, n2);
                break;
            }
            case 3: {
                int n4 = (int)((double)n * (1.0 - this.getVertexPosition()));
                point = new Point(n4, 0);
                break;
            }
            case 2: {
                int n5 = (int)((double)n2 * this.getVertexPosition());
                point = new Point(n, n5);
                break;
            }
            case 4: {
                int n6 = (int)((double)n2 * (1.0 - this.getVertexPosition()));
                point = new Point(0, n6);
                break;
            }
            default: {
                int n7 = (int)((double)n * this.getVertexPosition());
                point = new Point(n7, n2);
            }
        }
        return point;
    }

    @Override
    public Insets getInsets(Dimension dimension) {
        Insets insets;
        int n = 2 * this.getCornerSize() + dimension.height;
        double d = (1.0 - this.getBalloonSizeRatio()) / this.getBalloonSizeRatio();
        int n2 = (int)((double)n * d) + this.getCornerSize();
        int n3 = 2 * this.getCornerSize() + dimension.width;
        double d2 = (1.0 - this.getBalloonSizeRatio()) / this.getBalloonSizeRatio();
        int n4 = (int)((double)n3 * d2) + this.getCornerSize();
        switch (this._position) {
            case 1: {
                insets = new Insets(this.getCornerSize(), this.getCornerSize(), n2, this.getCornerSize());
                break;
            }
            case 3: {
                insets = new Insets(n2, this.getCornerSize(), this.getCornerSize(), this.getCornerSize());
                break;
            }
            case 2: {
                insets = new Insets(this.getCornerSize(), this.getCornerSize(), this.getCornerSize(), n4);
                break;
            }
            case 4: {
                insets = new Insets(this.getCornerSize(), n4, this.getCornerSize(), this.getCornerSize());
                break;
            }
            default: {
                insets = new Insets(n2, this.getCornerSize(), this.getCornerSize(), this.getCornerSize());
            }
        }
        return insets;
    }

    @Override
    public double getEdgeDistance(Point point, BalloonTip balloonTip) {
        Dimension dimension = balloonTip.getBalloonSize();
        int n = point.x;
        int n2 = point.y;
        int n3 = dimension.width;
        int n4 = dimension.height;
        double d = 0.0;
        switch (this._position) {
            case 1: {
                int n5 = (int)((double)n4 * this.getBalloonSizeRatio());
                int n6 = (int)((double)n3 * this.getArrowLeftRatio());
                int n7 = (int)((double)n3 * this.getArrowRightRatio());
                int n8 = (int)((double)n3 * this.getVertexPosition());
                Rectangle rectangle = new Rectangle(0, 0, n3, n5);
                if (n2 < n5 - this.getCornerSize()) {
                    d = RoundedRectangularShape.getDistance(point, rectangle, this.getCornerSize());
                    break;
                }
                if (n2 < n5) {
                    if (n <= n6 || n >= n3 - n7) {
                        d = RoundedRectangularShape.getDistance(point, rectangle, this.getCornerSize());
                        break;
                    }
                    d = RoundedRectangularBalloonShape.getDistance(point, new Point(n6, n5), new Point(n3 - n7, n5), new Point(n8, n4), this.getCornerSize(), true);
                    break;
                }
                d = RoundedRectangularBalloonShape.getDistance(point, new Point(n6, n5), new Point(n3 - n7, n5), new Point(n8, n4), this.getCornerSize(), false);
                break;
            }
            case 3: {
                int n9 = (int)((double)n4 * this.getBalloonSizeRatio());
                int n10 = (int)((double)n3 * this.getArrowRightRatio());
                int n11 = (int)((double)n3 * this.getArrowLeftRatio());
                int n12 = n3 - (int)((double)n3 * this.getVertexPosition());
                Rectangle rectangle = new Rectangle(0, 0, n3, n9);
                int n13 = n4 - n9 + 1;
                if (n2 > n4 + this.getCornerSize() - n9) {
                    d = RoundedRectangularShape.getDistance(new Point(n, n2 - n13), rectangle, this.getCornerSize());
                    break;
                }
                if (n2 > n4 - n9) {
                    if (n <= n10 || n >= n3 - n11) {
                        d = RoundedRectangularShape.getDistance(new Point(n, n2 - n13), rectangle, this.getCornerSize());
                        break;
                    }
                    d = RoundedRectangularBalloonShape.getDistance(point, new Point(n10, n13), new Point(n3 - n11, n13), new Point(n12, 0), this.getCornerSize(), true);
                    break;
                }
                d = RoundedRectangularBalloonShape.getDistance(point, new Point(n10, n13), new Point(n3 - n11, n13), new Point(n12, 0), this.getCornerSize(), false);
                break;
            }
            case 2: {
                int n14 = (int)((double)n3 * this.getBalloonSizeRatio());
                int n15 = (int)((double)n4 * this.getArrowLeftRatio());
                int n16 = (int)((double)n4 * this.getArrowRightRatio());
                int n17 = (int)((double)n4 * this.getVertexPosition());
                Rectangle rectangle = new Rectangle(0, 0, n14, n4);
                if (n < n14 - this.getCornerSize()) {
                    d = RoundedRectangularShape.getDistance(point, rectangle, this.getCornerSize());
                    break;
                }
                if (n < n14) {
                    if (n2 <= n15 || n2 >= n4 - n16) {
                        d = RoundedRectangularShape.getDistance(point, rectangle, this.getCornerSize());
                        break;
                    }
                    d = RoundedRectangularBalloonShape.getDistance(point, new Point(n14, n15), new Point(n14, n4 - n16), new Point(n3, n17), this.getCornerSize(), true);
                    break;
                }
                d = RoundedRectangularBalloonShape.getDistance(point, new Point(n14, n15), new Point(n14, n4 - n16), new Point(n3, n17), this.getCornerSize(), false);
                break;
            }
            case 4: {
                int n18 = (int)((double)n3 * this.getBalloonSizeRatio());
                int n19 = (int)((double)n4 * this.getArrowRightRatio());
                int n20 = (int)((double)n4 * this.getArrowLeftRatio());
                int n21 = n4 - (int)((double)n4 * this.getVertexPosition());
                int n22 = n3 - n18 + 1;
                Rectangle rectangle = new Rectangle(0, 0, n18, n4);
                if (n > n3 + this.getCornerSize() - n18) {
                    d = RoundedRectangularShape.getDistance(new Point(n - n22, n2), rectangle, this.getCornerSize());
                    break;
                }
                if (n > n3 - n18) {
                    if (n2 <= n19 || n2 >= n4 - n20) {
                        d = RoundedRectangularShape.getDistance(new Point(n - n22, n2), rectangle, this.getCornerSize());
                        break;
                    }
                    d = RoundedRectangularBalloonShape.getDistance(point, new Point(n22, n19), new Point(n22, n4 - n20), new Point(0, n21), this.getCornerSize(), true);
                    break;
                }
                d = RoundedRectangularBalloonShape.getDistance(point, new Point(n22, n19), new Point(n22, n4 - n20), new Point(0, n21), this.getCornerSize(), false);
            }
        }
        return d;
    }

    public static double getDistance(Point point, Point point2, Point point3, Point point4, int n, boolean bl) {
        Shape shape;
        int n2 = point.x;
        int n3 = point.y;
        if (!bl) {
            shape = new GeneralPath();
            ((Path2D.Float)shape).moveTo(point3.x, point3.y);
            ((Path2D.Float)shape).lineTo(point4.x, point4.y);
            ((Path2D.Float)shape).lineTo(point2.x, point2.y);
            ((Path2D)shape).closePath();
            if (!((Path2D)shape).contains(n2, n3)) {
                return 0.0;
            }
        }
        shape = new Line2D.Double(point4.x, point4.y, point2.x, point2.y);
        Line2D.Double double_ = new Line2D.Double(point4.x, point4.y, point3.x, point3.y);
        double d = ((Line2D)shape).ptSegDist(n2, n3);
        double d2 = double_.ptSegDist(n2, n3);
        double d3 = d >= (double)n && d2 >= (double)n ? (double)(-n) : (d < (double)n && d2 >= (double)n ? -d : (d >= (double)n && d2 < (double)n ? -d2 : -d * d2 / (double)n));
        return d3;
    }

    public int getCornerSize() {
        return this._cornerSize;
    }

    public void setCornerSize(int n) {
        this._cornerSize = n;
    }

    public double getBalloonSizeRatio() {
        return this._balloonSizeRatio;
    }

    public void setBalloonSizeRatio(double d) {
        this._balloonSizeRatio = d;
    }

    public double getArrowLeftRatio() {
        return this._arrowLeftRatio;
    }

    public void setArrowLeftRatio(double d) {
        this._arrowLeftRatio = d;
    }

    public double getArrowRightRatio() {
        return this._arrowRightRatio;
    }

    public void setArrowRightRatio(double d) {
        this._arrowRightRatio = d;
    }

    public double getVertexPosition() {
        return this._vertexPosition;
    }

    public void setVertexPosition(double d) {
        this._vertexPosition = d;
    }

    public void setPosition(int n) {
        this._position = n;
    }

    public int getPosition() {
        return this._position;
    }
}

