/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tooltip.shapes;

import com.jidesoft.tooltip.BalloonShape;
import com.jidesoft.tooltip.BalloonTip;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

class OvalBalloonShape
implements BalloonShape {
    protected double arrowRadiumRatio = 0.618;
    protected int angle = 240;
    protected int arrowAngle = 20;
    protected Ellipse2D.Double ellipse;
    protected GeneralPath triangle;
    protected Shape outline;

    OvalBalloonShape() {
    }

    @Override
    public Shape createOutline(Dimension dimension, Dimension dimension2) {
        if (this.outline == null) {
            if (this.ellipse == null) {
                this.ellipse = this.createEllipse2D(dimension2, dimension);
            }
            if (this.triangle == null) {
                this.triangle = this.createArrowTriangle(dimension, dimension2);
            }
            Area area = new Area(this.ellipse);
            Area area2 = new Area(this.triangle);
            area.add(area2);
            this.outline = area;
        }
        return this.outline;
    }

    @Override
    public Point getHotSpot(Dimension dimension) {
        return new Point(0, dimension.height);
    }

    private GeneralPath createArrowTriangle(Dimension dimension, Dimension dimension2) {
        Point2D.Double double_ = this.getVertext(dimension, dimension2);
        Point2D.Double double_2 = this.getArmPoint(dimension, dimension2, this.angle - this.arrowAngle / 2);
        Point2D.Double double_3 = this.getArmPoint(dimension, dimension2, this.angle + this.arrowAngle / 2);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)double_.x, (float)double_.y);
        generalPath.lineTo((float)double_2.x, (float)double_2.y);
        generalPath.lineTo((float)double_3.x, (float)double_3.y);
        generalPath.lineTo((float)double_.x, (float)double_.y);
        generalPath.closePath();
        return generalPath;
    }

    protected Point2D.Double getArmPoint(Dimension dimension, Dimension dimension2, int n) {
        double d = (double)dimension2.width / 2.0;
        double d2 = (double)dimension2.height / 2.0;
        double d3 = d * Math.sqrt(2.0);
        double d4 = d2 * Math.sqrt(2.0);
        this.angle %= 360;
        Point2D.Double double_ = this.intersectPoint(n, d3, d4);
        Point2D.Double double_2 = this.getEllipseCenter(dimension, d3, d4);
        double_.x += double_2.x;
        double_.y += double_2.y;
        return double_;
    }

    protected Point2D.Double getVertext(Dimension dimension, Dimension dimension2) {
        double d = (double)dimension2.width / 2.0;
        double d2 = (double)dimension2.height / 2.0;
        double d3 = d * Math.sqrt(2.0);
        double d4 = d2 * Math.sqrt(2.0);
        this.angle %= 360;
        Point2D.Double double_ = this.intersectPoint(this.angle, d3, d4);
        double_.x *= 1.0 + this.arrowRadiumRatio;
        double_.y *= 1.0 + this.arrowRadiumRatio;
        Point2D.Double double_2 = this.getEllipseCenter(dimension, d3, d4);
        double_.x += double_2.x;
        double_.y += double_2.y;
        return double_;
    }

    protected Point2D.Double intersectPoint(int n, double d, double d2) {
        if ((n %= 360) == 0) {
            return new Point2D.Double(d, 0.0);
        }
        if (n == 90) {
            return new Point2D.Double(0.0, -d2);
        }
        if (n == 180) {
            return new Point2D.Double(-d, 0.0);
        }
        if (n == 270) {
            return new Point2D.Double(0.0, d2);
        }
        int n2 = this.getNormalAngle(n);
        double d3 = Math.PI * (double)n2 / 180.0;
        double d4 = Math.tan(d3);
        double d5 = d * d2 / Math.sqrt(d * d * d4 * d4 + d2 * d2);
        double d6 = d4 * d5;
        if (n > 0 && n < 90) {
            return new Point2D.Double(d5, -d6);
        }
        if (n > 90 && n < 180) {
            return new Point2D.Double(-d5, -d6);
        }
        if (n > 180 && n < 270) {
            return new Point2D.Double(-d5, d6);
        }
        return new Point2D.Double(d5, d6);
    }

    private Point2D.Double getEllipseCenter(Dimension dimension, double d, double d2) {
        double d3 = d;
        double d4 = d2;
        if (this.angle >= 0 && this.angle < 90) {
            d3 = d;
            d4 = (double)dimension.height - d2;
        } else if (this.angle >= 90 && this.angle < 180) {
            d3 = (double)dimension.width - d;
            d4 = (double)dimension.height - d2;
        } else if (this.angle >= 180 && this.angle < 270) {
            d3 = (double)dimension.width - d;
            d4 = d2;
        } else {
            d3 = d;
            d4 = d2;
        }
        return new Point2D.Double(d3, d4);
    }

    @Override
    public Insets getInsets(Dimension dimension) {
        int n;
        double d = (double)dimension.width / 2.0 + 10.0;
        double d2 = (double)dimension.height / 2.0 + 5.0;
        double d3 = d * Math.sqrt(2.0);
        double d4 = d2 * Math.sqrt(2.0);
        int n2 = (int)(d3 - d);
        int n3 = (int)(d4 - d2);
        if (this.angle == 0) {
            double d5 = (this.arrowRadiumRatio + 1.0) * d3;
            return new Insets(n3, n2, n3, (int)(d5 - d));
        }
        if (this.angle == 90) {
            double d6 = (this.arrowRadiumRatio + 1.0) * d4;
            return new Insets((int)(d6 - d2), n2, n3, n2);
        }
        if (this.angle == 180) {
            double d7 = (this.arrowRadiumRatio + 1.0) * d3;
            return new Insets(n3, (int)(d7 - d), n3, n2);
        }
        if (this.angle == 270) {
            double d8 = (this.arrowRadiumRatio + 1.0) * d4;
            return new Insets(n3, n2, (int)(d8 - d2), n2);
        }
        int n4 = this.getNormalAngle(this.angle);
        double d9 = Math.PI * (double)n4 / 180.0;
        double d10 = Math.tan(d9);
        double d11 = d3 * d4 / Math.sqrt(d3 * d3 * d10 * d10 + d4 * d4);
        double d12 = d10 * d11;
        double d13 = Math.sqrt(d11 * d11 + d12 * d12);
        double d14 = (1.0 + this.arrowRadiumRatio) * d13;
        double d15 = d14 * Math.cos(d9);
        double d16 = d14 * Math.sin(d9);
        int n5 = (int)(d15 - d);
        if (n5 < n2) {
            n5 = n2;
        }
        if ((n = (int)(d16 - d2)) < n3) {
            n = n3;
        }
        if (this.angle > 0 && this.angle < 90) {
            return new Insets(n, n2, n3, n5);
        }
        if (this.angle > 90 && this.angle < 180) {
            return new Insets(n, n5, n3, n2);
        }
        if (this.angle > 180 && this.angle < 270) {
            return new Insets(n3, n5, n, n2);
        }
        return new Insets(n3, n2, n, n5);
    }

    private int getNormalAngle(int n) {
        if (n > 0 && n < 90) {
            return n;
        }
        if (n > 90 && n < 180) {
            return 180 - n;
        }
        if (n > 180 && n < 270) {
            return n - 180;
        }
        return 360 - n;
    }

    @Override
    public double getEdgeDistance(Point point, BalloonTip balloonTip) {
        Dimension dimension = balloonTip.getBalloonSize();
        Dimension dimension2 = balloonTip.getContentSize();
        if (this.ellipse == null) {
            this.ellipse = this.createEllipse2D(dimension2, dimension);
        }
        if (this.triangle == null) {
            this.triangle = this.createArrowTriangle(dimension, dimension2);
        }
        boolean bl = this.ellipse.contains(point);
        boolean bl2 = this.triangle.contains(point);
        if (bl && bl2) {
            return this.getJointPartDistance(point, dimension, dimension2);
        }
        if (bl && !bl2) {
            return this.getEllipseEdgeDistance(this.ellipse, point, dimension, dimension2);
        }
        if (!bl && bl2) {
            return this.getTriangleDistance(point, dimension, dimension2);
        }
        return 0.0;
    }

    protected Ellipse2D.Double createEllipse2D(Dimension dimension, Dimension dimension2) {
        double d = (double)dimension.width / 2.0;
        double d2 = (double)dimension.height / 2.0;
        double d3 = d * Math.sqrt(2.0);
        double d4 = d2 * Math.sqrt(2.0);
        this.angle %= 360;
        int n = (int)(2.0 * d3);
        int n2 = (int)(2.0 * d4);
        int n3 = (int)((double)dimension2.width - 2.0 * d3);
        int n4 = (int)((double)dimension2.height - 2.0 * d4);
        if (this.angle >= 0 && this.angle < 90) {
            return new Ellipse2D.Double(0.0, n4, n, n2);
        }
        if (this.angle >= 90 && this.angle < 180) {
            return new Ellipse2D.Double(n3, n4, n, n2);
        }
        if (this.angle >= 180 && this.angle < 270) {
            return new Ellipse2D.Double(n3, 0.0, n, n2);
        }
        return new Ellipse2D.Double(0.0, 0.0, n, n2);
    }

    private double getEllipseEdgeDistance(Ellipse2D.Double double_, Point point, Dimension dimension, Dimension dimension2) {
        double d = point.x;
        double d2 = point.y;
        double d3 = double_.x + double_.width / 2.0;
        double d4 = double_.y + double_.height / 2.0;
        double d5 = Math.sqrt((d -= d3) * d + (d2 -= d4) * d2);
        double d6 = double_.width / 2.0;
        double d7 = double_.height / 2.0;
        if ((int)d == 0) {
            if ((int)d2 == 0) {
                return -Math.max(d6, d7);
            }
            return d5 - d7;
        }
        if ((int)d2 == 0) {
            return d5 - d6;
        }
        Point2D.Double double_2 = this.getArmPoint(dimension, dimension2, this.angle - this.arrowAngle / 2);
        Point2D.Double double_3 = this.getArmPoint(dimension, dimension2, this.angle + this.arrowAngle / 2);
        Point2D.Double double_4 = new Point2D.Double(d3, d4);
        Line2D.Double double_5 = new Line2D.Double(double_4, double_2);
        Line2D.Double double_6 = new Line2D.Double(double_4, double_3);
        int n = double_5.relativeCCW(point);
        int n2 = double_6.relativeCCW(point);
        if (n > 0 && n2 < 0) {
            double d8 = point.distance(double_2);
            double d9 = point.distance(double_3);
            return -Math.min(d8, d9);
        }
        double d10 = d2 / d;
        double d11 = d6 * d7 * Math.sqrt((d10 * d10 + 1.0) / (d6 * d6 * d10 * d10 + d7 * d7));
        return d5 - d11;
    }

    private double getJointPartDistance(Point point, Dimension dimension, Dimension dimension2) {
        Point2D.Double double_ = this.getArmPoint(dimension, dimension2, this.angle - this.arrowAngle / 2);
        Point2D.Double double_2 = this.getArmPoint(dimension, dimension2, this.angle + this.arrowAngle / 2);
        double d = point.distance(double_);
        double d2 = point.distance(double_2);
        return -Math.min(d, d2);
    }

    private double getTriangleDistance(Point point, Dimension dimension, Dimension dimension2) {
        Point2D.Double double_ = this.getVertext(dimension, dimension2);
        Point2D.Double double_2 = this.getArmPoint(dimension, dimension2, this.angle - this.arrowAngle / 2);
        Point2D.Double double_3 = this.getArmPoint(dimension, dimension2, this.angle + this.arrowAngle / 2);
        Line2D.Double double_4 = new Line2D.Double(double_, double_2);
        Line2D.Double double_5 = new Line2D.Double(double_, double_3);
        double d = double_4.ptSegDist(point);
        double d2 = double_5.ptSegDist(point);
        return -Math.min(d, d2);
    }
}

