/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tooltip;

import com.jidesoft.tooltip.RelativePoint;
import com.jidesoft.tooltip.Tip;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

class HeavyweightTip
implements Tip {
    private final JComponent _component;
    private final boolean _focusableWindowState;
    private JWindow _window;
    private JComponent _parentComponent;

    public HeavyweightTip(JComponent jComponent, boolean bl) {
        this._component = jComponent;
        this._focusableWindowState = bl;
    }

    @Override
    public void show(JComponent jComponent, int n, int n2, JComponent jComponent2) {
        this._parentComponent = jComponent;
        Window window = SwingUtilities.getWindowAncestor(jComponent);
        this._window = new JWindow(window);
        this._window.setFocusableWindowState(this._focusableWindowState);
        this._window.getContentPane().setLayout(new BorderLayout());
        this._window.getContentPane().add((Component)this._component, "Center");
        this.updateBounds(n, n2, true);
        this.setWindowShape(this._window);
        this._window.setVisible(true);
    }

    protected void setWindowShape(JWindow jWindow) {
    }

    public Dimension getPreferredSize() {
        return this._component.getPreferredSize();
    }

    @Override
    public boolean isVisible() {
        return this._component.isShowing();
    }

    public JComponent getComponent() {
        return this._component;
    }

    @Override
    public void hide() {
        if (this._window != null) {
            this._window.dispose();
            this._window = null;
        }
    }

    @Override
    public void pack() {
        this.updateBounds(-1, -1, false);
    }

    private void updateBounds(int n, int n2, boolean bl) {
        if (this._window != null) {
            if (bl) {
                Point point = this._parentComponent.getLocationOnScreen();
                this._window.setLocation(point.x + n, point.y + n2);
            }
            this._window.setSize(this.getPreferredSize());
        }
    }

    @Override
    public void setLocation(RelativePoint relativePoint) {
        if (this._window != null) {
            this._window.setLocation(relativePoint.getScreenPoint().x, relativePoint.getScreenPoint().y);
        }
    }
}

