/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tooltip;

import com.jidesoft.popup.JidePopup;
import com.jidesoft.tooltip.BalloonShape;
import com.jidesoft.tooltip.BalloonTipUI;
import com.jidesoft.tooltip.ShadowSettings;
import com.jidesoft.tooltip.ShadowStyle;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;

public class BalloonTip
extends JToolTip {
    transient JidePopup _popup;
    private BalloonShape _balloonShape;
    private ShadowStyle _shadowStyle;
    private ShadowSettings _shadowSettings = new ShadowSettings();
    private Component _content;

    public BalloonTip() {
        this.updateUI();
    }

    @Override
    public void updateUI() {
        this.setUI(new BalloonTipUI(this));
    }

    public Dimension getContentSize() {
        return this._content.getSize();
    }

    public Dimension getBalloonSize() {
        return ((BalloonTipUI)this.getUI()).getBalloonSize();
    }

    public Dimension getBalloonPreferredSize() {
        return ((BalloonTipUI)this.getUI()).getBalloonPreferredSize();
    }

    public Point getHotSpot() {
        return ((BalloonTipUI)this.getUI()).getHotSpot();
    }

    public Dimension getShadowSize() {
        return ((BalloonTipUI)this.getUI()).getShadowSize();
    }

    public BalloonTip(Component component) {
        this();
        this.setContent(component);
    }

    public void setContent(Component component) {
        this._content = component;
        ((BalloonTipUI)this.getUI()).setContent(component);
    }

    @Override
    public boolean isVisible() {
        return this._popup != null && this._popup.isPopupVisible();
    }

    public void show(JComponent jComponent, int n, int n2) {
        if (this.isVisible()) {
            this._popup.hidePopupImmediately();
        }
        this._popup = this.createPopup();
        this._popup.setOwner(jComponent);
        this.customizePopup(this._popup);
        Point point = null;
        if (this.getBalloonShape() != null) {
            this.doLayout();
            point = this.getHotSpot();
            n -= point.x;
            n2 -= point.y;
        }
        Point point2 = new Point(n, n2);
        SwingUtilities.convertPointToScreen(point2, jComponent);
        this._popup.getContentPane().setLayout(new BorderLayout());
        this._popup.getContentPane().add(this);
        this._popup.showPopup(point2.x, point2.y, jComponent);
        if (this.getBalloonShape() != null) {
            Point point3 = this.getHotSpot();
            if (point != null && (point3.x != point.x || point3.y != point.y)) {
                this._popup.showPopup(point2.x - point3.x + point.x, point2.y - point3.y + point.y, jComponent);
            }
        }
    }

    protected JidePopup createPopup() {
        return new JidePopup(){

            @Override
            public boolean isClickOnPopup(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                Point point2 = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, BalloonTip.this.getContent().getParent());
                return BalloonTip.this.getContent().getParent().contains(point2);
            }
        };
    }

    protected void customizePopup(JidePopup jidePopup) {
        jidePopup.setPopupType(0);
        jidePopup.setTransient(true);
        jidePopup.setPopupBorder(BorderFactory.createEmptyBorder());
        jidePopup.setOpaque(false);
        ((JComponent)jidePopup.getContentPane()).setOpaque(false);
    }

    @Override
    public void hide() {
        if (this.isVisible()) {
            this._popup.hidePopupImmediately();
            this._popup = null;
        }
    }

    public BalloonShape getBalloonShape() {
        return this._balloonShape;
    }

    public void setBalloonShape(BalloonShape balloonShape) {
        this._balloonShape = balloonShape;
    }

    public Component getContent() {
        return this._content;
    }

    public ShadowStyle getShadowStyle() {
        return this._shadowStyle;
    }

    public void setShadowStyle(ShadowStyle shadowStyle) {
        this._shadowStyle = shadowStyle;
    }

    public ShadowSettings getShadowSettings() {
        return this._shadowSettings;
    }

    public void setShadowSettings(ShadowSettings shadowSettings) {
        this._shadowSettings = shadowSettings;
    }

    public void paintBalloonBackground(Graphics2D graphics2D, Shape shape) {
        graphics2D.setColor(this.getBackground());
        graphics2D.fill(shape);
    }

    public void paintBalloonForeground(Graphics2D graphics2D, Shape shape) {
        graphics2D.setColor(this.getForeground());
        graphics2D.draw(shape);
    }

    public void packPopup() {
        if (this._popup != null) {
            this._popup.packPopup();
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(2)) {
            Lm.showInvalidProductMessage(BalloonTip.class.getName(), 2);
        }
    }
}

