/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.util.collections;

import com.jidesoft.thirdparty.prefuse.util.collections.AbstractTreeMap;
import com.jidesoft.thirdparty.prefuse.util.collections.IntIterator;
import com.jidesoft.thirdparty.prefuse.util.collections.LiteralComparator;
import com.jidesoft.thirdparty.prefuse.util.collections.LiteralIterator;
import com.jidesoft.thirdparty.prefuse.util.collections.LongIntSortedMap;

public class LongIntTreeMap
extends AbstractTreeMap
implements LongIntSortedMap {
    private LongEntry dummy = new LongEntry(Long.MIN_VALUE, Integer.MAX_VALUE, NIL, 0);

    public LongIntTreeMap() {
        this(null, false);
    }

    public LongIntTreeMap(boolean bl) {
        this(null, bl);
    }

    public LongIntTreeMap(LiteralComparator literalComparator) {
        this(literalComparator, false);
    }

    public LongIntTreeMap(LiteralComparator literalComparator, boolean bl) {
        super(literalComparator, bl);
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = NIL;
    }

    @Override
    public boolean containsKey(long l) {
        return this.find(l, 0) != NIL;
    }

    @Override
    public int get(long l) {
        AbstractTreeMap.Entry entry = this.find(l, 0);
        return entry == NIL ? Integer.MIN_VALUE : entry.val;
    }

    @Override
    public int put(long l, int n) {
        AbstractTreeMap.Entry entry = this.root;
        this.lastOrder = 0;
        if (entry == NIL) {
            this.incrementSize(true);
            this.root = new LongEntry(l, n, NIL, this.lastOrder);
            return Integer.MIN_VALUE;
        }
        this.dummy.key = l;
        this.dummy.order = Integer.MAX_VALUE;
        while (true) {
            int n2;
            if ((n2 = this.compare(this.dummy, entry)) == 0) {
                return entry.setValue(n);
            }
            if (n2 < 0) {
                if (entry.left != NIL) {
                    entry = entry.left;
                    continue;
                }
                this.incrementSize(this.lastOrder == 0);
                entry.left = new LongEntry(l, n, entry, this.lastOrder);
                this.fixUpInsert(entry.left);
                return Integer.MIN_VALUE;
            }
            if (entry.right == NIL) break;
            entry = entry.right;
        }
        this.incrementSize(this.lastOrder == 0);
        entry.right = new LongEntry(l, n, entry, this.lastOrder);
        this.fixUpInsert(entry.right);
        return Integer.MIN_VALUE;
    }

    @Override
    public int remove(long l) {
        AbstractTreeMap.Entry entry = this.allowDuplicates ? this.findPredecessor(l, Integer.MAX_VALUE) : this.find(l, 0);
        if (entry == NIL) {
            return Integer.MIN_VALUE;
        }
        int n = entry.val;
        this.remove(entry);
        return n;
    }

    @Override
    public int remove(long l, int n) {
        AbstractTreeMap.Entry entry = this.findCeiling(l, 0);
        if (entry != NIL && entry.getLongKey() != l) {
            entry = this.successor(entry);
        }
        if (entry == NIL || entry.getLongKey() != l) {
            return Integer.MIN_VALUE;
        }
        while (entry.val != n && entry != NIL) {
            entry = this.successor(entry);
        }
        if (entry == NIL) {
            return Integer.MIN_VALUE;
        }
        this.remove(entry);
        return n;
    }

    @Override
    public long firstKey() {
        return this.minimum(this.root).getLongKey();
    }

    @Override
    public long lastKey() {
        return this.maximum(this.root).getLongKey();
    }

    @Override
    public LiteralIterator keyIterator() {
        return new KeyIterator();
    }

    @Override
    public LiteralIterator keyRangeIterator(long l, boolean bl, long l2, boolean bl2) {
        AbstractTreeMap.Entry entry;
        AbstractTreeMap.Entry entry2;
        if (this.cmp.compare(l, l2) <= 0) {
            entry2 = this.findCeiling(l, bl ? 0 : Integer.MAX_VALUE);
            entry = this.findCeiling(l2, bl2 ? Integer.MAX_VALUE : 0);
        } else {
            entry2 = this.findCeiling(l, bl ? Integer.MAX_VALUE : 0);
            entry2 = this.predecessor(entry2);
            entry = this.findCeiling(l2, bl2 ? 0 : Integer.MAX_VALUE);
            entry = this.predecessor(entry);
        }
        return new KeyIterator(entry2, entry);
    }

    @Override
    public IntIterator valueRangeIterator(long l, boolean bl, long l2, boolean bl2) {
        return new AbstractTreeMap.ValueIterator((AbstractTreeMap.EntryIterator)this.keyRangeIterator(l, bl, l2, bl2));
    }

    @Override
    protected int compare(AbstractTreeMap.Entry entry, AbstractTreeMap.Entry entry2) {
        int n = this.cmp.compare(entry.getLongKey(), entry2.getLongKey());
        if (this.allowDuplicates && n == 0) {
            n = entry.order < entry2.order ? -1 : (entry.order > entry2.order ? 1 : 0);
            this.lastOrder = 1 + (n < 0 ? entry.order : entry2.order);
        }
        return n;
    }

    private AbstractTreeMap.Entry find(long l, int n) {
        this.dummy.key = l;
        this.dummy.order = n;
        AbstractTreeMap.Entry entry = this.find(this.dummy);
        return entry;
    }

    private AbstractTreeMap.Entry findPredecessor(long l, int n) {
        this.dummy.key = l;
        this.dummy.order = n;
        AbstractTreeMap.Entry entry = this.findPredecessor(this.dummy);
        return entry;
    }

    private AbstractTreeMap.Entry findCeiling(long l, int n) {
        this.dummy.key = l;
        this.dummy.order = n;
        AbstractTreeMap.Entry entry = this.findCeiling(this.dummy);
        return entry;
    }

    private class KeyIterator
    extends AbstractTreeMap.KeyIterator {
        public KeyIterator() {
        }

        public KeyIterator(AbstractTreeMap.Entry entry, AbstractTreeMap.Entry entry2) {
            super(entry, entry2);
        }

        @Override
        public boolean isLongSupported() {
            return true;
        }

        @Override
        public long nextLong() {
            return this.nextEntry().getLongKey();
        }
    }

    static class LongEntry
    extends AbstractTreeMap.Entry {
        long key;

        public LongEntry(long l, int n) {
            super(n);
            this.key = l;
        }

        public LongEntry(long l, int n, AbstractTreeMap.Entry entry, int n2) {
            super(n, entry, n2);
            this.key = l;
        }

        @Override
        public long getLongKey() {
            return this.key;
        }

        @Override
        public Object getKey() {
            return new Long(this.key);
        }

        @Override
        public boolean keyEquals(AbstractTreeMap.Entry entry) {
            return entry instanceof LongEntry && this.key == ((LongEntry)entry).key;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof LongEntry)) {
                return false;
            }
            LongEntry longEntry = (LongEntry)object;
            return this.key == longEntry.key && this.val == longEntry.val;
        }

        @Override
        public int hashCode() {
            int n = (int)(this.key ^ this.key >>> 32);
            int n2 = this.val;
            return n ^ n2 ^ this.order;
        }

        @Override
        public String toString() {
            return this.key + "=" + this.val;
        }

        @Override
        public void copyFields(AbstractTreeMap.Entry entry) {
            super.copyFields(entry);
            this.key = entry.getLongKey();
        }
    }
}

