/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.util;

import com.jidesoft.thirdparty.prefuse.data.Table;
import com.jidesoft.thirdparty.prefuse.data.expression.AndPredicate;
import com.jidesoft.thirdparty.prefuse.data.expression.ColumnExpression;
import com.jidesoft.thirdparty.prefuse.data.expression.ComparisonPredicate;
import com.jidesoft.thirdparty.prefuse.data.expression.Expression;
import com.jidesoft.thirdparty.prefuse.data.expression.ExpressionAnalyzer;
import com.jidesoft.thirdparty.prefuse.data.expression.NotPredicate;
import com.jidesoft.thirdparty.prefuse.data.expression.OrPredicate;
import com.jidesoft.thirdparty.prefuse.data.expression.Predicate;
import com.jidesoft.thirdparty.prefuse.data.expression.RangePredicate;
import com.jidesoft.thirdparty.prefuse.data.tuple.TupleSet;
import com.jidesoft.thirdparty.prefuse.data.util.FilterIterator;
import com.jidesoft.thirdparty.prefuse.data.util.FilterRowIterator;
import com.jidesoft.thirdparty.prefuse.data.util.Index;
import com.jidesoft.thirdparty.prefuse.data.util.UniqueRowIterator;
import com.jidesoft.thirdparty.prefuse.util.PrefuseConfig;
import com.jidesoft.thirdparty.prefuse.util.collections.CompositeIntIterator;
import com.jidesoft.thirdparty.prefuse.util.collections.IntIterator;
import java.util.Comparator;
import java.util.Iterator;

public class FilterIteratorFactory {
    private static final int OPTIMIZATION_THRESHOLD = PrefuseConfig.getInt("data.filter.optimizeThreshold");

    public static Iterator tuples(TupleSet tupleSet, Predicate predicate) {
        Table table;
        IntIterator intIterator;
        if (predicate == null) {
            return tupleSet.tuples();
        }
        Iterator iterator = null;
        if (tupleSet instanceof Table && (intIterator = FilterIteratorFactory.getOptimizedIterator(table = (Table)tupleSet, predicate)) != null) {
            iterator = table.tuples(intIterator);
        }
        if (iterator == null) {
            iterator = new FilterIterator(tupleSet.tuples(), predicate);
        }
        return iterator;
    }

    public static IntIterator rows(Table table, Predicate predicate) {
        IntIterator intIterator = null;
        intIterator = FilterIteratorFactory.getOptimizedIterator(table, predicate);
        if (intIterator == null) {
            intIterator = new FilterRowIterator(table.rows(), table, predicate);
        }
        return intIterator;
    }

    protected static IntIterator getOptimizedIterator(Table table, Predicate predicate) {
        if (table.getRowCount() < OPTIMIZATION_THRESHOLD) {
            return null;
        }
        if (predicate instanceof ColumnExpression) {
            return FilterIteratorFactory.getColumnIterator(table, ((ColumnExpression)predicate).getColumnName(), true);
        }
        if (predicate instanceof NotPredicate) {
            Predicate predicate2 = ((NotPredicate)predicate).getPredicate();
            if (predicate2 instanceof ColumnExpression) {
                return FilterIteratorFactory.getColumnIterator(table, ((ColumnExpression)predicate2).getColumnName(), false);
            }
        } else {
            if (predicate instanceof AndPredicate) {
                return FilterIteratorFactory.getAndIterator(table, (AndPredicate)predicate);
            }
            if (predicate instanceof OrPredicate) {
                return FilterIteratorFactory.getOrIterator(table, (OrPredicate)predicate);
            }
            if (predicate instanceof ComparisonPredicate) {
                return FilterIteratorFactory.getComparisonIterator(table, (ComparisonPredicate)predicate);
            }
            if (predicate instanceof RangePredicate) {
                return FilterIteratorFactory.getRangeIterator(table, (RangePredicate)predicate);
            }
        }
        return null;
    }

    protected static IntIterator getColumnIterator(Table table, String string, boolean bl) {
        if (table.getColumnType(string) != Boolean.TYPE) {
            return null;
        }
        Index index = table.getIndex(string);
        if (index == null) {
            return null;
        }
        return index.rows(bl);
    }

    protected static IntIterator getOrIterator(Table table, OrPredicate orPredicate) {
        int n = orPredicate.size();
        if (n > 1) {
            IntIterator[] intIteratorArray = new IntIterator[n];
            for (int i = 0; i < intIteratorArray.length; ++i) {
                intIteratorArray[i] = FilterIteratorFactory.getOptimizedIterator(table, orPredicate.get(i));
                if (intIteratorArray[i] != null) continue;
                return null;
            }
            return new UniqueRowIterator(new CompositeIntIterator(intIteratorArray));
        }
        if (n == 1) {
            return FilterIteratorFactory.getOptimizedIterator(table, orPredicate.get(0));
        }
        return null;
    }

    protected static IntIterator getAndIterator(Table table, AndPredicate andPredicate) {
        IntIterator intIterator = null;
        Predicate predicate = null;
        int n = andPredicate.size();
        while (--n >= 0 && (intIterator = FilterIteratorFactory.getOptimizedIterator(table, predicate = andPredicate.get(n))) == null) {
        }
        if (intIterator == null) {
            return null;
        }
        if (andPredicate.size() == 1) {
            return intIterator;
        }
        return new FilterRowIterator(intIterator, table, andPredicate.getSubPredicate(predicate));
    }

    protected static IntIterator getComparisonIterator(Table table, ComparisonPredicate comparisonPredicate) {
        Expression expression;
        ColumnExpression columnExpression;
        Expression expression2 = comparisonPredicate.getLeftExpression();
        Expression expression3 = comparisonPredicate.getRightExpression();
        int n = comparisonPredicate.getOperation();
        if (n == 3) {
            return null;
        }
        if (expression2 instanceof ColumnExpression && !ExpressionAnalyzer.hasDependency(expression3)) {
            columnExpression = (ColumnExpression)expression2;
            expression = expression3;
        } else if (expression3 instanceof ColumnExpression && !ExpressionAnalyzer.hasDependency(expression2)) {
            columnExpression = (ColumnExpression)expression3;
            expression = expression2;
        } else {
            return null;
        }
        Comparator comparator = comparisonPredicate.getComparator();
        Index index = table.getIndex(columnExpression.getColumnName());
        if (index == null || !comparator.equals(index.getComparator())) {
            return null;
        }
        Class<?> clazz = expression.getClass();
        if (clazz == Integer.TYPE) {
            int n2 = expression.getInt(null);
            switch (n) {
                case 0: {
                    return index.rows(Integer.MIN_VALUE, n2, 41);
                }
                case 1: {
                    return index.rows(n2, Integer.MAX_VALUE, 38);
                }
                case 2: {
                    return index.rows(n2, n2, 42);
                }
                case 4: {
                    return index.rows(Integer.MIN_VALUE, n2, 42);
                }
                case 5: {
                    return index.rows(n2, Integer.MAX_VALUE, 42);
                }
            }
            throw new IllegalStateException();
        }
        if (clazz == Long.TYPE) {
            long l = expression.getLong(null);
            switch (n) {
                case 0: {
                    return index.rows(Long.MIN_VALUE, l, 41);
                }
                case 1: {
                    return index.rows(l, Long.MAX_VALUE, 38);
                }
                case 2: {
                    return index.rows(l, l, 42);
                }
                case 4: {
                    return index.rows(Long.MIN_VALUE, l, 42);
                }
                case 5: {
                    return index.rows(l, Long.MAX_VALUE, 42);
                }
            }
            throw new IllegalStateException();
        }
        if (clazz == Float.TYPE) {
            float f = expression.getFloat(null);
            switch (n) {
                case 0: {
                    return index.rows(Float.MIN_VALUE, f, 41);
                }
                case 1: {
                    return index.rows(f, Float.MAX_VALUE, 38);
                }
                case 2: {
                    return index.rows(f, f, 42);
                }
                case 4: {
                    return index.rows(Float.MIN_VALUE, f, 42);
                }
                case 5: {
                    return index.rows(f, Float.MAX_VALUE, 42);
                }
            }
            throw new IllegalStateException();
        }
        if (clazz == Double.TYPE) {
            double d = expression.getDouble(null);
            switch (n) {
                case 0: {
                    return index.rows((double)Double.MIN_VALUE, d, 41);
                }
                case 1: {
                    return index.rows(d, (double)Double.MAX_VALUE, 38);
                }
                case 2: {
                    return index.rows(d, d, 42);
                }
                case 4: {
                    return index.rows((double)Double.MIN_VALUE, d, 42);
                }
                case 5: {
                    return index.rows(d, (double)Double.MAX_VALUE, 42);
                }
            }
            throw new IllegalStateException();
        }
        Object object = expression.get(null);
        switch (n) {
            case 0: {
                return index.rows(null, object, 41);
            }
            case 1: {
                return index.rows(object, null, 38);
            }
            case 2: {
                return index.rows(object, object, 42);
            }
            case 4: {
                return index.rows(null, object, 42);
            }
            case 5: {
                return index.rows(object, null, 42);
            }
        }
        throw new IllegalStateException();
    }

    protected static IntIterator getRangeIterator(Table table, RangePredicate rangePredicate) {
        int n;
        if (!(rangePredicate.getMiddleExpression() instanceof ColumnExpression) || ExpressionAnalyzer.hasDependency(rangePredicate.getLeftExpression()) || ExpressionAnalyzer.hasDependency(rangePredicate.getRightExpression())) {
            return null;
        }
        ColumnExpression columnExpression = (ColumnExpression)rangePredicate.getMiddleExpression();
        Expression expression = rangePredicate.getLeftExpression();
        Expression expression2 = rangePredicate.getRightExpression();
        Comparator comparator = rangePredicate.getComparator();
        Index index = table.getIndex(columnExpression.getColumnName());
        if (index == null || !comparator.equals(index.getComparator())) {
            return null;
        }
        int n2 = rangePredicate.getOperation();
        Class clazz = table.getColumnType(columnExpression.getColumnName());
        switch (n2) {
            case 0: {
                n = 42;
                break;
            }
            case 1: {
                n = 41;
                break;
            }
            case 2: {
                n = 38;
                break;
            }
            case 3: {
                n = 37;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (clazz == Integer.TYPE) {
            return index.rows(expression.getInt(null), expression2.getInt(null), n);
        }
        if (clazz == Long.TYPE) {
            return index.rows(expression.getLong(null), expression2.getLong(null), n);
        }
        if (clazz == Float.TYPE) {
            return index.rows(expression.getFloat(null), expression2.getFloat(null), n);
        }
        if (clazz == Double.TYPE) {
            return index.rows(expression.getDouble(null), expression2.getDouble(null), n);
        }
        return index.rows(expression.get(null), expression2.get(null), n);
    }
}

