/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.XMLSerializer15;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class PersistenceUtils {
    private static String DEFAULT_XML_ENCODING = "UTF-8";
    private static final String DEFAULT_XML_VERSION = "1.0";
    public static final String NODE_COMPONENT = "component";
    public static final String ATTRIBUTE_VERSION = "version";

    public static void saveXMLDocumentToFile(Document document, String string, String string2) throws IOException {
        XMLSerializer15.save(document, string, string2, PersistenceUtils.getDefaultXmlVersion());
    }

    public static void saveXMLDocumentToStream(Document document, OutputStream outputStream, String string) throws IOException {
        XMLSerializer15.save(document, outputStream, string, PersistenceUtils.getDefaultXmlVersion());
    }

    private static boolean isSunPackageIncluded() {
        try {
            Class.forName("com.sun.org.apache.xml.internal.serialize.OutputFormat");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String getDefaultXmlEncoding() {
        return DEFAULT_XML_ENCODING;
    }

    public static void setDefaultXmlEncoding(String string) {
        DEFAULT_XML_ENCODING = string;
    }

    public static String getDefaultXmlVersion() {
        return DEFAULT_XML_VERSION;
    }

    public static void setDefaultXmlVersion(String string) {
        DEFAULT_XML_ENCODING = string;
    }

    public static Document getDocument(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(inputStream);
    }

    public static Document getDocument(String string) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(new File(string));
    }

    public static String getVersion(Document document) {
        Node node = document.getElementsByTagName(NODE_COMPONENT).item(0);
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (!ATTRIBUTE_VERSION.equals(node2.getNodeName())) continue;
            string = node2.getNodeValue();
            break;
        }
        return string;
    }

    public static int[] stringToIntArray(String string) {
        if (string == null || string.trim().length() == 0) {
            return new int[0];
        }
        String[] stringArray = string.split(", ");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            try {
                nArray[i] = Integer.parseInt(string2);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                nArray[i] = -1;
            }
        }
        return nArray;
    }

    public static String intArrayToString(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            stringBuffer.append(n);
            if (i == nArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public static boolean isXmlFormat(byte[] byArray) {
        if (byArray == null) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < Math.min(byArray.length, 10); ++i) {
            stringBuffer.append((char)byArray[i]);
        }
        String string = stringBuffer.toString().toLowerCase(Locale.getDefault());
        return string.contains("xml");
    }

    public static byte[] bufferStreamToArray(InputStream inputStream) throws IOException {
        int n;
        int n2 = 1;
        byte[] byArray = new byte[n2];
        for (n = inputStream.read(byArray, 0, n2); n >= n2; n += n2) {
            int n3 = n2 * 2;
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            n = inputStream.read(byArray2, n2, n2);
            byArray = byArray2;
            if (n < 0) break;
            n2 = n3;
        }
        if (n < 0) {
            return byArray;
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        return byArray3;
    }
}

