/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.AbstractLayoutPersistence;
import com.jidesoft.swing.LayoutPersistence;
import com.jidesoft.swing.PersistenceUtils;
import com.jidesoft.swing.RootPanePersistence;
import com.jidesoft.utils.PersistenceUtilsCallback;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class LayoutPersistenceManager
extends AbstractLayoutPersistence {
    private List<LayoutPersistence> _entries = new ArrayList<LayoutPersistence>();
    public static final String NODE_DOCKING_MANAGER = "DockingManager";
    public static final String NODE_DOCKABLE_BAR_MANAGER = "DockableBarManager";
    public static final String NODE_DOCUMENT_PANE = "DocumentPane";
    private boolean _loadDataSuccessful = true;

    public void addLayoutPersistence(LayoutPersistence layoutPersistence) {
        this._entries.add(layoutPersistence);
    }

    public void removeLayoutPersistence(LayoutPersistence layoutPersistence) {
        this._entries.remove(layoutPersistence);
    }

    public void clear() {
        this._entries.clear();
    }

    @Override
    public boolean loadLayoutFrom(Document document) {
        LayoutPersistence layoutPersistence;
        int n;
        this._loadDataSuccessful = true;
        if (document == null) {
            this._loadDataSuccessful = false;
            return this._loadDataSuccessful;
        }
        int n2 = -1;
        for (n = this._entries.size() - 1; n >= 0; --n) {
            layoutPersistence = this._entries.get(n);
            if (!(layoutPersistence instanceof RootPanePersistence)) continue;
            n2 = n;
            break;
        }
        for (n = 0; n < this._entries.size(); ++n) {
            boolean bl;
            layoutPersistence = this._entries.get(n);
            boolean bl2 = n == n2;
            boolean bl3 = layoutPersistence.isLast();
            String string = layoutPersistence.getLayoutPersistenceName();
            PersistenceUtilsCallback.Load load = layoutPersistence.getLoadCallback();
            layoutPersistence.setLast(bl2);
            if (string == null) {
                layoutPersistence.setLayoutPersistenceName("" + n);
            }
            if (load == null) {
                layoutPersistence.setLoadCallback(this.getLoadCallback());
            }
            boolean bl4 = this._loadDataSuccessful = (bl = layoutPersistence.loadLayoutFrom(document)) && this._loadDataSuccessful;
            if (!bl) {
                layoutPersistence.resetToDefault();
            }
            layoutPersistence.setLast(bl3);
            if (string == null) {
                layoutPersistence.setLayoutPersistenceName(string);
            }
            if (load != null) continue;
            layoutPersistence.setLoadCallback(load);
        }
        return this._loadDataSuccessful;
    }

    @Override
    public boolean loadLayoutFrom(InputStream inputStream) {
        byte[] byArray;
        this._loadDataSuccessful = true;
        if (inputStream == null) {
            this._loadDataSuccessful = false;
            return this._loadDataSuccessful;
        }
        try {
            byArray = PersistenceUtils.bufferStreamToArray(inputStream);
        }
        catch (IOException iOException) {
            byArray = null;
        }
        if (byArray == null) {
            this._loadDataSuccessful = false;
            return this._loadDataSuccessful;
        }
        boolean bl = PersistenceUtils.isXmlFormat(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        if (bl) {
            try {
                Document document = PersistenceUtils.getDocument(byteArrayInputStream);
                return this.loadLayoutFrom(document);
            }
            catch (Exception exception) {
                this._loadDataSuccessful = false;
                for (LayoutPersistence layoutPersistence : this._entries) {
                    layoutPersistence.resetToDefault();
                }
            }
        } else {
            LayoutPersistence layoutPersistence;
            int n;
            int n2 = -1;
            for (n = this._entries.size() - 1; n >= 0; --n) {
                layoutPersistence = this._entries.get(n);
                if (!(layoutPersistence instanceof RootPanePersistence)) continue;
                n2 = n;
                break;
            }
            for (n = 0; n < this._entries.size(); ++n) {
                layoutPersistence = this._entries.get(n);
                boolean bl2 = n == n2;
                boolean bl3 = layoutPersistence.isLast();
                boolean bl4 = layoutPersistence.isNeedFormatCheck();
                layoutPersistence.setLast(bl2);
                layoutPersistence.setNeedFormatCheck(false);
                boolean bl5 = layoutPersistence.loadLayoutFrom(byteArrayInputStream);
                boolean bl6 = this._loadDataSuccessful = bl5 && this._loadDataSuccessful;
                if (!bl5) {
                    layoutPersistence.resetToDefault();
                }
                layoutPersistence.setLast(bl3);
                layoutPersistence.setNeedFormatCheck(bl4);
            }
        }
        return this._loadDataSuccessful;
    }

    @Override
    public boolean isLoadDataSuccessful() {
        return this._loadDataSuccessful;
    }

    @Override
    public void saveLayoutTo(Document document) throws ParserConfigurationException {
        for (int i = 0; i < this._entries.size(); ++i) {
            LayoutPersistence layoutPersistence = this._entries.get(i);
            PersistenceUtilsCallback.Save save = layoutPersistence.getSaveCallback();
            String string = layoutPersistence.getXmlEncoding();
            String string2 = layoutPersistence.getLayoutPersistenceName();
            if (save == null) {
                layoutPersistence.setSaveCallback(this.getSaveCallback());
            }
            if (string == null) {
                layoutPersistence.setXmlEncoding(this.getXmlEncoding());
            }
            if (string2 == null) {
                layoutPersistence.setLayoutPersistenceName("" + i);
            }
            layoutPersistence.saveLayoutTo(document);
            if (save == null) {
                layoutPersistence.setSaveCallback(save);
            }
            if (string == null) {
                layoutPersistence.setXmlEncoding(string);
            }
            if (string2 != null) continue;
            layoutPersistence.setLayoutPersistenceName(string2);
        }
    }

    @Override
    public void saveLayoutTo(OutputStream outputStream) throws IOException {
        if (this.isXmlFormat()) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.newDocument();
                this.saveLayoutTo(document);
                PersistenceUtils.saveXMLDocumentToStream(document, outputStream, this.getXmlEncoding() == null ? PersistenceUtils.getDefaultXmlEncoding() : this.getXmlEncoding());
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
            }
            return;
        }
        for (LayoutPersistence layoutPersistence : this._entries) {
            layoutPersistence.saveLayoutTo(outputStream);
        }
    }

    @Override
    public void resetToDefault() {
        for (int i = 0; i < this._entries.size(); ++i) {
            LayoutPersistence layoutPersistence = this._entries.get(i);
            boolean bl = layoutPersistence.isLast();
            layoutPersistence.setLast(i == this._entries.size() - 1);
            layoutPersistence.resetToDefault();
            layoutPersistence.setLast(bl);
        }
    }

    @Override
    public void beginLoadLayoutData() {
        for (LayoutPersistence layoutPersistence : this._entries) {
            layoutPersistence.beginLoadLayoutData();
        }
    }

    @Override
    public void loadInitialLayout(String string) throws ParserConfigurationException, SAXException, IOException {
        for (LayoutPersistence layoutPersistence : this._entries) {
            layoutPersistence.loadInitialLayout(string);
        }
    }

    @Override
    public void loadInitialLayout(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        Object object;
        int n;
        Object object2 = new byte[10240];
        int n2 = 0;
        int n3 = ((byte[])object2).length;
        while ((n = inputStream.read((byte[])object2, n2, n3 - n2)) != -1) {
            if ((n2 += n) < n3) continue;
            object = new byte[n3 * 2];
            System.arraycopy(object2, 0, object, 0, ((byte[])object2).length);
            object2 = object;
            n3 = ((byte[])object2).length;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object2, 0, n2);
        byteArrayInputStream.mark(0);
        object = this._entries.iterator();
        while (object.hasNext()) {
            LayoutPersistence layoutPersistence = (LayoutPersistence)object.next();
            byteArrayInputStream.reset();
            layoutPersistence.loadInitialLayout(byteArrayInputStream);
        }
    }

    @Override
    public void loadInitialLayout(Document document) {
        for (LayoutPersistence layoutPersistence : this._entries) {
            layoutPersistence.loadInitialLayout(document);
        }
    }

    @Override
    public void setUseFrameBounds(boolean bl) {
        super.setUseFrameBounds(bl);
        for (LayoutPersistence layoutPersistence : this._entries) {
            layoutPersistence.setUseFrameBounds(bl);
        }
    }

    @Override
    public void setUseFrameState(boolean bl) {
        super.setUseFrameState(bl);
        for (LayoutPersistence layoutPersistence : this._entries) {
            layoutPersistence.setUseFrameState(bl);
        }
    }

    @Override
    public void setLayoutDirectory(String string) {
        super.setLayoutDirectory(string);
        for (LayoutPersistence layoutPersistence : this._entries) {
            layoutPersistence.setLayoutDirectory(string);
        }
    }

    @Override
    public void setVersion(short s) {
        super.setVersion(s);
        for (LayoutPersistence layoutPersistence : this._entries) {
            layoutPersistence.setVersion(s);
        }
    }

    @Override
    public void setUsePref(boolean bl) {
        super.setUsePref(bl);
        for (LayoutPersistence layoutPersistence : this._entries) {
            layoutPersistence.setUsePref(bl);
        }
    }

    @Override
    public void setProfileKey(String string) {
        super.setProfileKey(string);
        for (LayoutPersistence layoutPersistence : this._entries) {
            layoutPersistence.setProfileKey(string);
        }
    }

    @Override
    public boolean isLast() {
        return true;
    }

    @Override
    public void setLast(boolean bl) {
    }
}

