/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.status;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.status.StatusBarItem;
import com.jidesoft.status.StatusBarSeparator;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.Q;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;

public class StatusBar
extends JPanel
implements ComponentListener,
ContainerListener {
    private boolean _childrenOpaque = true;
    private boolean _autoAddSeparator = true;
    private ThemePainter _painter;
    private int _preferredHeight = 0;

    public StatusBar() {
        this.setLayout(new JideBoxLayout(this, 0));
        this.setBorder(UIDefaultsLookup.getBorder("StatusBar.border"));
        this.setChildrenOpaque(UIDefaultsLookup.getBoolean((Object)"StatusBar.childrenOpaque", true));
        PortingUtils.removeFocus(this);
        this.addContainerListener(this);
        this.updateUI();
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        super.addImpl(component, object, n);
        this._preferredHeight = 0;
    }

    @Override
    public void remove(int n) {
        super.remove(n);
        this._preferredHeight = 0;
    }

    @Override
    public void add(Component component, Object object) {
        super.add(component, object);
        if (component instanceof StatusBarItem) {
            StatusBarItem statusBarItem = (StatusBarItem)component;
            if (!this.isChildrenOpaque()) {
                JideSwingUtilities.setOpaqueRecursively(statusBarItem, false);
            }
            LookAndFeel.installBorder(statusBarItem, "StatusBarItem.border");
        }
    }

    public void remove(String string) {
        StatusBarItem statusBarItem = this.getItemByName(string);
        if (statusBarItem != null) {
            this.remove(statusBarItem);
        }
    }

    public boolean isAutoAddSeparator() {
        return this._autoAddSeparator;
    }

    public void setAutoAddSeparator(boolean bl) {
        this._autoAddSeparator = bl;
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        if (this.isAutoAddSeparator()) {
            containerEvent.getChild().addComponentListener(this);
            if (!(containerEvent.getChild() instanceof StatusBarSeparator)) {
                this.addExtraSeparator();
            }
            this.setSeparatorsVisible(true);
            this.resetToPreferredSizes();
        }
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        if (this.isAutoAddSeparator()) {
            containerEvent.getChild().removeComponentListener(this);
            if (!(containerEvent.getChild() instanceof StatusBarSeparator)) {
                this.removeExtraSeparator();
            }
            this.setSeparatorsVisible(false);
            this.resetToPreferredSizes();
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        if (this.isAutoAddSeparator()) {
            if (componentEvent.getComponent() instanceof StatusBarSeparator) {
                return;
            }
            this.setSeparatorsVisible(true);
            this.resetToPreferredSizes();
        }
    }

    public void resetToPreferredSizes() {
        this.doLayout();
    }

    private void setSeparatorsVisible(boolean bl) {
        if (this.getComponentCount() == 1) {
            this.setVisible(this.getComponent(0).isVisible());
        } else if (this.getComponentCount() > 1) {
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                if (!(component instanceof StatusBarSeparator)) {
                    if (!component.isVisible() || bl2) continue;
                    bl2 = true;
                    continue;
                }
                boolean bl4 = this.getComponent(i - 1).isVisible();
                boolean bl5 = this.getComponent(i + 1).isVisible();
                if (bl4 && bl5) {
                    component.setVisible(true);
                    continue;
                }
                if (!bl4 && !bl5) {
                    component.setVisible(false);
                    continue;
                }
                if (bl4 && !bl5) {
                    component.setVisible(false);
                    bl3 = true;
                    continue;
                }
                if (bl3) {
                    component.setVisible(true);
                    bl3 = false;
                    continue;
                }
                component.setVisible(false);
            }
            if (bl && !this.isVisible() && bl2) {
                this.setVisible(bl2);
            } else if (!bl && this.isVisible() && !bl2) {
                this.setVisible(bl2);
            }
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        if (this.isAutoAddSeparator()) {
            if (componentEvent.getComponent() instanceof StatusBarSeparator) {
                return;
            }
            this.setSeparatorsVisible(false);
            this.resetToPreferredSizes();
        }
    }

    protected boolean removeExtraSeparator() {
        int n = 0;
        if (this.getComponentCount() == 0) {
            return false;
        }
        boolean bl = false;
        if (this.getComponent(0) instanceof StatusBarSeparator) {
            this.remove(0);
            bl = true;
        }
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (component instanceof StatusBarSeparator) {
                if (++n != 2) continue;
                this.remove(component);
                bl = true;
                --n;
                --i;
                continue;
            }
            n = 0;
        }
        if (n == 1) {
            this.remove(this.getComponentCount() - 1);
            bl = true;
        }
        return bl;
    }

    protected void addExtraSeparator() {
        int n = 0;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof StatusBarSeparator)) {
                if (++n != 2) continue;
                this.add(this.createStatusBarSeparator(), "fix", i);
                n = 0;
                continue;
            }
            n = 0;
        }
    }

    protected StatusBarSeparator createStatusBarSeparator() {
        return new StatusBarSeparator();
    }

    public void addSeparator() {
        this.add((Component)this.createStatusBarSeparator(), "fix");
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.getBorder("StatusBarItem.border") == null || UIDefaultsLookup.getColor("StatusBar.background") == null || UIDefaultsLookup.getFont("StatusBar.font") == null) {
            LookAndFeelFactory.installJideExtension();
        }
        super.updateUI();
        this.setChildrenOpaque(UIDefaultsLookup.getBoolean((Object)"StatusBar.childrenOpaque", true));
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof StatusBarItem)) continue;
            StatusBarItem statusBarItem = (StatusBarItem)component;
            LookAndFeel.installBorder(statusBarItem, "StatusBarItem.border");
        }
        LookAndFeel.installColorsAndFont(this, "StatusBar.background", "StatusBar.foreground", "StatusBar.font");
        LookAndFeel.installBorder(this, "StatusBar.border");
    }

    public StatusBarItem getItemByName(String string) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            StatusBarItem statusBarItem;
            Component component = this.getComponent(i);
            if (!(component instanceof StatusBarItem) || !(statusBarItem = (StatusBarItem)component).getItemName().equals(string)) continue;
            return statusBarItem;
        }
        return null;
    }

    public int getPreferredHeight() {
        int n = 0;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof StatusBarItem)) continue;
            StatusBarItem statusBarItem = (StatusBarItem)component;
            Dimension dimension = statusBarItem.getPreferredSize();
            if (dimension.height <= n) continue;
            n = dimension.height;
        }
        Insets insets = this.getInsets();
        return n + insets.top + insets.bottom;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this._preferredHeight == 0) {
            this._preferredHeight = this.getPreferredHeight();
        }
        return new Dimension(0, this._preferredHeight);
    }

    public void setItemVisible(String string, boolean bl) {
        StatusBarItem statusBarItem = this.getItemByName(string);
        if (statusBarItem != null) {
            statusBarItem.setVisible(bl);
        }
        this.validate();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.isChildrenOpaque()) {
            super.paintComponent(graphics);
        } else if (this._painter != null) {
            this._painter.paintStatusBarBackground(this, graphics, new Rectangle(0, 0, this.getWidth(), this.getHeight()), 0, 0);
        }
    }

    public boolean isChildrenOpaque() {
        return this._childrenOpaque;
    }

    public void setChildrenOpaque(boolean bl) {
        this._childrenOpaque = bl;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof StatusBarItem)) continue;
            JideSwingUtilities.setOpaqueRecursively(component, this.isChildrenOpaque());
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(2)) {
            Lm.showInvalidProductMessage(StatusBar.class.getName(), 2);
        }
    }
}

