/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.shortcut;

import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.shortcut.KeyboardShortcut;
import com.jidesoft.shortcut.MouseShortcut;
import com.jidesoft.shortcut.Shortcut;
import com.jidesoft.shortcut.ShortcutEditorResource;
import com.jidesoft.shortcut.ShortcutIconsFactory;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.LabeledTextField;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ShortcutField
extends LabeledTextField {
    public static final int TYPE_KEYBOARD = 1;
    public static final int TYPE_MOUSE = 2;
    private int _allowedType = 3;
    private int _type = 1;
    private int _maximumAllowedKeystrokes = 3;
    private int _allowedKeystrokes = 1;
    private int _mouseClicks = 1;
    protected KeyListener _keyListener = this.createKeyListener();
    protected MouseListener _mouseListener = this.createMouseListener();
    private Shortcut _shortcut;
    protected transient ChangeEvent changeEvent = null;

    public ShortcutField() {
        this(3, 1);
    }

    public ShortcutField(int n) {
        this(n, n == 2 ? 2 : 1);
    }

    public ShortcutField(int n, int n2) {
        super(n2 == 1 ? ShortcutField.getDefaultKeyboardMenuIcon() : ShortcutField.getDefaultMouseMenuIcon());
        this.setType(n2);
        this.setAllowedType(n);
    }

    private static ImageIcon getDefaultMouseMenuIcon() {
        return ShortcutIconsFactory.getImageIcon("icons/mouse_menu.png");
    }

    private static ImageIcon getDefaultKeyboardMenuIcon() {
        return ShortcutIconsFactory.getImageIcon("icons/keyboard_menu.png");
    }

    private static ImageIcon getDefaultMouseIcon() {
        return ShortcutIconsFactory.getImageIcon("icons/mouse.png");
    }

    private static ImageIcon getDefaultKeyboardIcon() {
        return ShortcutIconsFactory.getImageIcon("icons/keyboard.png");
    }

    public int getType() {
        return this._type;
    }

    public void setType(int n) {
        if (1 != n && 2 != n) {
            throw new IllegalArgumentException("Illegal type: must be TYPE_KEYBOARD, or TYPE_MOUSE");
        }
        this._type = n;
        if (this._type == 2) {
            this.setIcon(ShortcutField.getDefaultMouseMenuIcon());
            this.getTextField().setCursor(Cursor.getDefaultCursor());
            this.getTextField().setCaretColor(this.getTextField().getBackground());
            this.getTextField().removeKeyListener(this._keyListener);
            if (!JideSwingUtilities.isMouseListenerRegistered(this.getTextField(), this._mouseListener)) {
                this.getTextField().addMouseListener(this._mouseListener);
            }
            this.getTextField().setEditable(false);
        } else {
            this.setIcon(ShortcutField.getDefaultKeyboardMenuIcon());
            this.getTextField().setCursor(Cursor.getPredefinedCursor(2));
            this.getTextField().setCaretColor(new JTextField().getCaretColor());
            if (!JideSwingUtilities.isKeyListenerRegistered(this.getTextField(), this._keyListener)) {
                this.getTextField().addKeyListener(this._keyListener);
            }
            this.getTextField().removeMouseListener(this._mouseListener);
            this.getTextField().setEditable(true);
        }
        this.clearShortcut();
    }

    public int getAllowedType() {
        return this._allowedType;
    }

    public void setAllowedType(int n) {
        this._allowedType = n;
        if (this._allowedType == 1) {
            this.setType(1);
        } else if (this._allowedType == 2) {
            this.setType(2);
        }
    }

    public int getMaximumAllowedKeystrokes() {
        return this._maximumAllowedKeystrokes;
    }

    public void setMaximumAllowedKeystrokes(int n) {
        if (n < 1) {
            n = 1;
        } else if (n > 3) {
            n = 3;
        }
        this._maximumAllowedKeystrokes = n;
    }

    public int getAllowedKeystrokes() {
        return this._allowedKeystrokes;
    }

    public void setAllowedKeystrokes(int n) {
        this._allowedKeystrokes = n;
        if (this._allowedKeystrokes > this.getMaximumAllowedKeystrokes()) {
            this._allowedKeystrokes = this.getMaximumAllowedKeystrokes();
        }
    }

    @Override
    protected JidePopupMenu createContextMenu() {
        ResourceBundle resourceBundle = ShortcutEditorResource.getResourceBundle(Locale.getDefault());
        JidePopupMenu jidePopupMenu = new JidePopupMenu();
        if (this.getType() == 1) {
            JMenuItem jMenuItem;
            if ((this.getAllowedType() & 2) != 0) {
                jMenuItem = jidePopupMenu.add(new JMenuItem(resourceBundle.getString("Shortcut.field.switchMouse"), ShortcutField.getDefaultMouseIcon()));
                jMenuItem.addActionListener(new AbstractAction(){
                    private static final long serialVersionUID = -4295891063363680876L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ShortcutField.this.setType(2);
                    }
                });
                jidePopupMenu.addSeparator();
            }
            jMenuItem = jidePopupMenu.add(new JMenuItem(KeyEvent.getKeyText(8)));
            jMenuItem.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = -5270380275809225947L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ShortcutField.this.addKeyStroke(KeyStroke.getKeyStroke(8, 0));
                }
            });
            jMenuItem = jidePopupMenu.add(new JMenuItem(KeyEvent.getKeyText(27)));
            jMenuItem.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = -8327643435951037432L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ShortcutField.this.addKeyStroke(KeyStroke.getKeyStroke(27, 0));
                }
            });
            jMenuItem = jidePopupMenu.add(new JMenuItem(KeyEvent.getKeyText(9)));
            jMenuItem.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 3690483347569179861L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ShortcutField.this.addKeyStroke(KeyStroke.getKeyStroke(9, 0));
                }
            });
            jMenuItem = jidePopupMenu.add(new JMenuItem(KeyEvent.getKeyText(16) + "+" + KeyEvent.getKeyText(9)));
            jMenuItem.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 6801274149072387013L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ShortcutField.this.addKeyStroke(KeyStroke.getKeyStroke(9, 1));
                }
            });
            jMenuItem = jidePopupMenu.add(new JMenuItem(KeyEvent.getKeyText(17) + "+" + KeyEvent.getKeyText(16) + "+" + KeyEvent.getKeyText(9)));
            jMenuItem.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = -4950906064567642880L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ShortcutField.this.addKeyStroke(KeyStroke.getKeyStroke(9, 3));
                }
            });
            final KeyStroke keyStroke = this.getContextMenuKeyStroke();
            if (keyStroke != null) {
                jMenuItem = jidePopupMenu.add(new JMenuItem((keyStroke.getModifiers() != 0 ? KeyEvent.getKeyModifiersText(keyStroke.getModifiers()) + "+" : "") + KeyEvent.getKeyText(keyStroke.getKeyCode())));
                jMenuItem.addActionListener(new AbstractAction(){
                    private static final long serialVersionUID = 7033988711280267468L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ShortcutField.this.addKeyStroke(keyStroke);
                    }
                });
            }
            int n = this.getAllowedKeystrokes();
            if (this.getMaximumAllowedKeystrokes() >= 2) {
                jidePopupMenu.addSeparator();
                ButtonGroup buttonGroup = new ButtonGroup();
                jMenuItem = jidePopupMenu.add(new JCheckBoxMenuItem(resourceBundle.getString("Shortcut.field.limit1")));
                jMenuItem.setSelected(n == 1);
                jMenuItem.addActionListener(new AbstractAction(){
                    private static final long serialVersionUID = 2939459387148417603L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ShortcutField.this.setAllowedKeystrokes(1);
                    }
                });
                buttonGroup.add(jMenuItem);
                jMenuItem = jidePopupMenu.add(new JCheckBoxMenuItem(resourceBundle.getString("Shortcut.field.limit2")));
                jMenuItem.setSelected(n == 2);
                jMenuItem.addActionListener(new AbstractAction(){
                    private static final long serialVersionUID = 8746540550003281294L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ShortcutField.this.setAllowedKeystrokes(2);
                    }
                });
                buttonGroup.add(jMenuItem);
                if (this.getMaximumAllowedKeystrokes() >= 3) {
                    jMenuItem = jidePopupMenu.add(new JCheckBoxMenuItem(resourceBundle.getString("Shortcut.field.limit3")));
                    jMenuItem.setSelected(n == 3);
                    jMenuItem.addActionListener(new AbstractAction(){
                        private static final long serialVersionUID = 6334981399606392609L;

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            ShortcutField.this.setAllowedKeystrokes(3);
                        }
                    });
                    buttonGroup.add(jMenuItem);
                }
            } else {
                this.setAllowedKeystrokes(1);
            }
        } else if (this.getType() == 2) {
            JMenuItem jMenuItem;
            if ((this.getAllowedType() & 1) != 0) {
                jMenuItem = jidePopupMenu.add(new JMenuItem(resourceBundle.getString("Shortcut.field.switchKeyboard"), ShortcutField.getDefaultKeyboardIcon()));
                jMenuItem.addActionListener(new AbstractAction(){
                    private static final long serialVersionUID = -1317879568995887083L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ShortcutField.this.setType(1);
                    }
                });
                jidePopupMenu.addSeparator();
            }
            ButtonGroup buttonGroup = new ButtonGroup();
            jMenuItem = jidePopupMenu.add(new JCheckBoxMenuItem(resourceBundle.getString("Shortcut.field.singleClick")));
            jMenuItem.setSelected(this._mouseClicks == 1);
            jMenuItem.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = -5761477398878605686L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ShortcutField.this._mouseClicks = 1;
                }
            });
            buttonGroup.add(jMenuItem);
            jMenuItem = jidePopupMenu.add(new JCheckBoxMenuItem(resourceBundle.getString("Shortcut.field.doubleClick")));
            jMenuItem.setSelected(this._mouseClicks == 2);
            jMenuItem.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = -8548470359087281776L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ShortcutField.this._mouseClicks = 2;
                }
            });
            buttonGroup.add(jMenuItem);
        }
        return jidePopupMenu;
    }

    public void addKeyStroke(KeyStroke keyStroke) {
        if (this._shortcut == null) {
            this._shortcut = this.createKeyboardShortcut();
        }
        if (((KeyboardShortcut)this._shortcut).getCount() >= this._allowedKeystrokes) {
            ((KeyboardShortcut)this._shortcut).clear();
        }
        ((KeyboardShortcut)this._shortcut).addKeyStroke(keyStroke);
        this.getTextField().setText(this.convertShortcutToString(this._shortcut));
        this.getTextField().requestFocus();
        this.fireStateChanged();
    }

    protected KeyboardShortcut createKeyboardShortcut() {
        return new KeyboardShortcut();
    }

    protected MouseShortcut createMouseShortcut() {
        return new MouseShortcut();
    }

    KeyListener createKeyListener() {
        return new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                keyEvent.consume();
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    return;
                }
                KeyStroke keyStroke = ShortcutField.this.getContextMenuKeyStroke();
                if (keyStroke != null && keyEvent.getKeyCode() == keyStroke.getKeyCode() && (keyEvent.getModifiers() | keyEvent.getModifiersEx()) == keyStroke.getModifiers()) {
                    return;
                }
                keyEvent.consume();
                switch (keyEvent.getKeyCode()) {
                    case 16: 
                    case 17: 
                    case 18: 
                    case 157: 
                    case 65406: {
                        return;
                    }
                }
                if (ShortcutField.this._shortcut == null) {
                    ShortcutField.this._shortcut = ShortcutField.this.createKeyboardShortcut();
                }
                JTextField jTextField = (JTextField)keyEvent.getSource();
                if (keyEvent.getKeyCode() == 8 && ((KeyboardShortcut)ShortcutField.this._shortcut).getCount() > 0) {
                    ((KeyboardShortcut)ShortcutField.this._shortcut).removeLastKeyStroke();
                } else {
                    if (((KeyboardShortcut)ShortcutField.this._shortcut).getCount() >= ShortcutField.this._allowedKeystrokes) {
                        ((KeyboardShortcut)ShortcutField.this._shortcut).clear();
                    }
                    ((KeyboardShortcut)ShortcutField.this._shortcut).addKeyStroke(KeyStroke.getKeyStrokeForEvent(keyEvent));
                }
                jTextField.setText(ShortcutField.this.convertShortcutToString(ShortcutField.this._shortcut));
                ShortcutField.this.fireStateChanged();
            }
        };
    }

    protected String convertShortcutToString(Shortcut shortcut) {
        return ObjectConverterManager.toString(shortcut);
    }

    MouseListener createMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (ShortcutField.this.isEnabled()) {
                    mouseEvent.consume();
                    JTextField jTextField = (JTextField)mouseEvent.getSource();
                    ShortcutField.this._shortcut = ShortcutField.this.createMouseShortcut();
                    ((MouseShortcut)ShortcutField.this._shortcut).setButton(mouseEvent.getButton());
                    ((MouseShortcut)ShortcutField.this._shortcut).setClickCount(ShortcutField.this._mouseClicks);
                    ((MouseShortcut)ShortcutField.this._shortcut).setModifiers(mouseEvent.getModifiersEx());
                    jTextField.setText(ShortcutField.this.convertShortcutToString(ShortcutField.this._shortcut));
                    ShortcutField.this.fireStateChanged();
                }
            }
        };
    }

    public void clearShortcut() {
        this._shortcut = null;
        this.getTextField().setText("");
        this.fireStateChanged();
    }

    public Shortcut getShortcut() {
        if (this._shortcut == null) {
            return null;
        }
        try {
            return (Shortcut)this._shortcut.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(64)) {
            Lm.showInvalidProductMessage(ShortcutField.class.getName(), 64);
        }
    }
}

