/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.scale;

import com.jidesoft.grid.TreeTable;
import com.jidesoft.plaf.GanttUIDefaultsCustomizer;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.PeriodHeaderPainter;
import com.jidesoft.plaf.ScaleAreaUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.scale.DefaultPeriodConverter;
import com.jidesoft.scale.Period;
import com.jidesoft.scale.PeriodConverter;
import com.jidesoft.scale.ScaleAreaPopupMenuCustomizer;
import com.jidesoft.scale.ScaleAreaResources;
import com.jidesoft.scale.ScaleModel;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class ScaleArea<T>
extends JComponent {
    private static final long serialVersionUID = -108765377692061814L;
    private static final String uiClassID = "ScaleAreaUI";
    public static final String PROPERTY_SCALE_MODEL = "scaleModel";
    public static final String PROPERTY_VISIBLE_PERIODS = "visiblePeriods";
    public static final String PROPERTY_SCALE_START = "scaleStart";
    public static final String PROPERTY_SCALE_END = "scaleEnd";
    public static final String PROPERTY_PREFERRED_PERIOD_SIZE = "preferredPeriodSize";
    public static final String PROPERTY_VISIBLE_PERIOD_COUNT = "visiblePeriodCount";
    public static final String PROPERTY_PERIOD_MARGIN = "periodMargin";
    public static final String PROPERTY_PERIOD_CONVERTERS = "periodConverters";
    public static final String PROPERTY_PERIOD_HEADER_PAINTER = "periodHeaderPainter";
    public static final String PROPERTY_PERIOD_BACKGROUND_PAINTER = "periodBackgroundPainter";
    public static final String PROPERTY_TREE_TABLE = "treeTable";
    public static final String PROPERTY_TABLE_CELL_RENDERER = "tableCellRenderer";
    public static final int DEFAULT_PERIOD_WIDTH = 27;
    public static final int DEFAULT_PERIOD_HEIGHT = 21;
    private static final int MINIMUM_PERIOD_WIDTH = 4;
    private ScaleModel<T> _scaleModel;
    private List<Period> _visiblePeriods = new ArrayList<Period>();
    private Dimension _preferredPeriodSize;
    private int _visiblePeriodCount = 20;
    private int _visiblePeriodTiers = 2;
    private int _periodMargin = 20;
    private T _start;
    private T _end;
    private PeriodConverter<T> _defaultConverter;
    private final Map<Period, PeriodConverter<T>> _converters = new HashMap<Period, PeriodConverter<T>>();
    private final List<ScaleAreaPopupMenuCustomizer<T>> popupMenuCustomizers = new ArrayList<ScaleAreaPopupMenuCustomizer<T>>();
    private PeriodHeaderPainter _periodHeaderPainter;
    private TreeTable _treeTable;
    private TableCellRenderer _tableCellRenderer;

    public ScaleArea() {
        this(null, new DefaultPeriodConverter());
    }

    public ScaleArea(ScaleModel<T> scaleModel, PeriodConverter<T> periodConverter) {
        this.setScaleModel(scaleModel);
        this.setDefaultPeriodConverter(periodConverter);
        this.updateUI();
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void setScaleModel(ScaleModel<T> scaleModel) {
        ScaleModel<T> scaleModel2 = this._scaleModel;
        this._scaleModel = scaleModel;
        ArrayList<Period> arrayList = new ArrayList<Period>();
        if (this._scaleModel != null) {
            this._start = scaleModel.getDefaultStart();
            this._end = scaleModel.getDefaultEnd();
            ArrayList<Period> arrayList2 = new ArrayList<Period>(scaleModel.getPeriods());
            if (arrayList2.isEmpty()) {
                throw new IllegalArgumentException("The ScaleModel must define at least one period!");
            }
            arrayList.addAll(this._visiblePeriods);
            arrayList.retainAll(arrayList2);
            if (arrayList.isEmpty()) {
                arrayList.addAll(arrayList2);
            }
        } else {
            this._start = null;
            this._end = null;
            arrayList = new ArrayList();
        }
        this.setVisiblePeriods(arrayList.subList(0, Math.min(arrayList.size(), Math.max(1, this._visiblePeriodTiers))), false);
        this.firePropertyChange(PROPERTY_SCALE_MODEL, scaleModel2, scaleModel);
        this.resizeAndRepaint();
    }

    public ScaleModel<T> getScaleModel() {
        return this._scaleModel;
    }

    public void setVisiblePeriods(List<? extends Period> list) {
        this.setVisiblePeriods(list, true);
    }

    public void setVisiblePeriods(List<? extends Period> list, boolean bl) {
        if (this._scaleModel != null && (!this._visiblePeriods.equals(list) || bl && this._visiblePeriodTiers != list.size())) {
            if (list == null || list.isEmpty()) {
                throw new IllegalArgumentException("At least one period must be visible!");
            }
            if (!this._scaleModel.getPeriods().containsAll(list)) {
                ArrayList<? extends Period> arrayList = new ArrayList<Period>(list);
                arrayList.removeAll(this._scaleModel.getPeriods());
                throw new IllegalArgumentException("The following periods are not defined in the scale model!\n" + arrayList);
            }
            List<Period> list2 = this._visiblePeriods;
            this._visiblePeriods = new ArrayList<Period>(list);
            if (bl) {
                this._visiblePeriodTiers = this._visiblePeriods.size();
            }
            this.firePropertyChange(PROPERTY_VISIBLE_PERIODS, list2, this._visiblePeriods);
            this.updateTreeTableHeaderHeight();
            this.resizeAndRepaint();
        }
    }

    protected void resizeAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    public List<Period> getVisiblePeriods() {
        return Collections.unmodifiableList(this._visiblePeriods);
    }

    public Period getSmallestVisiblePeriod() {
        if (this._scaleModel != null && !this._visiblePeriods.isEmpty()) {
            List<Period> list = this._scaleModel.getPeriods();
            Period period = this._visiblePeriods.get(0);
            for (int i = 1; i < this._visiblePeriods.size(); ++i) {
                Period period2 = this._visiblePeriods.get(i);
                if (list.indexOf(period2) >= list.indexOf(period)) continue;
                period = period2;
            }
            return period;
        }
        return null;
    }

    public int getVisiblePeriodCount() {
        return this._visiblePeriodCount;
    }

    public void setVisiblePeriodCount(int n) {
        if (this._visiblePeriodCount != n) {
            int n2 = this._visiblePeriodCount;
            this._visiblePeriodCount = n;
            this.firePropertyChange(PROPERTY_VISIBLE_PERIOD_COUNT, n2, this._visiblePeriodCount);
            this.resizeAndRepaint();
        }
    }

    public int getPeriodMargin() {
        return this._periodMargin;
    }

    public void setPeriodMargin(int n) {
        if (this._periodMargin != n) {
            int n2 = this._periodMargin;
            this._periodMargin = n;
            this.firePropertyChange(PROPERTY_PERIOD_MARGIN, n2, this._periodMargin);
            this.resizeAndRepaint();
        }
    }

    public void setVisiblePeriodsToFit(T t, T t2, int n) {
        if (t == null) {
            throw new IllegalArgumentException("start should not be null!");
        }
        if (t2 == null) {
            throw new IllegalArgumentException("end should not be null!");
        }
        ScaleModel<T> scaleModel = this.getScaleModel();
        if (scaleModel != null) {
            int n2;
            int n3;
            Object object;
            this.setStart(t);
            this.setEnd(t2);
            long l = scaleModel.getPosition(t2);
            ArrayList<Period> arrayList = new ArrayList<Period>(scaleModel.getPeriods());
            int n4 = arrayList.size() - 1;
            int n5 = n - this.getPeriodMargin() * 2;
            int n6 = Math.max(1, n5 / this.getPreferredPeriodSize().width);
            ScaleAreaUI scaleAreaUI = this.getUI();
            int n7 = n4;
            while (n7 >= 0) {
                object = (Period)arrayList.get(n7);
                n3 = scaleAreaUI != null ? scaleAreaUI.getPreferredPeriodSize((Period)object).width : this.getPreferredPeriodSize().width;
                T t3 = t;
                int n8 = 0;
                n2 = 0;
                do {
                    t3 = scaleModel.getPeriodEnd((Period)object, t3);
                    ++n2;
                } while (scaleModel.getPosition(t3) < l && (n8 += n3) < n5);
                if (n8 >= n5) break;
                n6 = n2;
                n4 = n7--;
            }
            Dimension dimension = scaleAreaUI != null ? scaleAreaUI.getPreferredPeriodSize((Period)arrayList.get(n4)) : this.getPreferredPeriodSize();
            dimension.width = Math.max(4, n5 / n6);
            this.setPreferredPeriodSize(dimension);
            object = new ArrayList<Period>(this.getVisiblePeriods());
            n3 = object.size();
            boolean bl = true;
            Object object2 = object.iterator();
            while (object2.hasNext()) {
                n2 = arrayList.indexOf(object2.next());
                if (n2 < n4) {
                    object2.remove();
                    continue;
                }
                if (n2 != n4) continue;
                bl = false;
            }
            if (bl) {
                object2 = (Period)arrayList.get(n4);
                if (object.size() < n3 || object.size() < this._visiblePeriodTiers) {
                    object.add(0, object2);
                } else {
                    object.set(0, object2);
                }
            }
            this.setVisiblePeriods((List<Period>)object, false);
        }
    }

    public void zoomPeriodWidth(double d) {
        Dimension dimension = this.getPreferredPeriodSize();
        dimension.width = (int)Math.max(4.0, Math.ceil((double)dimension.width * d));
        Period period = this.getSmallestVisiblePeriod();
        int n = this.getPreferredPeriodWidth(period);
        if (dimension.width < n) {
            if (d > 1.0) {
                this.setPreferredPeriodSize(dimension);
                return;
            }
            List<Period> list = this.getScaleModel().getPeriods();
            ArrayList<Period> arrayList = new ArrayList<Period>(this.getVisiblePeriods());
            int n2 = arrayList.indexOf(period);
            arrayList.remove(period);
            int n3 = list.indexOf(period);
            for (int i = n3 + 1; i < list.size(); ++i) {
                Period period2 = list.get(i);
                if (!arrayList.contains(period2)) {
                    arrayList.add(Math.min(n2, arrayList.size()), period2);
                    break;
                }
                ++n2;
            }
            if (arrayList.isEmpty()) {
                return;
            }
            this.setVisiblePeriods(arrayList, false);
            Period period3 = this.getSmallestVisiblePeriod();
            int n4 = this._scaleModel.getPeriodBoundaries(period, this._scaleModel.getPeriodStart(period3, this.getStart()), this._scaleModel.getPeriodEnd(period3, this.getStart())).size() - 1;
            dimension.width *= n4;
            this.setPreferredPeriodSize(dimension);
        } else {
            Period period4;
            if (d < 1.0) {
                this.setPreferredPeriodSize(dimension);
                return;
            }
            boolean bl = dimension.width > this.getVisibleRect().width - this.getPeriodMargin() * 2;
            List<Period> list = this.getScaleModel().getPeriods();
            ArrayList<Period> arrayList = new ArrayList<Period>(this.getVisiblePeriods());
            int n5 = list.indexOf(period);
            if (n5 > 0) {
                period4 = list.get(n5 - 1);
                arrayList.add(0, period4);
                if (arrayList.size() > this._visiblePeriodTiers) {
                    arrayList.remove(arrayList.size() - 1);
                }
            } else {
                if (bl) {
                    return;
                }
                this.setPreferredPeriodSize(dimension);
                return;
            }
            int n6 = this._scaleModel.getPeriodBoundaries(period4, this._scaleModel.getPeriodStart(period, this.getStart()), this._scaleModel.getPeriodEnd(period, this.getStart())).size() - 1;
            int n7 = dimension.width / n6;
            if (n7 >= this.getPreferredPeriodWidth(period4)) {
                this.setVisiblePeriods(arrayList, false);
                dimension.width = n7;
                this.setPreferredPeriodSize(dimension);
            } else {
                this.setPreferredPeriodSize(dimension);
            }
        }
    }

    private int getPreferredPeriodWidth(Period period) {
        ScaleAreaUI scaleAreaUI = this.getUI();
        if (scaleAreaUI != null) {
            return scaleAreaUI.getPreferredPeriodSize((Period)period).width;
        }
        return 27;
    }

    public T getStart() {
        return this._start;
    }

    public void setStart(T t) {
        if (t == null) {
            throw new IllegalArgumentException("Start instant cannot be null");
        }
        if (!JideSwingUtilities.equals(this._start, t)) {
            T t2 = this._start;
            this._start = t;
            this.firePropertyChange(PROPERTY_SCALE_START, t2, this._start);
            this.resizeAndRepaint();
            if (this._scaleModel != null && this._scaleModel.getPosition(this._start) >= this._scaleModel.getPosition(this._end)) {
                this.setEnd(this._scaleModel.getPeriodEnd(this.getSmallestVisiblePeriod(), this._start));
            }
        }
    }

    public T getEnd() {
        return this._end;
    }

    public void setEnd(T t) {
        if (t == null) {
            throw new IllegalArgumentException("End instant cannot be null");
        }
        if (!JideSwingUtilities.equals(this._end, t)) {
            T t2 = this._end;
            this._end = t;
            this.firePropertyChange(PROPERTY_SCALE_END, t2, this._end);
            this.resizeAndRepaint();
            if (this._scaleModel != null && this._scaleModel.getPosition(this._start) >= this._scaleModel.getPosition(this._end)) {
                this.setStart(this._scaleModel.getPeriodStart(this.getSmallestVisiblePeriod(), this._end));
            }
        }
    }

    public T getInstantAt(int n) {
        ScaleAreaUI scaleAreaUI = this.getUI();
        if (scaleAreaUI != null && this._scaleModel != null) {
            long l = scaleAreaUI.getPositionAt(n);
            return this._scaleModel.getInstantAt(l);
        }
        return null;
    }

    public int getX(T t) {
        ScaleAreaUI scaleAreaUI = this.getUI();
        if (t != null && scaleAreaUI != null && this._scaleModel != null) {
            long l = this._scaleModel.getPosition(t);
            return scaleAreaUI.getX(l);
        }
        return 0;
    }

    public Dimension getPreferredPeriodSize() {
        if (this._preferredPeriodSize != null) {
            return new Dimension(this._preferredPeriodSize);
        }
        ScaleAreaUI scaleAreaUI = this.getUI();
        if (scaleAreaUI != null) {
            return scaleAreaUI.getPreferredPeriodSize(this.getSmallestVisiblePeriod());
        }
        return new Dimension(27, 21);
    }

    public void setPreferredPeriodSize(Dimension dimension) {
        if (dimension != null && (dimension.width <= 0 || dimension.height <= 0)) {
            throw new IllegalArgumentException("Period sizes should be greater than zero!");
        }
        if (!JideSwingUtilities.equals(this._preferredPeriodSize, dimension)) {
            Dimension dimension2 = this._preferredPeriodSize;
            this._preferredPeriodSize = new Dimension(dimension);
            this.firePropertyChange(PROPERTY_PREFERRED_PERIOD_SIZE, dimension2, this._preferredPeriodSize);
            this.updateTreeTableHeaderHeight();
            this.resizeAndRepaint();
        }
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
        this.updateTreeTableHeaderHeight();
    }

    public boolean isPreferredPeriodSizeSet() {
        return this._preferredPeriodSize != null;
    }

    public PeriodConverter<T> getPeriodConverter(Period period) {
        PeriodConverter<T> periodConverter = this._converters.get(period);
        if (periodConverter == null) {
            periodConverter = this.getDefaultPeriodConverter();
        }
        return periodConverter;
    }

    public void setPeriodConverter(Period period, PeriodConverter<T> periodConverter) {
        PeriodConverter<T> periodConverter2 = this._converters.get(period);
        this._converters.put(period, periodConverter);
        this.firePropertyChange(PROPERTY_PERIOD_CONVERTERS, periodConverter2, periodConverter);
        this.repaint();
    }

    public PeriodConverter<T> getDefaultPeriodConverter() {
        return this._defaultConverter;
    }

    public void setDefaultPeriodConverter(PeriodConverter<T> periodConverter) {
        PeriodConverter<T> periodConverter2 = this._defaultConverter;
        this._defaultConverter = periodConverter;
        this.firePropertyChange(PROPERTY_PERIOD_CONVERTERS, periodConverter2, this._defaultConverter);
        this.repaint();
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        int n;
        Period period;
        ScaleAreaUI scaleAreaUI = this.getUI();
        if (scaleAreaUI != null && this._scaleModel != null && (period = scaleAreaUI.getPeriodAt(n = mouseEvent.getY())) != null) {
            int n2 = mouseEvent.getX();
            T t = this.getInstantAt(n2);
            T t2 = this._scaleModel.getPeriodStart(period, t);
            T t3 = this._scaleModel.getPeriodEnd(period, t);
            return this.getPeriodConverter(period).getDescription(t2, t3);
        }
        return super.getToolTipText();
    }

    public void setPeriodHeaderPainter(PeriodHeaderPainter periodHeaderPainter) {
        PeriodHeaderPainter periodHeaderPainter2 = this._periodHeaderPainter;
        this._periodHeaderPainter = periodHeaderPainter;
        this.firePropertyChange(PROPERTY_PERIOD_HEADER_PAINTER, periodHeaderPainter2, this._periodHeaderPainter);
        this.repaint();
    }

    public PeriodHeaderPainter getPeriodHeaderPainter() {
        return this._periodHeaderPainter;
    }

    public void setTreeTable(TreeTable treeTable) {
        TreeTable treeTable2 = this._treeTable;
        if (treeTable2 == treeTable) {
            return;
        }
        this._treeTable = treeTable;
        this.firePropertyChange(PROPERTY_TREE_TABLE, treeTable2, this._treeTable);
        this.updateTreeTableHeaderHeight();
    }

    private void updateTreeTableHeaderHeight() {
        if (this._treeTable != null && this._treeTable.getTableHeader() != null) {
            JTableHeader jTableHeader = this._treeTable.getTableHeader();
            jTableHeader.revalidate();
        }
    }

    public TreeTable getTreeTable() {
        return this._treeTable;
    }

    public void setTableCellRenderer(TableCellRenderer tableCellRenderer) {
        TableCellRenderer tableCellRenderer2 = this._tableCellRenderer;
        this._tableCellRenderer = tableCellRenderer;
        this.firePropertyChange(PROPERTY_TABLE_CELL_RENDERER, tableCellRenderer2, this._tableCellRenderer);
        this.updateTreeTableHeaderHeight();
    }

    public TableCellRenderer getTableCellRenderer() {
        if (this._tableCellRenderer != null) {
            return this._tableCellRenderer;
        }
        return null;
    }

    public List<ScaleAreaPopupMenuCustomizer<T>> getPopupMenuCustomizers() {
        return Collections.unmodifiableList(this.popupMenuCustomizers);
    }

    public void addPopupMenuCustomizer(ScaleAreaPopupMenuCustomizer<T> scaleAreaPopupMenuCustomizer) {
        this.popupMenuCustomizers.add(scaleAreaPopupMenuCustomizer);
    }

    public void removePopupMenuCustomizer(ScaleAreaPopupMenuCustomizer<T> scaleAreaPopupMenuCustomizer) {
        this.popupMenuCustomizers.remove(scaleAreaPopupMenuCustomizer);
    }

    protected void setUI(ScaleAreaUI scaleAreaUI) {
        super.setUI(scaleAreaUI);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public ScaleAreaUI getUI() {
        return (ScaleAreaUI)this.ui;
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            int n = LookAndFeelFactory.getStyle();
            if (n >= 0) {
                LookAndFeelFactory.installJideExtension(n);
            } else {
                LookAndFeelFactory.installJideExtension();
            }
            new GanttUIDefaultsCustomizer().customize(UIManager.getLookAndFeelDefaults());
        }
        this.setUI((ScaleAreaUI)UIManager.getUI(this));
    }

    public String getResourceString(String string) {
        return ScaleAreaResources.getResourceBundle(this.getLocale()).getString(string);
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(8192)) {
            Lm.showInvalidProductMessage(ScaleArea.class.getName(), 8192);
        }
    }
}

