/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.scale;

import com.jidesoft.scale.AbstractScaleModel;
import com.jidesoft.scale.NumberPeriod;
import com.jidesoft.scale.Period;

public class NumberScaleModel
extends AbstractScaleModel<Integer> {
    private static final long serialVersionUID = 6609177584771927835L;

    public NumberScaleModel() {
        super(0, 100, NumberPeriod.ONE, NumberPeriod.TWO, NumberPeriod.FOUR, NumberPeriod.EIGHT);
    }

    public NumberScaleModel(int n, int n2, NumberPeriod ... numberPeriodArray) {
        super(n, n2, numberPeriodArray);
    }

    @Override
    public Integer getInstantAt(long l) {
        return Long.valueOf(l).intValue();
    }

    @Override
    public Integer getPeriodEnd(Period period, Integer n) {
        int n2 = ((NumberPeriod)period).getDuration();
        int n3 = this.getPeriodOffset(n, n2);
        return n - n3 + n2;
    }

    private int getPeriodOffset(int n, int n2) {
        int n3 = n % n2;
        if (n < 0 && n3 != 0) {
            n3 = n2 + n % n2;
        }
        return n3;
    }

    @Override
    public Integer getPeriodStart(Period period, Integer n) {
        int n2 = ((NumberPeriod)period).getDuration();
        int n3 = this.getPeriodOffset(n, n2);
        return n - n3;
    }

    @Override
    public long getPosition(Integer n) {
        return n.intValue();
    }
}

