/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.scale;

import com.jidesoft.scale.AbstractScaleModel;
import com.jidesoft.scale.DatePeriod;
import com.jidesoft.scale.Period;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DateScaleModel
extends AbstractScaleModel<Date> {
    private static final long serialVersionUID = -2522724722032286931L;
    private static final Map<Integer, int[]> FIELDS_TO_TRUNCATE = new HashMap<Integer, int[]>();
    private final Locale _locale;

    public DateScaleModel() {
        this(DatePeriod.DAY_OF_WEEK, DatePeriod.FIRST_DAY_OF_WEEK, DatePeriod.MONTH, DatePeriod.QUARTER, DatePeriod.YEAR);
    }

    public DateScaleModel(DatePeriod ... datePeriodArray) {
        this(Locale.getDefault(), new Date(), DateScaleModel.add(Locale.getDefault(), 1, 1, new Date()), datePeriodArray);
    }

    public DateScaleModel(Locale locale, Date date, Date date2, DatePeriod ... datePeriodArray) {
        super(date, date2, datePeriodArray);
        this._locale = locale;
    }

    public Locale getLocale() {
        return this._locale;
    }

    private static Date add(Locale locale, int n, int n2, Date date) {
        Calendar calendar = Calendar.getInstance(locale);
        calendar.setTime(date);
        calendar.add(n, n2);
        return calendar.getTime();
    }

    @Override
    public Date getInstantAt(long l) {
        Calendar calendar = Calendar.getInstance(this._locale);
        calendar.setTimeInMillis(l);
        return calendar.getTime();
    }

    @Override
    public Date getPeriodEnd(Period period, Date date) {
        DatePeriod datePeriod = (DatePeriod)period;
        Calendar calendar = this.getPeriodCalendarStart(datePeriod, date);
        calendar.add(datePeriod.getCalendarField(), datePeriod.getAmount());
        return calendar.getTime();
    }

    @Override
    public Date getPeriodStart(Period period, Date date) {
        Calendar calendar = this.getPeriodCalendarStart((DatePeriod)period, date);
        return calendar.getTime();
    }

    private Calendar getPeriodCalendarStart(DatePeriod datePeriod, Date date) {
        int[] nArray;
        Calendar calendar = Calendar.getInstance(this._locale);
        calendar.setTime(date);
        int n = datePeriod.getCalendarField();
        this.roundToAmount(calendar, datePeriod);
        for (int n2 : nArray = FIELDS_TO_TRUNCATE.get(n)) {
            this.truncate(calendar, n2);
        }
        return calendar;
    }

    private void roundToAmount(Calendar calendar, DatePeriod datePeriod) {
        if (datePeriod.getAmount() != 1) {
            int n = datePeriod.getCalendarField();
            int n2 = calendar.getActualMinimum(n);
            int n3 = calendar.get(n);
            int n4 = (n2 + n3 + datePeriod.getOffset()) % datePeriod.getAmount();
            calendar.set(n, n3 - n4);
        }
    }

    private void truncate(Calendar calendar, int n) {
        int n2 = calendar.getActualMinimum(n);
        if (n == 7) {
            n2 = calendar.getFirstDayOfWeek();
        }
        calendar.set(n, n2);
    }

    @Override
    public long getPosition(Date date) {
        Calendar calendar = Calendar.getInstance(this._locale);
        calendar.setTime(date);
        return calendar.getTimeInMillis();
    }

    @Override
    public List<Date> getPeriodBoundaries(Period period, Date date, Date date2) {
        Date date3;
        ArrayList<Date> arrayList = new ArrayList<Date>();
        DatePeriod datePeriod = (DatePeriod)period;
        Calendar calendar = this.getPeriodCalendarStart(datePeriod, date);
        arrayList.add(calendar.getTime());
        do {
            calendar.add(datePeriod.getCalendarField(), datePeriod.getAmount());
            date3 = calendar.getTime();
            arrayList.add(date3);
        } while (date3.before(date2));
        return arrayList;
    }

    static {
        FIELDS_TO_TRUNCATE.put(0, new int[]{1, 2, 5, 11, 12, 13, 14});
        FIELDS_TO_TRUNCATE.put(1, new int[]{2, 5, 11, 12, 13, 14});
        FIELDS_TO_TRUNCATE.put(2, new int[]{5, 11, 12, 13, 14});
        FIELDS_TO_TRUNCATE.put(3, new int[]{7, 11, 12, 13, 14});
        FIELDS_TO_TRUNCATE.put(4, new int[]{7, 11, 12, 13, 14});
        FIELDS_TO_TRUNCATE.put(5, new int[]{11, 12, 13, 14});
        FIELDS_TO_TRUNCATE.put(6, new int[]{11, 12, 13, 14});
        FIELDS_TO_TRUNCATE.put(7, new int[]{11, 12, 13, 14});
        FIELDS_TO_TRUNCATE.put(8, new int[]{7, 11, 12, 13, 14});
        FIELDS_TO_TRUNCATE.put(9, new int[]{10, 12, 13, 14});
        FIELDS_TO_TRUNCATE.put(10, new int[]{12, 13, 14});
        FIELDS_TO_TRUNCATE.put(11, new int[]{12, 13, 14});
        FIELDS_TO_TRUNCATE.put(12, new int[]{13, 14});
        FIELDS_TO_TRUNCATE.put(13, new int[]{14});
        FIELDS_TO_TRUNCATE.put(14, new int[0]);
    }
}

