/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.rss;

import com.jidesoft.rss.ChannelTreeNode;
import com.jidesoft.rss.FeedReader;
import com.jidesoft.swing.StyleRange;
import com.jidesoft.tree.StyledTreeCellRenderer;
import de.nava.informa.core.ChannelGroupIF;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.utils.ItemComparator;
import java.awt.Component;
import java.util.Arrays;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;

class FeedTreeCellRender
extends StyledTreeCellRenderer {
    private FeedReader _feedReader = null;

    public FeedTreeCellRender(FeedReader feedReader) {
        this._feedReader = feedReader;
    }

    @Override
    protected void customizeStyledLabel(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        super.customizeStyledLabel(jTree, object, bl, bl2, bl3, n, bl4);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        this.clearStyleRanges();
        Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        if (defaultMutableTreeNode.getUserObject() instanceof ChannelIF) {
            final ChannelIF channelIF = (ChannelIF)defaultMutableTreeNode.getUserObject();
            this.setIcon(this._feedReader.getChannelIcon(channelIF));
            Set set = channelIF.getItems();
            ItemIF[] itemIFArray = set.toArray(new ItemIF[set.size()]);
            Arrays.sort(itemIFArray, new ItemComparator(true));
            int n2 = 0;
            int n3 = 0;
            Object object2 = itemIFArray;
            int n4 = ((ItemIF[])object2).length;
            for (int i = 0; i < n4; ++i) {
                ItemIF itemIF = object2[i];
                if (n2 >= this._feedReader.getMaxCacheItems()) break;
                if (itemIF == null) continue;
                if (itemIF.getUnRead()) {
                    ++n3;
                }
                ++n2;
            }
            if (n3 == 0) {
                this.setText(channelIF.getTitle());
            } else {
                this.setText(channelIF.getTitle() + " (" + n3 + ")");
                this.addStyleRange(new StyleRange(1));
            }
            if (defaultMutableTreeNode instanceof ChannelTreeNode && (n4 = ((ChannelTreeNode)(object2 = (ChannelTreeNode)defaultMutableTreeNode)).getUnreadItemCount()) != n3) {
                ((ChannelTreeNode)object2).setUnreadItemCount(n3);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        FeedTreeCellRender.this._feedReader.fireChannelEvent(12210, channelIF);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        } else if (defaultMutableTreeNode.getUserObject() instanceof ChannelGroupIF) {
            ChannelGroupIF channelGroupIF = (ChannelGroupIF)defaultMutableTreeNode.getUserObject();
            int n5 = jTree.getModel().getChildCount(defaultMutableTreeNode);
            int n6 = 0;
            if (n5 > 0) {
                for (int i = 0; i < n5; ++i) {
                    Object object3 = jTree.getModel().getChild(defaultMutableTreeNode, i);
                    if (!(object3 instanceof ChannelTreeNode)) continue;
                    n6 += ((ChannelTreeNode)object3).getUnreadItemCount();
                }
            }
            if (n6 == 0) {
                this.setText(channelGroupIF.getTitle());
            } else {
                this.setText(channelGroupIF.getTitle() + " (" + n6 + ")");
                this.addStyleRange(new StyleRange(1));
            }
        }
        return component;
    }
}

