/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.rss;

import com.jidesoft.grid.QuickTableFilterField;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.rss.AddChannelAction;
import com.jidesoft.rss.AddGroupAction;
import com.jidesoft.rss.BrowserAction;
import com.jidesoft.rss.BrowserLauncher;
import com.jidesoft.rss.ChannelPopupMenuAction;
import com.jidesoft.rss.ChannelPropertyAction;
import com.jidesoft.rss.ChannelPropertyDialog;
import com.jidesoft.rss.ChannelTreeNode;
import com.jidesoft.rss.ClearChannelHistoryAction;
import com.jidesoft.rss.DefaultFeedPreference;
import com.jidesoft.rss.DeleteChannelAction;
import com.jidesoft.rss.DeleteGroupAction;
import com.jidesoft.rss.FeedConstants;
import com.jidesoft.rss.FeedDatabasePersistenceManager;
import com.jidesoft.rss.FeedEvent;
import com.jidesoft.rss.FeedEventListener;
import com.jidesoft.rss.FeedIconsFactory;
import com.jidesoft.rss.FeedItemTableModel;
import com.jidesoft.rss.FeedPreference;
import com.jidesoft.rss.FeedResource;
import com.jidesoft.rss.FeedTable;
import com.jidesoft.rss.FeedTreeCellRender;
import com.jidesoft.rss.FeedTreeModel;
import com.jidesoft.rss.FeedTreeModelListener;
import com.jidesoft.rss.GroupPropertyAction;
import com.jidesoft.rss.HyperlinkAction;
import com.jidesoft.rss.ItemPopupMenuAction;
import com.jidesoft.rss.MakeAllItemsReadAction;
import com.jidesoft.rss.MakeAllItemsUnreadAction;
import com.jidesoft.rss.MoveChannelAction;
import com.jidesoft.rss.PreferenceAction;
import com.jidesoft.rss.ReloadAllChannelsAction;
import com.jidesoft.rss.ReloadChannelAction;
import com.jidesoft.rss.SelectItemAction;
import com.jidesoft.rss.ToggleItemAction;
import com.jidesoft.rss.TreeSelectAction;
import com.jidesoft.rss.VisitChannelAction;
import com.jidesoft.rss.VisitItemAction;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.TreeSearchable;
import com.jidesoft.tree.TreeUtils;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import de.nava.informa.core.ChannelBuilderIF;
import de.nava.informa.core.ChannelGroupIF;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.core.ParseException;
import de.nava.informa.impl.basic.ChannelBuilder;
import de.nava.informa.impl.basic.ChannelGroup;
import de.nava.informa.parsers.FeedParser;
import de.nava.informa.utils.ItemComparator;
import de.nava.informa.utils.manager.PersistenceManagerException;
import de.nava.informa.utils.manager.PersistenceManagerIF;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FeedReader
extends JPanel
implements FeedEventListener {
    public static String LOGGER_NAME;
    public static String EVENT_LOGGER_NAME;
    private static final Logger LOGGER;
    private static final Logger EVENT_LOGGER;
    private JTree _feedTree;
    private DefaultMutableTreeNode _rootNode;
    private FeedTreeModel _groupTreeModel;
    private FeedTable _feedTable;
    private FeedItemTableModel _itemTableModel;
    private Component _editor;
    private Component _editorTitleLabel;
    private Component _editorLinkLabel;
    private AbstractButton _addChannelButton;
    private AbstractButton _channelPropertyButton;
    private AbstractButton _deleteChannelButton;
    private AbstractButton _reloadChannelButton;
    private AbstractButton _moveChannelButton;
    private AbstractButton _addGroupButton;
    private AbstractButton _deleteGroupButton;
    private AbstractButton _groupPropertyButton;
    private QuickTableFilterField _filterField;
    private JPanel _editorBottomPane;
    private Timer _timer;
    private JPopupMenu _channelPopupMenu;
    private JPopupMenu _groupPopupMenu;
    private JPopupMenu _itemPopupMenu;
    private AddChannelAction _addChannelAction;
    private ChannelPropertyAction _channelPropertyAction;
    private DeleteChannelAction _deleteChannelAction;
    private ReloadChannelAction _reloadChannelAction;
    private ReloadAllChannelsAction _reloadAllChannelsAction;
    private PreferenceAction _preferenceAction;
    private MakeAllItemsReadAction _makeAllItemsReadAction;
    private MakeAllItemsUnreadAction _makeAllItemsUnreadAction;
    private VisitChannelAction _visitChannelAction;
    private ClearChannelHistoryAction _clearHistoryAction;
    private ToggleItemAction _toggleItemAction;
    private VisitItemAction _visitItemAction;
    private AddGroupAction _addGroupAction;
    private DeleteGroupAction _deleteGroupAction;
    private MoveChannelAction _moveChannelAction;
    private GroupPropertyAction _groupPropertyAction;
    private FeedPreference _feedPreference;
    private PersistenceManagerIF _feedPersistence;
    private transient ItemIF _lastSelectedItem;
    private String[] _defaultChannels;
    private String _userDataPath;
    private boolean _isAllowGroup;
    private String _defaultSelectedChannel;
    private Color _invalidHtmlBrowserColor;
    private Color _validHtmlBrowserColor;
    protected EventListenerList listenerList;

    public FeedReader() {
        this(new String[0]);
    }

    public FeedReader(String string) {
        this(string, new String[0]);
    }

    public FeedReader(String[] stringArray) {
        this(null, stringArray);
    }

    public FeedReader(String[] stringArray, String string) {
        this(null, stringArray, string);
    }

    public FeedReader(String[] stringArray, boolean bl) {
        this(null, null, bl, null, stringArray);
    }

    public FeedReader(String string, String[] stringArray) {
        this(null, null, true, string, stringArray);
    }

    public FeedReader(String string, String[] stringArray, String string2) {
        this(null, null, true, string, stringArray, string2);
    }

    public FeedReader(String[] stringArray, String string, boolean bl) {
        this(null, null, bl, string, stringArray);
    }

    public FeedReader(PersistenceManagerIF persistenceManagerIF, FeedPreference feedPreference, boolean bl, String string, String[] stringArray) {
        this(persistenceManagerIF, feedPreference, bl, string, stringArray, null);
    }

    public FeedReader(PersistenceManagerIF persistenceManagerIF, FeedPreference feedPreference, boolean bl, String string, String[] stringArray, String string2) {
        block4: {
            this._feedTree = null;
            this._feedTable = null;
            this._editor = null;
            this._timer = null;
            this._channelPopupMenu = null;
            this._groupPopupMenu = null;
            this._itemPopupMenu = null;
            this._feedPreference = null;
            this._feedPersistence = null;
            this._lastSelectedItem = null;
            this._userDataPath = null;
            this._isAllowGroup = true;
            this._defaultSelectedChannel = null;
            this.listenerList = new EventListenerList();
            Object object = UIManager.getDefaults().get("FeedReader.inactiveBrowserBackground");
            this._invalidHtmlBrowserColor = object instanceof Color ? (Color)object : Color.gray;
            object = UIManager.getDefaults().get("FeedReader.activeBrowserBackground");
            this._validHtmlBrowserColor = object instanceof Color ? (Color)object : Color.white;
            this._userDataPath = string == null ? FeedConstants.DEFAULT_USER_DATA_PATH : string;
            this._feedPersistence = persistenceManagerIF == null ? new FeedDatabasePersistenceManager(this) : persistenceManagerIF;
            this._feedPreference = feedPreference != null ? feedPreference : this.createFeedPreference();
            this._isAllowGroup = bl;
            this._defaultSelectedChannel = string2;
            ChannelGroup channelGroup = new ChannelGroup();
            channelGroup.setId(0L);
            channelGroup.setTitle(this.getResourceString("RssFeeds.tree.defaultGroup"));
            this._rootNode = new DefaultMutableTreeNode(channelGroup);
            this._groupTreeModel = new FeedTreeModel(this, this._rootNode);
            this._itemTableModel = new FeedItemTableModel(this.getFeedPreference().getMaxCacheItems(), this.getFeedPersistenceManager()){
                private static final long serialVersionUID = 7394319403807090217L;

                @Override
                public String getColumnName(int n) {
                    switch (n) {
                        case 1: {
                            return FeedReader.this.getResourceString("RssFeeds.tableColumn.title");
                        }
                        case 2: {
                            return FeedReader.this.getResourceString("RssFeeds.tableColumn.date");
                        }
                        case 3: {
                            return FeedReader.this.getResourceString("RssFeeds.tableColumn.author");
                        }
                    }
                    return " ";
                }
            };
            this.initialize();
            this._defaultChannels = stringArray;
            if (this._feedPersistence != null) {
                try {
                    for (String string3 : stringArray) {
                        this.addChannel(string3);
                    }
                }
                catch (Exception exception) {
                    if (!FeedReader.getLogger().isLoggable(Level.WARNING)) break block4;
                    FeedReader.getLogger().warning(exception.getLocalizedMessage());
                }
            }
        }
    }

    protected FeedPreference createFeedPreference() {
        return new DefaultFeedPreference();
    }

    public String getTitle() {
        return this.getResourceString("RssFeeds.title");
    }

    public void initialize() {
        this.createActions();
        this.layoutComponents();
        this._channelPopupMenu = this.createChannelPopupMenu();
        this._groupPopupMenu = this.createGroupPopupMenu();
        this._itemPopupMenu = this.createItemPopupMenu();
        this.installListeners();
        this.loadData();
    }

    private JPopupMenu createGroupPopupMenu() {
        JidePopupMenu jidePopupMenu = new JidePopupMenu();
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setAction(this._addGroupAction);
        jidePopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem();
        jMenuItem.setAction(this._deleteGroupAction);
        jidePopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem();
        jMenuItem.setAction(this._groupPropertyAction);
        jidePopupMenu.add(jMenuItem);
        jidePopupMenu.addSeparator();
        jMenuItem = new JMenuItem();
        jMenuItem.setAction(this._addChannelAction);
        jidePopupMenu.add(jMenuItem);
        return jidePopupMenu;
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.layoutComponents(this.createToolBar(), this.createChannelPane(), this.createItemPane(), this.createBrowserPane()), "Center");
    }

    protected JComponent layoutComponents(Component component, Component component2, Component component3, Component component4) {
        component2.setMinimumSize(new Dimension(10, 10));
        component3.setMinimumSize(new Dimension(10, 10));
        component4.setMinimumSize(new Dimension(10, 10));
        JideSplitPane jideSplitPane = new JideSplitPane(0);
        jideSplitPane.add(component3);
        jideSplitPane.add(component4, "vary");
        JideSplitPane jideSplitPane2 = new JideSplitPane(1);
        jideSplitPane2.add(component2);
        jideSplitPane2.add((Component)jideSplitPane, "vary");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(component, "First");
        jPanel.add((Component)jideSplitPane2, "Center");
        return jPanel;
    }

    public void dispose() {
        block3: {
            try {
                if (this.getFeedPersistenceManager() instanceof FeedDatabasePersistenceManager) {
                    FeedDatabasePersistenceManager feedDatabasePersistenceManager = (FeedDatabasePersistenceManager)this.getFeedPersistenceManager();
                    feedDatabasePersistenceManager.close();
                }
            }
            catch (Exception exception) {
                if (!FeedReader.getLogger().isLoggable(Level.WARNING)) break block3;
                FeedReader.getLogger().warning(exception.getLocalizedMessage());
            }
        }
    }

    private void loadData() {
        block24: {
            Object object;
            ChannelIF channelIF;
            block23: {
                channelIF = null;
                try {
                    ChannelGroupIF[] channelGroupIFArray = this._feedPersistence.getGroups();
                    if (this.isAllowGroup()) {
                        if (channelGroupIFArray != null && channelGroupIFArray.length > 0) {
                            Collection collection;
                            object = null;
                            for (ChannelGroupIF channelGroupIF : channelGroupIFArray) {
                                collection = channelGroupIF.getAll();
                                if (channelGroupIF.getTitle().equals(this.getResourceString("RssFeeds.tree.defaultGroup"))) {
                                    object = channelGroupIF;
                                    continue;
                                }
                                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(channelGroupIF);
                                if (collection != null && !collection.isEmpty()) {
                                    for (ChannelIF channelIF2 : collection) {
                                        if (this.getDefaultSelectedChannel() != null && this.getDefaultSelectedChannel().equals(channelIF2.getLocation().toExternalForm())) {
                                            channelIF = channelIF2;
                                        }
                                        defaultMutableTreeNode.add(new ChannelTreeNode(channelIF2));
                                    }
                                }
                                this._rootNode.add(defaultMutableTreeNode);
                            }
                            if (object == null) {
                                object = this._feedPersistence.createGroup(this.getResourceString("RssFeeds.tree.defaultGroup"));
                            } else {
                                collection = object.getAll();
                                if (collection != null && !collection.isEmpty()) {
                                    for (ChannelIF channelIF3 : collection) {
                                        ChannelTreeNode channelTreeNode = new ChannelTreeNode(channelIF3);
                                        if (this.getDefaultSelectedChannel() != null && this.getDefaultSelectedChannel().equals(channelIF3.getLocation().toExternalForm())) {
                                            channelIF = channelIF3;
                                        }
                                        this._rootNode.add(channelTreeNode);
                                    }
                                }
                            }
                        }
                    } else if (channelGroupIFArray != null && channelGroupIFArray.length > 0) {
                        object = channelGroupIFArray;
                        int n = ((ChannelGroupIF[])object).length;
                        for (int i = 0; i < n; ++i) {
                            ChannelGroupIF channelGroupIF = object[i];
                            Collection collection = channelGroupIF.getAll();
                            if (collection == null || collection.isEmpty()) continue;
                            for (DefaultMutableTreeNode defaultMutableTreeNode : collection) {
                                this._rootNode.add(new ChannelTreeNode(defaultMutableTreeNode));
                            }
                        }
                    }
                }
                catch (PersistenceManagerException persistenceManagerException) {
                    if (!FeedReader.getLogger().isLoggable(Level.WARNING)) break block23;
                    FeedReader.getLogger().warning(persistenceManagerException.getLocalizedMessage());
                }
            }
            this._groupTreeModel.reload();
            if (channelIF != null && (object = TreeUtils.findTreeNode(this._feedTree, channelIF)) != null) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(object);
                if (object instanceof TreeNode) {
                    TreeNode treeNode = (TreeNode)object;
                    while ((treeNode = treeNode.getParent()) != null) {
                        arrayList.add(0, treeNode);
                    }
                }
                TreePath treePath = new TreePath(arrayList.toArray(new Object[arrayList.size()]));
                this._feedTree.setSelectionPath(treePath);
            }
            try {
                int n = this._feedPreference.getRefreshTime();
                this.setRefreshDelay(n * FeedConstants.MS_IN_MINUTE);
            }
            catch (Exception exception) {
                if (!FeedReader.getLogger().isLoggable(Level.WARNING)) break block24;
                FeedReader.getLogger().warning(exception.getLocalizedMessage());
            }
        }
    }

    public String getDefaultSelectedChannel() {
        return this._defaultSelectedChannel;
    }

    private void createActions() {
        this._addChannelAction = new AddChannelAction(this);
        this._channelPropertyAction = new ChannelPropertyAction(this);
        this._deleteChannelAction = new DeleteChannelAction(this);
        this._reloadChannelAction = new ReloadChannelAction(this);
        this._makeAllItemsReadAction = new MakeAllItemsReadAction(this);
        this._makeAllItemsUnreadAction = new MakeAllItemsUnreadAction(this);
        this._visitChannelAction = new VisitChannelAction(this);
        this._clearHistoryAction = new ClearChannelHistoryAction(this);
        this._addGroupAction = new AddGroupAction(this);
        this._deleteGroupAction = new DeleteGroupAction(this);
        this._moveChannelAction = new MoveChannelAction(this);
        this._groupPropertyAction = new GroupPropertyAction(this);
        this._toggleItemAction = new ToggleItemAction(this);
        this._visitItemAction = new VisitItemAction(this);
        this._preferenceAction = new PreferenceAction(this);
        this._reloadAllChannelsAction = new ReloadAllChannelsAction(this);
    }

    private void installListeners() {
        this._feedTree.getSelectionModel().addTreeSelectionListener(new TreeSelectAction(this));
        this._feedTree.addMouseListener(new ChannelPopupMenuAction(this));
        this._groupTreeModel.addTreeModelListener(new FeedTreeModelListener(this));
        this._feedTable.getSelectionModel().addListSelectionListener(new SelectItemAction(this));
        this._feedTable.addMouseListener(new ItemPopupMenuAction(this));
        this._addChannelButton.setDisabledIcon(this.getImageIcon("icons/add_disabled.png"));
        this._channelPropertyButton.setDisabledIcon(this.getImageIcon("icons/property_disabled.png"));
        this._deleteChannelButton.setDisabledIcon(this.getImageIcon("icons/remove_disabled.png"));
        this._reloadChannelButton.setDisabledIcon(this.getImageIcon("icons/reset_disabled.png"));
        this._addGroupButton.setDisabledIcon(this.getImageIcon("icons/addGroup_disabled.png"));
        this._deleteGroupButton.setDisabledIcon(this.getImageIcon("icons/removeGroup_disabled.png"));
        this._moveChannelButton.setDisabledIcon(this.getImageIcon("icons/moveChannel_disabled.png"));
        this._groupPropertyButton.setDisabledIcon(this.getImageIcon("icons/group_disabled.png"));
        this._addChannelAction.setEnabled(true);
        this._channelPropertyAction.setEnabled(false);
        this._deleteChannelAction.setEnabled(false);
        this._reloadChannelAction.setEnabled(false);
        this._moveChannelAction.setEnabled(false);
        this._addGroupAction.setEnabled(true);
        this._deleteGroupAction.setEnabled(false);
        this._groupPropertyAction.setEnabled(false);
        this.addFeedEventListener(this);
    }

    @Override
    public void eventHappened(FeedEvent feedEvent) {
        block4: {
            Object object;
            block3: {
                TreeNode treeNode;
                if (feedEvent.getID() != 12208) break block3;
                Object object2 = TreeUtils.findTreeNode(this._feedTree, feedEvent.getItem().getChannel());
                if (!(object2 instanceof TreeNode)) break block4;
                Object object3 = object2;
                this._groupTreeModel.nodeChanged((TreeNode)object3);
                while ((treeNode = ((TreeNode)object3).getParent()) != null) {
                    this._groupTreeModel.nodeChanged(treeNode);
                    object3 = treeNode;
                }
                break block4;
            }
            if (feedEvent.getID() == 12200 && (object = TreeUtils.findTreeNode(this._feedTree, feedEvent.getChannel())) instanceof TreeNode) {
                TreeNode treeNode;
                Object object4 = object;
                this._groupTreeModel.nodeChanged((TreeNode)object4);
                while ((treeNode = ((TreeNode)object4).getParent()) != null) {
                    this._groupTreeModel.nodeChanged(treeNode);
                    object4 = treeNode;
                }
            }
        }
    }

    private Component createToolBar() {
        JComponent jComponent = this.createToolBarComponent();
        if (jComponent instanceof JToolBar) {
            ((JToolBar)jComponent).addSeparator();
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jComponent.add(jPanel);
        jPanel.add((Component)jPanel2, "East");
        jPanel.setPreferredSize(new Dimension(150, 20));
        JLabel jLabel = new JLabel(this.getResourceString("RssFeeds.Label.filter"));
        jPanel2.add((Component)jLabel, "West");
        this._filterField = new QuickTableFilterField(this._itemTableModel);
        this._filterField.setObjectConverterManagerEnabled(true);
        int[] nArray = new int[]{1, 2, 3};
        this._filterField.setColumnIndices(nArray);
        jPanel2.add((Component)this._filterField, "East");
        this._filterField.setPreferredSize(new Dimension(150, 20));
        this._filterField.setBorder(BorderFactory.createLineBorder(FeedConstants.BORDER_LINE_COLOR));
        return jComponent;
    }

    private Component createBrowserPane() {
        this._editor = this.createHtmlBrowser();
        JComponent jComponent = this.createScrollPaneForHtmlBrowser(this._editor);
        Border border = jComponent.getBorder();
        jComponent.setBorder(BorderFactory.createEmptyBorder());
        this._editorTitleLabel = this.createEditorTitleLabel();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(this._invalidHtmlBrowserColor);
        jPanel.add(this._editorTitleLabel, "West");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this._editorLinkLabel = this.createEditorLinkLabel();
        jPanel2.setBackground(this._invalidHtmlBrowserColor);
        jPanel2.add(this._editorLinkLabel, "Before");
        this._editorBottomPane = new JPanel();
        this._editorBottomPane.setLayout(new BorderLayout());
        this._editorBottomPane.setBorder(border);
        this._editorBottomPane.add((Component)jComponent, "Center");
        this._editorBottomPane.add((Component)jPanel, "North");
        this._editorBottomPane.add((Component)jPanel2, "South");
        return this._editorBottomPane;
    }

    protected Component createEditorLinkLabel() {
        JideButton jideButton = new JideButton();
        jideButton.setButtonStyle(3);
        jideButton.setForeground(Color.BLUE);
        jideButton.setAction(new BrowserAction(this));
        return jideButton;
    }

    protected Component createEditorTitleLabel() {
        JLabel jLabel = new JLabel();
        jLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        return jLabel;
    }

    protected JComponent createScrollPaneForHtmlBrowser(Component component) {
        return new JideScrollPane(component);
    }

    protected Component createHtmlBrowser() {
        JEditorPane jEditorPane = new JEditorPane(){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(500, 360);
            }
        };
        jEditorPane.setMinimumSize(new Dimension(100, 100));
        jEditorPane.setEditable(false);
        jEditorPane.setBackground(this._invalidHtmlBrowserColor);
        jEditorPane.addHyperlinkListener(new HyperlinkAction(this));
        jEditorPane.setEditorKit(new HTMLEditorKit());
        return jEditorPane;
    }

    protected void clearHtmlBrowser() {
        Component component;
        Component component2;
        Component component3 = this.getEditor();
        if (component3 instanceof JEditorPane) {
            ((JEditorPane)component3).removeAll();
            component3.setBackground(this._invalidHtmlBrowserColor);
            ((JEditorPane)component3).setText(null);
        }
        if ((component2 = this.getEditorTitleLabel()) != null) {
            component2.setBackground(this._invalidHtmlBrowserColor);
            if (component2 instanceof JLabel) {
                ((JLabel)component2).setText(null);
            } else if (component2 instanceof AbstractButton) {
                ((AbstractButton)component2).setText(null);
            }
        }
        if ((component = this.getEditorLinkLabel()) instanceof AbstractButton) {
            ((AbstractButton)component).setText(null);
            ((AbstractButton)component).setIcon(null);
            ((AbstractButton)component).setToolTipText(null);
        } else if (component instanceof JLabel) {
            ((JLabel)component).setText(null);
            ((JLabel)component).setIcon(null);
            ((JLabel)component).setToolTipText(null);
        }
    }

    public Component getHtmlBrowser() {
        return this._editor;
    }

    protected void displayHtmlBrowser(String string, ItemIF itemIF) {
        Object object;
        Component component;
        Component component2 = this.getEditor();
        if (component2 instanceof JEditorPane) {
            component2.setBackground(this._validHtmlBrowserColor);
            ((JEditorPane)component2).setText(string);
            ((JEditorPane)component2).setCaretPosition(0);
        }
        if ((component = this.getEditorTitleLabel()) != null) {
            component.setBackground(this._validHtmlBrowserColor);
            if (itemIF.getDate() != null) {
                object = DateFormat.getDateTimeInstance().format(itemIF.getDate());
                if (component instanceof JLabel) {
                    ((JLabel)component).setText(itemIF.getTitle() + " - " + (String)object);
                } else if (component instanceof AbstractButton) {
                    ((AbstractButton)component).setText(itemIF.getTitle() + " - " + (String)object);
                }
            } else if (component instanceof JLabel) {
                ((JLabel)component).setText(itemIF.getTitle());
            } else if (component instanceof AbstractButton) {
                ((AbstractButton)component).setText(itemIF.getTitle());
            }
        }
        if ((object = this.getEditorLinkLabel()) instanceof AbstractButton) {
            ((AbstractButton)object).setIcon(this.getImageIcon("icons/browser.png"));
            ((AbstractButton)object).setText(itemIF.getLink().toExternalForm());
            ((AbstractButton)object).setToolTipText(this.getResourceString("RssFeeds.Label.clickToOpenInBrowser"));
        } else if (object instanceof JLabel) {
            ((JLabel)object).setIcon(this.getImageIcon("icons/browser.png"));
            ((JLabel)object).setText(itemIF.getLink().toExternalForm());
            ((JLabel)object).setToolTipText(this.getResourceString("RssFeeds.Label.clickToOpenInBrowser"));
        }
    }

    private Component createChannelPane() {
        this._feedTree = this.createChannelTree(this._groupTreeModel);
        this.customizeChannelTree(this._feedTree);
        this._groupTreeModel.reload();
        return new JideScrollPane(this._feedTree);
    }

    protected void customizeChannelTree(JTree jTree) {
        TreeSearchable treeSearchable = new TreeSearchable(jTree){

            @Override
            protected String convertElementToString(Object object) {
                if (object instanceof TreePath) {
                    Object object2 = ((DefaultMutableTreeNode)((TreePath)object).getLastPathComponent()).getUserObject();
                    if (object2 instanceof ChannelIF) {
                        return ((ChannelIF)object2).getTitle();
                    }
                    if (object2 instanceof ChannelGroupIF) {
                        return ((ChannelGroupIF)object2).getTitle();
                    }
                }
                return super.convertElementToString(object);
            }
        };
        treeSearchable.setRecursive(true);
        jTree.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        jTree.setCellRenderer(new FeedTreeCellRender(this));
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(true);
        jTree.getSelectionModel().setSelectionMode(1);
    }

    protected JTree createChannelTree(TreeModel treeModel) {
        return new JTree(treeModel){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension dimension = super.getPreferredScrollableViewportSize();
                int n = FeedReader.this.getWidth();
                if (n > 100 && dimension.width > n / 3) {
                    dimension.width = n / 3;
                }
                return dimension;
            }
        };
    }

    private Component createItemPane() {
        this._feedTable = new FeedTable(this._filterField.getDisplayTableModel()){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(600, 180);
            }
        };
        JideScrollPane jideScrollPane = new JideScrollPane(this._feedTable);
        jideScrollPane.getViewport().setBackground(this._validHtmlBrowserColor);
        return jideScrollPane;
    }

    protected JComponent createToolBarComponent() {
        this._addGroupButton = this.createToolBarButton(this._addGroupAction);
        this._deleteGroupButton = this.createToolBarButton(this._deleteGroupAction);
        this._groupPropertyButton = this.createToolBarButton(this._groupPropertyAction);
        this._addChannelButton = this.createToolBarButton(this._addChannelAction);
        this._channelPropertyButton = this.createToolBarButton(this._channelPropertyAction);
        this._deleteChannelButton = this.createToolBarButton(this._deleteChannelAction);
        this._moveChannelButton = this.createToolBarButton(this._moveChannelAction);
        this._reloadChannelButton = this.createToolBarButton(this._reloadChannelAction);
        AbstractButton abstractButton = this.createToolBarButton(this._preferenceAction);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        if (this.isAllowGroup()) {
            jToolBar.add(this._addGroupButton);
            jToolBar.add(this._deleteGroupButton);
            jToolBar.add(this._groupPropertyButton);
            jToolBar.addSeparator();
        }
        jToolBar.add(this._addChannelButton);
        jToolBar.add(this._deleteChannelButton);
        jToolBar.add(this._reloadChannelButton);
        if (this.isAllowGroup()) {
            jToolBar.add(this._moveChannelButton);
        }
        jToolBar.add(this._channelPropertyButton);
        jToolBar.addSeparator();
        jToolBar.add(abstractButton);
        return jToolBar;
    }

    protected AbstractButton createToolBarButton(AbstractAction abstractAction) {
        JideButton jideButton = new JideButton();
        jideButton.putClientProperty("hideActionText", Boolean.TRUE);
        jideButton.setAction(abstractAction);
        jideButton.setRequestFocusEnabled(false);
        jideButton.setFocusable(false);
        return jideButton;
    }

    protected JPopupMenu createItemPopupMenu() {
        JidePopupMenu jidePopupMenu = new JidePopupMenu();
        jidePopupMenu.add(new JMenuItem(this._visitItemAction));
        jidePopupMenu.add(new JMenuItem(this._toggleItemAction));
        return jidePopupMenu;
    }

    protected JPopupMenu createChannelPopupMenu() {
        JidePopupMenu jidePopupMenu = new JidePopupMenu();
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setAction(this._visitChannelAction);
        jidePopupMenu.add(jMenuItem);
        jidePopupMenu.addSeparator();
        jMenuItem = new JMenuItem();
        jMenuItem.setAction(this._addChannelAction);
        jidePopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem();
        jMenuItem.setAction(this._deleteChannelAction);
        jidePopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem();
        jMenuItem.setAction(this._reloadChannelAction);
        jidePopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem();
        jMenuItem.setAction(this._channelPropertyAction);
        jidePopupMenu.add(jMenuItem);
        if (this.isAllowGroup()) {
            jMenuItem = new JMenuItem();
            jMenuItem.setAction(this._moveChannelAction);
            jidePopupMenu.add(jMenuItem);
        }
        jidePopupMenu.addSeparator();
        jMenuItem = new JMenuItem();
        jMenuItem.setAction(this._makeAllItemsReadAction);
        jidePopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem();
        jMenuItem.setAction(this._makeAllItemsUnreadAction);
        jidePopupMenu.add(jMenuItem);
        jidePopupMenu.addSeparator();
        jMenuItem = new JMenuItem();
        jMenuItem.setAction(this._clearHistoryAction);
        jidePopupMenu.add(jMenuItem);
        return jidePopupMenu;
    }

    public JTree getFeedTree() {
        return this._feedTree;
    }

    DefaultTreeModel getGroupTreeModel() {
        return this._groupTreeModel;
    }

    public JPopupMenu getChannelPopupMenu() {
        return this._channelPopupMenu;
    }

    public JPopupMenu getItemPopupMenu() {
        return this._itemPopupMenu;
    }

    public JTable getFeedTable() {
        return this._feedTable;
    }

    FeedItemTableModel getItemTableModel() {
        return this._itemTableModel;
    }

    private JPanel getEditorBottomPane() {
        return this._editorBottomPane;
    }

    public Component getEditor() {
        return this._editor;
    }

    public Component getEditorLinkLabel() {
        return this._editorLinkLabel;
    }

    public Component getEditorTitleLabel() {
        return this._editorTitleLabel;
    }

    protected ImageIcon getImageIcon(String string) {
        return FeedIconsFactory.getImageIcon(string);
    }

    protected String getResourceString(String string) {
        return this.getResourceBundle().getString(string);
    }

    public ResourceBundle getResourceBundle() {
        return FeedResource.getResourceBundle(this.getLocale());
    }

    public void setFeedPersistenceManager(PersistenceManagerIF persistenceManagerIF) {
        this._feedPersistence = persistenceManagerIF;
    }

    public PersistenceManagerIF getFeedPersistenceManager() {
        return this._feedPersistence;
    }

    public void addFeedEventListener(FeedEventListener feedEventListener) {
        this.listenerList.add(FeedEventListener.class, feedEventListener);
    }

    public void removeFeedEventListener(FeedEventListener feedEventListener) {
        this.listenerList.remove(FeedEventListener.class, feedEventListener);
    }

    public FeedEventListener[] getFeedEventListeners() {
        return (FeedEventListener[])this.listenerList.getListeners(FeedEventListener.class);
    }

    public void fireStatusChangedEvent(String string) {
        if (EVENT_LOGGER.isLoggable(Level.FINE)) {
            EVENT_LOGGER.fine("Status is changed to \"" + string + "\"");
        }
        Object[] objectArray = this.listenerList.getListenerList();
        FeedEvent feedEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != FeedEventListener.class) continue;
            if (feedEvent == null) {
                feedEvent = new FeedEvent((Object)this, string);
            }
            ((FeedEventListener)objectArray[i + 1]).eventHappened(feedEvent);
        }
    }

    public void fireChannelEvent(int n, ChannelIF channelIF) {
        if (EVENT_LOGGER.isLoggable(Level.FINE)) {
            switch (n) {
                case 12199: {
                    EVENT_LOGGER.fine("Channel \"" + channelIF.getTitle() + "\" is added");
                    break;
                }
                case 12201: {
                    EVENT_LOGGER.fine("Channel \"" + channelIF.getTitle() + "\" is removed");
                    break;
                }
                case 12200: {
                    EVENT_LOGGER.fine("Channel \"" + channelIF.getTitle() + "\" is changed");
                    break;
                }
                case 12203: {
                    EVENT_LOGGER.fine("Channel \"" + channelIF.getTitle() + "\" is cleared");
                    break;
                }
                case 12204: {
                    EVENT_LOGGER.fine("Channel \"" + channelIF.getTitle() + "\" is reloaded");
                }
            }
        }
        Object[] objectArray = this.listenerList.getListenerList();
        FeedEvent feedEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != FeedEventListener.class) continue;
            if (feedEvent == null) {
                feedEvent = new FeedEvent((Object)this, n, channelIF);
            }
            ((FeedEventListener)objectArray[i + 1]).eventHappened(feedEvent);
        }
    }

    public void fireChannelMovedEvent(ChannelIF channelIF, ChannelGroupIF channelGroupIF) {
        if (EVENT_LOGGER.isLoggable(Level.FINE)) {
            EVENT_LOGGER.fine("Channel \"" + channelIF.getTitle() + "\" is moved to \"" + channelGroupIF.getTitle() + "\"");
        }
        Object[] objectArray = this.listenerList.getListenerList();
        FeedEvent feedEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != FeedEventListener.class) continue;
            if (feedEvent == null) {
                feedEvent = new FeedEvent(this, 12202, channelIF, channelGroupIF);
            }
            ((FeedEventListener)objectArray[i + 1]).eventHappened(feedEvent);
        }
    }

    public void fireGroupEvent(int n, ChannelGroupIF channelGroupIF) {
        if (EVENT_LOGGER.isLoggable(Level.FINE)) {
            switch (n) {
                case 12205: {
                    EVENT_LOGGER.fine("Group \"" + channelGroupIF.getTitle() + "\" is added");
                    break;
                }
                case 12207: {
                    EVENT_LOGGER.fine("Group \"" + channelGroupIF.getTitle() + "\" is removed");
                    break;
                }
                case 12206: {
                    EVENT_LOGGER.fine("Group \"" + channelGroupIF.getTitle() + "\" is changed");
                }
            }
        }
        Object[] objectArray = this.listenerList.getListenerList();
        FeedEvent feedEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != FeedEventListener.class) continue;
            if (feedEvent == null) {
                feedEvent = new FeedEvent((Object)this, n, channelGroupIF);
            }
            ((FeedEventListener)objectArray[i + 1]).eventHappened(feedEvent);
        }
    }

    public void firePreferenceChangedEvent(FeedPreference feedPreference) {
        if (EVENT_LOGGER.isLoggable(Level.FINE)) {
            EVENT_LOGGER.fine("FeedPreference is changed");
        }
        Object[] objectArray = this.listenerList.getListenerList();
        FeedEvent feedEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != FeedEventListener.class) continue;
            if (feedEvent == null) {
                feedEvent = new FeedEvent((Object)this, feedPreference);
            }
            ((FeedEventListener)objectArray[i + 1]).eventHappened(feedEvent);
        }
    }

    public void fireChannelItemEvent(int n, ItemIF itemIF) {
        if (EVENT_LOGGER.isLoggable(Level.FINE)) {
            EVENT_LOGGER.fine("Item \"" + itemIF.getTitle() + "\" is changed");
        }
        Object[] objectArray = this.listenerList.getListenerList();
        FeedEvent feedEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != FeedEventListener.class) continue;
            if (feedEvent == null) {
                feedEvent = new FeedEvent((Object)this, n, itemIF);
            }
            ((FeedEventListener)objectArray[i + 1]).eventHappened(feedEvent);
        }
    }

    public void fireFeedEvent(FeedEvent feedEvent) {
        if (EVENT_LOGGER.isLoggable(Level.FINE)) {
            EVENT_LOGGER.fine("FeedEvent \"" + feedEvent.paramString() + "\" is fired");
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != FeedEventListener.class) continue;
            ((FeedEventListener)objectArray[i + 1]).eventHappened(feedEvent);
        }
    }

    public void makeSelectedChannelRead(boolean bl) {
        ChannelIF channelIF = this._itemTableModel.getChannel();
        if (channelIF == null) {
            return;
        }
        Set set = channelIF.getItems();
        ItemIF[] itemIFArray = set.toArray(new ItemIF[set.size()]);
        Arrays.sort(itemIFArray, new ItemComparator(true));
        for (ItemIF itemIF : itemIFArray) {
            if (itemIF == null) continue;
            itemIF.setUnRead(!bl);
            this.fireChannelItemEvent(12208, itemIF);
            try {
                this.getFeedPersistenceManager().updateItem(itemIF);
            }
            catch (PersistenceManagerException persistenceManagerException) {
                if (!FeedReader.getLogger().isLoggable(Level.WARNING)) continue;
                FeedReader.getLogger().warning(persistenceManagerException.getLocalizedMessage());
            }
        }
        this._itemTableModel.fireTableRowsUpdated(0, this._itemTableModel.getRowCount() - 1);
    }

    public void toggleSelectedItemReadStatus() {
        int n = this._feedTable.getSelectedRow();
        int n2 = TableModelWrapperUtils.getActualRowAt(this._feedTable.getModel(), n);
        ItemIF itemIF = this._itemTableModel.getItemAt(n2);
        if (itemIF != null) {
            this._itemTableModel.toggleItemReadStatus(n2);
            this.fireChannelItemEvent(12208, itemIF);
        }
    }

    public void openItemInBrowser() {
        int n = this._feedTable.getSelectedRow();
        int n2 = TableModelWrapperUtils.getActualRowAt(this._feedTable.getModel(), n);
        ItemIF itemIF = this._itemTableModel.getItemAt(n2);
        if (itemIF != null) {
            String string = itemIF.getLink().toString();
            this.openInBrowser(string);
        }
    }

    public void openInBrowser(String string) {
        block5: {
            if (string != null && string.trim().length() != 0) {
                try {
                    if (this._feedPreference.isUseDefaultBrowser()) {
                        BrowserLauncher.openURL(string);
                    } else {
                        BrowserLauncher.openURL(string, this._feedPreference.getBrowser());
                    }
                }
                catch (Exception exception) {
                    if (!FeedReader.getLogger().isLoggable(Level.WARNING)) break block5;
                    FeedReader.getLogger().warning(exception.getLocalizedMessage());
                }
            }
        }
    }

    public void openChannelInBrowser() {
        block5: {
            if (this._feedTree.getLastSelectedPathComponent() == null) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._feedTree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode.isLeaf()) {
                ChannelIF channelIF = (ChannelIF)defaultMutableTreeNode.getUserObject();
                try {
                    if (channelIF != null) {
                        String string = channelIF.getLocation().toExternalForm();
                        this.openInBrowser(string);
                    }
                }
                catch (Exception exception) {
                    if (!FeedReader.getLogger().isLoggable(Level.WARNING)) break block5;
                    FeedReader.getLogger().warning(exception.getLocalizedMessage());
                }
            }
        }
    }

    public void removeSelectedChannel() {
        if (this._feedTree.getLastSelectedPathComponent() == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._feedTree.getLastSelectedPathComponent();
        if (!defaultMutableTreeNode.isLeaf() || defaultMutableTreeNode.getUserObject() instanceof ChannelGroupIF) {
            return;
        }
        ChannelIF channelIF = (ChannelIF)defaultMutableTreeNode.getUserObject();
        int n = JOptionPane.showConfirmDialog(this, MessageFormat.format(this.getResourceString("RssFeeds.message.deleteChannelConfirmation"), channelIF.getTitle()), this.getResourceString("RssFeeds.title"), 0);
        if (n == 0) {
            this._itemTableModel.closeCurrentChannel();
            this._groupTreeModel.removeNodeFromParent(defaultMutableTreeNode);
            this.fireChannelEvent(12201, channelIF);
            this.fireStatusChangedEvent(MessageFormat.format(this.getResourceString("RssFeeds.message.channelDeleted"), channelIF.getSite().toString()));
        }
    }

    public void openSelectedChannel() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._feedTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null || !defaultMutableTreeNode.isLeaf() || defaultMutableTreeNode.getUserObject() instanceof ChannelGroupIF) {
            return;
        }
        ChannelIF channelIF = (ChannelIF)defaultMutableTreeNode.getUserObject();
        this.loadChannelInTable(channelIF);
    }

    public void openSelectedItem() {
        ItemIF itemIF;
        block10: {
            int n;
            if (this._lastSelectedItem != null && this._lastSelectedItem.getUnRead()) {
                n = this._itemTableModel.getItemIndex(this._lastSelectedItem);
                if (n != -1) {
                    this._itemTableModel.setItemReadStatus(n, false);
                    this.fireChannelItemEvent(12208, this._itemTableModel.getItemAt(n));
                } else {
                    this.makeItemRead(this._lastSelectedItem);
                }
            }
            n = this._feedTable.getSelectedRow();
            int n2 = TableModelWrapperUtils.getActualRowAt(this._feedTable.getModel(), n);
            JPanel jPanel = (JPanel)this.getEditorBottomPane().getComponent(1);
            JPanel jPanel2 = (JPanel)this.getEditorBottomPane().getComponent(2);
            if (n < 0 || this._feedTree.getSelectionPath() == null) {
                block9: {
                    try {
                        this.clearHtmlBrowser();
                    }
                    catch (Exception exception) {
                        if (!FeedReader.getLogger().isLoggable(Level.WARNING)) break block9;
                        FeedReader.getLogger().warning(exception.getLocalizedMessage());
                    }
                }
                jPanel.setBackground(this._invalidHtmlBrowserColor);
                jPanel2.setBackground(this._invalidHtmlBrowserColor);
                return;
            }
            itemIF = this._itemTableModel.getItemAt(n2);
            if (itemIF == null) {
                return;
            }
            jPanel.setBackground(this._validHtmlBrowserColor);
            jPanel2.setBackground(this._validHtmlBrowserColor);
            try {
                this.displayHtmlBrowser(itemIF.getDescription(), itemIF);
            }
            catch (Exception exception) {
                if (!FeedReader.getLogger().isLoggable(Level.WARNING)) break block10;
                FeedReader.getLogger().warning(exception.getLocalizedMessage());
            }
        }
        this._lastSelectedItem = itemIF;
    }

    public void clearSelectedChannelHistory() {
        block3: {
            this._itemTableModel.removeAll();
            try {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._feedTree.getLastSelectedPathComponent();
                ChannelIF channelIF = (ChannelIF)defaultMutableTreeNode.getUserObject();
                Set set = channelIF.getItems();
                ItemIF[] itemIFArray = set.toArray(new ItemIF[set.size()]);
                Arrays.sort(itemIFArray, new ItemComparator(true));
                for (ItemIF itemIF : itemIFArray) {
                    this._feedPersistence.deleteItem(itemIF);
                }
                this.fireChannelEvent(12203, channelIF);
            }
            catch (Exception exception) {
                if (!FeedReader.getLogger().isLoggable(Level.WARNING)) break block3;
                FeedReader.getLogger().warning(exception.getLocalizedMessage());
            }
        }
    }

    private void makeItemRead(ItemIF itemIF) {
        block2: {
            itemIF.setUnRead(false);
            try {
                this._feedPersistence.updateItem(itemIF);
                this.fireChannelItemEvent(12208, itemIF);
            }
            catch (Exception exception) {
                if (!FeedReader.getLogger().isLoggable(Level.WARNING)) break block2;
                FeedReader.getLogger().warning(exception.getLocalizedMessage());
            }
        }
    }

    public void reloadSelectedChannel() {
        TreePath treePath = this._feedTree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._feedTree.getLastSelectedPathComponent();
        if (!defaultMutableTreeNode.isLeaf() || !(defaultMutableTreeNode.getUserObject() instanceof ChannelIF)) {
            return;
        }
        ChannelIF channelIF = (ChannelIF)defaultMutableTreeNode.getUserObject();
        ChannelIF channelIF2 = this.reloadChannel(channelIF);
        defaultMutableTreeNode.setUserObject(channelIF2);
        this.loadChannelInTable(channelIF2);
        this._groupTreeModel.nodeChanged(defaultMutableTreeNode);
    }

    public ChannelIF reloadChannel(ChannelIF channelIF) {
        block9: {
            if (channelIF == null || channelIF.getLocation() == null) {
                return channelIF;
            }
            URL uRL = channelIF.getLocation();
            this.fireStatusChangedEvent(MessageFormat.format(this.getResourceString("RssFeeds.message.reloadingChannel"), uRL.toExternalForm()));
            Set set = channelIF.getItems();
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            for (ItemIF[] itemIFArray : set) {
                if (itemIFArray.getUnRead()) continue;
                hashMap.put(itemIFArray.getTitle(), itemIFArray.getUnRead());
            }
            try {
                ItemIF[] itemIFArray;
                ChannelIF channelIF2 = FeedParser.parse((ChannelBuilderIF)new ChannelBuilder(), (URL)uRL);
                channelIF2.setId(channelIF.getId());
                channelIF2.setTitle(channelIF.getTitle());
                set = channelIF2.getItems();
                itemIFArray = set.toArray(new ItemIF[set.size()]);
                Arrays.sort(itemIFArray, new ItemComparator(true));
                for (ItemIF itemIF : itemIFArray) {
                    Boolean bl = (Boolean)hashMap.get(itemIF.getTitle());
                    if (bl == null) continue;
                    itemIF.setUnRead(bl.booleanValue());
                }
                this.fireChannelEvent(12204, channelIF2);
                this.getFeedPersistenceManager().updateChannel(channelIF2);
                return channelIF2;
            }
            catch (PersistenceManagerException persistenceManagerException) {
                if (FeedReader.getLogger().isLoggable(Level.WARNING)) {
                    FeedReader.getLogger().warning(persistenceManagerException.getLocalizedMessage());
                }
            }
            catch (IOException iOException) {
                if (FeedReader.getLogger().isLoggable(Level.WARNING)) {
                    FeedReader.getLogger().warning(iOException.getLocalizedMessage());
                }
            }
            catch (ParseException parseException) {
                if (!FeedReader.getLogger().isLoggable(Level.WARNING)) break block9;
                FeedReader.getLogger().warning(parseException.getLocalizedMessage());
            }
        }
        return channelIF;
    }

    public void addChannelGroup(String string) {
        if (string != null) {
            ChannelGroup channelGroup = new ChannelGroup();
            channelGroup.setTitle(string);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._groupTreeModel.getRoot();
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(channelGroup);
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            DefaultMutableTreeNode defaultMutableTreeNode3 = null;
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)enumeration.nextElement();
                if (defaultMutableTreeNode4.getUserObject() == null || !(defaultMutableTreeNode4.getUserObject() instanceof ChannelGroupIF)) continue;
                defaultMutableTreeNode3 = defaultMutableTreeNode4;
            }
            int n = 0;
            if (defaultMutableTreeNode3 != null) {
                n = defaultMutableTreeNode.getIndex(defaultMutableTreeNode3) + 1;
            }
            this._groupTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, n);
            this._feedTree.makeVisible(new TreePath(defaultMutableTreeNode2.getPath()));
            this.fireGroupEvent(12205, (ChannelGroupIF)channelGroup);
        }
    }

    public void loadChannelInTable(ChannelIF channelIF) {
        int n;
        if (channelIF == null || channelIF.getLocation() == null) {
            return;
        }
        int n2 = this._feedTable.getSelectedRow();
        ItemIF itemIF = null;
        if (n2 != -1) {
            itemIF = this._itemTableModel.getItemAt(n2);
        }
        this._itemTableModel.openChannel(channelIF);
        if (itemIF != null && (n = this._itemTableModel.getItemIndex(itemIF)) != -1) {
            this._feedTable.getSelectionModel().setSelectionInterval(n, n);
        }
        if (this._feedTable.getSelectedRow() == -1 && this._feedTable.getRowCount() > 0) {
            this._feedTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public void updateSelectedChannel() {
        if (this._feedTree.getLastSelectedPathComponent() == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._feedTree.getLastSelectedPathComponent();
        if (!defaultMutableTreeNode.isLeaf() || !(defaultMutableTreeNode.getUserObject() instanceof ChannelIF)) {
            return;
        }
        Window window = JideSwingUtilities.getWindowForComponent(this);
        ChannelPropertyDialog channelPropertyDialog = window instanceof Frame ? new ChannelPropertyDialog((Frame)window, this) : (window instanceof Dialog ? new ChannelPropertyDialog((Dialog)window, this) : new ChannelPropertyDialog((Frame)null, this));
        channelPropertyDialog.pack();
        channelPropertyDialog.setLocationRelativeTo(null);
        channelPropertyDialog.setVisible(true);
    }

    public void removeSelectedGroup() {
        if (this._feedTree.getLastSelectedPathComponent() == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._feedTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode.getUserObject() instanceof ChannelIF) {
            return;
        }
        ChannelGroupIF channelGroupIF = (ChannelGroupIF)defaultMutableTreeNode.getUserObject();
        int n = JOptionPane.showConfirmDialog(this, MessageFormat.format(this.getResourceString("RssFeeds.message.deleteGroupConfirmation"), channelGroupIF.getTitle()), this.getResourceString("RssFeeds.title"), 0);
        if (n == 0) {
            this._itemTableModel.closeCurrentChannel();
            this._groupTreeModel.removeNodeFromParent(defaultMutableTreeNode);
            this.fireGroupEvent(12207, channelGroupIF);
        }
    }

    public void moveSelectedChannel(ChannelGroupIF channelGroupIF) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getFeedTree().getLastSelectedPathComponent();
        this.getGroupTreeModel().removeNodeFromParent(defaultMutableTreeNode);
        ChannelIF channelIF = (ChannelIF)defaultMutableTreeNode.getUserObject();
        this.moveChannel(channelIF, channelGroupIF);
    }

    public void moveChannel(ChannelIF channelIF, ChannelGroupIF channelGroupIF) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getGroupTreeModel().getRoot();
        ChannelGroupIF channelGroupIF2 = (ChannelGroupIF)defaultMutableTreeNode.getUserObject();
        if (channelGroupIF2.getId() == channelGroupIF.getId()) {
            ChannelTreeNode channelTreeNode = new ChannelTreeNode(channelIF);
            this.getFeedTable().removeAll();
            this.getGroupTreeModel().insertNodeInto(channelTreeNode, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
            this.getFeedTree().setSelectionPath(new TreePath(((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(defaultMutableTreeNode.getChildCount() - 1)).getPath()));
            this.fireChannelMovedEvent(channelIF, channelGroupIF);
            return;
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            ChannelGroupIF channelGroupIF3;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            Object object = defaultMutableTreeNode2.getUserObject();
            if (!(object instanceof ChannelGroupIF) || (channelGroupIF3 = (ChannelGroupIF)object).getId() != channelGroupIF.getId()) continue;
            ChannelTreeNode channelTreeNode = new ChannelTreeNode(channelIF);
            this.getFeedTable().removeAll();
            this.getGroupTreeModel().insertNodeInto(channelTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
            this.getFeedTree().setSelectionPath(new TreePath(((DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(defaultMutableTreeNode2.getChildCount() - 1)).getPath()));
            this.fireChannelMovedEvent(channelIF, channelGroupIF);
            break;
        }
    }

    public void setRefreshDelay(int n) {
        if (n != 0) {
            this.getReloadTimer().setDelay(n);
        }
        this.getReloadTimer().restart();
    }

    private Timer getReloadTimer() {
        if (this._timer == null) {
            this._timer = new Timer(FeedConstants.MS_IN_MINUTE, this._reloadAllChannelsAction);
            this._timer.setInitialDelay(2000);
        }
        return this._timer;
    }

    public void reloadAllChannels() {
        this.getReloadTimer().restart();
    }

    public int getUnReadItemCountForAllChannels() {
        int n = 0;
        Collection<ChannelIF> collection = this.getAllChannels();
        for (ChannelIF channelIF : collection) {
            n += this.getUnReadItemCount(channelIF);
        }
        return n;
    }

    private int getUnReadItemCount(ChannelIF channelIF) {
        int n = 0;
        Set set = channelIF.getItems();
        for (ItemIF itemIF : set) {
            if (!itemIF.getUnRead()) continue;
            ++n;
        }
        return n;
    }

    private Collection<ChannelIF> getAllChannels() {
        HashSet<ChannelIF> hashSet;
        block4: {
            hashSet = new HashSet<ChannelIF>();
            try {
                ChannelGroupIF[] channelGroupIFArray = this.getFeedPersistenceManager().getGroups();
                if (channelGroupIFArray != null) {
                    for (ChannelGroupIF channelGroupIF : channelGroupIFArray) {
                        Collection collection = channelGroupIF.getAll();
                        if (collection == null) continue;
                        hashSet.addAll(collection);
                    }
                }
            }
            catch (PersistenceManagerException persistenceManagerException) {
                if (!FeedReader.getLogger().isLoggable(Level.WARNING)) break block4;
                FeedReader.getLogger().warning(persistenceManagerException.getLocalizedMessage());
            }
        }
        return hashSet;
    }

    public String[] getDefaultChannels() {
        return this._defaultChannels;
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public FeedPreference getFeedPreference() {
        return this._feedPreference;
    }

    public boolean isAllowGroup() {
        return this._isAllowGroup;
    }

    public String getUserDataPath() {
        return this._userDataPath;
    }

    public String getUserIconPath() {
        return this._userDataPath + "/icons/";
    }

    public void enableGroupActionMenu() {
        if (!this._addChannelAction.isEnabled()) {
            this._addChannelAction.setEnabled(true);
        }
        if (this._deleteChannelAction.isEnabled()) {
            this._deleteChannelAction.setEnabled(false);
        }
        if (this._reloadChannelAction.isEnabled()) {
            this._reloadChannelAction.setEnabled(false);
        }
        if (this._channelPropertyAction.isEnabled()) {
            this._channelPropertyAction.setEnabled(false);
        }
        if (this._moveChannelAction.isEnabled()) {
            this._moveChannelAction.setEnabled(false);
        }
        if (!this._addGroupAction.isEnabled()) {
            this._addGroupAction.setEnabled(true);
        }
        if (!this._deleteGroupAction.isEnabled()) {
            this._deleteGroupAction.setEnabled(true);
        }
        if (!this._groupPropertyAction.isEnabled()) {
            this._groupPropertyAction.setEnabled(true);
        }
    }

    public void enableChannelActionMenu() {
        if (!this._addChannelAction.isEnabled()) {
            this._addChannelAction.setEnabled(true);
        }
        if (!this._deleteChannelAction.isEnabled()) {
            this._deleteChannelAction.setEnabled(true);
        }
        if (!this._reloadChannelAction.isEnabled()) {
            this._reloadChannelAction.setEnabled(true);
        }
        if (!this._channelPropertyAction.isEnabled()) {
            this._channelPropertyAction.setEnabled(true);
        }
        if (!this._moveChannelAction.isEnabled()) {
            this._moveChannelAction.setEnabled(true);
        }
        if (!this._addGroupAction.isEnabled()) {
            this._addGroupAction.setEnabled(true);
        }
        if (this._deleteGroupAction.isEnabled()) {
            this._deleteGroupAction.setEnabled(false);
        }
        if (this._groupPropertyAction.isEnabled()) {
            this._groupPropertyAction.setEnabled(false);
        }
    }

    public void enableDefaultActionMenu() {
        this._addChannelAction.setEnabled(true);
        this._deleteChannelAction.setEnabled(false);
        this._reloadChannelAction.setEnabled(false);
        this._moveChannelAction.setEnabled(false);
        this._addGroupAction.setEnabled(true);
        this._deleteGroupAction.setEnabled(false);
        this._groupPropertyAction.setEnabled(false);
    }

    public JPopupMenu getGroupPopupMenu() {
        return this._groupPopupMenu;
    }

    public ImageIcon getChannelIcon(ChannelIF channelIF) {
        return this.getImageIcon("icons/rss.png");
    }

    public void addChannel(String string) {
        Object object;
        Object object2;
        block6: {
            object2 = null;
            try {
                object2 = this.getFeedTree().getLastSelectedPathComponent() != null ? (((DefaultMutableTreeNode)(object = (DefaultMutableTreeNode)this.getFeedTree().getLastSelectedPathComponent())).getUserObject() instanceof ChannelIF ? (DefaultMutableTreeNode)((DefaultMutableTreeNode)object).getParent() : object) : (DefaultMutableTreeNode)this.getGroupTreeModel().getRoot();
                object = this.getFeedPreference();
                if (!object.isAllowDuplicatedChannels() && this.urlExists(string)) {
                    this.fireStatusChangedEvent(this.getResourceString("RssFeeds.message.duplicateChannel"));
                    return;
                }
            }
            catch (Exception exception) {
                if (!FeedReader.getLogger().isLoggable(Level.WARNING)) break block6;
                FeedReader.getLogger().warning(exception.getLocalizedMessage());
            }
        }
        try {
            object = new URL(string);
            URLConnection uRLConnection = ((URL)object).openConnection();
            uRLConnection.addRequestProperty("User-agent", "Mozilla/4.0");
            ChannelIF channelIF = FeedParser.parse((ChannelBuilderIF)new ChannelBuilder(), (InputStream)uRLConnection.getInputStream());
            channelIF.setLocation((URL)object);
            this.fireChannelEvent(12199, channelIF);
            ChannelTreeNode channelTreeNode = new ChannelTreeNode(channelIF);
            this.getGroupTreeModel().insertNodeInto(channelTreeNode, (MutableTreeNode)object2, ((DefaultMutableTreeNode)object2).getChildCount());
            this.getFeedTree().setSelectionPath(new TreePath(channelTreeNode.getPath()));
            this.fireStatusChangedEvent(MessageFormat.format(this.getResourceString("RssFeeds.message.channelAdded"), string));
        }
        catch (Exception exception) {
            if (FeedReader.getLogger().isLoggable(Level.WARNING)) {
                FeedReader.getLogger().warning(exception.getLocalizedMessage());
            }
            this.fireStatusChangedEvent(MessageFormat.format(this.getResourceString("RssFeeds.message.failToLoad"), string));
        }
    }

    private boolean urlExists(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getGroupTreeModel().getRoot();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            Collection collection;
            ChannelIF channelIF;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode2.getUserObject() instanceof ChannelIF) {
                channelIF = (ChannelIF)defaultMutableTreeNode2.getUserObject();
                if (!string.equals(channelIF.getLocation().toExternalForm())) continue;
                return true;
            }
            if (!(defaultMutableTreeNode2.getUserObject() instanceof ChannelGroupIF) || (collection = (channelIF = (ChannelGroupIF)defaultMutableTreeNode2.getUserObject()).getAll()) == null || collection.isEmpty()) continue;
            for (ChannelIF channelIF2 : collection) {
                if (!string.equals(channelIF2.getLocation().toExternalForm())) continue;
                return true;
            }
        }
        return false;
    }

    public void setMaxCacheItems(int n) {
        if (this._itemTableModel != null) {
            this._itemTableModel.setMaxItems(n);
            this.reloadSelectedChannel();
        }
    }

    public int getMaxCacheItems() {
        if (this._itemTableModel != null) {
            return this._itemTableModel.getMaxItems();
        }
        return 0;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(256)) {
            Lm.showInvalidProductMessage(FeedReader.class.getName(), 256);
        }
        LOGGER_NAME = "com.jidesoft.rss.FeedReader";
        EVENT_LOGGER_NAME = "com.jidesoft.rss.FeedReader.FeedEvent";
        LOGGER = Logger.getLogger(LOGGER_NAME);
        EVENT_LOGGER = Logger.getLogger(EVENT_LOGGER_NAME);
    }
}

