/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.rss;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.StandardDialog;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.rss.FeedReader;
import com.jidesoft.swing.SelectAllUtils;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.utils.manager.PersistenceManagerException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;

class ChannelPropertyDialog
extends StandardDialog {
    private JTextField _channelField = null;
    private FeedReader _rss = null;
    private DefaultMutableTreeNode _selectNode = null;
    private ChannelIF _channel = null;

    public ChannelPropertyDialog(Frame frame, FeedReader feedReader) {
        super(frame);
        this.initDialog(feedReader);
    }

    public ChannelPropertyDialog(Dialog dialog, FeedReader feedReader) {
        super(dialog, true);
        this.initDialog(feedReader);
    }

    private void initDialog(FeedReader feedReader) {
        this.setResizable(false);
        this._rss = feedReader;
        this.setTitle(this._rss.getResourceString("RssFeeds.ChannelProperty.dialogTitle"));
        this._selectNode = (DefaultMutableTreeNode)this._rss.getFeedTree().getLastSelectedPathComponent();
        this._channel = (ChannelIF)this._selectNode.getUserObject();
        this.setDefaultAction(new AbstractAction(UIDefaultsLookup.getString("OptionPane.okButtonText", this.getLocale())){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChannelPropertyDialog.this.setChannelProperty();
                ChannelPropertyDialog.this.setVisible(false);
                ChannelPropertyDialog.this.dispose();
            }
        });
        this.setDefaultCancelAction(new AbstractAction(UIDefaultsLookup.getString("OptionPane.cancelButtonText", this.getLocale())){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChannelPropertyDialog.this.setVisible(false);
                ChannelPropertyDialog.this.dispose();
            }
        });
    }

    @Override
    public JComponent createBannerPanel() {
        return null;
    }

    @Override
    public JComponent createContentPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(3, 3));
        JLabel jLabel = new JLabel(this._rss.getResourceString("RssFeeds.ChannelProperty.title"));
        jLabel.setDisplayedMnemonic(this._rss.getResourceString("RssFeeds.ChannelProperty.title.mnemonic").charAt(0));
        jPanel.add((Component)jLabel, "First");
        this._channelField = new JTextField(50);
        SelectAllUtils.install(this._channelField, false);
        jLabel.setLabelFor(this._channelField);
        if (this._channel != null) {
            this._channelField.setText(this._channel.getTitle());
            this._channelField.setCaretPosition(0);
        }
        jPanel.add((Component)this._channelField, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout(3, 3));
        JLabel jLabel2 = new JLabel(this._rss.getResourceString("RssFeeds.ChannelProperty.url"));
        jLabel2.setDisplayedMnemonic(this._rss.getResourceString("RssFeeds.ChannelProperty.url.mnemonic").charAt(0));
        jPanel2.add((Component)jLabel2, "First");
        JTextField jTextField = new JTextField(50);
        jLabel2.setLabelFor(jTextField);
        if (this._channel != null) {
            jTextField.setText(this._channel.getLocation().toExternalForm());
            jTextField.setCaretPosition(0);
        }
        jTextField.setEditable(false);
        jPanel2.add((Component)jTextField, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout(6, 6));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        jPanel3.add((Component)jPanel, "First");
        jPanel3.add((Component)jPanel2, "Last");
        return jPanel3;
    }

    @Override
    public ButtonPanel createButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        buttonPanel.addButton((AbstractButton)jButton, "AFFIRMATIVE");
        buttonPanel.addButton((AbstractButton)jButton2, "CANCEL");
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        buttonPanel.setPreferredSize(new Dimension(100, 45));
        jButton.setAction(this.getDefaultAction());
        jButton2.setAction(this.getDefaultCancelAction());
        return buttonPanel;
    }

    private void setChannelProperty() {
        String string = this._channelField.getText();
        if (!string.equals(this._channel.getTitle())) {
            block3: {
                this._channel.setTitle(string);
                try {
                    this._rss.getFeedPersistenceManager().updateChannel(this._channel);
                }
                catch (PersistenceManagerException persistenceManagerException) {
                    if (!FeedReader.getLogger().isLoggable(Level.WARNING)) break block3;
                    FeedReader.getLogger().warning(persistenceManagerException.getLocalizedMessage());
                }
            }
            this._rss.fireChannelEvent(12200, this._channel);
        }
    }
}

